/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.utils.svn;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.service.utils.svn.SvnConst;
import org.tio.utils.hutool.StrUtil;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnKit {
    private static Logger log = LoggerFactory.getLogger(SvnKit.class);
    public static Boolean DoUpdateStatus;
    private static SVNClientManager ourClientManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCommitHistory(String svnUsername, String svnPwd, String svnPath, long limit) {
        long start = System.currentTimeMillis();
        try {
            long startRevision = 0L;
            long endRevision = -1L;
            SVNRepository repository = null;
            repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)svnPath));
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)svnUsername, (char[])svnPwd.toCharArray());
            repository.setAuthenticationManager(authManager);
            try {
                endRevision = repository.getLatestRevision();
                startRevision = endRevision - limit;
                startRevision = Math.max(0L, startRevision);
            }
            catch (SVNException e) {
                log.error("", (Throwable)e);
                String string = "";
                long end = System.currentTimeMillis();
                long iv = end - start;
                log.error("\u83b7\u53d6\u63d0\u4ea4\u65e5\u5fd7\u8017\u65f6{}\u6beb\u79d2\r\n\u4ed3\u5e93:{}\r\n", (Object)iv, (Object)svnPath);
                return string;
            }
            final StringBuilder sb = new StringBuilder(1024);
            repository.log(new String[]{""}, endRevision, startRevision, true, true, limit, new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                    sb.append("<span style='color:#009688;'>").append(DateUtil.formatDate((Date)logEntry.getDate())).append("</span>\r\n");
                    sb.append("---------------------------------------------\r\n");
                    if (StrUtil.isNotBlank((CharSequence)logEntry.getMessage())) {
                        sb.append("<span style='color:#777;font-size:14px;'>");
                        sb.append(logEntry.getMessage()).append("\r\n");
                        sb.append("</span>");
                        sb.append("---------------------------------------------\r\n");
                    }
                    if (logEntry.getChangedPaths().size() > 0) {
                        Set changedPathsSet = logEntry.getChangedPaths().keySet();
                        sb.append("<span style='color:#777;font-size:14px;'>");
                        Iterator changedPaths = changedPathsSet.iterator();
                        while (changedPaths.hasNext()) {
                            SVNLogEntryPath entryPath = (SVNLogEntryPath)logEntry.getChangedPaths().get(changedPaths.next());
                            sb.append(" ").append(entryPath.getType()).append("\t").append(entryPath.getPath());
                            sb.append(entryPath.getCopyPath() != null ? " (from " + entryPath.getCopyPath() + " revision " + entryPath.getCopyRevision() + ")" : "");
                            sb.append("\r\n");
                        }
                        sb.append("</span>");
                    }
                    sb.append("\r\n");
                }
            });
            String ret = sb.toString();
            System.out.println(ret);
            String string = ret;
            return string;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            long end = System.currentTimeMillis();
            long iv = end - start;
            log.error("\u83b7\u53d6\u63d0\u4ea4\u65e5\u5fd7\u8017\u65f6{}\u6beb\u79d2\r\n\u4ed3\u5e93:{}\r\n", (Object)iv, (Object)svnPath);
        }
    }

    public static Boolean checkOut() {
        SVNURL repositoryURL = null;
        try {
            repositoryURL = SVNURL.parseURIEncoded((String)SvnConst.SVN_URL);
        }
        catch (SVNException e) {
            log.error("", (Throwable)e);
            return false;
        }
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        ourClientManager = SVNClientManager.newInstance((DefaultSVNOptions)options, (String)SvnConst.SVN_USERNAME, (String)SvnConst.SVN_PWD);
        File wcDir = new File(SvnConst.SVN_LOCAL_DIR);
        SVNUpdateClient updateClient = ourClientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        long workingVersion = -1L;
        try {
            if (!wcDir.exists()) {
                workingVersion = updateClient.doCheckout(repositoryURL, wcDir, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, false);
            } else {
                ourClientManager.getWCClient().doCleanup(wcDir);
                workingVersion = updateClient.doCheckout(repositoryURL, wcDir, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, false);
            }
        }
        catch (SVNException e) {
            log.error("", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
        System.out.println("\u628a\u7248\u672c\uff1a" + workingVersion + " check out \u5230\u76ee\u5f55\uff1a" + wcDir + "\u4e2d\u3002");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean doExport(String svnUsername, String svnPwd, String svnPath, String outputDir) {
        SVNURL repositoryURL;
        long start = System.currentTimeMillis();
        try {
            repositoryURL = null;
            try {
                repositoryURL = SVNURL.parseURIEncoded((String)svnPath);
            }
            catch (SVNException e) {
                log.error("", (Throwable)e);
                Boolean bl = false;
                long end = System.currentTimeMillis();
                long iv = end - start;
                log.error("\u5bfc\u51fasvn\u4ed3\u5e93\u8017\u65f6{}\u6beb\u79d2\r\n\u4ed3\u5e93:{}\r\n\u672c\u5730\u76ee\u5f55\uff1a{}", new Object[]{iv, svnPath, outputDir});
                return bl;
            }
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            long iv = end - start;
            log.error("\u5bfc\u51fasvn\u4ed3\u5e93\u8017\u65f6{}\u6beb\u79d2\r\n\u4ed3\u5e93:{}\r\n\u672c\u5730\u76ee\u5f55\uff1a{}", new Object[]{iv, svnPath, outputDir});
            throw throwable;
        }
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        ourClientManager = SVNClientManager.newInstance((DefaultSVNOptions)options, (String)svnUsername, (String)svnPwd);
        File wcDir = new File(outputDir);
        SVNUpdateClient updateClient = ourClientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        long workingVersion = -1L;
        try {
            if (wcDir.exists()) {
                FileUtil.del((File)wcDir);
            }
            workingVersion = updateClient.doExport(repositoryURL, wcDir, SVNRevision.HEAD, SVNRevision.HEAD, "downloadModel", true, SVNDepth.INFINITY);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            Boolean bl = false;
            long end = System.currentTimeMillis();
            long iv = end - start;
            log.error("\u5bfc\u51fasvn\u4ed3\u5e93\u8017\u65f6{}\u6beb\u79d2\r\n\u4ed3\u5e93:{}\r\n\u672c\u5730\u76ee\u5f55\uff1a{}", new Object[]{iv, svnPath, outputDir});
            return bl;
        }
        Boolean bl = true;
        long end = System.currentTimeMillis();
        long iv = end - start;
        log.error("\u5bfc\u51fasvn\u4ed3\u5e93\u8017\u65f6{}\u6beb\u79d2\r\n\u4ed3\u5e93:{}\r\n\u672c\u5730\u76ee\u5f55\uff1a{}", new Object[]{iv, svnPath, outputDir});
        return bl;
    }

    public static Boolean doCleanup() {
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        ourClientManager = SVNClientManager.newInstance((DefaultSVNOptions)options, (String)SvnConst.SVN_USERNAME, (String)SvnConst.SVN_PWD);
        File wcDir = new File(SvnConst.SVN_LOCAL_DIR);
        if (wcDir.exists()) {
            try {
                ourClientManager.getWCClient().doCleanup(wcDir);
            }
            catch (SVNException e) {
                log.error("", (Throwable)e);
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static int doUpdate() {
        if (!DoUpdateStatus.booleanValue()) {
            System.out.println("\u66f4\u65b0\u7a0b\u5e8f\u5df2\u7ecf\u5728\u8fd0\u884c\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u8bf7\u6c42\uff01");
            return 0;
        }
        DoUpdateStatus = false;
        try {
            DAVRepositoryFactory.setup();
            DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
            ourClientManager = SVNClientManager.newInstance((DefaultSVNOptions)options, (String)SvnConst.SVN_USERNAME, (String)SvnConst.SVN_PWD);
            File updateFile = new File(SvnConst.SVN_LOCAL_DIR);
            SVNUpdateClient updateClient = ourClientManager.getUpdateClient();
            updateClient.setIgnoreExternals(false);
            long versionNum = updateClient.doUpdate(updateFile, SVNRevision.HEAD, SVNDepth.INFINITY, false, false);
            System.out.println("\u5de5\u4f5c\u526f\u672c\u66f4\u65b0\u540e\u7684\u7248\u672c\uff1a" + versionNum);
            DoUpdateStatus = true;
            return 1;
        }
        catch (SVNException e) {
            DoUpdateStatus = true;
            log.error("", (Throwable)e);
            return -1;
        }
    }

    public static Boolean doCommit(List<String> fileRelativePathList) {
        SVNRepositoryFactoryImpl.setup();
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        ourClientManager = SVNClientManager.newInstance((DefaultSVNOptions)options, (String)SvnConst.SVN_USERNAME, (String)SvnConst.SVN_PWD);
        File commitFile = new File(SvnConst.SVN_LOCAL_DIR);
        SVNStatus status = null;
        File addFile = null;
        String strPath = null;
        try {
            if (fileRelativePathList != null && fileRelativePathList.size() > 0) {
                for (int i = 0; i < fileRelativePathList.size(); ++i) {
                    strPath = fileRelativePathList.get(i);
                    addFile = new File(SvnConst.SVN_LOCAL_DIR + "/" + strPath);
                    status = ourClientManager.getStatusClient().doStatus(addFile, true);
                    if (null != status && status.getContentsStatus() != SVNStatusType.STATUS_UNVERSIONED) continue;
                    ourClientManager.getWCClient().doAdd(addFile, false, false, false, SVNDepth.INFINITY, false, false);
                    System.out.println("add");
                }
                ourClientManager.getCommitClient().doCommit(new File[]{commitFile}, true, "", null, null, true, false, SVNDepth.INFINITY);
                System.out.println("commit");
            } else {
                ourClientManager.getCommitClient().doCommit(new File[]{commitFile}, true, "", null, null, true, false, SVNDepth.INFINITY);
                System.out.println("commit");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
        return true;
    }

    public static Boolean doCommit(String fileRelativePath) {
        SVNRepositoryFactoryImpl.setup();
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        ourClientManager = SVNClientManager.newInstance((DefaultSVNOptions)options, (String)SvnConst.SVN_USERNAME, (String)SvnConst.SVN_PWD);
        File commitFile = new File(SvnConst.SVN_LOCAL_DIR);
        SVNStatus status = null;
        File addFile = null;
        try {
            if (fileRelativePath != null && fileRelativePath.trim().length() > 0) {
                addFile = new File(SvnConst.SVN_LOCAL_DIR + "/" + fileRelativePath);
                status = ourClientManager.getStatusClient().doStatus(addFile, true);
                if (null == status || status.getContentsStatus() == SVNStatusType.STATUS_UNVERSIONED) {
                    ourClientManager.getWCClient().doAdd(addFile, false, false, false, SVNDepth.INFINITY, false, false);
                    System.out.println("add");
                }
                ourClientManager.getCommitClient().doCommit(new File[]{commitFile}, true, "", null, null, true, false, SVNDepth.INFINITY);
                System.out.println("commit");
            } else {
                ourClientManager.getCommitClient().doCommit(new File[]{commitFile}, true, "", null, null, true, false, SVNDepth.INFINITY);
                System.out.println("commit");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
        return true;
    }

    public static Boolean doImport(String dirPath) {
        DAVRepositoryFactory.setup();
        SVNURL repositoryURL = null;
        try {
            repositoryURL = SVNURL.parseURIEncoded((String)SvnConst.SVN_URL);
        }
        catch (SVNException e) {
            log.error("", (Throwable)e);
        }
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        ourClientManager = SVNClientManager.newInstance((DefaultSVNOptions)options, (String)SvnConst.SVN_USERNAME, (String)SvnConst.SVN_PWD);
        File impDir = new File(dirPath);
        SVNCommitInfo commitInfo = null;
        try {
            commitInfo = ourClientManager.getCommitClient().doImport(impDir, repositoryURL, "import operation!", null, false, false, SVNDepth.INFINITY);
        }
        catch (SVNException e) {
            log.error("", (Throwable)e);
            return false;
        }
        System.out.println(commitInfo.toString());
        return true;
    }

    public static void main(String[] args) {
        SvnKit.doExport(SvnConst.SVN_USERNAME, SvnConst.SVN_PWD, SvnConst.SVN_URL, SvnConst.SVN_LOCAL_DIR);
    }

    static {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        DoUpdateStatus = true;
    }
}

