-- 用户列表
#sql("list")
	SELECT
		u.id,
		#if(email != null && email != "")
			u.loginname, 
		#end
		#if(noemail != null && noemail != "")
			'******' loginname, 
		#end
		u.nick,
		u.avatar,
		#if(email != null && email != "")
			ub.email,
			ub.phone,
		#end
		#if(noemail != null && noemail != "")
			'******' email, 
			'******' phone,
		#end
		u.createtime,
		u.`status`,
		ub.sign,
		ub.sex,
		ub.validphone,
		ub.validemail,
		ri.ip,
		ri.province,
		ri.city,
		ll.createtime lastlogintime,
		friend.count fcount,
		grouptable.count gcount,
		allgroup.count agcount,
		fromcall.count fcallcount,
		fromcall.callduration fduration,
		tocall.callduration toduration,
		tocall.count tcallcount
	FROM
		`user` u
	INNER JOIN user_base ub ON u.id = ub.uid
	LEFT JOIN ip_info ri ON ri.id = u.ipid
	LEFT JOIN user_last_login_time ll ON ll.uid = u.id
	LEFT JOIN (
		SELECT
			uid,
			count(1) count
		FROM
			wx_friend
		WHERE
			`status` = 1
		GROUP BY
			uid
	) AS friend ON friend.uid = u.id
	LEFT JOIN (
		SELECT
			uid,
			count(1) count
		FROM
			wx_group
		WHERE
			`status` = 1
		GROUP BY
			uid
	) AS grouptable ON grouptable.uid = u.id
	LEFT JOIN (
		SELECT
			uid,
			count(1) count
		FROM
			wx_group_user
		WHERE
			`status` = 1
		GROUP BY
			uid
	) AS allgroup ON allgroup.uid = u.id
	LEFT JOIN (
		SELECT
			fromuid uid,
			count(1) count,
			callduration
		FROM
			wx_call_item
		WHERE
			callduration > 0
		GROUP BY
			fromuid
	) AS fromcall ON fromcall.uid = u.id
	LEFT JOIN (
		SELECT
			touid uid,
			count(1) count,
			callduration
		FROM
			wx_call_item
		WHERE
			callduration > 0
		GROUP BY
			touid
	) AS tocall ON tocall.uid = u.id
	
	
	where
		#if(status != null && status != "")
			 u.`status` = #para(status) 
		#end
		#if(defaultstatus != null && defaultstatus != "")
			 u.`status` != #para(defaultstatus) 
		#end
		#if(searchkey != null && searchkey != "")
			and (u.loginname like #para(searchkey) or u.nick like #para(searchkey)
			### or ub.phone like #para(searchkey) 
				or u.id = #para(searchid))
		#end
	order by u.id desc
#end

-- 用户信息
#sql("info")
	SELECT
		u.id,
		#if(email != null && email != "")
			u.loginname, 
		#end
		#if(noemail != null && noemail != "")
			'******' loginname, 
		#end
		u.nick,
		u.avatar,
		#if(email != null && email != "")
			ub.email,
			ub.phone,
		#end
		#if(noemail != null && noemail != "")
			'******' email, 
			'******' phone,
		#end
		u.createtime,
		u.`status`,
		ub.sign,
		ub.sex,
		ub.validphone,
		ub.validemail,
		ri.ip,
		ri.province,
		ri.city,
		ll.createtime lastlogintime,
		friend.count fcount,
		grouptable.count gcount,
		allgroup.count agcount,
		fromcall.count fcallcount,
		fromcall.callduration fduration,
		tocall.callduration toduration,
		tocall.count tcallcount
	FROM
		`user` u
	INNER JOIN user_base ub ON u.id = ub.uid
	LEFT JOIN ip_info ri ON ri.id = u.ipid
	LEFT JOIN user_last_login_time ll ON ll.uid = u.id
	LEFT JOIN (
		SELECT
			uid,
			count(1) count
		FROM
			wx_friend
		WHERE
			 uid = #para(uid) and `status` = 1 
	) AS friend ON friend.uid = u.id
	LEFT JOIN (
		SELECT
			uid,
			count(1) count
		FROM
			wx_group
		WHERE
			uid = #para(uid) and `status` = 1 
	) AS grouptable ON grouptable.uid = u.id
	LEFT JOIN (
		SELECT
			uid,
			count(1) count
		FROM
			wx_group_user
		WHERE
			uid = #para(uid) and `status` = 1
	) AS allgroup ON allgroup.uid = u.id
	LEFT JOIN (
		SELECT
			fromuid uid,
			count(1) count,
			callduration
		FROM
			wx_call_item
		WHERE
			fromuid = #para(uid) and callduration > 0
	) AS fromcall ON fromcall.uid = u.id
	LEFT JOIN (
		SELECT
			touid uid,
			count(1) count,
			callduration
		FROM
			wx_call_item
		WHERE
			touid = #para(uid) and  callduration > 0
	) AS tocall ON tocall.uid = u.id
	where
		u.id = #para(uid) 
#end
			
-- 统计用户列表
#sql("statlist")
	SELECT
		u.id,
		#if(email != null && email != "")
			u.loginname, 
		#end
		#if(noemail != null && noemail != "")
			'******' loginname, 
		#end
		u.nick,
		u.avatar,
		#if(email != null && email != "")
			ub.email,
			ub.phone,
		#end
		#if(noemail != null && noemail != "")
			'******' email, 
			'******' phone,
		#end
		u.createtime,
		u.`status`,
		ub.sign,
		ub.sex,
		ub.validphone,
		ub.validemail,
		ri.ip,
		ri.province,
		ri.city,
		friend.count fcount,
		allgroup.count agcount,
		ll.createtime lastlogintime
	FROM
		`user` u
	INNER JOIN user_base ub ON u.id = ub.uid
	LEFT JOIN ip_info ri ON ri.id = u.ipid
	LEFT JOIN user_last_login_time ll ON ll.uid = u.id
	LEFT JOIN (
		SELECT
			uid,
			count(1) count
		FROM
			wx_friend
		WHERE
			`status` = 1
		GROUP BY
			uid
	) AS friend ON friend.uid = u.id
	LEFT JOIN (
		SELECT
			uid,
			count(1) count
		FROM
			wx_group_user
		WHERE
			`status` = 1
		GROUP BY
			uid
	) AS allgroup ON allgroup.uid = u.id
	where
		 u.createtime >= #para(starttime) 
		 and u.createtime <= #para(endtime) 
		#if(ipid != null && ipid != "")
		  	and u.ipid = #para(ipid) 
		#end
	order by u.id desc
#end