/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.auth;

import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.UserRoleService;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.web.server.auth.AccessCtrlConfig;

public class AccessCtrlService {
    private static Logger log = LoggerFactory.getLogger(AccessCtrlService.class);
    public static final String PATH_CURR_USER = "/user/curr";

    public static boolean canAccess(AccessCtrlConfig accessCtrlConfig, String userid, String servletPath1) throws IOException {
        if (accessCtrlConfig == null) {
            log.error("\u6ca1\u6709\u914d\u7f6e\u6743\u9650\u63a7\u5236\uff0c\u8bf4\u660e\u4e0d\u9700\u8981\u8fdb\u884c\u6743\u9650\u63a7\u5236");
            return true;
        }
        String servletPath = servletPath1;
        if (Const.USE_ANONYMOUS && PATH_CURR_USER.equals(servletPath)) {
            log.error("\u53c2\u6570\u914d\u7f6e\u6743\u9650\u4e0d\u63a7\u5236\uff0c\u8bf4\u660e\u4e0d\u9700\u8981\u8fdb\u884c\u6743\u9650\u63a7\u5236");
            return true;
        }
        Object neededRolecodes = accessCtrlConfig.getNeededRolecodes(servletPath);
        if (neededRolecodes != null) {
            boolean b = false;
            if (neededRolecodes instanceof List) {
                String neededRolecode;
                List _neededRolecodes = (List)neededRolecodes;
                Iterator iterator = _neededRolecodes.iterator();
                while (iterator.hasNext() && !(b = AccessCtrlService.isMeetRoleExp(neededRolecode = (String)iterator.next(), userid).booleanValue())) {
                }
            } else {
                b = AccessCtrlService.isMeetRoleExp((String)neededRolecodes, userid);
            }
            return b;
        }
        return true;
    }

    public static boolean hasRole(String userid, Byte code) throws Exception {
        User user = UserService.ME.getById(userid);
        return AccessCtrlService.hasRole(user, code);
    }

    public static boolean hasRole(User user, Byte code) throws Exception {
        if (user == null) {
            return false;
        }
        if (!UserRoleService.checkUserStatus((User)user)) {
            return false;
        }
        List roles = user.getRoles();
        if (roles == null || roles.isEmpty()) {
            return false;
        }
        return roles.contains(code);
    }

    private static Boolean isMeetRoleExp(String roleCodeExp, String userid) throws IOException {
        block17: {
            if ("true".equals(roleCodeExp) || "".equals(roleCodeExp)) {
                return true;
            }
            if ("false".equals(roleCodeExp)) {
                return false;
            }
            if (roleCodeExp.contains("(") && roleCodeExp.contains(")")) {
                String rolecode = AccessCtrlService.getBracketValue(roleCodeExp);
                Boolean ret = AccessCtrlService.isMeetRoleExp(rolecode, userid);
                roleCodeExp = AccessCtrlService.replaceBracketValue(roleCodeExp, ret.toString());
                return AccessCtrlService.isMeetRoleExp(roleCodeExp, userid);
            }
            if (roleCodeExp.contains("&")) {
                String[] codes = StrUtil.split((CharSequence)roleCodeExp, (CharSequence)"&");
                boolean ret = true;
                for (String code : codes) {
                    boolean bl = ret = ret && AccessCtrlService.isMeetRoleExp(code, userid) != false;
                    if (ret) continue;
                    return false;
                }
                return true;
            }
            if (roleCodeExp.contains("|")) {
                String[] codes = StrUtil.split((CharSequence)roleCodeExp, (CharSequence)"|");
                boolean ret = false;
                for (String code : codes) {
                    boolean bl = ret = ret || AccessCtrlService.isMeetRoleExp(code, userid) != false;
                    if (!ret) continue;
                    return true;
                }
                return false;
            }
            if (roleCodeExp.startsWith("!")) {
                String excludedRolecode = roleCodeExp.substring(1);
                try {
                    if (userid == null) {
                        return true;
                    }
                    if (AccessCtrlService.hasRole(userid, Byte.valueOf(excludedRolecode))) {
                        return false;
                    }
                    break block17;
                }
                catch (Throwable e) {
                    log.error("", e);
                    return false;
                }
            }
            if ("*".equals(roleCodeExp)) {
                if (userid != null) {
                    return true;
                }
                return false;
            }
            try {
                if (userid == null || !AccessCtrlService.hasRole(userid, Byte.valueOf(roleCodeExp))) {
                    return false;
                }
            }
            catch (Throwable e) {
                log.error("", e);
                return false;
            }
        }
        return true;
    }

    private static String getBracketValue(String input) {
        String regex = "\\({1}[^\\(\\)]+\\){1}";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(input);
        String reserved = "";
        if (matcher.find()) {
            reserved = matcher.group(0);
        }
        String ret = AccessCtrlService.replaceAll(reserved, "\\(|\\)", "");
        return ret;
    }

    public static void main(String[] args) {
        String input = "4|(5&(3|6))";
        String ret = AccessCtrlService.replaceBracketValue(input, "false");
        System.out.println(ret);
        String xx = AccessCtrlService.getBracketValue(input);
        System.out.println(xx);
    }

    public static String replaceAll(String input, String regex, String replacement) {
        Pattern p = Pattern.compile(regex, 2);
        Matcher m = p.matcher(input);
        String result = m.replaceAll(replacement);
        return result;
    }

    private static String replaceBracketValue(String input, String value) {
        String regex = "\\({1}[^\\(\\)]+\\){1}";
        return AccessCtrlService.replaceAll(input, regex, value);
    }
}

