/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller;

import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.annotation.RequestPath;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.IpInfo;
import org.tio.sitexxx.service.model.main.TioUsageStat;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.web.server.init.WebApiInit;
import org.tio.utils.cache.ICache;
import org.tio.utils.hutool.DateUtil;

@RequestPath(value="/open")
public class OpenController {
    private static Logger log = LoggerFactory.getLogger(OpenController.class);

    @RequestPath(value="/lastVersion1")
    public String lastVersion1(HttpRequest request, String v) throws Exception {
        ICache cache = Caches.getCache((CacheConfig)CacheConfig.LATEST_VERSION);
        String id = request.getHttpSession().getId();
        cache.put(id, (Serializable)((Object)v));
        return id;
    }

    @RequestPath(value="/lastVersion2")
    public String lastVersion2(final HttpRequest request, final String id) throws Exception {
        WebApiInit.serverTioConfig.groupExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ICache cache = Caches.getCache((CacheConfig)CacheConfig.LATEST_VERSION);
                String version = (String)cache.get(id, String.class);
                if (StrUtil.isBlank((CharSequence)version)) {
                    request.close();
                    return;
                }
                cache.remove(id);
                Date date = new Date();
                IpInfo ipInfo = IpInfoService.ME.save(request.getClientIp());
                TioUsageStat tioUsageStat = new TioUsageStat();
                tioUsageStat.setIp(request.getClientIp());
                tioUsageStat.setIpid(ipInfo.getId());
                tioUsageStat.setVersion(version);
                tioUsageStat.setLatestversion("3.7.1.2207-SNAPSHOT");
                tioUsageStat.setIslatest(Byte.valueOf(Objects.equals("3.7.1.2207-SNAPSHOT", version) ? (byte)1 : 2));
                tioUsageStat.setTime(date);
                try {
                    String uid = UserService.ME.getUidByIpid(ipInfo.getId());
                    if (uid != null) {
                        tioUsageStat.setUid(uid);
                        tioUsageStat.setUpdateuidtime(date);
                    }
                }
                catch (Exception e) {
                    log.error("\u4e0d\u5f71\u54cd\u903b\u8f91", (Throwable)e);
                }
                try {
                    String userVersionDateStr = version.substring(version.length() - 16, version.length() - 8);
                    String latestVersionDateStr = "3.7.1.2207-SNAPSHOT".substring("3.7.1.2207-SNAPSHOT".length() - 16, "3.7.1.2207-SNAPSHOT".length() - 8);
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                    Date userVersionDate = format.parse(userVersionDateStr);
                    Date latestVersionDate = format.parse(latestVersionDateStr);
                    Integer days = DateUtil.daysBetween((Date)userVersionDate, (Date)latestVersionDate);
                    tioUsageStat.setDays(days);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
                tioUsageStat.save();
            }
        });
        return "3.7.1.2207-SNAPSHOT";
    }
}

