/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.base;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.AES;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.server.annotation.RequestPath;
import org.tio.http.server.util.Resps;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.init.PropInit;
import org.tio.sitexxx.service.vo.RequestExt;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.utils.SystemTimer;
import org.tio.utils.cache.ICache;
import org.tio.utils.crypto.ACEUtils;
import org.tio.utils.crypto.Md5;
import org.tio.utils.jfinal.P;
import org.tio.utils.resp.Resp;

@RequestPath(value="/a")
public class AccessTokenController {
    private static Logger log = LoggerFactory.getLogger(AccessTokenController.class);
    public static final String androidKey1 = P.get((String)"access.token.android.key1");
    public static final String androidKey2 = P.get((String)"access.token.android.key2");
    public static final String androidKey3 = P.get((String)"access.token.android.key3");
    public static final String iosKey1 = P.get((String)"access.token.ios.key1");
    public static final String iosKey2 = P.get((String)"access.token.ios.key2");
    public static final String iosKey3 = P.get((String)"access.token.ios.key3");
    public static final String pcKey1 = P.get((String)"access.token.pc.key1");
    public static final String pcKey2 = P.get((String)"access.token.pc.key2");
    public static final String pcKey3 = P.get((String)"access.token.pc.key3");
    public static final long MAX_TIME_INTERVAL = 86400000L;

    public static void main(String[] args) {
        PropInit.init();
        String content = "test\u4e2d\u6587";
        byte[] key = SecureUtil.generateKey((String)SymmetricAlgorithm.AES.getValue()).getEncoded();
        System.out.println(new String(key));
        AES aes = SecureUtil.aes((byte[])key);
        byte[] encrypt = aes.encrypt(content);
        byte[] decrypt = aes.decrypt(encrypt);
        String encryptHex = aes.encryptHex(content);
        String decryptStr = aes.decryptStr(encryptHex);
        System.out.println(encryptHex);
        System.out.println(decryptStr);
    }

    private static void error(HttpRequest request, String msg) {
        log.error(request.getClientIp() + "\r\n" + request.getRequestLine() + "\r\n" + msg);
    }

    @RequestPath(value="/x")
    public HttpResponse step1(HttpRequest request, String r, Long t, String s) throws Exception {
        if (t == null) {
            AccessTokenController.error(request, "\u53c2\u6570t\u4e3a\u7a7a");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        if (r == null || r.length() != 9) {
            AccessTokenController.error(request, "\u53c2\u6570r\u4e3a\u7a7a\u6216\u5176\u957f\u5ea6\u4e0d\u4e3a9");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        long time = SystemTimer.currTime;
        if (Math.abs(time - t) > 86400000L) {
            AccessTokenController.error(request, "\u53c2\u6570t\u4e0e\u670d\u52a1\u5668\u65f6\u95f4\u76f8\u9694\u8d85\u8fc71\u5929");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        if (StrUtil.isBlank((CharSequence)s)) {
            AccessTokenController.error(request, "\u53c2\u6570s\u4e3a\u7a7a");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        RequestExt requestExt = WebUtils.getRequestExt(request);
        String key1 = AccessTokenController.getKey1(request, requestExt);
        String sign = Md5.getMD5((String)("${" + key1 + r + t + "}"));
        if (!Objects.equals(sign, s)) {
            AccessTokenController.error(request, "\u9a8c\u7b7e\u5931\u8d25");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        AccessTokenResp1 accessTokenResp1 = new AccessTokenResp1(t);
        ICache cache = Caches.getCache((CacheConfig)CacheConfig.ACCESS_TOKEN_RESP_1);
        cache.put(accessTokenResp1.getX() + request.getClientIp() + accessTokenResp1.getY(), (Serializable)accessTokenResp1);
        HttpResponse ret = Resps.json((HttpRequest)request, (Object)Resp.ok((Object)accessTokenResp1));
        return ret;
    }

    @RequestPath(value="/y")
    public HttpResponse step2(HttpRequest request, String x, String y, String z, String i, Long t, String s) throws Exception {
        if (t == null) {
            AccessTokenController.error(request, "\u53c2\u6570t\u4e3a\u7a7a");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        if (StrUtil.isBlank((CharSequence)x) || x.length() != 9) {
            AccessTokenController.error(request, "\u53c2\u6570x\u4e3a\u7a7a\u6216\u957f\u5ea6\u4e0d\u5bf9");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        if (StrUtil.isBlank((CharSequence)y) || x.length() != 9) {
            AccessTokenController.error(request, "\u53c2\u6570y\u4e3a\u7a7a\u6216\u957f\u5ea6\u4e0d\u5bf9");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        if (StrUtil.isBlank((CharSequence)z) || x.length() != 9) {
            AccessTokenController.error(request, "\u53c2\u6570z\u4e3a\u7a7a\u6216\u957f\u5ea6\u4e0d\u5bf9");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        if (StrUtil.isBlank((CharSequence)i) || x.length() != 9) {
            AccessTokenController.error(request, "\u53c2\u6570i\u4e3a\u7a7a\u6216\u957f\u5ea6\u4e0d\u5bf9");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        long time = SystemTimer.currTime;
        if (Math.abs(time - t) > 86400000L) {
            AccessTokenController.error(request, "\u53c2\u6570t\u4e0e\u670d\u52a1\u5668\u65f6\u95f4\u76f8\u9694\u8d85\u8fc71\u5929");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        if (StrUtil.isBlank((CharSequence)s)) {
            AccessTokenController.error(request, "\u53c2\u6570s\u4e3a\u7a7a");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        RequestExt requestExt = WebUtils.getRequestExt(request);
        String key2 = AccessTokenController.getKey2(request, requestExt);
        String sign = Md5.getMD5((String)("${" + key2 + y + i + "}"));
        if (!Objects.equals(sign, s)) {
            AccessTokenController.error(request, "\u9a8c\u7b7e\u5931\u8d25");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        ICache cache = Caches.getCache((CacheConfig)CacheConfig.ACCESS_TOKEN_RESP_1);
        AccessTokenResp1 accessTokenResp1 = (AccessTokenResp1)cache.get(y + request.getClientIp() + x, AccessTokenResp1.class);
        if (accessTokenResp1 == null) {
            AccessTokenController.error(request, "\u83b7\u53d6\u4e0d\u5230AccessTokenResp1\uff0c\u4e5f\u8bb8\u5df2\u7ecf\u8d85\u65f6\uff0c\u6216\u8005\u8fd9\u662f\u4e2a\u975e\u6cd5\u8bf7\u6c42");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        if (!Objects.equals(i, accessTokenResp1.getZ()) || !Objects.equals(z, accessTokenResp1.getI())) {
            AccessTokenController.error(request, "i\u548cz\u7684\u503c\u4e0d\u5bf9");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        long iv = t - accessTokenResp1.getT();
        if (iv <= 0L || iv > 5000L) {
            AccessTokenController.error(request, "\u8fd9\u6b21\u4f20\u7684t\u548c\u4e0a\u6b21\u7684t\u76f8\u9694" + iv + "\u6beb\u79d2");
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"");
            return null;
        }
        String key3 = AccessTokenController.getKey3(request, requestExt);
        String sessionid = request.getHttpSession().getId();
        ICache cacheTemp = Caches.getCache((CacheConfig)CacheConfig.TIO_ACCESS_TOKEN_TEMP);
        String xxxx = (String)cacheTemp.get(sessionid, String.class);
        if (StrUtil.isBlank((CharSequence)xxxx)) {
            HttpConfig httpConfig = request.httpConfig;
            xxxx = httpConfig.getSessionIdGenerator().sessionId(httpConfig, request);
            cacheTemp.put(sessionid, (Serializable)((Object)xxxx));
        }
        String zzz = ACEUtils.encrypt((String)xxxx, (String)key3, (String)key3);
        ICache cache2 = Caches.getCache((CacheConfig)CacheConfig.TIO_ACCESS_TOKEN);
        cache2.put(request.getHttpSession().getId(), (Serializable)((Object)xxxx));
        HttpResponse ret = Resps.json((HttpRequest)request, (Object)Resp.ok((Object)zzz));
        ICache cache3 = Caches.getCache((CacheConfig)CacheConfig.TIO_ACCESSTOKEN_USERAGENT);
        cache3.put(xxxx, (Serializable)((Object)request.getUserAgent()));
        return ret;
    }

    private static String getKey1(HttpRequest request, RequestExt requestExt) {
        boolean isFromAndroid = requestExt.isFromAppAndroid();
        if (isFromAndroid) {
            return androidKey1;
        }
        boolean isFromPc = requestExt.isFromBrowser();
        if (isFromPc) {
            return pcKey1;
        }
        boolean isFromIos = requestExt.isFromAppIos();
        if (isFromIos) {
            return iosKey1;
        }
        Tio.remove((ChannelContext)request.getChannelContext(), (String)"\u8fd9\u4e2ahttp\u8bf7\u6c42\u4e0d\u6765\u81eapc\u3001ios\u3001android\u4efb\u4f55\u4e00\u65b9");
        return null;
    }

    private static String getKey2(HttpRequest request, RequestExt requestExt) {
        boolean isFromAndroid = requestExt.isFromAppAndroid();
        if (isFromAndroid) {
            return androidKey2;
        }
        boolean isFromPc = requestExt.isFromBrowser();
        if (isFromPc) {
            return pcKey2;
        }
        boolean isFromIos = requestExt.isFromAppIos();
        if (isFromIos) {
            return iosKey2;
        }
        Tio.remove((ChannelContext)request.getChannelContext(), (String)"\u8fd9\u4e2ahttp\u8bf7\u6c42\u4e0d\u6765\u81eapc\u3001ios\u3001android\u4efb\u4f55\u4e00\u65b9");
        return null;
    }

    private static String getKey3(HttpRequest request, RequestExt requestExt) {
        boolean isFromAndroid = requestExt.isFromAppAndroid();
        if (isFromAndroid) {
            return androidKey3;
        }
        boolean isFromPc = requestExt.isFromBrowser();
        if (isFromPc) {
            return pcKey3;
        }
        boolean isFromIos = requestExt.isFromAppIos();
        if (isFromIos) {
            return iosKey3;
        }
        Tio.remove((ChannelContext)request.getChannelContext(), (String)"\u8fd9\u4e2ahttp\u8bf7\u6c42\u4e0d\u6765\u81eapc\u3001ios\u3001android\u4efb\u4f55\u4e00\u65b9");
        return null;
    }

    public static class AccessTokenResp1
    implements Serializable {
        private static final long serialVersionUID = -4042961444820016173L;
        public static final int RANDOM_LEN = 9;
        private String x = RandomUtil.randomString((int)9);
        private String y = RandomUtil.randomString((int)9);
        private String z = RandomUtil.randomString((int)9);
        private String i = RandomUtil.randomString((int)9);
        private Long t = null;

        public AccessTokenResp1(Long t) {
            this.t = t;
        }

        public String getX() {
            return this.x;
        }

        public void setX(String x) {
            this.x = x;
        }

        public String getY() {
            return this.y;
        }

        public void setY(String y) {
            this.y = y;
        }

        public String getZ() {
            return this.z;
        }

        public void setZ(String z) {
            this.z = z;
        }

        public String getI() {
            return this.i;
        }

        public void setI(String i) {
            this.i = i;
        }

        public Long getT() {
            return this.t;
        }

        public void setT(Long t) {
            this.t = t;
        }
    }
}

