/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.base;

import java.util.HashMap;
import java.util.Map;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.annotation.RequestPath;
import org.tio.sitexxx.service.init.PropInit;
import org.tio.sitexxx.service.init.RedisInit;
import org.tio.sitexxx.service.service.conf.ConfService;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.service.vo.topic.TopicVo;
import org.tio.utils.jfinal.P;
import org.tio.utils.resp.Resp;

@RequestPath(value="/config")
public class ConfigController {
    private static Logger log = LoggerFactory.getLogger(ConfigController.class);
    public static Map<String, Object> CONFIG_MAP = new HashMap<String, Object>();
    public static Map<String, Object> VIEW_MODEL = new HashMap<String, Object>();

    public static void main(String[] args) {
    }

    @RequestPath(value="/update")
    public Resp update(HttpRequest request) throws Exception {
        P.clear();
        PropInit.forceInit();
        return Resp.ok();
    }

    @RequestPath(value="/clearConf")
    public Resp clearConf(HttpRequest request) throws Exception {
        ConfService.clearCache();
        RedissonClient redisson = RedisInit.get();
        RTopic topic1 = redisson.getTopic("COMMON_TOPIC");
        TopicVo topicVo = new TopicVo();
        topicVo.setType(Byte.valueOf((byte)3));
        topic1.publish((Object)topicVo);
        return Resp.ok();
    }

    @RequestPath(value="/clearAll")
    public Resp clearAll(HttpRequest request) throws Exception {
        this.clearConf(request);
        this.update(request);
        return Resp.ok();
    }

    @RequestPath(value="/viewmodel")
    public Resp viewmodel(HttpRequest request) throws Exception {
        return Resp.ok(VIEW_MODEL);
    }

    @RequestPath(value="/base")
    public Resp config(HttpRequest request) throws Exception {
        return Resp.ok(CONFIG_MAP);
    }

    static {
        String title = ConfService.getString((String)"seo.title", (String)"t-io - \u89e3\u51b3\u5176\u5b83\u7f51\u7edc\u6846\u67b6\u6ca1\u6709\u89e3\u51b3\u7684\u75db\u70b9");
        String keywords = ConfService.getString((String)"seo.keywords", (String)"t-io,tio,\u5f00\u6e90,netty,mina,rpc,jfinal,layui,hutool,osc,io,socket,tcp,nio,aio,nio2,im,\u6e38\u620f,java,\u957f\u8fde\u63a5");
        String description = ConfService.getString((String)"seo.description", (String)"t-io - \u89e3\u51b3\u5176\u5b83\u7f51\u7edc\u6846\u67b6\u6ca1\u6709\u89e3\u51b3\u7684\u75db\u70b9");
        String jsVersion = ConfService.getString((String)"js_version", (String)"1");
        CONFIG_MAP.put("res_server", Const.RES_SERVER);
        CONFIG_MAP.put("session_cookie_name", Const.Http.SESSION_COOKIE_NAME);
        CONFIG_MAP.put("api_ctx", Const.API_CONTEXTPATH);
        CONFIG_MAP.put("api_suf", Const.API_SUFFIX);
        CONFIG_MAP.put("js_version", jsVersion);
        CONFIG_MAP.put("sitename", ConfService.getString((String)"sitename", (String)"t-io\u793e\u4ea4IM\u5e73\u53f0"));
        CONFIG_MAP.put("im_heartbeat_timeout", Const.IM_HEARTBEAT_TIMEOUT);
        String tioim_title = ConfService.getString((String)"tioim.title", (String)"\u8c2d\u804a\uff0c\u8ba9\u6240\u6709\u516c\u53f8\u7528\u5f97\u4e0a\u9760\u8c31\u7684IM");
        String tioim_keywords = ConfService.getString((String)"tioim.keywords", (String)"IM,t-io,\u9ad8\u5e76\u53d1,\u96c6\u7fa4,\u79c1\u6709\u90e8\u7f72");
        String tioim_description = ConfService.getString((String)"tioim.description", (String)"\u8c2d\u804a\u662f\u57fa\u4e8et-io\u7814\u53d1\u7684\u7c7b\u4f3c\u5fae\u4fe1\u7684\u5b8c\u6574IM\uff0c\u652f\u6301\u96c6\u7fa4\u3001\u8bed\u97f3\u901a\u8bdd\u3001\u89c6\u9891\u901a\u8bdd\u3001\u79c1\u804a\u3001\u7fa4\u804a");
        VIEW_MODEL.put("tioim_title", tioim_title);
        VIEW_MODEL.put("tioim_keywords", tioim_keywords);
        VIEW_MODEL.put("tioim_description", tioim_description);
        VIEW_MODEL.put("title", title);
        VIEW_MODEL.put("keywords", keywords);
        VIEW_MODEL.put("description", description);
        VIEW_MODEL.putAll(CONFIG_MAP);
    }
}

