/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.base;

import cn.hutool.core.img.ImgUtil;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.UploadFile;
import org.tio.http.server.annotation.RequestPath;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.sitexxx.service.model.main.Img;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.ImgService;
import org.tio.sitexxx.service.service.base.UserRoleService;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.web.server.utils.ImgUtils;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.utils.resp.Resp;

@RequestPath(value="/img")
public class ImgController {
    private static Logger log = LoggerFactory.getLogger(ImgController.class);

    @RequestPath(value="/page")
    public Resp page(Integer pageNumber, Integer pageSize, Integer start, Byte status, HttpRequest request) throws Exception {
        pageSize = 18;
        pageNumber = 1;
        User curr = WebUtils.currUser(request);
        Page page = ImgService.me.page(curr, pageNumber.intValue(), pageSize.intValue(), start, status);
        return Resp.ok((Object)page);
    }

    @RequestPath(value="/page1")
    public Resp page1(Integer pageNumber, Integer pageSize, Integer start, Byte status, HttpRequest request) throws Exception {
        return this.page(pageNumber, pageSize, start, status, request);
    }

    @RequestPath(value="/updateStatus")
    public Resp updateStatus(HttpRequest request, int id, byte status) {
        ImgService.me.updateStatus(id, status);
        WebUtils.clearHttpcache("/img/page1");
        WebUtils.clearHttpcache("/img/page");
        return Resp.ok();
    }

    public Resp uploadImg(HttpRequest request, UploadFile uploadFile, String imgRootDir, int maxsize, Integer maxwidth) throws Exception {
        User curr = WebUtils.currUser(request);
        byte[] imageBytes = uploadFile.getData();
        Resp ret = null;
        if (!UserService.isSuper((User)curr) && !UserRoleService.hasRole((User)curr, (Byte)6) && imageBytes.length > 1024 * maxsize) {
            ret = Resp.fail((String)("\u6587\u4ef6\u5c3a\u5bf8\u4e0d\u80fd\u5927\u4e8e" + maxsize + "KB"));
        }
        String uid = null;
        uid = curr != null ? curr.getId() : "1";
        BufferedImage bi = ImgUtil.toImage((byte[])imageBytes);
        float scale = ImgUtils.calcScaleWithWidth(maxwidth, bi);
        Img img = ImgUtils.processImg(imgRootDir, uid, uploadFile, scale);
        img.setComefrom(Byte.valueOf((byte)1));
        img.setStatus(Byte.valueOf((byte)1));
        img.setSession(request.getHttpSession().getId());
        boolean f = ImgService.me.save(img);
        if (ret != null) {
            return ret;
        }
        if (f) {
            return Resp.ok((Object)img);
        }
        return Resp.fail((String)"\u670d\u52a1\u5668\u5f02\u5e38");
    }
}

