/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.base;

import cn.hutool.core.date.DateUtil;
import org.redisson.api.RKeys;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.annotation.RequestPath;
import org.tio.sitexxx.service.init.RedisInit;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.utils.cache.redis.RedisCache;
import org.tio.utils.resp.Resp;

@RequestPath(value="/redis")
public class RedisController {
    private static Logger log = LoggerFactory.getLogger(RedisController.class);

    @RequestPath(value="/getTtl")
    public Resp getTtl(HttpRequest request, String cacheName, String key) throws Exception {
        RedisCache redisCache = RedisCache.getCache((String)cacheName);
        if (redisCache == null) {
            return Resp.fail((String)("cacheName\u3010" + cacheName + "\u3011\u4e0d\u5b58\u5728"));
        }
        long remainTimeToLive = redisCache.ttl(key);
        if (remainTimeToLive == -1L) {
            return Resp.fail((String)"\u4e0d\u4f1a\u8d85\u65f6(-1)");
        }
        if (remainTimeToLive == -2L) {
            return Resp.fail((String)"key\u4e0d\u5b58\u5728(-2)");
        }
        return Resp.ok((Object)DateUtil.formatBetween((long)remainTimeToLive));
    }

    @RequestPath(value="/clean")
    public Resp clean(HttpRequest request, String cacheName) throws Exception {
        User currUser = WebUtils.currUser(request);
        if (currUser == null || !UserService.isSuper((User)currUser)) {
            return Resp.fail((String)"\u4f60\u6ca1\u8d44\u683c\u6e05\u9664redis\u7f13\u5b58");
        }
        RedisCache redisCache = RedisCache.getCache((String)cacheName);
        if (redisCache == null) {
            RedissonClient redisson = RedisInit.get();
            RKeys keys = redisson.getKeys();
            keys.deleteByPatternAsync(RedisCache.keyPrefix((String)cacheName) + "*");
        } else {
            redisCache.clear();
        }
        return Resp.ok();
    }
}

