/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.base;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.img.ImgUtil;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.UploadFile;
import org.tio.http.common.session.HttpSession;
import org.tio.http.server.annotation.RequestPath;
import org.tio.http.server.mvc.Routes;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.sitexxx.im.server.handler.wx.WxChatApi;
import org.tio.sitexxx.service.model.main.Img;
import org.tio.sitexxx.service.model.main.UserAddress;
import org.tio.sitexxx.service.model.main.WxChatUserItem;
import org.tio.sitexxx.service.model.main.WxFriend;
import org.tio.sitexxx.service.model.main.WxUserBlackItems;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.ImgService;
import org.tio.sitexxx.service.service.base.ChatroomJoinLeaveService;
import org.tio.sitexxx.service.service.base.LoginLogService;
import org.tio.sitexxx.service.service.base.UserRoleService;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.service.chat.ChatIndexService;
import org.tio.sitexxx.service.service.chat.ChatService;
import org.tio.sitexxx.service.service.chat.FriendService;
import org.tio.sitexxx.service.service.conf.ConfService;
import org.tio.sitexxx.service.utils.CommonUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.service.vo.SessionExt;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.sitexxx.web.server.controller.base.LoginController;
import org.tio.sitexxx.web.server.utils.ImgUtils;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.sitexxx.web.server.utils.WxGroupAvatarUtil;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.resp.Resp;

@RequestPath(value="/user")
public class UserController {
    private static Logger log = LoggerFactory.getLogger(UserController.class);
    private UserService userService = UserService.ME;

    @RequestPath(value="/search")
    public Resp search(String nick, String uid, String loginname, Integer pageNumber, Integer pageSize, HttpRequest request) throws Exception {
        pageSize = 20;
        User curr = WebUtils.currUser(request);
        Page page = UserService.ME.search(curr, nick, uid, loginname, pageNumber, pageSize);
        return Resp.ok((Object)page);
    }

    @RequestPath(value="/info")
    public Resp info(String uid, HttpRequest request) throws Exception {
        WxFriend friend;
        WxChatUserItem fd;
        if (uid == null) {
            return Resp.fail((String)"\u7528\u6237id\u53c2\u6570\u4e3a\u7a7a");
        }
        User curr = WebUtils.currUser(request);
        Record record = UserService.ME.info(uid);
        if (curr != null && ChatService.existFriend((WxChatUserItem)(fd = ChatIndexService.fdUserIndex((String)curr.getId(), (String)uid))) && (friend = FriendService.me.getFriendInfo(fd.getLinkid())) != null && StrUtil.isNotBlank((CharSequence)friend.getRemarkname())) {
            Record newread = new Record();
            HashMap<String, String> retMap = new HashMap<String, String>();
            BeanUtil.copyProperties((Object)record.getColumns(), retMap, (String[])new String[0]);
            retMap.put("remarkname", friend.getRemarkname());
            newread.setColumns(retMap);
            return Resp.ok((Object)newread);
        }
        return Resp.ok((Object)record);
    }

    @RequestPath(value="/block")
    public Resp block(String uid, HttpRequest request) throws Exception {
        if (uid == null) {
            return Resp.fail((String)"\u7528\u6237id\u53c2\u6570\u4e3a\u7a7a");
        }
        User curr = WebUtils.currUser(request);
        WxUserBlackItems items = ChatService.getBlockItems((String)curr.getId(), (String)uid);
        return Resp.ok((Object)(items != null ? (byte)1 : 2));
    }

    @RequestPath(value="/info1")
    public Resp info1(String uid, HttpRequest request) throws Exception {
        WxFriend friend;
        WxChatUserItem fd;
        User curr = WebUtils.currUser(request);
        Record record = UserService.ME.info1(curr, uid);
        if (curr != null && ChatService.existFriend((WxChatUserItem)(fd = ChatIndexService.fdUserIndex((String)curr.getId(), (String)uid))) && (friend = FriendService.me.getFriendInfo(fd.getLinkid())) != null && StrUtil.isNotBlank((CharSequence)friend.getRemarkname())) {
            Record newread = new Record();
            HashMap<String, String> retMap = new HashMap<String, String>();
            BeanUtil.copyProperties((Object)record.getColumns(), retMap, (String[])new String[0]);
            retMap.put("remarkname", friend.getRemarkname());
            newread.setColumns(retMap);
            return Resp.ok((Object)newread);
        }
        return Resp.ok((Object)record);
    }

    @RequestPath(value="/curr")
    public Resp curr(HttpRequest request) throws Exception {
        User user = WebUtils.currUser(request);
        if (user != null) {
            Resp resp = Resp.ok((Object)user);
            return resp;
        }
        if (Const.USE_ANONYMOUS) {
            request.setAttribute("USE_ROBOT", (Serializable)Boolean.valueOf(true));
            LoginController loginController = (LoginController)Routes.getController(LoginController.class);
            loginController.login(null, null, null, request);
            return this.curr(request);
        }
        Resp resp = Resp.fail();
        return resp;
    }

    @RequestPath(value="/byToken")
    public Resp byToken(HttpRequest request, String token) throws Exception {
        String sessionId = token;
        HttpSession httpSession = request.httpConfig.getHttpSession(sessionId);
        if (httpSession != null) {
            SessionExt sessionExt = (SessionExt)httpSession.getAttribute("SESSION_EXT", SessionExt.class);
            String userid = sessionExt.getUid();
            if (userid != null) {
                Resp resp = Resp.ok((Object)userid);
                return resp;
            }
            log.info("{} session\u4e2d\u5e76\u672a\u7ed1\u5b9auserid", (Object)request.getChannelContext());
        } else {
            log.info("{} \u4e0d\u80fd\u6839\u636esessionId[{}]\u627e\u5230session\u5bf9\u8c61", (Object)request.getChannelContext(), (Object)sessionId);
        }
        Resp resp = Resp.fail();
        return resp;
    }

    @RequestPath(value="/by")
    public Resp by(HttpRequest request, String x) throws Exception {
        if (x == null) {
            Tio.remove((ChannelContext)request.getChannelContext(), (String)"\u975e\u6cd5\u8bf7\u6c42");
            return null;
        }
        SimpleUser simpleUser = SimpleUser.fromUid((String)x);
        Resp resp = null;
        resp = simpleUser != null ? Resp.ok((Object)simpleUser) : Resp.fail((String)"can not found the userid");
        return resp;
    }

    @RequestPath(value="/updateNick")
    public Resp updateNick(HttpRequest request, String nick) throws Exception {
        User curr = WebUtils.currUser(request);
        if (StrUtil.isBlank((CharSequence)nick)) {
            return Resp.fail().msg("\u65e0\u6548\u53c2\u6570");
        }
        if (curr == null) {
            return Resp.fail().msg("\u7528\u6237\u672a\u767b\u5f55");
        }
        String path = "";
        if (curr.getAvatar().trim().indexOf("/user/base/avatar/") == 0 && !Objects.equals(nick.substring(0, 1), curr.getNick().substring(0, 1))) {
            path = WxGroupAvatarUtil.pressUserAvatar(nick);
        }
        Resp resp = this.userService.updateNick(curr, nick, path);
        User user = UserService.ME.getById(curr.getId());
        WxChatApi.synUserInfoToSelf((String)curr.getId(), (Byte)99, (User)user);
        return resp;
    }

    @RequestPath(value="/updatValid")
    public Resp updatValid(HttpRequest request, Byte fdvalidtype) throws Exception {
        User curr = WebUtils.currUser(request);
        if (curr == null) {
            return Resp.fail().msg("\u7528\u6237\u672a\u767b\u5f55");
        }
        return this.userService.updateFdvalidtype(curr, fdvalidtype);
    }

    @RequestPath(value="/updatRemind")
    public Resp updatRemind(HttpRequest request, Byte remindflag) throws Exception {
        User curr = WebUtils.currUser(request);
        if (curr == null) {
            return Resp.fail().msg("\u7528\u6237\u672a\u767b\u5f55");
        }
        return this.userService.updateRemind(curr, remindflag);
    }

    @RequestPath(value="/updatSearchFlag")
    public Resp updatSearchFlag(HttpRequest request, Byte searchflag) throws Exception {
        User curr = WebUtils.currUser(request);
        if (curr == null) {
            return Resp.fail().msg("\u7528\u6237\u672a\u767b\u5f55");
        }
        return this.userService.updateSearchFlag(curr, searchflag);
    }

    @RequestPath(value="/updatPhone")
    public Resp updatPhone(HttpRequest request, String phone) throws Exception {
        User curr = WebUtils.currUser(request);
        if (curr == null) {
            return Resp.fail().msg("\u7528\u6237\u672a\u767b\u5f55");
        }
        return this.userService.updatePhone(curr, phone);
    }

    @RequestPath(value="/updatSign")
    public Resp updatSign(HttpRequest request, String sign) throws Exception {
        User curr = WebUtils.currUser(request);
        if (curr == null) {
            return Resp.fail().msg("\u7528\u6237\u672a\u767b\u5f55");
        }
        return this.userService.updateSign(curr, sign);
    }

    @RequestPath(value="/updatUser")
    public Resp updatUser(HttpRequest request, User user) throws Exception {
        Resp resp;
        User curr = WebUtils.currUser(request);
        if (curr == null) {
            return Resp.fail().msg("\u7528\u6237\u672a\u767b\u5f55");
        }
        String nick = user.getNick();
        boolean isSyn = false;
        if (StrUtil.isNotBlank((CharSequence)nick) && !nick.equals(curr.getNick())) {
            String path = "";
            if (curr.getAvatar().trim().indexOf("/user/base/avatar/") == 0 && !Objects.equals(nick.substring(0, 1), curr.getNick().substring(0, 1))) {
                path = WxGroupAvatarUtil.pressUserAvatar(nick);
            }
            user.setAvatar(path);
            user.setAvatarbig(path);
            isSyn = true;
        }
        if (!nick.equals(curr.getNick()) && !(resp = CommonUtils.checkGroupName((String)nick, (String)"\u6635\u79f0")).isOk()) {
            return resp;
        }
        resp = this.userService.updateUser(curr, user);
        if (isSyn) {
            User sendUser = UserService.ME.getById(curr.getId());
            WxChatApi.synUserInfoToSelf((String)curr.getId(), (Byte)99, (User)sendUser);
        }
        return resp;
    }

    @RequestPath(value="/updatSex")
    public Resp updatSex(HttpRequest request, Byte sex) throws Exception {
        User curr = WebUtils.currUser(request);
        if (curr == null) {
            return Resp.fail().msg("\u7528\u6237\u672a\u767b\u5f55");
        }
        if (Objects.equals(sex, (byte)2) || Objects.equals(sex, (byte)1) || Objects.equals(sex, (byte)3)) {
            return this.userService.updateSex(curr, sex);
        }
        return Resp.fail((String)"\u65e0\u6548\u6027\u522b");
    }

    @RequestPath(value="/updatePwd")
    public Resp updatePwd(HttpRequest request, String initPwd, String newPwd) {
        if (StrUtil.isBlank((CharSequence)initPwd)) {
            return Resp.fail((String)"\u539f\u5bc6\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)newPwd)) {
            return Resp.fail((String)"\u65b0\u5bc6\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        User curr = WebUtils.currUser(request);
        return this.userService.updatePwd(curr, initPwd, newPwd);
    }

    @RequestPath(value="/updateAvatar")
    public Resp updateAvatar(HttpRequest request, UploadFile uploadFile) throws Exception {
        int maxsize;
        if (uploadFile == null) {
            return Resp.fail((String)"\u4e0a\u4f20\u4fe1\u606f\u4e3a\u7a7a");
        }
        User curr = WebUtils.currUser(request);
        Resp ret = null;
        if (curr == null) {
            ret = Resp.fail((String)"\u60a8\u5c1a\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6").code(Integer.valueOf(1001));
        }
        byte[] imageBytes = uploadFile.getData();
        if (!UserService.isSuper((User)curr) && !UserRoleService.hasRole((User)curr, (Byte)6) && imageBytes.length > 1024 * (maxsize = ConfService.getInt((String)"user.upload.avatar.maxsize", (Integer)512).intValue())) {
            ret = Resp.fail((String)("\u6587\u4ef6\u5c3a\u5bf8\u4e0d\u80fd\u5927\u4e8e" + maxsize + "KB"));
        }
        String uid = null;
        uid = curr != null ? curr.getId() : "1";
        BufferedImage bi = ImgUtil.toImage((byte[])imageBytes);
        float scale = ImgUtils.calcScaleWithWidth(168, bi);
        Img img = ImgUtils.processImg("user/avatar", uid, uploadFile, scale);
        img.setComefrom(Byte.valueOf((byte)3));
        img.setStatus(Byte.valueOf((byte)1));
        img.setSession(request.getHttpSession().getId());
        boolean f = ImgService.me.save(img);
        if (ret != null) {
            return ret;
        }
        if (f) {
            Resp resp = this.userService.updateAvatar(curr, img.getCoverurl(), img.getUrl());
            User sendUser = UserService.ME.getById(curr.getId());
            WxChatApi.synUserInfoToSelf((String)curr.getId(), (Byte)99, (User)sendUser);
            return resp;
        }
        return Resp.fail((String)"\u670d\u52a1\u5668\u5f02\u5e38");
    }

    @RequestPath(value="/pageLoginLog")
    public Resp pageLoginLog(HttpRequest request, String uid, Integer pageNumber) {
        User curr = WebUtils.currUser(request);
        boolean isSuper = UserService.isSuper((User)curr);
        if (!isSuper) {
            uid = curr.getId();
        }
        Page page = LoginLogService.me.page(curr, uid, pageNumber);
        return Resp.ok((Object)page);
    }

    @RequestPath(value="/pageAccessLog")
    public Resp pageAccessLog(HttpRequest request, String uid, Integer pageNumber) {
        User curr = WebUtils.currUser(request);
        boolean isSuper = UserService.isSuper((User)curr);
        if (!isSuper) {
            uid = curr.getId();
        }
        Page page = ChatroomJoinLeaveService.me.page(curr, uid, pageNumber);
        return Resp.ok((Object)page);
    }

    @RequestPath(value="/updateAds")
    public Resp updateAds(UserAddress userAddress, HttpRequest request) throws Exception {
        User user = WebUtils.currUser(request);
        Ret ret = this.userService.updateUserAddress(user.getId(), userAddress);
        if (ret.isOk()) {
            return Resp.ok().data(ret.get((Object)"data"));
        }
        return Resp.fail((String)ret.getStr((Object)"msg"));
    }
}

