/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.base.oauth2;

import java.util.Set;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.tio.http.common.HttpRequest;

public class OAuthRequest {
    private HttpRequest request;

    public OAuthRequest(HttpRequest request) {
        this.request = request;
    }

    public String getParam(String name) {
        return this.request.getParam(name);
    }

    public String getClientId() {
        String[] creds = OAuthUtils.decodeClientAuthenticationHeader((String)this.request.getHeader("Authorization"));
        if (creds != null) {
            return creds[0];
        }
        return this.getParam("client_id");
    }

    public String getRedirectURI() {
        return this.getParam("redirect_uri");
    }

    public String getClientSecret() {
        String[] creds = OAuthUtils.decodeClientAuthenticationHeader((String)this.request.getHeader("Authorization"));
        if (creds != null) {
            return creds[1];
        }
        return this.getParam("client_secret");
    }

    public boolean isClientAuthHeaderUsed() {
        return OAuthUtils.decodeClientAuthenticationHeader((String)this.request.getHeader("Authorization")) != null;
    }

    public Set<String> getScopes() {
        String scopes = this.getParam("scope");
        return OAuthUtils.decodeScopes((String)scopes);
    }

    public String getResponseType() {
        return this.getParam("response_type");
    }

    public static void main(String[] args) {
    }
}

