/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.base.thirdlogin;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.server.annotation.RequestPath;
import org.tio.http.server.mvc.Routes;
import org.tio.http.server.util.Resps;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.IpInfo;
import org.tio.sitexxx.service.model.main.UserThird;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.atom.RegisterAtom;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.service.base.UserThirdService;
import org.tio.sitexxx.service.utils.CommonUtils;
import org.tio.sitexxx.service.vo.RequestExt;
import org.tio.sitexxx.web.server.controller.base.LoginController;
import org.tio.sitexxx.web.server.controller.base.RegisterController;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.IThirdLogin;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.ThirdLoginFactory;
import org.tio.sitexxx.web.server.utils.SessionCacheUtils;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.utils.cache.ICache;
import org.tio.utils.resp.Resp;

@RequestPath(value="/tlogin")
public class ThirdLoginController {
    private static Logger log = LoggerFactory.getLogger(ThirdLoginController.class);

    public static void main(String[] args) {
    }

    @RequestPath(value="/{type}")
    public HttpResponse login(Integer type, HttpRequest request) throws Exception {
        IThirdLogin thirdLogin = ThirdLoginFactory.me.getThirdLogin(type);
        if (thirdLogin == null) {
            request.close();
            return null;
        }
        String referer = request.getReferer();
        if (StrUtil.isNotBlank((CharSequence)referer)) {
            SessionCacheUtils.put(request, "THIRD_LOGIN_REFER", (Serializable)((Object)referer));
        }
        return thirdLogin.toLoginPage(request, type);
    }

    @RequestPath(value="/cb/p/{type}")
    public HttpResponse callback(Integer type, HttpRequest request) throws Exception {
        IThirdLogin thirdLogin = ThirdLoginFactory.me.getThirdLogin(type);
        if (thirdLogin == null) {
            request.close();
            return null;
        }
        UserThird userThird = thirdLogin.callback(request, type);
        if (userThird == null) {
            request.close();
            return null;
        }
        UserThird userThirdInDb = null;
        String openid = userThird.getOpenid();
        String unionid = userThird.getUnionid();
        String inStr = ThirdLoginFactory.getSimilarTypesStr(type);
        if (StrUtil.isNotBlank((CharSequence)unionid)) {
            userThirdInDb = UserThirdService.me.getByUnionid(type, inStr, unionid);
            if (userThirdInDb == null && (userThirdInDb = UserThirdService.me.getByOpenid(type, inStr, openid)) != null) {
                userThirdInDb.setUnionid(unionid);
                UserThird update = new UserThird();
                update.setUnionid(unionid);
                update.setId(userThirdInDb.getId());
                update.update();
            }
        } else if (StrUtil.isNotBlank((CharSequence)openid)) {
            userThirdInDb = UserThirdService.me.getByOpenid(type, inStr, openid);
        }
        String clientip = request.getClientIp();
        IpInfo ipInfo = IpInfoService.ME.save(clientip);
        String pwd = type + "";
        if (userThirdInDb == null) {
            User user = new User();
            if (StrUtil.isNotBlank((CharSequence)unionid)) {
                user.setLoginname(unionid);
            } else {
                user.setLoginname(openid);
            }
            RequestExt requestExt = WebUtils.getRequestExt(request);
            byte deviceType = requestExt.getDeviceType();
            user.setRegistertype(Byte.valueOf(deviceType));
            user.setPwd(pwd);
            String nick = userThird.getNick();
            Resp resp = CommonUtils.checkGroupName((String)nick, (String)"\u6635\u79f0");
            if (!resp.isOk()) {
                nick = RandomUtil.randomString((String)"abcdefghijklmnopqrstuvwxyz", (int)6);
            }
            user.setNick(nick);
            user.setAvatar(userThird.getAvatar());
            user.setAvatarbig(userThird.getAvatar());
            user.setStatus(Byte.valueOf((byte)1));
            user.setIpInfo(ipInfo);
            user.setUserThird(userThird);
            user.setThirdstatus(Byte.valueOf((byte)2));
            user.setCreatetime(new Date());
            String referer = (String)((Object)SessionCacheUtils.get(request, "THIRD_LOGIN_REFER"));
            user.setReghref(referer);
            RegisterAtom registerUserAtom = new RegisterAtom(user);
            registerUserAtom.setThird(true);
            boolean result = RegisterController.register(request, user, registerUserAtom);
            if (result) {
                if (StrUtil.isNotBlank((CharSequence)unionid)) {
                    ICache openidCache = Caches.getCache((CacheConfig)CacheConfig.OPENID_USERTHIRD);
                    String key = inStr + "_" + unionid;
                    openidCache.remove(key);
                    userThirdInDb = UserThirdService.me.getByUnionid(type, inStr, unionid);
                } else {
                    ICache openidCache = Caches.getCache((CacheConfig)CacheConfig.OPENID_USERTHIRD);
                    String key = inStr + "_" + openid;
                    openidCache.remove(key);
                    userThirdInDb = UserThirdService.me.getByOpenid(type, inStr, openid);
                }
            } else {
                if (thirdLogin.isAjax(request, type)) {
                    return Resps.json((HttpRequest)request, (Object)Resp.fail((String)registerUserAtom.getMsg()));
                }
                return Resps.redirect((HttpRequest)request, (String)"/");
            }
        }
        String uid = userThirdInDb.getUid();
        User user = UserService.ME.getById(uid);
        request.setAttribute("IS_THIRD_LOGIN", (Serializable)Boolean.valueOf(true));
        request.setAttribute("THIRD_LOGIN_USER", (Serializable)user);
        HttpResponse response = null;
        if (!thirdLogin.isAjax(request, type)) {
            String referer = (String)((Object)SessionCacheUtils.get(request, "THIRD_LOGIN_REFER"));
            response = StrUtil.isNotBlank((CharSequence)referer) ? Resps.redirect((HttpRequest)request, (String)referer) : Resps.redirect((HttpRequest)request, (String)"/");
        }
        request.setAttribute("THIRD_LOGIN_RESPONSE", response);
        LoginController loginController = (LoginController)Routes.getController(LoginController.class);
        return loginController.login(user.getLoginname(), null, null, request);
    }
}

