/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.base.thirdlogin;

import cn.hutool.core.collection.CollUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.IThirdLogin;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.provider.apple.AppleLogin;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.provider.douyin.DouyinLogin;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.provider.osc.OscLogin;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.provider.qq.QQLogin;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.provider.qqmobile.QQMobileLogin;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.provider.wb.WbLogin;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.provider.wbmobile.WbMobileLogin;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.provider.wx.WxLogin;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.provider.wx.WxOpenLogin;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.provider.wxmobile.WxMobileLogin;

public class ThirdLoginFactory {
    private static Logger log = LoggerFactory.getLogger(ThirdLoginFactory.class);
    public static final ThirdLoginFactory me = new ThirdLoginFactory();
    private static final Map<Integer, List<Integer>> SIMILAR_TYPES = new HashMap<Integer, List<Integer>>();
    private static final Map<Integer, String> SIMILAR_TYPES_STR = new HashMap<Integer, String>();

    private ThirdLoginFactory() {
    }

    public static List<Integer> getSimilarTypes(Integer type) {
        return SIMILAR_TYPES.get(type);
    }

    public static String getSimilarTypesStr(Integer type) {
        return SIMILAR_TYPES_STR.get(type);
    }

    public IThirdLogin getThirdLogin(Integer type) {
        switch (type) {
            case 1: {
                return QQLogin.me;
            }
            case 11: {
                return QQMobileLogin.me;
            }
            case 2: {
                return WxLogin.me;
            }
            case 22: {
                return WxMobileLogin.me;
            }
            case 222: {
                return WxOpenLogin.me;
            }
            case 3: {
                return WbLogin.me;
            }
            case 33: {
                return WbMobileLogin.me;
            }
            case 4: {
                return DouyinLogin.me;
            }
            case 5: {
                return OscLogin.me;
            }
            case 9999: {
                return AppleLogin.me;
            }
        }
        log.warn("\u627e\u4e0d\u5230IThirdLogin\u7684\u5b9e\u73b0\u7c7b, type:{}", (Object)type);
        return null;
    }

    public static void main(String[] args) {
        System.out.println(3);
        System.out.println(1);
        System.out.println(6);
        System.out.println(7);
        System.out.println(ThirdLoginFactory.getSimilarTypesStr(1));
        System.out.println(ThirdLoginFactory.getSimilarTypesStr(11));
        System.out.println(ThirdLoginFactory.getSimilarTypesStr(111));
        System.out.println(ThirdLoginFactory.getSimilarTypesStr(1111));
        System.out.println(ThirdLoginFactory.getSimilarTypesStr(2));
        System.out.println(ThirdLoginFactory.getSimilarTypesStr(22));
        System.out.println(ThirdLoginFactory.getSimilarTypesStr(222));
        System.out.println(ThirdLoginFactory.getSimilarTypesStr(2222));
        System.out.println(ThirdLoginFactory.getSimilarTypesStr(3));
        System.out.println(ThirdLoginFactory.getSimilarTypesStr(33));
        System.out.println(ThirdLoginFactory.getSimilarTypesStr(9999));
    }

    static {
        for (int i = 1; i < 10; ++i) {
            ArrayList<Integer> list = new ArrayList<Integer>(3);
            list.add(i);
            list.add(i + i * 10);
            list.add(i + i * 10 + i * 100);
            list.add(i + i * 10 + i * 100 + i * 1000);
            for (int j = 0; j < list.size(); ++j) {
                SIMILAR_TYPES.put((Integer)list.get(j), (List<Integer>)list);
                SIMILAR_TYPES_STR.put((Integer)list.get(j), CollUtil.join(list, (CharSequence)","));
            }
        }
    }
}

