/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.base.thirdlogin.provider;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.server.util.Resps;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.UserThird;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.RequestExt;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.IThirdLogin;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.utils.cache.ICache;
import org.tio.utils.crypto.Md5;
import org.tio.utils.resp.Resp;

public abstract class MobileLogin
implements IThirdLogin {
    private static Logger log = LoggerFactory.getLogger(MobileLogin.class);
    final ICache cache = Caches.getCache((CacheConfig)CacheConfig.TIME_TO_LIVE_SECONDS_5);

    public static void main(String[] args) {
    }

    @Override
    public HttpResponse toLoginPage(HttpRequest request, Integer type) throws Exception {
        String openid = request.getParam("openid");
        String sign = request.getParam("sign");
        String mysign = Md5.getMD5((String)(openid + request.getHttpSession().getId() + type));
        if (!Objects.equals(mysign, sign)) {
            RequestExt requestExt = WebUtils.getRequestExt(request);
            log.error("appversion:{}, {}, \u9a8c\u7b7e\u6ca1\u901a\u8fc7", (Object)requestExt.getAppVersion(), (Object)requestExt.getDeviceinfo());
            request.close();
            return null;
        }
        String uuid = RandomUtil.simpleUUID();
        this.cache.put(uuid, (Serializable)((Object)openid));
        return Resps.json((HttpRequest)request, (Object)Resp.ok((Object)uuid));
    }

    @Override
    public UserThird callback(HttpRequest request, Integer type) throws Exception {
        String appVersion;
        String uuid = request.getParam("uuid");
        if (StrUtil.isBlank((CharSequence)uuid)) {
            return null;
        }
        String openid = request.getParam("openid");
        String unionid = request.getParam("unionid");
        RequestExt requestExt = WebUtils.getRequestExt(request);
        if (Objects.equals(Devicetype.IOS.getValue(), requestExt.getDeviceType()) && ("1.1.4".equals(appVersion = requestExt.getAppVersion()) || "1.1.5".equals(appVersion))) {
            unionid = openid;
        }
        String myopenid = (String)this.cache.get(uuid, String.class);
        if (StrUtil.isBlank((CharSequence)openid) || StrUtil.isBlank((CharSequence)myopenid) || !Objects.equals(myopenid, openid)) {
            log.error("myopenid:{}, openid:{}", (Object)myopenid, (Object)openid);
            return null;
        }
        String nick = request.getParam("nick");
        String avatar = request.getParam("avatar");
        String sex = request.getParam("sex");
        UserThird userThird = new UserThird();
        userThird.setAvatar(avatar);
        userThird.setNick(nick);
        userThird.setOpenid(openid);
        userThird.setUnionid(unionid);
        if (StrUtil.isNotBlank((CharSequence)sex)) {
            userThird.setSex(Integer.valueOf(Integer.parseInt(sex)));
        }
        userThird.setType(type);
        UserThird.SubTable sub = this.createSubTable(request, type);
        if (sub != null) {
            userThird.setSubTable(sub);
        }
        return userThird;
    }

    public abstract UserThird.SubTable createSubTable(HttpRequest var1, Integer var2);

    @Override
    public boolean isAjax(HttpRequest request, Integer type) throws Exception {
        return true;
    }
}

