/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.base.thirdlogin.provider.qq;

import cn.hutool.core.util.StrUtil;
import com.qq.connect.api.OpenID;
import com.qq.connect.api.qzone.UserInfo;
import com.qq.connect.javabeans.AccessToken;
import com.qq.connect.javabeans.qzone.UserInfoBean;
import com.qq.connect.oauth.Oauth;
import com.qq.connect.utils.QQConnectConfig;
import java.net.URLEncoder;
import java.util.Objects;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.sitexxx.service.model.main.UserThird;
import org.tio.sitexxx.service.model.main.UserThirdQq;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.ThirdLoginUtils;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.provider.Auth2Login;
import org.tio.sitexxx.web.server.controller.base.thirdlogin.provider.qq.UnionID;
import org.tio.sitexxx.web.server.init.WebApiInit;
import org.tio.utils.http.HttpUtils;
import org.tio.utils.jfinal.P;
import org.tio.utils.json.Json;

public class QQLogin
extends Auth2Login {
    private static Logger log = LoggerFactory.getLogger(QQLogin.class);
    public static QQLogin me = new QQLogin();

    private QQLogin() {
        this.updateProperties();
    }

    private void updateProperties() {
        QQConnectConfig.updateProperties((String)"app_ID", (String)P.get((String)"third.login.qq.pc.AppID"));
        QQConnectConfig.updateProperties((String)"app_KEY", (String)P.get((String)"third.login.qq.pc.AppSecret"));
        QQConnectConfig.updateProperties((String)"redirect_URI", (String)ThirdLoginUtils.getCallbackUrl(WebApiInit.httpConfig, 1));
    }

    public static void main(String[] args) {
    }

    @Override
    public String loginUrl(HttpRequest request, Integer type, String state) throws Exception {
        String scope = QQConnectConfig.getValue((String)"scope");
        return new Oauth().getAuthorizeURL(scope, state);
    }

    private static String getQQUnionID(String accessToken) throws Exception {
        String url = "https://graph.qq.com/oauth2.0/me?access_token=" + URLEncoder.encode(accessToken, "utf-8") + "&unionid=1";
        Response response = HttpUtils.get((String)url);
        if (response.isSuccessful()) {
            int j;
            String string = response.body().string();
            int i = StrUtil.indexOf((CharSequence)string, (char)'(');
            UnionID unionidObj = (UnionID)Json.toBean((String)(string = StrUtil.trim((CharSequence)string.substring(i + 1, (j = StringUtils.lastIndexOf((CharSequence)string, (CharSequence)")")) - 1))), UnionID.class);
            if (StrUtil.isNotBlank((CharSequence)unionidObj.getUnionID())) {
                return unionidObj.getUnionID();
            }
            return null;
        }
        return null;
    }

    @Override
    public UserThird getUserThird(HttpRequest request, Integer type, String state, String code) throws Exception {
        String queryString = request.getRequestLine().getQueryString();
        AccessToken accessTokenObj = new Oauth().getAccessTokenByQueryString(queryString, state);
        if (accessTokenObj == null) {
            return null;
        }
        String accessToken = null;
        String openID = null;
        long tokenExpireIn = 0L;
        if (StrUtil.isBlank((CharSequence)accessTokenObj.getAccessToken())) {
            log.error("QQ\u767b\u5f55\uff0c AccessToken is null");
            request.close();
            return null;
        }
        accessToken = accessTokenObj.getAccessToken();
        tokenExpireIn = accessTokenObj.getExpireIn();
        OpenID openIDObj = new OpenID(accessToken);
        openID = openIDObj.getUserOpenID();
        String unionID = QQLogin.getQQUnionID(accessToken);
        if (StrUtil.isBlank((CharSequence)unionID)) {
            return null;
        }
        UserInfo userinfo = new UserInfo(accessToken, openID);
        UserInfoBean userInfoBean = userinfo.getUserInfo();
        if (userInfoBean.getRet() == 0) {
            UserThird userThird = new UserThird();
            userThird.setOpenid(openID);
            userThird.setAvatar(userInfoBean.getAvatar().getAvatarURL100());
            userThird.setNick(userInfoBean.getNickname());
            userThird.setUnionid(unionID);
            String gender = userInfoBean.getGender();
            Integer sex = Objects.equals("\u7537", gender) ? 1 : (Objects.equals("\u5973", gender) ? Integer.valueOf(2) : null);
            if (sex != null) {
                userThird.setSex(sex);
            }
            UserThirdQq userThirdQq = new UserThirdQq();
            userThirdQq.setIsYellowVip(Byte.valueOf(userInfoBean.isYellowYearVip() ? (byte)1 : 2));
            if (userInfoBean.isYellowYearVip()) {
                userThirdQq.setYellowVipLevel(userInfoBean.getLevel() + "");
            }
            userThird.setSubTable((UserThird.SubTable)userThirdQq);
            return userThird;
        }
        return null;
    }
}

