/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.manager;

import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.redisson.api.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.maintain.IpStats;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.server.annotation.RequestPath;
import org.tio.http.server.util.Resps;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.sitexxx.service.init.RedisInit;
import org.tio.sitexxx.service.model.main.WxApp;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.RegisterService;
import org.tio.sitexxx.service.service.base.TioIpPullblackLogService;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.service.conf.IpWhiteListService;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.topic.CleanViewCacheVo;
import org.tio.sitexxx.web.server.utils.TioIpPullblackUtils;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.utils.resp.Resp;
import org.tio.utils.ui.layui.table.LayuiPage;

@RequestPath(value="/m/tio")
public class TioController {
    private static Logger log = LoggerFactory.getLogger(TioController.class);

    public static void main(String[] args) {
    }

    @RequestPath(value="/initWx")
    public Resp initWx() {
        String sql = "select * from user where id < 31329 and id > 23351";
        sql = "select * from user where id <= 23351";
        List list = User.dao.find(sql);
        for (User user : list) {
            try {
                RegisterService.me.initWx(user);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return Resp.ok();
    }

    @RequestPath(value="/clearStaticResCache")
    public Resp clearStaticResCache(HttpRequest request) throws Exception {
        CleanViewCacheVo cleanViewCacheVo = new CleanViewCacheVo();
        RTopic topic = RedisInit.get().getTopic("CLEAN_VIEW_CACHE");
        topic.publish((Object)cleanViewCacheVo);
        return Resp.ok((Object)"\u7f13\u5b58\u5df2\u7ecf\u6e05\u7a7a");
    }

    @RequestPath(value="/ipStat")
    public Resp ipStat(Long duration, HttpRequest request, ChannelContext channelContext) throws Exception {
        IpStats ipStats = channelContext.tioConfig.ipStats;
        return Resp.ok((Object)LayuiPage.ok((Collection)ipStats.values(duration), (long)ipStats.size(duration)));
    }

    @RequestPath(value="/addWhiteIp")
    public Resp addWhiteIp(HttpRequest request, String ip) throws Exception {
        ip = StrUtil.trim((CharSequence)ip);
        User currUser = WebUtils.currUser(request);
        String clientip = request.getClientIp();
        String curruserid = currUser.getId();
        String remark = curruserid + "," + clientip;
        IpWhiteListService.me.save(ip, remark);
        return Resp.ok();
    }

    @RequestPath(value="/addSelfToWhiteIp")
    public Resp addSelfToWhiteIp(HttpRequest request) throws Exception {
        User currUser = WebUtils.currUser(request);
        String clientip = request.getClientIp();
        String curruserid = currUser.getId();
        String remark = "\u628a\u81ea\u5df1\u8bbe\u4e3a\u767d\u540d\u5355, " + curruserid + ", " + clientip;
        IpWhiteListService.me.save(clientip, remark);
        return Resp.ok();
    }

    @RequestPath(value="/deleteSelfToWhiteIp")
    public Resp deleteSelfToWhiteIp(HttpRequest request) throws Exception {
        User currUser = WebUtils.currUser(request);
        String clientip = request.getClientIp();
        String curruserid = currUser.getId();
        String remark = "\u5c06\u81ea\u5df1\u4ece\u767d\u540d\u5355\u4e2d\u5220\u9664, " + curruserid + ", " + clientip;
        IpWhiteListService.me.delete(clientip, remark);
        return Resp.ok();
    }

    @RequestPath(value="/deleteWhiteIp")
    public Resp deleteWhiteIp(HttpRequest request, String ip) throws Exception {
        ip = StrUtil.trim((CharSequence)ip);
        User currUser = WebUtils.currUser(request);
        String clientip = request.getClientIp();
        String curruserid = currUser.getId();
        String remark = curruserid + "," + clientip;
        IpWhiteListService.me.delete(ip, remark);
        return Resp.ok();
    }

    @RequestPath(value="/addBlackIp")
    public Resp addBlackIp(HttpRequest request, String ip) throws Exception {
        ip = StrUtil.trim((CharSequence)ip);
        User currUser = WebUtils.currUser(request);
        String clientip = request.getClientIp();
        String curruserid = currUser.getId();
        String remark = curruserid + "," + clientip;
        TioIpPullblackUtils.addToBlack(request, ip, remark, (byte)3);
        return Resp.ok();
    }

    @RequestPath(value="/deleteBlackIp")
    public Resp deleteBlackIp(HttpRequest request, String ip) throws Exception {
        ip = StrUtil.trim((CharSequence)ip);
        User currUser = WebUtils.currUser(request);
        String clientip = request.getClientIp();
        String curruserid = currUser.getId();
        String remark = curruserid + "," + clientip;
        TioIpPullblackLogService.ME.deleteFromBlack(ip, request.getChannelContext().getServerNode().getPort(), remark);
        return Resp.ok();
    }

    @RequestPath(value="/pullBlackUser")
    public Resp pullBlackUser(HttpRequest request, String nick) throws Exception {
        int r = UserService.ME.pullBlackUserByNick(nick);
        if (r > 0) {
            return Resp.ok();
        }
        return Resp.fail((String)"\u62c9\u9ed1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6635\u79f0\u662f\u5426\u6b63\u786e");
    }

    @RequestPath(value="/normalUser")
    public Resp normalUser(HttpRequest request, String nick) throws Exception {
        int r = UserService.ME.normalUserByNick(nick);
        if (r > 0) {
            return Resp.ok();
        }
        return Resp.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6635\u79f0\u662f\u5426\u6b63\u786e");
    }

    @RequestPath(value="/clearAllUserCache")
    public Resp clearAllUserCache(HttpRequest request) throws Exception {
        UserService.ME.notifyClearCache(null);
        return Resp.ok();
    }

    @RequestPath(value="/clearUserCache")
    public Resp clearUserCache(HttpRequest request, String nick) throws Exception {
        User user = UserService.ME.getByNick(nick);
        if (user == null) {
            return Resp.fail((String)"\u6635\u79f0\u4e0d\u5b58\u5728");
        }
        UserService.ME.notifyClearCache(user.getId());
        return Resp.ok();
    }

    @RequestPath(value="/q")
    public HttpResponse q(HttpRequest request, String db, String sql) throws Exception {
        if (!IpWhiteListService.isWhiteIp((String)request.getClientIp())) {
            return Resps.html((HttpRequest)request, (String)"\u4f60\u6ca1\u8d44\u683c\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        if (StrUtil.isBlank((CharSequence)db)) {
            db = "tio_site_main";
        }
        List list = Db.use((String)db).find(sql);
        HttpResponse response = Resps.json((HttpRequest)request, (Object)LayuiPage.ok((Collection)list, (long)list.size()));
        response.addHeader(HeaderName.Access_Control_Allow_Origin, HeaderValue.from((String)"*"));
        response.addHeader(HeaderName.Access_Control_Allow_Headers, HeaderValue.from((String)"x-requested-with,content-type"));
        return response;
    }

    @RequestPath(value="/avatar")
    public HttpResponse avatar(HttpRequest request) throws Exception {
        return null;
    }

    @RequestPath(value="/addRoleByLoginname")
    public Resp addRoleByLoginname(HttpRequest request, String loginname, byte roleid) {
        return UserService.ME.addRoleByLoginname(loginname, roleid);
    }

    @RequestPath(value="/addRoleByLNick")
    public Resp addRoleByLNick(HttpRequest request, String nick, byte roleid) {
        return UserService.ME.addRoleByNick(nick, roleid);
    }

    @RequestPath(value="/tioAppConfig")
    public Resp tioAppConfig(HttpRequest request) throws Exception {
        WxApp sysVersion = (WxApp)WxApp.dao.findFirst("select * from wx_app where type = ? and `status` = ?", new Object[]{Devicetype.ANDROID.getValue(), (byte)1});
        HashMap<String, WxApp> config = new HashMap<String, WxApp>();
        config.put("android", sysVersion);
        return Resp.ok(config);
    }
}

