/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.recharge;

import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.server.annotation.RequestPath;
import org.tio.http.server.mvc.Routes;
import org.tio.http.server.util.Resps;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.RechargeItem;
import org.tio.sitexxx.service.model.main.UserAgent;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.UserAgentService;
import org.tio.sitexxx.service.service.recharge.RechargeItemService;
import org.tio.sitexxx.service.utils.LogUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.service.vo.RequestExt;
import org.tio.sitexxx.web.server.controller.base.QrCodeController;
import org.tio.sitexxx.web.server.recharge.IRechargeProvider;
import org.tio.sitexxx.web.server.recharge.RechargeServiceFactory;
import org.tio.sitexxx.web.server.recharge.provider.weixin.WxPayScan2RechargeProvider;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.utils.cache.ICache;
import org.tio.utils.jfinal.P;
import org.tio.utils.json.Json;
import org.tio.utils.resp.Resp;

@RequestPath(value="/recharge")
public class RechargeController {
    private static Logger log = LogUtils.getCoinLog();

    public static String newTradeno(HttpRequest request) {
        String ret = WebUtils.currUserId(request) + RandomStringUtils.randomAlphabetic((int)5) + new SimpleDateFormat("yyMMddHHmmssSSS").format(new Date());
        return ret;
    }

    public static boolean isFromWeixin(HttpRequest request) {
        String userAgent = request.getUserAgent();
        return userAgent != null && userAgent.contains("MicroMessenger");
    }

    public static boolean isFromAlipay(HttpRequest request) {
        String userAgent = request.getUserAgent();
        return userAgent != null && userAgent.contains("AlipayClient");
    }

    @RequestPath(value="/qr")
    public HttpResponse qr(HttpRequest request, RechargeItem rechargeItem, Integer width, Integer height) throws Exception {
        if (width == null) {
            width = 200;
        }
        if (height == null) {
            height = 200;
        }
        width = Math.min(width, 1200);
        height = Math.min(height, 1200);
        IRechargeProvider rechargeProvider = RechargeServiceFactory.getThirdRechargeService(rechargeItem.getPaytype());
        QrCodeController qrCodeController = (QrCodeController)Routes.getController(QrCodeController.class);
        if (rechargeProvider instanceof WxPayScan2RechargeProvider) {
            request.setAttribute("recharge_only_qr", (Serializable)Integer.valueOf(1));
            request.setAttribute("recharge_only_qr_width", (Serializable)width);
            request.setAttribute("recharge_only_qr_height", (Serializable)height);
            return this.submit(request, rechargeItem);
        }
        HttpConfig httpConfig = request.httpConfig;
        String uuid = httpConfig.getSessionIdGenerator().sessionId(httpConfig, request);
        ICache cache = Caches.getCache((CacheConfig)CacheConfig.RECHARGE_QR);
        cache.put(uuid, (Serializable)rechargeItem);
        String str = Const.SITE + httpConfig.getContextPath() + "/recharge/qrSubmit/" + uuid + "/" + request.getHttpSession().getId() + httpConfig.getSuffix();
        return qrCodeController.index(width, height, null, null, str, request);
    }

    @RequestPath(value="/qrSubmit/{uuid}/{tio_http_sessionid}")
    public HttpResponse qrSubmit(HttpRequest request, String uuid, String tio_http_sessionid) throws Exception {
        ICache cache = Caches.getCache((CacheConfig)CacheConfig.RECHARGE_QR);
        RechargeItem rechargeItem = (RechargeItem)cache.get(uuid);
        if (rechargeItem == null) {
            return Resps.json((HttpRequest)request, (Object)Resp.fail((String)"\u4e8c\u7ef4\u7801\u5931\u6548\u6216\u8fc7\u671f"));
        }
        if (!RechargeController.isFromAlipay(request)) {
            return Resps.html((HttpRequest)request, (String)"\u8bf7\u7528\u652f\u4ed8\u5b9d");
        }
        rechargeItem.setPaytype(RechargeItem.Paytype.ALIPAY_H5);
        request.setAttribute("rechargeItem", (Serializable)rechargeItem);
        return Resps.forward((HttpRequest)request, (String)"/recharge");
    }

    @RequestPath(value="")
    public HttpResponse submit(HttpRequest request, RechargeItem rechargeItem) throws Exception {
        RechargeItem rechargeItem1 = (RechargeItem)request.getAttribute("rechargeItem");
        if (rechargeItem1 != null) {
            rechargeItem = rechargeItem1;
        }
        Double costmoney = rechargeItem.getAmount();
        Double MIN_PAY = Double.valueOf(P.get((String)"recharge.least.money", (String)"1"));
        if (costmoney == null || costmoney < MIN_PAY) {
            return Resps.json((HttpRequest)request, (Object)Resp.fail().msg("\u6700\u4f4e\u5145\u503c\u989d\u4e3a" + MIN_PAY + "\u5143\u54e6"));
        }
        Integer paytype = rechargeItem.getPaytype();
        IRechargeProvider rechargeProvider = RechargeServiceFactory.getThirdRechargeService(paytype);
        if (rechargeProvider == null) {
            return Resps.html((HttpRequest)request, (String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u652f\u4ed8\u65b9\u5f0f!");
        }
        User user = WebUtils.currUser(request);
        if (user == null) {
            return Resps.html((HttpRequest)request, (String)"\u8bf7\u5148\u767b\u5f55!");
        }
        if (StrUtil.isBlank((CharSequence)rechargeItem.getCallback())) {
            rechargeItem.setCallback(rechargeItem.getReferer());
        }
        String userid = user.getId();
        String tradeno = RechargeController.newTradeno(request);
        rechargeItem.setStatus(Integer.valueOf(1));
        rechargeItem.setUserid(userid);
        rechargeItem.setTradeno(tradeno);
        RequestExt requestExt = WebUtils.getRequestExt(request);
        rechargeItem.setClienttype(Integer.valueOf(requestExt.getDeviceType()));
        String userAgentStr = request.getUserAgent();
        UserAgent userAgent = UserAgentService.ME.save(userAgentStr);
        if (userAgent.getId() != null) {
            rechargeItem.setUseragentid(userAgent.getId());
        } else {
            rechargeItem.setClientinfo(StringUtils.left((String)userAgentStr, (int)255));
        }
        rechargeItem.setRemoteip(request.getClientIp());
        Date date = new Date();
        rechargeItem.setCreatetime(date);
        rechargeItem.setUpdatetime(date);
        RechargeItemService.me.save(rechargeItem);
        return rechargeProvider.toThirdRechargePage(request, rechargeItem, paytype);
    }

    @RequestPath(value="/rt/{paytype}")
    public HttpResponse returnurl(HttpRequest request, Integer paytype) throws Exception {
        IRechargeProvider rechargeProvider = RechargeServiceFactory.getThirdRechargeService(paytype);
        if (rechargeProvider == null) {
            request.close();
            return null;
        }
        Boolean isValidCallback = rechargeProvider.isValidCallback(request, 1);
        if (!isValidCallback.booleanValue()) {
            log.error("\u975e\u6cd5return url\u56de\u8c03\r\n{}", (Object)request.toString());
            request.close();
            return null;
        }
        String tradeno = rechargeProvider.getTradeno(request, 1);
        RechargeItem rechargeItem = RechargeItemService.me.selectByTradeno(tradeno);
        if (rechargeItem == null) {
            log.error("\u627e\u4e0d\u5230\u5145\u503c\u8bb0\u5f55, tradeno: {}\r\n{}", (Object)tradeno, (Object)request.toString());
            return Resps.redirect((HttpRequest)request, (String)(Const.SITE + "/"));
        }
        return Resps.redirect((HttpRequest)request, (String)rechargeItem.getCallback());
    }

    @RequestPath(value="/nf/{paytype}")
    public HttpResponse notifyurl(HttpRequest request, Integer paytype) throws Exception {
        log.info("\u6536\u5230notifyurl\u56de\u8c03,from {}\r\n{}", (Object)request.getClientIp(), (Object)request.toString());
        IRechargeProvider rechargeProvider = RechargeServiceFactory.getThirdRechargeService(paytype);
        if (rechargeProvider == null) {
            request.close();
            return null;
        }
        Boolean isValidCallback = rechargeProvider.isValidCallback(request, 2);
        if (!isValidCallback.booleanValue()) {
            log.info("\u975e\u6cd5notifyurl\u56de\u8c03,from {}\r\n{}", (Object)request.getClientIp(), (Object)request.toString());
            request.close();
            return null;
        }
        String tradeno = rechargeProvider.getTradeno(request, 2);
        RechargeItem rechargeItem = RechargeItemService.me.selectByTradeno(tradeno);
        if (rechargeItem == null) {
            log.error("\u627e\u4e0d\u5230\u5145\u503c\u8bb0\u5f55, tradeno: {}\r\n{}", (Object)tradeno, (Object)request.toString());
            return rechargeProvider.notifyFail(request, rechargeItem, paytype);
        }
        rechargeItem.setRemoteipnotify(request.getClientIp());
        if (!Objects.equals(rechargeItem.getStatus(), 1)) {
            log.error("\u8be5\u8ba2\u5355\u5df2\u7ecf\u5904\u7406\uff0c \u4e0d\u5141\u8bb8\u518d\u6b21\u5904\u7406 tradeno: {}\r\n{}", (Object)tradeno, (Object)request.toString());
            return rechargeProvider.notifySuccess(request, rechargeItem, paytype);
        }
        try {
            rechargeProvider.fillOnNotify(request, rechargeItem, paytype);
        }
        catch (Exception e1) {
            log.error("\u5145\u503c\u56de\u8c03\u5f02\u5e38", (Throwable)e1);
            throw e1;
        }
        Integer tradeStatus = rechargeItem.getStatus();
        if (Objects.equals(tradeStatus, 2) || Objects.equals(tradeStatus, 4)) {
            try {
                log.info("\u5145\u503c\u6210\u529f\u4e86:{}", (Object)Json.toFormatedJson((Object)rechargeItem));
                RechargeItemService.me.updateUserAndRecharge(rechargeItem);
                return rechargeProvider.notifySuccess(request, rechargeItem, paytype);
            }
            catch (Exception e) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("msg", "\u5145\u503c\u4ea4\u6613\u6210\u529f\uff0c\u4f46\u66f4\u65b0\u6570\u636e\u5e93\u65f6\u51fa\u73b0\u5f02\u5e38");
                map.put("recharge", (String)rechargeItem);
                map.put("exception", ExceptionUtils.getStackTrace((Throwable)e));
                log.error(Json.toFormatedJson(map));
                return rechargeProvider.notifyFail(request, rechargeItem, paytype);
            }
        }
        if (Objects.equals(tradeStatus, 3)) {
            try {
                log.error("\u5145\u503c\u53d6\u6d88\u4e86:{}", (Object)Json.toFormatedJson((Object)rechargeItem));
                RechargeItemService.me.update(rechargeItem);
                return rechargeProvider.notifySuccess(request, rechargeItem, paytype);
            }
            catch (Exception e) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("msg", "\u5145\u503c\u4ea4\u6613\u5173\u95ed\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u65f6\u51fa\u73b0\u5f02\u5e38");
                map.put("recharge", (String)rechargeItem);
                map.put("exception", ExceptionUtils.getStackTrace((Throwable)e));
                log.error(Json.toFormatedJson(map));
                return rechargeProvider.notifyFail(request, rechargeItem, paytype);
            }
        }
        if (Objects.equals(tradeStatus, 9)) {
            try {
                log.error("\u5145\u503c\u53d7\u5230\u653b\u51fb\u4e86:{}", (Object)Json.toFormatedJson((Object)rechargeItem));
                RechargeItemService.me.attackRecharge(rechargeItem);
                return rechargeProvider.notifySuccess(request, rechargeItem, paytype);
            }
            catch (Exception e) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("msg", "\u5145\u503c\u4ea4\u6613\u72b6\u6001\u4e3a\u672a\u77e5\u72b6\u6001\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u65f6\u51fa\u73b0\u5f02\u5e38");
                map.put("recharge", (String)rechargeItem);
                map.put("exception", ExceptionUtils.getStackTrace((Throwable)e));
                log.error(Json.toFormatedJson(map));
                return rechargeProvider.notifyFail(request, rechargeItem, paytype);
            }
        }
        if (Objects.equals(tradeStatus, 99)) {
            try {
                log.error("\u5145\u503c\u5f02\u5e38\u4e86:{}", (Object)Json.toFormatedJson((Object)rechargeItem));
                RechargeItemService.me.update(rechargeItem);
                return rechargeProvider.notifySuccess(request, rechargeItem, paytype);
            }
            catch (Exception e) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("msg", "\u5145\u503c\u4ea4\u6613\u72b6\u6001\u4e3a\u672a\u77e5\u72b6\u6001\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u65f6\u51fa\u73b0\u5f02\u5e38");
                map.put("recharge", (String)rechargeItem);
                map.put("exception", ExceptionUtils.getStackTrace((Throwable)e));
                log.error(Json.toFormatedJson(map));
                return rechargeProvider.notifyFail(request, rechargeItem, paytype);
            }
        }
        if (Objects.equals(tradeStatus, 1)) {
            try {
                log.error(rechargeProvider.getClass().getName() + ".fillOnNotify()\u6ca1\u6709\u4fee\u6539\u8ba2\u5355\u72b6\u6001:{}", (Object)Json.toFormatedJson((Object)rechargeItem));
                return rechargeProvider.notifyFail(request, rechargeItem, paytype);
            }
            catch (Exception e) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("msg", "notifyFail\u65f6\u5f02\u5e38\u4e86");
                map.put("recharge", (String)rechargeItem);
                map.put("exception", ExceptionUtils.getStackTrace((Throwable)e));
                log.error(Json.toFormatedJson(map));
                return rechargeProvider.notifyFail(request, rechargeItem, paytype);
            }
        }
        return rechargeProvider.notifyFail(request, rechargeItem, paytype);
    }

    @RequestPath(value="/getCallback")
    public Resp getCallback(HttpRequest request, String tradeno) throws Exception {
        User user = WebUtils.currUser(request);
        RechargeItem rechargeItem = RechargeItemService.me.selectByTradeno(tradeno);
        if (rechargeItem == null) {
            log.error("\u627e\u4e0d\u5230\u5145\u503c\u8bb0\u5f55, tradeno: {}\r\n{}", (Object)tradeno, (Object)request.toString());
            return Resp.ok().data((Object)"/");
        }
        if (!Objects.equals(rechargeItem.getUserid(), user.getId())) {
            log.error("\u65e0\u6548\u7528\u6237\u5145\u503c\u8bb0\u5f55, tradeno: {}\r\n{}", (Object)tradeno, (Object)request.toString());
            return Resp.ok().data((Object)"/");
        }
        if (Objects.equals(rechargeItem.getStatus(), 2) || Objects.equals(rechargeItem.getStatus(), 4)) {
            String path = rechargeItem.getCallback();
            if (StrUtil.isBlank((CharSequence)path)) {
                path = "/";
            }
            return Resp.ok().data((Object)path);
        }
        return Resp.fail();
    }

    public static void main(String[] args) {
        Byte xx = 2;
        byte xxx = xx;
        System.out.println(xxx);
    }
}

