/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.stat;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.annotation.RequestPath;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.UserRoleService;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.service.stat.StatService;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.utils.resp.Resp;

@RequestPath(value="/stat")
public class StatController {
    private static Logger log = LoggerFactory.getLogger(StatController.class);

    public static void main(String[] args) {
        log.info("");
    }

    @RequestPath(value="/requestCountByDay")
    public Resp requestCountByDay(Integer days, HttpRequest request) throws Exception {
        List list = StatService.me.requestCountByDay(days);
        return Resp.ok((Object)list);
    }

    @RequestPath(value="/ipCountByDay")
    public Resp ipCountByDay(Integer days, HttpRequest request) throws Exception {
        List list = StatService.me.ipCountByDay(days);
        return Resp.ok((Object)list);
    }

    @RequestPath(value="/statIpAndHitsByProvince")
    public Resp statIpAndHitsByProvince(Integer days, HttpRequest request) throws Exception {
        List list = StatService.me.statIpAndHitsByProvince(days);
        return Resp.ok((Object)list);
    }

    @RequestPath(value="/ip")
    public Resp ip(Boolean mergeRequest, String starttime, String endtime, Integer pageNumber, Integer pageSize, HttpRequest request) throws Exception {
        User curr = WebUtils.currUser(request);
        if (!UserService.isSuper((User)curr)) {
            DateTime startdate = DateUtil.parseDateTime((CharSequence)starttime);
            DateTime enddate = DateUtil.parseDateTime((CharSequence)endtime);
            long iv = enddate.getTime() - startdate.getTime();
            if (iv < 18000000L) {
                return Resp.fail((String)"<5\u5c0f\u65f6\u7684\u65f6\u95f4\u6bb5\u6570\u636e\uff0c\u53ea\u6709\u8d85\u7ba1\u53ef\u4ee5\u67e5\u8be2");
            }
            if (iv >= 864000000L) {
                return Resp.fail((String)">=10\u5929\u7684\u65f6\u95f4\u6bb5\u6570\u636e\uff0c\u53ea\u6709\u8d85\u7ba1\u53ef\u4ee5\u67e5\u8be2");
            }
            if (iv >= 432000000L && !UserRoleService.hasRole((User)curr, (Byte)9)) {
                return Resp.fail((String)">=5\u5929\u7684\u65f6\u95f4\u6bb5\u6570\u636e\uff0c\u53ea\u6709\u5b98\u7f51\u6e90\u4ee3\u7801\u6388\u6743\u7528\u6237\u53ef\u4ee5\u67e5\u8be2");
            }
            if (iv >= 86400000L && !UserRoleService.hasRole((User)curr, (Byte)8)) {
                return Resp.fail((String)">=1\u5929\u7684\u65f6\u95f4\u6bb5\u6570\u636e\uff0c\u53ea\u6709\u6587\u6863VIP\u6388\u6743\u7528\u6237\u53ef\u4ee5\u67e5\u8be2");
            }
        }
        Page page = StatService.me.ip(mergeRequest, starttime, endtime, pageNumber, pageSize);
        return Resp.ok((Object)page);
    }
}

