/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.wx;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.UploadFile;
import org.tio.http.server.annotation.RequestPath;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.bs.wx.group.WxGroupOperNtf;
import org.tio.sitexxx.im.server.Ims;
import org.tio.sitexxx.im.server.TioSiteImServerStarter;
import org.tio.sitexxx.im.server.handler.wx.WxChatApi;
import org.tio.sitexxx.im.server.handler.wx.WxSynApi;
import org.tio.sitexxx.service.model.main.Audio;
import org.tio.sitexxx.service.model.main.Img;
import org.tio.sitexxx.service.model.main.IpInfo;
import org.tio.sitexxx.service.model.main.Video;
import org.tio.sitexxx.service.model.main.WxChatGroupItem;
import org.tio.sitexxx.service.model.main.WxChatItems;
import org.tio.sitexxx.service.model.main.WxChatUserItem;
import org.tio.sitexxx.service.model.main.WxFriend;
import org.tio.sitexxx.service.model.main.WxFriendApplyItems;
import org.tio.sitexxx.service.model.main.WxGroup;
import org.tio.sitexxx.service.model.main.WxGroupMsg;
import org.tio.sitexxx.service.model.stat.GroupStat;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.ImgService;
import org.tio.sitexxx.service.service.VideoService;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.service.chat.ChatIndexService;
import org.tio.sitexxx.service.service.chat.ChatMsgService;
import org.tio.sitexxx.service.service.chat.ChatService;
import org.tio.sitexxx.service.service.chat.FriendApplyService;
import org.tio.sitexxx.service.service.chat.FriendService;
import org.tio.sitexxx.service.service.chat.GroupService;
import org.tio.sitexxx.service.service.stat.StatService;
import org.tio.sitexxx.service.utils.PeriodUtils;
import org.tio.sitexxx.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.wx.SysMsgVo;
import org.tio.sitexxx.web.server.utils.ImgUtils;
import org.tio.sitexxx.web.server.utils.UploadUtils;
import org.tio.sitexxx.web.server.utils.VideoUtils;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.sitexxx.web.server.utils.WxGroupAvatarUtil;
import org.tio.utils.Threads;
import org.tio.utils.json.Json;
import org.tio.utils.resp.Resp;

@RequestPath(value="/chat")
public class ChatController {
    private static Logger log = LoggerFactory.getLogger(ChatController.class);
    private static final FriendService friendService = FriendService.me;
    private static final ChatService chatService = ChatService.me;
    private static final GroupService groupService = GroupService.me;

    @RequestPath(value="/list")
    public Resp list(HttpRequest request) throws Exception {
        Byte devicetype;
        User curr = WebUtils.currUser(request);
        Ret ret = chatService.chatItemList(curr, devicetype = Byte.valueOf(WebUtils.getRequestExt(request).getDeviceType()));
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkList((Ret)ret));
    }

    @RequestPath(value="/group")
    public Resp group(HttpRequest request, Long groupid, Byte userflag) throws Exception {
        User curr = WebUtils.currUser(request);
        Ret ret = groupService.groupInfo(groupid, Objects.equals(userflag, (byte)1) ? curr.getId() : null);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)ret);
    }

    @RequestPath(value="/isFriend")
    public Resp isFriend(HttpRequest request, String touid) throws Exception {
        User curr = WebUtils.currUser(request);
        Ret ret = friendService.isFriend(curr, touid);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/applyList")
    public Resp applyList(HttpRequest request) throws Exception {
        User curr = WebUtils.currUser(request);
        Ret ret = FriendApplyService.me.applyList(curr.getId());
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkList((Ret)ret));
    }

    @RequestPath(value="/applyData")
    public Resp applyData(HttpRequest request) throws Exception {
        User curr = WebUtils.currUser(request);
        Ret ret = FriendApplyService.me.applyData(curr.getId());
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/mailList")
    public Resp mailList(HttpRequest request, Byte mode, String searchkey, Integer pageNumber) throws Exception {
        User curr = WebUtils.currUser(request);
        Ret ret = chatService.mailList(curr, mode, searchkey, pageNumber);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/applyGroupFdList")
    public Resp applyGroupFdList(HttpRequest request, String searchkey, Long groupid) throws Exception {
        User curr = WebUtils.currUser(request);
        Ret ret = friendService.getOutGroupFdList(curr, searchkey, groupid);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/joinGroup")
    public Resp joinGroup(final HttpRequest request, final String uids, final Long groupid, final String applyuid) throws Exception {
        final User curr = WebUtils.currUser(request);
        if (applyuid != null) {
            Byte devicetype = WebUtils.getRequestExt(request).getDeviceType();
            Ret ret = groupService.joinGroup(curr, groupid, uids, applyuid);
            if (ret.isFail()) {
                return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
            }
            Short joinnum = (Short)RetUtils.getOkTData((Ret)ret, (String)"joinnum");
            Byte nameUpdate = (Byte)RetUtils.getOkTData((Ret)ret, (String)"nameupdate");
            if (joinnum != 0) {
                User msgUser = UserService.ME.getById(applyuid);
                WxChatApi.joinGroup((HttpRequest)request, (User)msgUser, (Long)groupid, (String)((String)RetUtils.getOkTData((Ret)ret)), (List)((List)RetUtils.getOkTData((Ret)ret, (String)"rebind")));
                this.auotUpdateGroupInfo(request, devicetype, groupid, nameUpdate, joinnum, msgUser);
            }
        } else {
            Threads.getGroupExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Byte devicetype = WebUtils.getRequestExt(request).getDeviceType();
                        Ret ret = groupService.joinGroup(curr, groupid, uids, applyuid);
                        if (ret.isFail()) {
                            WxChatApi.sendFriendErrorMsg((HttpRequest)request, (String)curr.getId(), (String)curr.getId(), (String)curr.getId(), (Long)(-groupid.longValue()), (Integer)30001, (String)RetUtils.getRetMsg((Ret)ret));
                            return;
                        }
                        Short joinnum = (Short)RetUtils.getOkTData((Ret)ret, (String)"joinnum");
                        Byte nameUpdate = (Byte)RetUtils.getOkTData((Ret)ret, (String)"nameupdate");
                        if (joinnum != null && joinnum != 0) {
                            User msgUser = curr;
                            ChatController.this.auotUpdateGroupInfo(request, devicetype, groupid, nameUpdate, joinnum, msgUser);
                            WxChatApi.joinGroup((HttpRequest)request, (User)msgUser, (Long)groupid, (String)((String)RetUtils.getOkTData((Ret)ret)), (List)((List)RetUtils.getOkTData((Ret)ret, (String)"rebind")));
                        }
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                }
            });
        }
        return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestPath(value="/modifyApply")
    public Resp modifyApply(final HttpRequest request, final Long groupid, Byte mode) {
        String text = "";
        final User curr = WebUtils.currUser(request);
        final SysMsgVo sysMsgVo = new SysMsgVo(curr.getNick(), "", "", "");
        switch (mode) {
            case 1: {
                text = "%%% \u5f00\u542f\u4e86\u7fa4\u9080\u8bf7\u5f00\u5173\uff1a\u6240\u6709\u4eba\u90fd\u53ef\u4ee5\u9080\u8bf7\u4eba\u5458\u8fdb\u7fa4";
                sysMsgVo.setMsgbody(text);
                sysMsgVo.setMsgkey("applyopen");
                break;
            }
            case 2: {
                text = "%%% \u5173\u95ed\u4e86\u7fa4\u9080\u8bf7\u5f00\u5173\uff1a\u53ea\u6709\u7fa4\u4e3b\u6216\u8005\u7fa4\u7ba1\u7406\u5458\u624d\u80fd\u9080\u8bf7\u4eba\u5458\u8fdb\u7fa4";
                sysMsgVo.setMsgbody(text);
                sysMsgVo.setMsgkey("applyclose");
                break;
            }
            default: {
                return Resp.fail().msg("\u65e0\u6548\u5165\u7fa4\u65b9\u5f0f");
            }
        }
        Ret ret = groupService.modifyApply(curr, groupid, mode);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        Threads.getGroupExecutor().execute(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    Ret ret = WxChatApi.sendGroupMsgEach((HttpRequest)request, (String)sysMsgVo.toText(), (Byte)1, (String)curr.getId(), (Long)groupid, null, (Byte)1, (SysMsgVo)sysMsgVo);
                    if (!ret.isFail()) return;
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestPath(value="/modifyGroupNick")
    public Resp modifyGroupNick(HttpRequest request, Long groupid, String nick) {
        User curr = WebUtils.currUser(request);
        Ret ret = groupService.modifyGroupNick(groupid, nick, curr.getId());
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestPath(value="/modifyGroupPush")
    public Resp modifyGroupPush(HttpRequest request, Long groupid, Byte freeflag) {
        User curr = WebUtils.currUser(request);
        Ret ret = groupService.modifyGroupPush(groupid, freeflag, curr.getId());
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestPath(value="/modifyReview")
    public Resp modifyReview(final HttpRequest request, final Long groupid, Byte mode) {
        String text = "";
        final User curr = WebUtils.currUser(request);
        final SysMsgVo sysMsgVo = new SysMsgVo(curr.getNick(), "", "", "");
        switch (mode) {
            case 1: {
                text = "%%% \u5f00\u542f\u7fa4\u5ba1\u6838\u5f00\u5173\uff1a\u6210\u5458\u8fdb\u7fa4\u524d,\u5fc5\u987b\u7fa4\u4e3b\u6216\u8005\u7fa4\u7ba1\u7406\u5458\u5ba1\u6838\u901a\u8fc7";
                sysMsgVo.setMsgbody(text);
                sysMsgVo.setMsgkey("reviewopen");
                break;
            }
            case 2: {
                text = "%%% \u5173\u95ed\u4e86\u7fa4\u5ba1\u6838\u5f00\u5173\uff1a\u6210\u5458\u8fdb\u7fa4\u4e0d\u9700\u8981\u5ba1\u6838";
                sysMsgVo.setMsgbody(text);
                sysMsgVo.setMsgkey("reviewclose");
                break;
            }
            default: {
                return Resp.fail().msg("\u65e0\u6548\u5165\u7fa4\u65b9\u5f0f");
            }
        }
        Ret ret = groupService.modifyReview(curr, groupid, mode);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        Threads.getGroupExecutor().execute(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    Ret ret = WxChatApi.sendGroupMsgEach((HttpRequest)request, (String)sysMsgVo.toText(), (Byte)1, (String)curr.getId(), (Long)groupid, null, (Byte)1, (SysMsgVo)sysMsgVo);
                    if (!ret.isFail()) return;
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestPath(value="/leaveGroup")
    public Resp leaveGroup(final HttpRequest request, Integer uid, final Long groupid) throws Exception {
        final User curr = WebUtils.currUser(request);
        final Ret ret = groupService.leaveGroup(curr, groupid);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        final Byte nameUpdate = (Byte)RetUtils.getOkTData((Ret)ret, (String)"nameupdate");
        Tio.unbindGroup((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)(curr.getId() + ""), (String)(groupid + ""));
        WxGroupOperNtf leaveNtf = new WxGroupOperNtf();
        leaveNtf.setC("\u81ea\u52a8\u9000\u7fa4");
        leaveNtf.setMid(null);
        leaveNtf.setT(Long.valueOf(System.currentTimeMillis()));
        leaveNtf.setUid(curr.getId());
        leaveNtf.setG(groupid);
        leaveNtf.setChatlinkid(Long.valueOf(-groupid.longValue()));
        leaveNtf.setOper(Byte.valueOf((byte)5));
        ImPacket imPacket = new ImPacket(Command.WxGroupOperNtf, Json.toJson((Object)leaveNtf));
        Ims.sendToUser((String)curr.getId(), (ImPacket)imPacket);
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Byte devicetype = WebUtils.getRequestExt(request).getDeviceType();
                    ChatController.this.auotUpdateGroupInfo(request, devicetype, groupid, nameUpdate, (short)-1, curr);
                    WxChatGroupItem newowner = (WxChatGroupItem)RetUtils.getOkTData((Ret)ret, (String)"owner");
                    WxChatGroupItem leave = (WxChatGroupItem)RetUtils.getOkTData((Ret)ret, (String)"leave");
                    WxChatApi.leaveGroup((HttpRequest)request, (User)curr, (WxChatGroupItem)leave, (WxChatGroupItem)newowner);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestPath(value="/kickGroup")
    public Resp kickGroup(final HttpRequest request, String uids, final Long groupid) throws Exception {
        final User curr = WebUtils.currUser(request);
        final Ret ret = groupService.kickGroup(curr, groupid, uids);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        final Short joinnum = (Short)RetUtils.getOkTData((Ret)ret, (String)"joinnum");
        final Byte nameUpdate = (Byte)RetUtils.getOkTData((Ret)ret, (String)"nameupdate");
        if (joinnum != 0) {
            Threads.getGroupExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Byte devicetype = WebUtils.getRequestExt(request).getDeviceType();
                        ChatController.this.auotUpdateGroupInfo(request, devicetype, groupid, nameUpdate, joinnum, curr);
                        List kickGroupItem = (List)RetUtils.getOkTData((Ret)ret, (String)"kick");
                        String nickStr = (String)RetUtils.getOkTData((Ret)ret);
                        WxChatApi.kickGroup((HttpRequest)request, (User)curr, (Long)groupid, (List)kickGroupItem, (String)nickStr);
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                }
            });
        }
        return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestPath(value="/resetFdChatIndex")
    public Resp resetFdChatIndex(HttpRequest request) throws Exception {
        friendService.resetFdChatIndex();
        return Resp.ok();
    }

    @RequestPath(value="/resetGroupAvatar")
    public Resp resetGroupAvatar(HttpRequest request) throws Exception {
        List groups = groupService.getAllGroup();
        User curr = WebUtils.currUser(request);
        Byte devicetype = WebUtils.getRequestExt(request).getDeviceType();
        for (WxGroup group : groups) {
            this.auotUpdateGroupInfo(request, devicetype, group.getId(), (byte)2, (short)-1, curr);
        }
        return Resp.ok();
    }

    @RequestPath(value="/registerStat")
    public Resp registerStat(HttpRequest request) throws Exception {
        StatService.me.userRegisterStatInit();
        return Resp.ok();
    }

    @RequestPath(value="/groupStatInit")
    public Resp groupStatInit(HttpRequest request) throws Exception {
        GroupStat groupStat;
        String dayperiod;
        long start = System.currentTimeMillis();
        Db.use((String)"tio_site_stat").update("truncate table group_stat");
        List groups = WxGroup.dao.find("select * from wx_group order by id");
        List delGroups = WxGroup.dao.find("select * from wx_group_bak");
        log.error(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ",\u5f00\u59cb\u7fa4\u7edf\u8ba1\u521d\u59cb\u5316\uff0c\u6709\u6548\u7fa4\uff1a" + groups.size() + "\u65e0\u6548\u7fa4\uff1a" + delGroups.size());
        for (WxGroup group : groups) {
            dayperiod = PeriodUtils.dateToPeriodByType((Date)group.getCreatetime(), (byte)1);
            groupStat = (GroupStat)GroupStat.dao.findFirst("select * from group_stat where dayperiod = ? and type = ?", new Object[]{dayperiod, (byte)1});
            if (groupStat == null) {
                groupStat = new GroupStat();
                groupStat.setAddcount(Integer.valueOf(1));
                groupStat.setDayperiod(dayperiod);
                groupStat.setType(Byte.valueOf((byte)1));
                groupStat.ignoreSave();
                continue;
            }
            Db.use((String)"tio_site_stat").update("update group_stat set addcount = addcount + 1 where dayperiod = ? and type = ?", new Object[]{dayperiod, (byte)1});
        }
        for (WxGroup group : delGroups) {
            dayperiod = PeriodUtils.dateToPeriodByType((Date)group.getCreatetime(), (byte)1);
            groupStat = (GroupStat)GroupStat.dao.findFirst("select * from group_stat where dayperiod = ? and type = ?", new Object[]{dayperiod, (byte)3});
            if (groupStat == null) {
                groupStat = new GroupStat();
                groupStat.setAddcount(Integer.valueOf(1));
                groupStat.setDayperiod(dayperiod);
                groupStat.setType(Byte.valueOf((byte)3));
                groupStat.ignoreSave();
                continue;
            }
            Db.use((String)"tio_site_stat").update("update group_stat set addcount = addcount + 1 where dayperiod = ? and type = ?", new Object[]{dayperiod, (byte)3});
        }
        long end = System.currentTimeMillis();
        long exe = (end - start) / 60000L;
        log.error(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "\u7ed3\u675f\u7fa4\u7edf\u8ba1\u521d\u59cb\u5316\uff0c\u603b\u65f6\u95f4\uff1a{}", (Object)exe);
        return Resp.ok();
    }

    @RequestPath(value="/loginLogStat")
    public Resp loginLogStat(HttpRequest request) throws Exception {
        UserService.ME.loginInit();
        return Resp.ok();
    }

    @RequestPath(value="/fdStat")
    public Resp fdStat(HttpRequest request) throws Exception {
        StatService.me.fdKeyInit();
        return Resp.ok();
    }

    @RequestPath(value="/groupStat")
    public Resp groupStat(HttpRequest request) throws Exception {
        ChatMsgService.me.bakGroupInvalidMsg();
        ChatMsgService.me.updateGroupInvalidMsg();
        return Resp.ok();
    }

    @RequestPath(value="/resetFdHistroy")
    public Resp resetFdHistroy(HttpRequest request) throws Exception {
        chatService.resetHistory();
        return Resp.ok();
    }

    @RequestPath(value="/groupUserList")
    public Resp groupUserList(HttpRequest request, Long groupid, Integer pageNumber, String searchkey) throws Exception {
        Ret ret = groupService.groupUserList(groupid, pageNumber, searchkey);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkPage((Ret)ret));
    }

    @RequestPath(value="/atGroupUserList")
    public Resp atGroupUserList(HttpRequest request, Long groupid, String searchkey) throws Exception {
        User curr = WebUtils.currUser(request);
        Ret ret = groupService.atGroupUserList(groupid, searchkey, curr.getId());
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkList((Ret)ret));
    }

    @RequestPath(value="/checkAddFriend")
    public Resp checkAddFriend(HttpRequest request, String touid) throws Exception {
        User curr = WebUtils.currUser(request);
        Ret ret = friendService.checkAddFriend(curr, touid);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getCode((Ret)ret));
    }

    @RequestPath(value="/checkCardJoinGroup")
    public Resp checkCardJoinGroup(HttpRequest request, Long groupid, String applyuid, Date sendtime) throws Exception {
        User curr = WebUtils.currUser(request);
        Ret ret = groupService.checkJoinGroup(applyuid, groupid, curr.getId(), sendtime);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkTData((Ret)ret, (String)"joinflag"));
    }

    @RequestPath(value="/checkSendCard")
    public Resp checkCard(HttpRequest request, Long groupid) throws Exception {
        User curr = WebUtils.currUser(request);
        Ret ret = groupService.checkSendCard(curr.getId(), groupid);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok();
    }

    @RequestPath(value="/friendApply")
    public Resp friendApply(final HttpRequest request, final String touid, String greet) throws Exception {
        final User curr = WebUtils.currUser(request);
        Ret ret = friendService.addApply(curr, touid, greet);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        final WxFriendApplyItems applyItems = (WxFriendApplyItems)RetUtils.getOkTData((Ret)ret);
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (WxSynApi.isSynVersion()) {
                        WxSynApi.synFriendApply((String)touid, (WxFriendApplyItems)applyItems, (Byte)1);
                    } else {
                        WxChatApi.useSysChatNtf((HttpRequest)request, (String)touid, (Byte)30, (String)(curr.getNick() + " \u60f3\u8981\u6210\u4e3a\u4f60\u7684\u597d\u53cb\uff1a" + applyItems.getGreet()), (String)(applyItems.getId() + ""));
                    }
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        return Resp.ok((Object)applyItems);
    }

    @RequestPath(value="/applyInfo")
    public Resp applyInfo(HttpRequest request, Integer applyid) throws Exception {
        Ret ret = FriendApplyService.me.applyInfo(applyid);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        Record record = (Record)RetUtils.getOkTData((Ret)ret);
        if (record == null) {
            return Resp.fail().msg("\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        return Resp.ok((Object)record);
    }

    @RequestPath(value="/addFriend")
    public Resp addFriend(final HttpRequest request, String touid) throws Exception {
        User curr = WebUtils.currUser(request);
        final Ret ret = friendService.addFriend(curr, touid);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    WxFriend friend = (WxFriend)RetUtils.getOkTData((Ret)ret, (String)"friend");
                    WxFriend toFriend = (WxFriend)RetUtils.getOkTData((Ret)ret, (String)"tofriend");
                    WxChatApi.friendChangeAddNtf((HttpRequest)request, (WxFriend)friend, (WxFriend)toFriend);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @Deprecated
    @RequestPath(value="/onFocus")
    public Resp onFocus(final HttpRequest request, Long chatlinkid) throws Exception {
        IpInfo ipInfo;
        Byte devicetype;
        Ret ret;
        User curr = WebUtils.currUser(request);
        String uid = curr.getId();
        if (chatlinkid == null) {
            return Resp.fail((String)"\u4f1a\u8bddid\u53c2\u6570\u4e3a\u7a7a");
        }
        Byte chatmode = 1;
        Long groupid = null;
        if (chatlinkid <= 0L) {
            chatmode = 2;
            groupid = -chatlinkid.longValue();
            WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)uid, (Long)groupid);
            if (groupItem == null || groupItem.getChatlinkid() == null) {
                return Resp.fail((String)"\u4f1a\u8bddid\u4e3a\u7a7a");
            }
            chatlinkid = groupItem.getChatlinkid();
        }
        if ((ret = ChatMsgService.me.onFocus(curr, chatlinkid, groupid, chatmode, devicetype = Byte.valueOf(WebUtils.getRequestExt(request).getDeviceType()), (ipInfo = IpInfoService.ME.save(request.getClientIp())).getId())).isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        boolean isToRead = (Boolean)RetUtils.getOkTData((Ret)ret);
        if (isToRead) {
            final Byte runChatMode = chatmode;
            final Long fGroup = groupid;
            Threads.getGroupExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Long tochatlinkid = (Long)RetUtils.getOkTData((Ret)ret, (String)"tochatlinkid");
                        String touid = (String)RetUtils.getOkTData((Ret)ret, (String)"touid");
                        if (Objects.equals(runChatMode, (byte)2)) {
                            WxChatApi.userChatOper((HttpRequest)request, (String)touid, (Long)(-fGroup.longValue()), (Byte)7, (String)"\u597d\u53cb\u5df2\u8bfb\u4f60\u7684\u6d88\u606f", (String)"", null);
                        } else {
                            WxChatApi.userChatOper((HttpRequest)request, (String)touid, (Long)tochatlinkid, (Byte)7, (String)"\u597d\u53cb\u5df2\u8bfb\u4f60\u7684\u6d88\u606f", (String)"", null);
                        }
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                }
            });
        }
        return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestPath(value="/file")
    public Resp file(HttpRequest request, UploadFile uploadFile, Long chatlinkid) throws Exception {
        try {
            WxChatUserItem touserItem;
            WxChatItems chatItems;
            if (uploadFile == null) {
                return Resp.fail((String)"\u4e0a\u4f20\u4fe1\u606f\u4e3a\u7a7a");
            }
            if (chatlinkid == null) {
                return Resp.fail((String)"\u4f1a\u8bddid\u53c2\u6570\u4e3a\u7a7a");
            }
            User curr = WebUtils.currUser(request);
            if (chatlinkid <= 0L) {
                WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)curr.getId(), (Long)(-chatlinkid.longValue()));
                if (groupItem == null || groupItem.getChatlinkid() == null) {
                    return Resp.fail((String)"\u4f1a\u8bddid\u4e3a\u7a7a");
                }
                if (!ChatService.groupChatLink((WxChatGroupItem)groupItem)) {
                    return Resp.fail((String)"\u4f60\u4e0d\u662f\u6709\u6548\u6210\u5458");
                }
                chatlinkid = groupItem.getChatlinkid();
            }
            if ((chatItems = chatService.getChatItems(chatlinkid)) == null) {
                return Resp.fail((String)"\u65e0\u6548\u53c2\u6570");
            }
            if (Objects.equals(chatItems.getChatmode(), (byte)1) && !ChatService.existTwoFriend((WxChatUserItem)(touserItem = ChatIndexService.fdUserIndex((String)chatItems.getBizid(), (String)chatItems.getUid())))) {
                return Resp.fail((String)"\u5bf9\u65b9\u4e0d\u662f\u4f60\u7684\u597d\u53cb");
            }
            String sessionid = request.getHttpSession().getId();
            org.tio.sitexxx.service.model.main.File dbFile = ChatController.innerUploadFile(curr, uploadFile, sessionid);
            String text = Json.toJson((Object)dbFile);
            if (Objects.equals(chatItems.getChatmode(), (byte)1)) {
                Ret ret = WxChatApi.sendFdMsgEach((HttpRequest)request, (String)text, (Byte)3, (String)chatItems.getUid(), (String)chatItems.getBizid(), (Long)chatlinkid, (Byte)2);
                if (ret.isFail()) {
                    return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
                }
                return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
            }
            Ret ret = WxChatApi.sendGroupMsgEach((HttpRequest)request, (String)text, (Byte)3, (String)chatItems.getUid(), (Long)Long.parseLong(chatItems.getBizid()), (Long)chatlinkid, (Byte)2, null);
            if (ret.isFail()) {
                return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
            }
            return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return Resp.fail((String)"\u7cfb\u7edf\u9519\u8bef");
        }
    }

    @RequestPath(value="/video")
    public Resp video(HttpRequest request, UploadFile uploadFile, Long chatlinkid) throws Exception {
        try {
            WxChatUserItem touserItem;
            WxChatItems chatItems;
            if (uploadFile == null) {
                return Resp.fail((String)"\u4e0a\u4f20\u4fe1\u606f\u4e3a\u7a7a");
            }
            if (chatlinkid == null) {
                return Resp.fail((String)"\u4f1a\u8bddid\u53c2\u6570\u4e3a\u7a7a");
            }
            User curr = WebUtils.currUser(request);
            if (chatlinkid <= 0L) {
                WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)curr.getId(), (Long)(-chatlinkid.longValue()));
                if (groupItem == null || groupItem.getChatlinkid() == null) {
                    return Resp.fail((String)"\u4f1a\u8bddid\u4e3a\u7a7a");
                }
                if (!ChatService.groupChatLink((WxChatGroupItem)groupItem)) {
                    return Resp.fail((String)"\u4f60\u4e0d\u662f\u6709\u6548\u6210\u5458");
                }
                chatlinkid = groupItem.getChatlinkid();
            }
            if ((chatItems = chatService.getChatItems(chatlinkid)) == null) {
                return Resp.fail((String)"\u65e0\u6548\u53c2\u6570");
            }
            if (Objects.equals(chatItems.getChatmode(), (byte)1) && !ChatService.existTwoFriend((WxChatUserItem)(touserItem = ChatIndexService.fdUserIndex((String)chatItems.getBizid(), (String)chatItems.getUid())))) {
                return Resp.fail((String)"\u5bf9\u65b9\u4e0d\u662f\u4f60\u7684\u597d\u53cb");
            }
            Resp resp = this.processUploadedVideo(request, uploadFile);
            if (!resp.isOk()) {
                return resp;
            }
            Video video = (Video)resp.getData();
            String text = Json.toJson((Object)video);
            if (Objects.equals(chatItems.getChatmode(), (byte)1)) {
                Ret ret = WxChatApi.sendFdMsgEach((HttpRequest)request, (String)text, (Byte)5, (String)chatItems.getUid(), (String)chatItems.getBizid(), (Long)chatlinkid, (Byte)2);
                if (ret.isFail()) {
                    return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
                }
                return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
            }
            Ret ret = WxChatApi.sendGroupMsgEach((HttpRequest)request, (String)text, (Byte)5, (String)chatItems.getUid(), (Long)Long.parseLong(chatItems.getBizid()), (Long)chatlinkid, (Byte)2, null);
            if (ret.isFail()) {
                return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
            }
            return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return Resp.fail((String)"\u7cfb\u7edf\u9519\u8bef");
        }
    }

    @RequestPath(value="/img")
    public Resp img(HttpRequest request, UploadFile uploadFile, Long chatlinkid) throws Exception {
        try {
            WxChatUserItem touserItem;
            WxChatItems chatItems;
            if (uploadFile == null) {
                return Resp.fail((String)"\u4e0a\u4f20\u4fe1\u606f\u4e3a\u7a7a");
            }
            if (chatlinkid == null) {
                return Resp.fail((String)"\u4f1a\u8bddid\u53c2\u6570\u4e3a\u7a7a");
            }
            User curr = WebUtils.currUser(request);
            if (chatlinkid <= 0L) {
                WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)curr.getId(), (Long)(-chatlinkid.longValue()));
                if (groupItem == null || groupItem.getChatlinkid() == null) {
                    return Resp.fail((String)"\u4f1a\u8bddid\u4e3a\u7a7a");
                }
                if (!ChatService.groupChatLink((WxChatGroupItem)groupItem)) {
                    return Resp.fail((String)"\u4f60\u4e0d\u662f\u6709\u6548\u6210\u5458");
                }
                chatlinkid = groupItem.getChatlinkid();
            }
            if ((chatItems = chatService.getChatItems(chatlinkid)) == null) {
                return Resp.fail((String)"\u65e0\u6548\u53c2\u6570");
            }
            if (Objects.equals(chatItems.getChatmode(), (byte)1) && !ChatService.existTwoFriend((WxChatUserItem)(touserItem = ChatIndexService.fdUserIndex((String)chatItems.getBizid(), (String)chatItems.getUid())))) {
                return Resp.fail((String)"\u5bf9\u65b9\u4e0d\u662f\u4f60\u7684\u597d\u53cb");
            }
            Resp resp = this.processUploadedImg(request, uploadFile);
            if (!resp.isOk()) {
                return resp;
            }
            Img img = (Img)resp.getData();
            String text = Json.toJson((Object)img);
            if (Objects.equals(chatItems.getChatmode(), (byte)1)) {
                Ret ret = WxChatApi.sendFdMsgEach((HttpRequest)request, (String)text, (Byte)6, (String)chatItems.getUid(), (String)chatItems.getBizid(), (Long)chatlinkid, (Byte)2);
                if (ret.isFail()) {
                    return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
                }
                return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
            }
            Ret ret = WxChatApi.sendGroupMsgEach((HttpRequest)request, (String)text, (Byte)6, (String)chatItems.getUid(), (Long)Long.parseLong(chatItems.getBizid()), (Long)chatlinkid, (Byte)2, null);
            if (ret.isFail()) {
                return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
            }
            return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return Resp.fail((String)"\u7cfb\u7edf\u9519\u8bef");
        }
    }

    @RequestPath(value="/audio")
    public Resp audio(HttpRequest request, UploadFile uploadFile, Long chatlinkid) throws Exception {
        try {
            WxChatUserItem touserItem;
            WxChatItems chatItems;
            if (uploadFile == null) {
                return Resp.fail((String)"\u4e0a\u4f20\u4fe1\u606f\u4e3a\u7a7a");
            }
            if (chatlinkid == null) {
                return Resp.fail((String)"\u4f1a\u8bddid\u53c2\u6570\u4e3a\u7a7a");
            }
            User curr = WebUtils.currUser(request);
            if (chatlinkid <= 0L) {
                WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)curr.getId(), (Long)(-chatlinkid.longValue()));
                if (groupItem == null || groupItem.getChatlinkid() == null) {
                    return Resp.fail((String)"\u4f1a\u8bddid\u4e3a\u7a7a");
                }
                if (!ChatService.groupChatLink((WxChatGroupItem)groupItem)) {
                    return Resp.fail((String)"\u4f60\u4e0d\u662f\u6709\u6548\u6210\u5458");
                }
                chatlinkid = groupItem.getChatlinkid();
            }
            if ((chatItems = chatService.getChatItems(chatlinkid)) == null) {
                return Resp.fail((String)"\u65e0\u6548\u53c2\u6570");
            }
            if (Objects.equals(chatItems.getChatmode(), (byte)1) && !ChatService.existTwoFriend((WxChatUserItem)(touserItem = ChatIndexService.fdUserIndex((String)chatItems.getBizid(), (String)chatItems.getUid())))) {
                return Resp.fail((String)"\u5bf9\u65b9\u4e0d\u662f\u4f60\u7684\u597d\u53cb");
            }
            Resp resp = this.processUploadedAudio(request, uploadFile);
            if (!resp.isOk()) {
                return resp;
            }
            Audio audio = (Audio)resp.getData();
            String text = Json.toJson((Object)audio);
            if (Objects.equals(chatItems.getChatmode(), (byte)1)) {
                Ret ret = WxChatApi.sendFdMsgEach((HttpRequest)request, (String)text, (Byte)4, (String)chatItems.getUid(), (String)chatItems.getBizid(), (Long)chatlinkid, (Byte)2);
                if (ret.isFail()) {
                    return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
                }
                return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
            }
            Ret ret = WxChatApi.sendGroupMsgEach((HttpRequest)request, (String)text, (Byte)4, (String)chatItems.getUid(), (Long)Long.parseLong(chatItems.getBizid()), (Long)chatlinkid, (Byte)2, null);
            if (ret.isFail()) {
                return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
            }
            return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return Resp.fail((String)"\u7cfb\u7edf\u9519\u8bef");
        }
    }

    @RequestPath(value="/leaveChat")
    public Resp leaveChat(HttpRequest request) throws Exception {
        Ret ret;
        User curr = WebUtils.currUser(request);
        Byte devicetype = WebUtils.getRequestExt(request).getDeviceType();
        if (Objects.equals(devicetype, Devicetype.IOS.getValue()) || Objects.equals(devicetype, Devicetype.ANDROID.getValue())) {
            devicetype = Devicetype.APP.getValue();
        }
        if ((ret = ChatMsgService.me.leaveChat(curr, devicetype)).isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/p2pMsgList")
    public Resp p2pMsgList(HttpRequest request, Integer uid, Long chatlinkid, Long startmid) throws Exception {
        User curr = WebUtils.currUser(request);
        Ret ret = ChatMsgService.me.p2pMsgList(chatlinkid, curr.getId(), startmid, null);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/groupMsgList")
    public Resp groupMsgList(HttpRequest request, Long chatlinkid, Long startmid) throws Exception {
        User curr = WebUtils.currUser(request);
        WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)curr.getId(), (Long)Math.abs(chatlinkid));
        if (groupItem == null || groupItem.getChatlinkid() == null) {
            return Resp.fail((String)"\u4f1a\u8bdd\u4e3a\u7a7a");
        }
        chatlinkid = groupItem.getChatlinkid();
        Ret ret = ChatMsgService.me.groupMsgList(chatlinkid, curr.getId(), startmid, null);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/delFriend")
    public Resp delFriend(HttpRequest request, String touid) throws Exception {
        User curr = WebUtils.currUser(request);
        String uid = curr.getId();
        if (Objects.equals(uid, touid)) {
            return Resp.fail((String)"\u4e0d\u80fd\u5220\u9664\u81ea\u5df1");
        }
        IpInfo ipInfo = IpInfoService.ME.save(request.getClientIp());
        Ret ret = friendService.delFriend(curr, touid, ipInfo.getId());
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        Long chatlinkid = (Long)RetUtils.getOkTData((Ret)ret, (String)"chatlinkid");
        Long tochatlinkid = (Long)RetUtils.getOkTData((Ret)ret, (String)"tochatlinkid");
        if (WxSynApi.isSynVersion()) {
            WxSynApi.synFriendDel((String)uid, (String)touid, (Long)chatlinkid, (Long)tochatlinkid, (Long)((Long)RetUtils.getOkTData((Ret)ret, (String)"fid")));
        } else {
            if (chatlinkid != null) {
                WxChatApi.userChatOper((HttpRequest)request, (String)uid, (Long)chatlinkid, (Byte)5, (String)"\u5220\u9664\u597d\u53cb", (String)"", null);
            }
            if (tochatlinkid != null) {
                WxChatApi.userChatOper((HttpRequest)request, (String)touid, (Long)tochatlinkid, (Byte)6, (String)"\u88ab\u5220\u9664\u597d\u53cb", (String)"", null);
            }
            WxChatApi.friendChangeDelNtf((HttpRequest)request, (String)uid, (Long)((Long)RetUtils.getOkTData((Ret)ret, (String)"fid")));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/delGroup")
    public Resp delGroup(final HttpRequest request, Integer uid, Long groupid) throws Exception {
        final User curr = WebUtils.currUser(request);
        if (!Objects.equals(curr.getId(), uid)) {
            return Resp.fail((String)"\u767b\u5f55\u4fe1\u606f\u4e0d\u4e00\u81f4");
        }
        final Ret ret = groupService.delGroup(curr, groupid);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    WxChatGroupItem groupItem = (WxChatGroupItem)RetUtils.getOkTData((Ret)ret, (String)"groupitem");
                    WxGroup group = (WxGroup)RetUtils.getOkTData((Ret)ret, (String)"group");
                    WxChatApi.delGroup((HttpRequest)request, (User)curr, (WxChatGroupItem)groupItem, (WxGroup)group);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    WxGroup group = (WxGroup)RetUtils.getOkTData((Ret)ret, (String)"group");
                    String dayperiod = PeriodUtils.dateToPeriodByType((Date)group.getCreatetime(), (byte)1);
                    GroupStat groupStat = (GroupStat)GroupStat.dao.findFirst("select * from group_stat where dayperiod = ? and type = ?", new Object[]{dayperiod, (byte)3});
                    if (groupStat == null) {
                        groupStat = new GroupStat();
                        groupStat.setAddcount(Integer.valueOf(1));
                        groupStat.setDayperiod(dayperiod);
                        groupStat.setType(Byte.valueOf((byte)3));
                        groupStat.ignoreSave();
                    } else {
                        Db.use((String)"tio_site_stat").update("update group_stat set addcount = addcount + 1 where dayperiod = ? and type = ?", new Object[]{dayperiod, (byte)3});
                    }
                    Db.use((String)"tio_site_stat").update("update group_stat set addcount = addcount - 1 where dayperiod = ? and type = ?", new Object[]{dayperiod, (byte)1});
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        return Resp.ok((Object)RetUtils.okOper());
    }

    @RequestPath(value="/changeOwner")
    public Resp changeOwner(final HttpRequest request, final Long groupid, String otheruid) throws Exception {
        final User curr = WebUtils.currUser(request);
        if (Objects.equals(otheruid, curr.getId())) {
            return Resp.fail().msg("\u4e0d\u80fd\u5bf9\u81ea\u5df1\u64cd\u4f5c\u54e6");
        }
        User user = UserService.ME.getById(otheruid);
        if (user == null) {
            return Resp.fail().msg("\u65e0\u6548\u8f6c\u8ba9\u7528\u6237");
        }
        final Ret ret = groupService.changeOwner(curr.getId(), user.getId(), groupid);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    WxChatGroupItem owner = (WxChatGroupItem)RetUtils.getOkTData((Ret)ret, (String)"owner");
                    WxChatGroupItem other = (WxChatGroupItem)RetUtils.getOkTData((Ret)ret, (String)"other");
                    Byte devicetype = WebUtils.getRequestExt(request).getDeviceType();
                    WxChatApi.changeOwner((HttpRequest)request, (User)curr, (WxChatGroupItem)owner, (WxChatGroupItem)other);
                    ChatController.this.auotUpdateGroupInfo(request, devicetype, groupid, (byte)1, (short)0, curr);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        return Resp.ok((Object)RetUtils.okOper());
    }

    @RequestPath(value="/oper")
    public Resp oper(final HttpRequest request, String touid, final Byte oper, Long chatlinkid) throws Exception {
        Ret ret;
        User curr = WebUtils.currUser(request);
        final String uid = curr.getId();
        Long group = null;
        final Long oldChatLinkid = chatlinkid;
        if (chatlinkid != null && chatlinkid <= 0L) {
            group = -chatlinkid.longValue();
            WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)curr.getId(), (Long)(-chatlinkid.longValue()));
            if (groupItem == null || groupItem.getChatlinkid() == null) {
                return Resp.fail((String)"\u4f1a\u8bddid\u4e3a\u7a7a");
            }
            chatlinkid = groupItem.getChatlinkid();
        }
        if ((ret = chatService.chatUserOper(oper, uid, touid, chatlinkid)).isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        final Long fGroup = group;
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    WxChatItems chatItems = (WxChatItems)RetUtils.getOkTData((Ret)ret, (String)"chat");
                    if ((Objects.equals(oper, (byte)1) || Objects.equals(oper, (byte)11)) && chatItems != null && Objects.equals(chatItems.getChatmode(), (byte)2)) {
                        Tio.unbindGroup((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)(uid + ""), (String)(chatItems.getBizid() + ""));
                    }
                    if (WxSynApi.isSynVersion()) {
                        switch (oper) {
                            case 2: {
                                break;
                            }
                            case 3: {
                                break;
                            }
                            case 1: {
                                WxChatItems delChatItems = new WxChatItems();
                                delChatItems.setChatlinkid(oldChatLinkid);
                                WxSynApi.synChatSession((String)uid, (WxChatItems)delChatItems, (Byte)4);
                                break;
                            }
                            case 8: {
                                WxSynApi.synMsgClear((String)uid, (Long)oldChatLinkid);
                                break;
                            }
                            case 21: {
                                WxChatItems topChatItems = new WxChatItems();
                                topChatItems.setChatlinkid(oldChatLinkid);
                                topChatItems.setTopflag(Byte.valueOf((byte)1));
                                topChatItems.setChatuptime(new Date());
                                WxSynApi.synChatSession((String)uid, (WxChatItems)topChatItems, (Byte)2);
                                break;
                            }
                            case 22: {
                                WxChatItems cancelTop = new WxChatItems();
                                cancelTop.setChatlinkid(oldChatLinkid);
                                cancelTop.setTopflag(Byte.valueOf((byte)2));
                                cancelTop.setChatuptime(new Date());
                                WxSynApi.synChatSession((String)uid, (WxChatItems)cancelTop, (Byte)2);
                                break;
                            }
                            case 11: {
                                WxChatItems hide = new WxChatItems();
                                hide.setChatlinkid(oldChatLinkid);
                                hide.setViewflag(Byte.valueOf((byte)2));
                                hide.setChatuptime(new Date());
                                WxSynApi.synChatSession((String)uid, (WxChatItems)hide, (Byte)2);
                            }
                        }
                    } else {
                        String operBizData = "";
                        Long chatlinkid = (Long)RetUtils.getOkTData((Ret)ret, (String)"chatlinkid");
                        switch (oper) {
                            case 2: {
                                break;
                            }
                            case 3: {
                                if (chatlinkid == null) break;
                                WxChatItems removeBlack = chatService.getChatItems(chatlinkid);
                                WxChatApi.userChatOper((HttpRequest)request, (String)uid, (Long)chatlinkid, (Byte)oper, (String)"", (String)operBizData, (WxChatItems)removeBlack);
                                break;
                            }
                            case 21: {
                                WxChatItems topChatItems = new WxChatItems();
                                topChatItems.setChatlinkid(oldChatLinkid);
                                topChatItems.setTopflag(Byte.valueOf((byte)1));
                                topChatItems.setChatuptime(new Date());
                                operBizData = Json.toJson((Object)topChatItems);
                                break;
                            }
                            case 22: {
                                WxChatItems cancelTop = new WxChatItems();
                                cancelTop.setChatlinkid(oldChatLinkid);
                                cancelTop.setTopflag(Byte.valueOf((byte)2));
                                cancelTop.setChatuptime(new Date());
                                operBizData = Json.toJson((Object)cancelTop);
                                break;
                            }
                            case 11: {
                                WxChatItems hide = new WxChatItems();
                                hide.setChatlinkid(oldChatLinkid);
                                hide.setViewflag(Byte.valueOf((byte)2));
                                hide.setChatuptime(new Date());
                                operBizData = Json.toJson((Object)hide);
                            }
                        }
                        WxChatApi.userChatOper((HttpRequest)request, (String)uid, (Long)(fGroup == null ? (Long)RetUtils.getOkTData((Ret)ret, (String)"chatlinkid") : Long.valueOf(-fGroup.longValue())), (Byte)oper, (String)"", (String)operBizData, null);
                    }
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/actChat")
    public Resp actChat(final HttpRequest request, String touid, Long groupid) throws Exception {
        User curr = WebUtils.currUser(request);
        final String uid = curr.getId();
        Ret ret = null;
        if (groupid == null) {
            if (touid == null) {
                return Resp.fail((String)"\u65e0\u6548\u53c2\u6570");
            }
            ret = chatService.actFdChatItems(uid, touid);
        } else {
            ret = chatService.actGroupChatItems(groupid, curr);
        }
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        Byte act = (Byte)RetUtils.getOkTData((Ret)ret, (String)"actflag");
        final Ret sendRet = ret;
        if (act != null && Objects.equals(act, (byte)1)) {
            Threads.getGroupExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        WxChatItems chatItems = (WxChatItems)RetUtils.getOkTData((Ret)sendRet, (String)"chat");
                        if (WxSynApi.isSynVersion()) {
                            WxSynApi.synChatSession((String)uid, (WxChatItems)chatItems, (Byte)1);
                        } else {
                            WxChatApi.userActOper((HttpRequest)request, (String)uid, (WxChatItems)chatItems);
                        }
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                }
            });
        }
        return Resp.ok((Object)ret);
    }

    @RequestPath(value="/dealApply")
    public Resp dealApply(final HttpRequest request, Integer applyid, String remarkname) throws Exception {
        User curr = WebUtils.currUser(request);
        final WxFriendApplyItems items = FriendApplyService.me.getById(applyid);
        if (items == null) {
            return Resp.fail((String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        final Ret ret = friendService.dealApply(curr, items, remarkname);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String uid = items.getFromuid();
                    String touid = items.getTouid();
                    String send = RetUtils.retKey((Ret)ret, (String)"send");
                    if (StrUtil.isNotBlank((CharSequence)send)) {
                        String greet = RetUtils.retKey((Ret)ret, (String)"greet");
                        Long tochatlinkid = RetUtils.retLongKey((Ret)ret, (String)"tochatlinkid");
                        if (send.equals("double")) {
                            boolean applysigle = (Boolean)RetUtils.getOkTData((Ret)ret, (String)"applysigle");
                            Long chatlinkid = RetUtils.retLongKey((Ret)ret, (String)"chatlinkid");
                            WxChatApi.addFriendEachOfPassApply((HttpRequest)request, (String)uid, (String)touid, (Long)chatlinkid, (Long)tochatlinkid, (String)greet, (boolean)applysigle);
                        } else {
                            WxChatApi.addFriendSigleOfPassApply((HttpRequest)request, (String)uid, (String)touid, (Long)tochatlinkid, (String)greet);
                        }
                    }
                    WxFriend friend = (WxFriend)RetUtils.getOkTData((Ret)ret, (String)"friend");
                    WxFriend toFriend = (WxFriend)RetUtils.getOkTData((Ret)ret, (String)"tofriend");
                    WxChatApi.friendChangeAddNtf((HttpRequest)request, (WxFriend)friend, (WxFriend)toFriend);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/chatInfo")
    public Resp chatInfo(HttpRequest request, Long chatlinkid) throws Exception {
        WxChatItems chatItems;
        User curr = WebUtils.currUser(request);
        if (chatlinkid == null) {
            return Resp.fail((String)"\u4f1a\u8bddid\u53c2\u6570\u4e3a\u7a7a");
        }
        if (chatlinkid <= 0L) {
            WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)curr.getId(), (Long)(-chatlinkid.longValue()));
            if (groupItem == null || groupItem.getChatlinkid() == null) {
                return Resp.fail((String)"\u4f1a\u8bddid\u4e3a\u7a7a");
            }
            chatlinkid = groupItem.getChatlinkid();
        }
        if ((chatItems = chatService.getChatItems(chatlinkid)) == null) {
            return Resp.fail((String)"\u4f1a\u8bdd\u4e0d\u5b58\u5728");
        }
        if (!Objects.equals(curr.getId(), chatItems.getUid())) {
            log.error("\u5f02\u5e38\u767b\u5f55\u8bf7\u6c42\u4f1a\u8bdd\u4fe1\u606f\uff1a\u767b\u5f55uid\uff1a{}\uff0c\u8bf7\u6c42\u4f1a\u8bdd\u7684uid\uff1a{}", (Object)curr.getId(), (Object)chatItems.getUid());
            return Resp.fail((String)"\u6743\u9650\u4e0d\u8db3");
        }
        return Resp.ok((Object)chatItems);
    }

    @RequestPath(value="/msgOper")
    public Resp msgOper(final HttpRequest request, Long chatlinkid, final String mids, final Byte oper) throws Exception {
        Ret ret;
        if (chatlinkid == null) {
            return Resp.fail((String)"\u4f1a\u8bddid\u53c2\u6570\u4e3a\u7a7a");
        }
        final User curr = WebUtils.currUser(request);
        Byte chatmode = 1;
        if (chatlinkid <= 0L) {
            WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)curr.getId(), (Long)(-chatlinkid.longValue()));
            if (groupItem == null || groupItem.getChatlinkid() == null) {
                return Resp.fail((String)"\u4f1a\u8bddid\u4e3a\u7a7a");
            }
            chatlinkid = groupItem.getChatlinkid();
            chatmode = 2;
        }
        if ((ret = ChatMsgService.me.msgOper(curr, chatlinkid, oper, mids, chatmode)).isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        final Long sendChatLinkid = chatlinkid;
        final Byte sendMode = chatmode;
        final WxChatItems chatItems = (WxChatItems)RetUtils.getOkTData((Ret)ret, (String)"chatItems");
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Object msg = RetUtils.getOkTData((Ret)ret, (String)"msg");
                    switch (oper) {
                        case 1: {
                            WxChatApi.delMsg((HttpRequest)request, (User)curr, (Long)sendChatLinkid, (Byte)sendMode, (String)mids, (WxChatItems)chatItems);
                            break;
                        }
                        case 9: {
                            WxChatApi.backMsg((HttpRequest)request, (User)curr, (Long)sendChatLinkid, (Byte)sendMode, (Object)msg);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestPath(value="/msgForward")
    public Resp msgForward(HttpRequest request, Long chatlinkid, String mids, String groupids, String uids) throws Exception {
        Ret ret;
        if (chatlinkid == null) {
            return Resp.fail((String)"\u4f1a\u8bddid\u53c2\u6570\u4e3a\u7a7a");
        }
        User curr = WebUtils.currUser(request);
        Byte chatmode = 1;
        if (chatlinkid <= 0L) {
            WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)curr.getId(), (Long)(-chatlinkid.longValue()));
            if (groupItem == null || groupItem.getChatlinkid() == null) {
                return Resp.fail((String)"\u4f1a\u8bddid\u4e3a\u7a7a");
            }
            chatlinkid = groupItem.getChatlinkid();
            chatmode = 2;
        }
        if ((ret = WxChatApi.msgForward((HttpRequest)request, (User)curr, (Long)chatlinkid, (Byte)chatmode, (String)mids, (String)groupids, (String)uids)).isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestPath(value="/shareCard")
    public Resp shareCard(HttpRequest request, String cardid, String groupids, String uids, Byte chatmode) throws Exception {
        User curr = WebUtils.currUser(request);
        Ret ret = WxChatApi.sharChard((HttpRequest)request, (User)curr, (String)cardid, (Byte)chatmode, (String)groupids, (String)uids);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestPath(value="/checkGroupUser")
    public Resp checkGroupUser(HttpRequest request, Long groupid, String uid) throws Exception {
        WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)uid, (Long)groupid);
        if (!ChatService.groupChatLink((WxChatGroupItem)groupItem)) {
            return Resp.ok((Object)2).msg("\u4e0d\u662f\u7fa4\u6210\u5458");
        }
        return Resp.ok((Object)1);
    }

    @RequestPath(value="/createGroup")
    public Resp createGroup(final HttpRequest request, final WxGroup wxGroup, final String uidList) throws Exception {
        String name = "";
        if (StrUtil.isNotBlank((CharSequence)wxGroup.getName())) {
            name = wxGroup.getName();
            name = name.length() > 30 ? name.substring(0, 30) : name;
            wxGroup.setName(name);
            wxGroup.setAutoflag(Byte.valueOf((byte)2));
        }
        String[] uidArr = StrUtil.split((CharSequence)uidList, (CharSequence)",");
        final User curr = WebUtils.currUser(request);
        Ret imgRet = ChatController.getGroupImg(uidArr, curr, name);
        Img img = (Img)RetUtils.getOkTData((Ret)imgRet, (String)"img");
        final String nicks = (String)RetUtils.getOkTData((Ret)imgRet, (String)"nicks");
        if (StrUtil.isBlank((CharSequence)name)) {
            name = (String)RetUtils.getOkTData((Ret)imgRet, (String)"name");
            wxGroup.setName(name);
            wxGroup.setAutoflag(Byte.valueOf((byte)1));
        }
        wxGroup.setAvatar(img.getCoverurl());
        final Byte devicetype = WebUtils.getRequestExt(request).getDeviceType();
        String sessionid = request.getHttpSession().getId();
        String ip = request.getClientIp();
        short joinnum = uidArr != null ? (short)(uidArr.length + 1) : (short)1;
        wxGroup.setCreatetime(new Date());
        final Ret ret = groupService.createGroup(curr, wxGroup, nicks, devicetype, sessionid, ip, joinnum, WebUtils.getRequestExt(request).getAppVersion());
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    WxGroupMsg msg = (WxGroupMsg)RetUtils.getOkTData((Ret)ret, (String)"msg");
                    SysMsgVo sysMsgVo = (SysMsgVo)RetUtils.getOkTData((Ret)ret, (String)"sysmsgvo");
                    WxChatApi.creatGroupOwner((HttpRequest)request, (Byte)devicetype, (User)curr, (WxGroup)wxGroup, (WxGroupMsg)msg, (SysMsgVo)sysMsgVo);
                    WxChatApi.creatGroup((HttpRequest)request, (User)curr, (String)uidList, (String)nicks, (WxGroup)wxGroup, (WxGroupMsg)msg, (SysMsgVo)sysMsgVo);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String dayperiod = PeriodUtils.dateToPeriodByType((Date)wxGroup.getCreatetime(), (byte)1);
                    GroupStat groupStat = (GroupStat)GroupStat.dao.findFirst("select * from group_stat where dayperiod = ? and type = ?", new Object[]{dayperiod, (byte)1});
                    if (groupStat == null) {
                        groupStat = new GroupStat();
                        groupStat.setAddcount(Integer.valueOf(1));
                        groupStat.setDayperiod(dayperiod);
                        groupStat.setType(Byte.valueOf((byte)1));
                        groupStat.ignoreSave();
                    } else {
                        Db.use((String)"tio_site_stat").update("update group_stat set addcount = addcount + 1 where dayperiod = ? and type = ?", new Object[]{dayperiod, (byte)1});
                    }
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        return Resp.ok((Object)wxGroup);
    }

    private static org.tio.sitexxx.service.model.main.File innerUploadFile(User curr, UploadFile uploadFile, String sessionid) throws Exception {
        byte[] bs = uploadFile.getData();
        String filename = uploadFile.getName();
        String ext = FileUtil.extName((String)filename);
        String urlWithoutExt = UploadUtils.newFile("wx/upload/file", curr.getId(), uploadFile.getName());
        String url = urlWithoutExt + "." + ext;
        File file = new File(Const.RES_ROOT, url);
        FileUtil.writeBytes((byte[])bs, (File)file);
        org.tio.sitexxx.service.model.main.File dbFile = new org.tio.sitexxx.service.model.main.File();
        dbFile.setExt(ext);
        dbFile.setFilename(uploadFile.getName());
        dbFile.setSession(sessionid);
        dbFile.setSize(Long.valueOf(bs.length));
        dbFile.setUid(curr.getId());
        dbFile.setUrl(url);
        dbFile.save();
        return dbFile;
    }

    private Resp processUploadedVideo(HttpRequest request, UploadFile uploadFile) throws Exception {
        User curr = WebUtils.currUser(request);
        byte[] bs = uploadFile.getData();
        String filename = uploadFile.getName();
        String extName = FileUtil.extName((String)filename);
        Resp ret = null;
        if (curr == null) {
            ret = Resp.fail((String)"\u60a8\u5c1a\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6").code(Integer.valueOf(1001));
        }
        String uid = null;
        uid = curr != null ? curr.getId() : "1";
        String videoUrlWithoutExt = UploadUtils.newFile("wx/upload/video", uid, filename);
        String videoUrl = videoUrlWithoutExt + "." + extName;
        String videoFilePath = Const.RES_ROOT + videoUrl;
        FileUtil.writeBytes((byte[])bs, (String)videoFilePath);
        String coverExt = "jpg";
        String coverUrl = UploadUtils.newFile("wx/upload/video", uid, FileUtil.mainName((String)filename)) + "." + coverExt;
        String coverFilePath = Const.RES_ROOT + coverUrl;
        Video video = VideoUtils.processVideo(videoFilePath, coverFilePath, 400, coverExt);
        video.setUrl(videoUrl);
        video.setUid(uid);
        video.setComefrom(Byte.valueOf((byte)1));
        video.setCoverurl(coverUrl);
        video.setStatus(Byte.valueOf((byte)1));
        video.setTitle(filename);
        video.setFilename(filename);
        video.setSession(request.getHttpSession().getId());
        boolean f = VideoService.me.save(video);
        if (ret != null) {
            return ret;
        }
        if (f) {
            return Resp.ok((Object)video);
        }
        return Resp.fail().data((Object)video);
    }

    private Resp processUploadedAudio(HttpRequest request, UploadFile uploadFile) throws Exception {
        User curr = WebUtils.currUser(request);
        byte[] bs = uploadFile.getData();
        String filename = uploadFile.getName();
        String extName = FileUtil.extName((String)filename);
        Resp ret = null;
        if (curr == null) {
            ret = Resp.fail((String)"\u60a8\u5c1a\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6").code(Integer.valueOf(1001));
        }
        String uid = null;
        uid = curr != null ? curr.getId() : "1";
        String urlWithoutExt = UploadUtils.newFile("wx/upload/video", uid, filename);
        String url = urlWithoutExt + "." + extName;
        String filePath = Const.RES_ROOT + url;
        FileUtil.writeBytes((byte[])bs, (String)filePath);
        FFmpegFrameGrabber ff = new FFmpegFrameGrabber(filePath);
        ff.start();
        long millseconds = ff.getLengthInTime() / 1000L;
        double seconds = Math.ceil(new Double(millseconds) / 1000.0);
        ff.stop();
        Audio audio = new Audio();
        audio.setSeconds(Integer.valueOf((int)seconds));
        audio.setUid(uid);
        audio.setUrl(url);
        audio.setFilename(filename);
        audio.save();
        if (ret != null) {
            return ret;
        }
        return Resp.ok((Object)audio);
    }

    private Resp processUploadedImg(HttpRequest request, UploadFile uploadFile) throws Exception {
        User curr = WebUtils.currUser(request);
        byte[] imageBytes = uploadFile.getData();
        Resp ret = null;
        if (curr == null) {
            ret = Resp.fail((String)"\u60a8\u5c1a\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6").code(Integer.valueOf(1001));
        }
        String uid = null;
        uid = curr != null ? curr.getId() : "1";
        BufferedImage bi = ImgUtil.toImage((byte[])imageBytes);
        float scale = ImgUtils.calcScaleWithWidth(400, bi);
        Img img = ImgUtils.processImg("wx/upload/img", uid, uploadFile, scale);
        img.setComefrom(Byte.valueOf((byte)5));
        img.setStatus(Byte.valueOf((byte)1));
        img.setSession(request.getHttpSession().getId());
        boolean f = ImgService.me.save(img);
        if (ret != null) {
            return ret;
        }
        if (f) {
            return Resp.ok((Object)img);
        }
        return Resp.fail((String)"\u670d\u52a1\u5668\u5f02\u5e38");
    }

    private static Ret getGroupImg(String[] uidArr, User curr, String name) throws Exception {
        boolean createName;
        ArrayList<String> avatarList = new ArrayList<String>();
        avatarList.add(curr.getAvatar());
        boolean bl = createName = StrUtil.isBlank((CharSequence)name);
        if (createName) {
            name = curr.getNick();
        }
        String nicks = "";
        int c = 0;
        for (String uidStr : uidArr) {
            String newName;
            User user;
            if (!StrUtil.isNotBlank((CharSequence)uidStr) || Objects.equals(uidStr, curr.getId()) || (user = UserService.ME.getById(uidStr)) == null) continue;
            if (createName && (newName = name + "\u3001" + user.getNick()).length() < 30) {
                name = newName;
            }
            nicks = nicks + "\u3001" + user.getNick();
            if (c >= 8) continue;
            avatarList.add(user.getAvatar());
            ++c;
        }
        Img img = WxGroupAvatarUtil.generateGroupAvatar(avatarList, curr.getId());
        if (createName) {
            return Ret.ok().set((Object)"img", (Object)img).set((Object)"nicks", (Object)nicks.substring(1)).set((Object)"name", (Object)name);
        }
        return Ret.ok().set((Object)"img", (Object)img).set((Object)"nicks", (Object)nicks.substring(1));
    }

    private void auotUpdateGroupInfo(HttpRequest request, Byte devicetype, Long groupid, Byte nameUpdate, Short joinnum, User curr) throws Exception {
        String avatar;
        String oldName;
        String name;
        block19: {
            WxGroup group = groupService.getByGroupid(groupid);
            if (group == null) {
                log.error("\u7fa4\u81ea\u52a8\u4fee\u6539\u5934\u50cf\uff0c\u672c\u7fa4\u5df2\u89e3\u6563\uff1agroupid-{}", (Object)groupid);
                return;
            }
            boolean nameInit = false;
            name = "";
            oldName = group.getName();
            if (Objects.equals(group.getAutoflag(), (byte)1) && Objects.equals(nameUpdate, (byte)1)) {
                nameInit = true;
            }
            avatar = "";
            if (joinnum != null && (joinnum > 0 && group.getJoinnum() - joinnum < 9 || joinnum <= 0)) {
                ArrayList<String> avatarList = new ArrayList<String>();
                Ret ret = groupService.groupUserList(groupid, null, "");
                if (ret.isFail()) {
                    return;
                }
                Page page = (Page)RetUtils.getOkTPage((Ret)ret);
                if (page == null) {
                    log.error("\u83b7\u53d6\u7528\u6237\u5217\u8868\u4e3a\u7a7a");
                    return;
                }
                List groupUserList = page.getList();
                int avatarCount = 0;
                for (Record record : groupUserList) {
                    String newName;
                    if (avatarCount > 8) break;
                    String uid = record.getStr("uid");
                    User user = UserService.ME.getById(uid);
                    if (user != null) {
                        avatarList.add(user.getAvatar());
                        ++avatarCount;
                    }
                    if (!nameInit || (newName = name + "\u3001" + user.getNick()).length() >= 31) continue;
                    name = newName;
                }
                try {
                    Img img = WxGroupAvatarUtil.generateGroupAvatar(avatarList, ((Record)groupUserList.get(0)).getStr("uid"));
                    avatar = img.getCoverurl();
                    if (!avatar.equals(group.getAvatar())) {
                        groupService.modifyAvatar(groupid, avatar);
                        break block19;
                    }
                    avatar = "";
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            } else if (nameInit) {
                Ret ret = groupService.groupUserList(groupid, null, "");
                if (ret.isFail()) {
                    return;
                }
                Page page = (Page)RetUtils.getOkTPage((Ret)ret);
                if (page == null) {
                    log.error("\u83b7\u53d6\u7528\u6237\u5217\u8868\u4e3a\u7a7a");
                    return;
                }
                List groupUserList = page.getList();
                for (Record record : groupUserList) {
                    String uid = record.getStr("uid");
                    User user = UserService.ME.getById(uid);
                    String newName = name + "\u3001" + user.getNick();
                    if (newName.length() >= 31) continue;
                    name = newName;
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)name)) {
            name = name.substring(1);
        }
        if (StrUtil.isNotBlank((CharSequence)name) && !oldName.equals(name)) {
            groupService.modifyName(curr.getId(), groupid, name, true);
        } else {
            name = "";
        }
        if (StrUtil.isNotBlank((CharSequence)name) || StrUtil.isNotBlank((CharSequence)avatar)) {
            WxChatApi.autoUpdateGroupInfo((HttpRequest)request, (Byte)devicetype, (User)curr, (Long)groupid, (String)name, (String)avatar);
        }
    }
}

