/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.wx;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.UploadFile;
import org.tio.http.server.annotation.RequestPath;
import org.tio.jfinal.kit.Ret;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.chat.SysService;
import org.tio.sitexxx.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.service.vo.RequestExt;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.Json;
import org.tio.utils.resp.Resp;

@RequestPath(value="/sys")
public class SysController {
    private static Logger log = LoggerFactory.getLogger(SysController.class);

    @RequestPath(value="/version")
    public Resp version(HttpRequest request, String version) throws Exception {
        Ret ret;
        RequestExt requestExt = WebUtils.getRequestExt(request);
        byte deviceType = requestExt.getDeviceType();
        if (requestExt.isFromAppAndroid()) {
            deviceType = 1;
        } else if (requestExt.isFromAppIos()) {
            deviceType = 2;
        }
        if (StrUtil.isBlank((CharSequence)version)) {
            version = requestExt.getAppVersion();
        }
        if ((ret = SysService.me.checkVersion(Byte.valueOf(deviceType), version)).isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/errlog")
    public Resp updateAvatar(HttpRequest request, UploadFile uploadFile) throws Exception {
        String sessionid;
        if (uploadFile == null) {
            return Resp.fail((String)"\u4e0a\u4f20\u4fe1\u606f\u4e3a\u7a7a");
        }
        User curr = WebUtils.currUser(request);
        String uid = null;
        uid = curr != null ? curr.getId() : "-777";
        org.tio.sitexxx.service.model.main.File dbFile = SysController.innerUploadFile(uid, uploadFile, sessionid = request.getHttpSession().getId());
        if (dbFile != null) {
            log.error("app\u51fa\u73b0\u4e86\u672a\u77e5\u5f02\u5e38\uff0c\u5df2\u4fdd\u5b58\u8bb0\u5f55\uff0c\u4e0a\u4f20\u8bb0\u5f55\uff1a{}", (Object)Json.toJson((Object)dbFile));
        }
        return Resp.ok();
    }

    private static org.tio.sitexxx.service.model.main.File innerUploadFile(String uid, UploadFile uploadFile, String sessionid) throws Exception {
        byte[] bs = uploadFile.getData();
        String filename = uploadFile.getName();
        String ext = FileUtil.extName((String)filename);
        String resRootDir = Const.RES_ROOT;
        String path = "/app/log/err/" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHH") + "/" + uid;
        File dir = new File(resRootDir, path);
        FileUtil.mkdir((File)dir);
        String url = path + "/" + filename;
        File file = new File(resRootDir, url);
        FileUtil.writeBytes((byte[])bs, (File)file);
        org.tio.sitexxx.service.model.main.File dbFile = new org.tio.sitexxx.service.model.main.File();
        dbFile.setExt(ext);
        dbFile.setFilename(uploadFile.getName());
        dbFile.setSession(sessionid);
        dbFile.setSize(Long.valueOf(bs.length));
        dbFile.setUid(uid);
        dbFile.setUrl(url);
        dbFile.save();
        return dbFile;
    }
}

