/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.wx;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.UploadFile;
import org.tio.http.server.annotation.RequestPath;
import org.tio.http.server.mvc.Routes;
import org.tio.sitexxx.im.server.handler.wx.friend.WxFriendChatReqHandler;
import org.tio.sitexxx.im.server.handler.wx.group.WxGroupChatReqHandler;
import org.tio.sitexxx.service.model.main.Img;
import org.tio.sitexxx.service.model.main.Video;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.ImgService;
import org.tio.sitexxx.service.service.VideoService;
import org.tio.sitexxx.service.service.base.UserRoleService;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.service.wx.WxFriendService;
import org.tio.sitexxx.service.service.wx.WxGroupService;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.RequestExt;
import org.tio.sitexxx.web.server.controller.im.ImController;
import org.tio.sitexxx.web.server.utils.ImgUtils;
import org.tio.sitexxx.web.server.utils.UploadUtils;
import org.tio.sitexxx.web.server.utils.VideoUtils;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.utils.hutool.ZipUtil;
import org.tio.utils.json.Json;
import org.tio.utils.resp.Resp;

@RequestPath(value="/wx")
public class WxController {
    private static Logger log = LoggerFactory.getLogger(WxController.class);
    public static final String SUBDIR_VIDEO = "wx/upload/video";
    public static final String SUBDIR_IMG = "wx/upload/img";
    public static final String SUBDIR_GROUP_AVATAR = "wx/group/avatar";
    public static final String SUBDIR_FILE = "wx/upload/file";

    @RequestPath(value="/imserver")
    public Resp imserver(HttpRequest request) throws Exception {
        ImController imController = (ImController)Routes.getController(ImController.class);
        return imController.imserver(request);
    }

    private Resp processUploadedVideo(HttpRequest request, UploadFile uploadFile, Long groupid) throws Exception {
        User curr = WebUtils.currUser(request);
        byte[] bs = uploadFile.getData();
        String filename = uploadFile.getName();
        String extName = FileUtil.extName((String)filename);
        Resp ret = null;
        if (UserService.isSuper((User)curr) || UserRoleService.hasRole((User)curr, (Byte)6)) {
            // empty if block
        }
        if (curr == null) {
            ret = Resp.fail((String)"\u60a8\u5c1a\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6").code(Integer.valueOf(1001));
        }
        String uid = null;
        uid = curr != null ? curr.getId() : "1";
        String videoUrlWithoutExt = UploadUtils.newFile(SUBDIR_VIDEO, uid, filename);
        String videoUrl = videoUrlWithoutExt + "." + extName;
        String videoFilePath = Const.RES_ROOT + videoUrl;
        FileUtil.writeBytes((byte[])bs, (String)videoFilePath);
        String coverExt = "jpg";
        String coverUrl = UploadUtils.newFile(SUBDIR_VIDEO, uid, FileUtil.mainName((String)filename)) + "." + coverExt;
        String coverFilePath = Const.RES_ROOT + coverUrl;
        Video video = VideoUtils.processVideo(videoFilePath, coverFilePath, 400, coverExt);
        video.setUrl(videoUrl);
        video.setUid(uid);
        video.setComefrom(Byte.valueOf((byte)1));
        video.setCoverurl(coverUrl);
        video.setStatus(Byte.valueOf((byte)1));
        video.setTitle(filename);
        video.setFilename(filename);
        video.setSession(request.getHttpSession().getId());
        boolean f = VideoService.me.save(video);
        if (ret != null) {
            return ret;
        }
        if (f) {
            return Resp.ok((Object)video);
        }
        return Resp.fail().data((Object)video);
    }

    @RequestPath(value="/uploadvideo")
    public Resp uploadvideo(HttpRequest request, UploadFile uploadFile, Long groupid, String touid) throws Exception {
        try {
            Resp resp = this.processUploadedVideo(request, uploadFile, groupid);
            if (!resp.isOk()) {
                return resp;
            }
            Video video = (Video)resp.getData();
            String text = Json.toJson((Object)new Video[]{video});
            return WxController.sendVideo(request, text, groupid, touid);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return Resp.fail((String)"\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    private static Resp sendVideo(HttpRequest request, String text, Long groupid, String touid) throws Exception {
        String fromIp;
        String sessionid;
        Devicetype devicetype;
        boolean f;
        boolean f2;
        User curr = WebUtils.currUser(request);
        RequestExt requestExt = WebUtils.getRequestExt(request);
        if (groupid != null ? !(f2 = WxGroupChatReqHandler.groupChatAndLog((Devicetype)Devicetype.from((Byte)requestExt.getDeviceType()), (String)request.getHttpSession().getId(), (String)text, (String)curr.getId(), null, (String)request.getClientIp(), (long)groupid, (Byte)5, (byte)2)) : !(f = WxFriendChatReqHandler.p2pChatAndLog((Devicetype)(devicetype = Devicetype.from((Byte)WebUtils.getRequestExt(request).getDeviceType())), (String)(sessionid = request.getHttpSession().getId()), (String)(fromIp = request.getClientIp()), (String)text, (String)curr.getId(), (String)touid, (Byte)5, (byte)2))) {
            return Resp.fail((String)"\u53d1\u9001\u5931\u8d25");
        }
        return Resp.ok();
    }

    @RequestPath(value="/uploadfile")
    public Resp uploadfile(HttpRequest request, UploadFile uploadFile, Long groupid, String touid) throws Exception {
        try {
            String fromIp;
            String sessionid;
            Devicetype devicetype;
            boolean f;
            boolean f2;
            User curr = WebUtils.currUser(request);
            byte[] bs = uploadFile.getData();
            String filename = uploadFile.getName();
            String ext = FileUtil.extName((String)filename);
            String urlWithoutExt = UploadUtils.newFile(SUBDIR_FILE, curr.getId(), uploadFile.getName());
            String url = null;
            url = StrUtil.isNotBlank((CharSequence)ext) ? urlWithoutExt + "." + ext + ".zip" : urlWithoutExt + ".zip";
            byte[] zipbs = ZipUtil.gzip((byte[])bs);
            File file = new File(Const.RES_ROOT, url);
            FileUtil.writeBytes((byte[])zipbs, (File)file);
            org.tio.sitexxx.service.model.main.File dbFile = new org.tio.sitexxx.service.model.main.File();
            dbFile.setExt(ext);
            dbFile.setFilename(uploadFile.getName());
            dbFile.setSession(request.getHttpSession().getId());
            dbFile.setSize(Long.valueOf(zipbs.length));
            dbFile.setUid(curr.getId());
            dbFile.setUrl(url);
            dbFile.save();
            String text = Json.toJson((Object)new org.tio.sitexxx.service.model.main.File[]{dbFile});
            RequestExt requestExt = WebUtils.getRequestExt(request);
            if (groupid != null ? !(f2 = WxGroupChatReqHandler.groupChatAndLog((Devicetype)Devicetype.from((Byte)requestExt.getDeviceType()), (String)request.getHttpSession().getId(), (String)text, (String)curr.getId(), (Integer[])null, (String)request.getClientIp(), (long)groupid, (Byte)3, (byte)2)) : !(f = WxFriendChatReqHandler.p2pChatAndLog((Devicetype)(devicetype = Devicetype.from((Byte)WebUtils.getRequestExt(request).getDeviceType())), (String)(sessionid = request.getHttpSession().getId()), (String)(fromIp = request.getClientIp()), (String)text, (String)curr.getId(), (String)touid, (Byte)3, (byte)2))) {
                return Resp.fail((String)"\u53d1\u9001\u5931\u8d25");
            }
            return Resp.ok();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return Resp.fail((String)"\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    private Resp processUploadedImg(HttpRequest request, UploadFile uploadFile) throws Exception {
        User curr = WebUtils.currUser(request);
        byte[] imageBytes = uploadFile.getData();
        Resp ret = null;
        if (UserService.isSuper((User)curr) || UserRoleService.hasRole((User)curr, (Byte)6)) {
            // empty if block
        }
        if (curr == null) {
            ret = Resp.fail((String)"\u60a8\u5c1a\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6").code(Integer.valueOf(1001));
        }
        String uid = null;
        uid = curr != null ? curr.getId() : "1";
        BufferedImage bi = ImgUtil.toImage((byte[])imageBytes);
        float scale = ImgUtils.calcScaleWithWidth(400, bi);
        Img img = ImgUtils.processImg(SUBDIR_IMG, uid, uploadFile, scale);
        img.setComefrom(Byte.valueOf((byte)5));
        img.setStatus(Byte.valueOf((byte)1));
        img.setSession(request.getHttpSession().getId());
        boolean f = ImgService.me.save(img);
        if (ret != null) {
            return ret;
        }
        if (f) {
            return Resp.ok((Object)img);
        }
        return Resp.fail((String)"\u670d\u52a1\u5668\u5f02\u5e38");
    }

    @RequestPath(value="/uploadimg")
    public Resp uploadimg(HttpRequest request, UploadFile uploadFile, Long groupid, String touid) throws Exception {
        try {
            Resp resp = this.processUploadedImg(request, uploadFile);
            if (!resp.isOk()) {
                return resp;
            }
            Img img = (Img)resp.getData();
            String content = Json.toJson((Object)new Img[]{img});
            return WxController.sendImg(request, content, groupid, touid);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return Resp.fail((String)"\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    @RequestPath(value="/uploadimgs")
    public Resp uploadimgs(HttpRequest request, UploadFile[] uploadFiles, Long groupid, String touid) throws Exception {
        Img[] imgs = new Img[uploadFiles.length];
        int i = 0;
        for (UploadFile uploadFile : uploadFiles) {
            Resp resp = this.processUploadedImg(request, uploadFile);
            if (!resp.isOk()) {
                return resp;
            }
            Img img = (Img)resp.getData();
            imgs[i++] = img;
        }
        String content = Json.toJson((Object)imgs);
        return WxController.sendImg(request, content, groupid, touid);
    }

    private static Resp sendImg(HttpRequest request, String text, Long groupid, String touid) throws Exception {
        String fromIp;
        String sessionid;
        Devicetype devicetype;
        boolean f;
        boolean f2;
        User curr = WebUtils.currUser(request);
        RequestExt requestExt = WebUtils.getRequestExt(request);
        if (groupid != null ? !(f2 = WxGroupChatReqHandler.groupChatAndLog((Devicetype)Devicetype.from((Byte)requestExt.getDeviceType()), (String)request.getHttpSession().getId(), (String)text, (String)curr.getId(), (Integer[])null, (String)request.getClientIp(), (long)groupid, (Byte)6, (byte)2)) : !(f = WxFriendChatReqHandler.p2pChatAndLog((Devicetype)(devicetype = Devicetype.from((Byte)WebUtils.getRequestExt(request).getDeviceType())), (String)(sessionid = request.getHttpSession().getId()), (String)(fromIp = request.getClientIp()), (String)text, (String)curr.getId(), (String)touid, (Byte)6, (byte)2))) {
            return Resp.fail((String)"\u53d1\u9001\u5931\u8d25");
        }
        return Resp.ok();
    }

    @RequestPath(value="/recent")
    public Resp recent(HttpRequest request) {
        User curr = WebUtils.currUser(request);
        String curruid = curr.getId();
        List list = WxFriendService.me.getRecentMsg(curr);
        List list2 = WxGroupService.me.getRecentMsg(curruid);
        if (CollUtil.isEmpty((Collection)list2)) {
            return Resp.ok((Object)list);
        }
        if (CollUtil.isEmpty((Collection)list)) {
            return Resp.ok((Object)list2);
        }
        ArrayList listall = new ArrayList(list.size() + list2.size());
        listall.addAll(list2);
        listall.addAll(list);
        return Resp.ok(listall);
    }
}

