/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.wx;

import cn.hutool.core.util.EscapeUtil;
import cn.hutool.core.util.StrUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.annotation.RequestPath;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.sitexxx.im.server.handler.wx.WxChatApi;
import org.tio.sitexxx.im.server.handler.wx.WxSynApi;
import org.tio.sitexxx.service.model.main.IpInfo;
import org.tio.sitexxx.service.model.main.WxChatItems;
import org.tio.sitexxx.service.model.main.WxFriend;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.chat.ChatService;
import org.tio.sitexxx.service.service.chat.FriendService;
import org.tio.sitexxx.service.service.wx.WxFriendService;
import org.tio.sitexxx.service.utils.RetUtils;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.utils.json.Json;
import org.tio.utils.resp.Resp;

@RequestPath(value="/wx/friend")
public class WxFriendController {
    private static Logger log = LoggerFactory.getLogger(WxFriendController.class);

    @RequestPath(value="/friendInfo")
    public Resp friendInfo(HttpRequest request, String uid) throws Exception {
        User curr = WebUtils.currUser(request);
        WxFriend wxFriend = WxFriendService.me.getWxFriend(curr, uid);
        return Resp.ok((Object)wxFriend);
    }

    @RequestPath(value="/addFriendDirectly")
    public Resp addFriendDirectly(HttpRequest request, String uid, String remarkname) throws Exception {
        User curr = WebUtils.currUser(request);
        Resp resp = WxFriendService.me.addFriendDirectly(curr, uid, remarkname);
        if (resp.isOk()) {
            WxFriendController.clearFriendCache(request, curr, uid);
        }
        return resp;
    }

    public static void clearFriendCache(HttpRequest request, User curr, String frienduid) {
        String path = "/wx/friend/isFriend";
        Kv params = Kv.by((Object)"uid", (Object)frienduid);
        WebUtils.removeHttpcache(path, (Map<String, Object>)params, curr.getId());
        path = "/wx/friend/friendInfo";
        params = Kv.by((Object)"uid", (Object)frienduid);
        WebUtils.removeHttpcache(path, (Map<String, Object>)params, curr.getId());
    }

    @RequestPath(value="/delFriend")
    public Resp delFriend(HttpRequest request, String frienduid) throws Exception {
        IpInfo ipInfo;
        User curr = WebUtils.currUser(request);
        Resp resp = WxFriendService.me.delFriend(curr, frienduid, (ipInfo = IpInfoService.ME.save(request.getClientIp())).getId());
        if (resp.isOk()) {
            WxFriendController.clearFriendCache(request, curr, frienduid);
        }
        return resp;
    }

    @RequestPath(value="/modifyRemarkname")
    public Resp modifyRemarkname(HttpRequest request, String frienduid, String remarkname) {
        User curr = WebUtils.currUser(request);
        remarkname = StrUtil.isNotBlank((CharSequence)remarkname) ? EscapeUtil.escapeHtml4((CharSequence)remarkname) : "";
        Ret ret = FriendService.me.updateRemarkName(curr.getId(), frienduid, remarkname);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        Long fid = (Long)RetUtils.getOkTData((Ret)ret);
        if (WxSynApi.isSynVersion()) {
            WxSynApi.synFdRemarkName((String)curr.getId(), (Long)fid, (String)remarkname, (Long)((Long)RetUtils.getOkTData((Ret)ret, (String)"chatlinkid")));
        } else {
            WxFriend sendFreind = FriendService.me.getFriendInfo(fid);
            WxChatItems chatItems = ChatService.me.getChatItems((Long)RetUtils.getOkTData((Ret)ret, (String)"chatlinkid"));
            WxChatApi.autoUseSysChatNtf((String)curr.getId(), (Byte)33, (String)"\u597d\u53cb\u4fe1\u606f\u53d1\u751f\u53d8\u66f4", (String)Json.toJson((Object)sendFreind), (WxChatItems)chatItems);
        }
        return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestPath(value="/isFriend")
    public static Resp isFriend(HttpRequest request, String uid) throws Exception {
        User curr = WebUtils.currUser(request);
        boolean f = WxFriendService.me.isFriend(curr.getId(), uid);
        return Resp.ok((Object)f);
    }

    @RequestPath(value="/queryChatList")
    public static Resp queryChatList(HttpRequest request, String uid, Long startMid) {
        User curr = WebUtils.currUser(request);
        List list = WxFriendService.me.queryChatList(curr.getId(), uid, startMid);
        return Resp.ok((Object)list);
    }

    @RequestPath(value="/queryLastApply")
    public Resp queryLastApply(HttpRequest request) throws Exception {
        User curr = WebUtils.currUser(request);
        List list = WxFriendService.me.queryLastApply(curr);
        return Resp.ok((Object)list);
    }

    @RequestPath(value="/myFriends")
    public Resp myFriends(HttpRequest request, Integer pageNumber, String nick, Long groupid) throws Exception {
        User curr = WebUtils.currUser(request);
        Page page = WxFriendService.me.myFriends(curr, pageNumber, nick, groupid);
        return Resp.ok((Object)page);
    }

    @RequestPath(value="/myFriendsFilterGroup")
    public Resp myFriendsFilterGroup(HttpRequest request, Integer pageNumber, String nick, Long groupid) throws Exception {
        return this.myFriends(request, pageNumber, nick, groupid);
    }
}

