/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.controller.wx;

import cn.hutool.core.util.EscapeUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.UploadFile;
import org.tio.http.server.annotation.RequestPath;
import org.tio.http.server.mvc.Routes;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.bs.wx.WxLeaveGroupNtf;
import org.tio.sitexxx.im.server.TioSiteImServerStarter;
import org.tio.sitexxx.im.server.handler.wx.WxChatApi;
import org.tio.sitexxx.im.server.handler.wx.friend.WxFriendChatReqHandler;
import org.tio.sitexxx.im.server.handler.wx.group.WxGroupChatReqHandler;
import org.tio.sitexxx.service.model.main.Img;
import org.tio.sitexxx.service.model.main.WxGroup;
import org.tio.sitexxx.service.model.main.WxGroupUser;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.service.chat.GroupService;
import org.tio.sitexxx.service.service.wx.WxGroupService;
import org.tio.sitexxx.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.RequestExt;
import org.tio.sitexxx.service.vo.wx.SysMsgVo;
import org.tio.sitexxx.web.server.controller.base.ImgController;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.sitexxx.web.server.utils.WxGroupAvatarUtil;
import org.tio.utils.Threads;
import org.tio.utils.json.Json;
import org.tio.utils.resp.Resp;

@RequestPath(value="/wx/group")
public class WxGroupController {
    private static Logger log = LoggerFactory.getLogger(WxGroupController.class);

    @RequestPath(value="/modifyIntro")
    public Resp modifyIntro(HttpRequest request, Long groupid, String intro) {
        User curr = WebUtils.currUser(request);
        Resp resp = WxGroupService.me.modifyIntro(curr, groupid, intro);
        return resp;
    }

    @RequestPath(value="/modifyName")
    public Resp modifyName(final HttpRequest request, final Long groupid, String name) {
        final User curr = WebUtils.currUser(request);
        name = EscapeUtil.escapeHtml4((CharSequence)name);
        Ret ret = GroupService.me.modifyName(curr.getId(), groupid, name);
        if (ret.isFail()) {
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        final String sendName = name;
        Threads.getGroupExecutor().execute(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    Ret ret = WxChatApi.updateGroupInfo((HttpRequest)request, (User)curr, (Long)groupid, (String)sendName);
                    if (!ret.isFail()) return;
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        return Resp.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestPath(value="/modifyNotice")
    public Resp modifyNotice(final HttpRequest request, final Long groupid, String notice) {
        final User curr = WebUtils.currUser(request);
        Resp resp = WxGroupService.me.modifyNotice(curr, groupid, notice);
        if (StrUtil.isNotBlank((CharSequence)notice)) {
            final SysMsgVo sysMsgVo = new SysMsgVo(curr.getNick(), "%%% \u4fee\u6539\u4e86\u7fa4\u516c\u544a:###", notice, "updatenotice");
            Threads.getGroupExecutor().execute(new Runnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    try {
                        Ret ret = WxChatApi.sendGroupMsgEach((HttpRequest)request, (String)sysMsgVo.toText(), (Byte)1, (String)curr.getId(), (Long)groupid, null, (Byte)1, (SysMsgVo)sysMsgVo);
                        if (!ret.isFail()) return;
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                }
            });
        }
        return resp;
    }

    @RequestPath(value="/modifyJoinMode")
    public Resp modifyJoinMode(HttpRequest request, Long groupid, Byte mode) {
        String text = "";
        switch (mode) {
            case 1: {
                text = "\u5141\u8bb8\u7fa4\u6210\u5458\u9080\u8bf7\u5176\u4ed6\u4eba\u52a0\u5165";
                break;
            }
            case 2: {
                text = "\u4ec5\u7fa4\u4e3b\u53ef\u4ee5\u9080\u8bf7";
                break;
            }
            default: {
                return Resp.fail().msg("\u65e0\u6548\u5165\u7fa4\u65b9\u5f0f");
            }
        }
        User curr = WebUtils.currUser(request);
        Resp resp = WxGroupService.me.modifyJoinMode(curr, groupid, mode);
        return resp;
    }

    @RequestPath(value="/inGroup")
    public Resp inGroup(HttpRequest request, Long groupid) {
        User curr = WebUtils.currUser(request);
        WxGroupUser wxGroupUser = WxGroupService.me.getWxGroupUser(curr.getId(), groupid.longValue());
        if (wxGroupUser != null && Objects.equals(wxGroupUser.getStatus(), (byte)1)) {
            return Resp.ok((Object)true);
        }
        return Resp.ok((Object)false);
    }

    @RequestPath(value="/leave")
    public Resp leave(HttpRequest request, Long groupid) {
        User curr = WebUtils.currUser(request);
        Resp resp = WxGroupService.me.leave(curr, groupid);
        if (resp.isOk()) {
            WxGroupController.clearGroupInfoCache(request, groupid);
            WxGroupController.clearGroupMemberCache(request, groupid);
            WxLeaveGroupNtf wxLeaveGroupNtf = new WxLeaveGroupNtf(groupid, Byte.valueOf((byte)1));
            ImPacket imPacket = new ImPacket(Command.WxLeaveGroupNtf, (Object)wxLeaveGroupNtf);
            Tio.sendToUser((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)(curr.getId() + ""), (Packet)imPacket);
        }
        return resp;
    }

    @RequestPath(value="/del")
    public Resp del(HttpRequest request, Long groupid) {
        User curr = WebUtils.currUser(request);
        Resp resp = WxGroupService.me.del(curr, groupid);
        if (resp.isOk()) {
            WxGroupController.clearGroupInfoCache(request, groupid);
            WxGroupController.clearGroupMemberCache(request, groupid);
            WxLeaveGroupNtf wxLeaveGroupNtf = new WxLeaveGroupNtf(groupid, Byte.valueOf((byte)3));
            ImPacket imPacket = new ImPacket(Command.WxLeaveGroupNtf, (Object)wxLeaveGroupNtf);
            Tio.sendToGroup((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)(groupid + ""), (Packet)imPacket);
        }
        return resp;
    }

    @RequestPath(value="/delMember")
    public Resp delMember(HttpRequest request, Long groupid, String[] uids) {
        User curr = WebUtils.currUser(request);
        Resp resp = WxGroupService.me.delMember(curr, groupid, uids);
        if (resp.isOk()) {
            WxGroupController.clearGroupInfoCache(request, groupid);
            WxGroupController.clearGroupMemberCache(request, groupid);
            for (String uid : uids) {
                try {
                    WxLeaveGroupNtf wxLeaveGroupNtf = new WxLeaveGroupNtf(groupid, Byte.valueOf((byte)2));
                    ImPacket imPacket = new ImPacket(Command.WxLeaveGroupNtf, (Object)wxLeaveGroupNtf);
                    Tio.sendToUser((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)(uid + ""), (Packet)imPacket);
                    Tio.unbindGroup((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)(uid + ""), (String)(groupid + ""));
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        return resp;
    }

    @RequestPath(value="/agreeInvite")
    public Resp agreeInvite(HttpRequest request, Long groupid) {
        User curr = WebUtils.currUser(request);
        Resp resp = WxGroupService.me.agreeInvite(curr, groupid);
        if (resp.isOk()) {
            WxGroupController.clearGroupInfoCache(request, groupid);
            WxGroupController.clearGroupMemberCache(request, groupid);
            Tio.bindGroup((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)(curr.getId() + ""), (String)(groupid + ""));
            RequestExt requestExt = WebUtils.getRequestExt(request);
            String text = curr.getNick() + " \u52a0\u5165\u7fa4\u804a";
            WxGroupChatReqHandler.groupChatAndLog((Devicetype)Devicetype.from((Byte)requestExt.getDeviceType()), (String)request.getHttpSession().getId(), (String)text, (String)curr.getId(), null, (String)request.getClientIp(), (long)groupid, (Byte)1, (byte)1);
        }
        return resp;
    }

    @RequestPath(value="/directInvite")
    public Resp directInvite(HttpRequest request, Long groupid, String[] uids) {
        User curr = WebUtils.currUser(request);
        Resp resp = WxGroupService.me.directInvite(curr, groupid, uids);
        if (resp.isOk()) {
            int invite = (Integer)resp.getData();
            new Thread(() -> {
                int count = WxGroupService.me.count(groupid);
                if (count - invite < 9) {
                    ArrayList<String> avatarList = new ArrayList<String>();
                    List groupUserList = WxGroupService.me.groupUserOrder(groupid, Integer.valueOf(15));
                    int avatarCount = 0;
                    for (Record record : groupUserList) {
                        if (avatarCount > 8) break;
                        String uid = record.getStr("uid");
                        User user = UserService.ME.getById(uid);
                        if (user == null) continue;
                        avatarList.add(user.getAvatar());
                        ++avatarCount;
                    }
                    try {
                        Img img = WxGroupAvatarUtil.generateGroupAvatar(avatarList, ((Record)groupUserList.get(0)).getStr("uid"));
                        WxGroupService.me.modifyGroupAvatar(groupid, img.getCoverurl());
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                }
            }).start();
            WxGroupController.clearGroupInfoCache(request, groupid);
            WxGroupController.clearGroupMemberCache(request, groupid);
            String nicks = "";
            int spiltLength = 0;
            boolean isAll = true;
            for (String uid : uids) {
                Tio.bindGroup((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)(uid + ""), (String)(groupid + ""));
                User user = UserService.ME.getById(uid);
                if (spiltLength < 50) {
                    if (user == null) continue;
                    nicks = nicks + "," + user.getNick();
                    ++spiltLength;
                    continue;
                }
                if (!isAll || user == null) continue;
                isAll = false;
            }
            RequestExt requestExt = WebUtils.getRequestExt(request);
            String text = nicks.substring(1) + (isAll ? "" : " \u7b49\u4eba") + " \u52a0\u5165\u7fa4\u804a";
            WxGroupChatReqHandler.groupChatAndLog((Devicetype)Devicetype.from((Byte)requestExt.getDeviceType()), (String)request.getHttpSession().getId(), (String)text, (String)curr.getId(), null, (String)request.getClientIp(), (long)groupid, (Byte)1, (byte)1);
        }
        return resp;
    }

    @RequestPath(value="/invite")
    public Resp invite(HttpRequest request, Long groupid, String[] uids) throws Exception {
        User curr = WebUtils.currUser(request);
        Resp resp = WxGroupService.me.invite(curr, groupid, uids);
        if (resp.isOk()) {
            Devicetype devicetype = Devicetype.from((Byte)WebUtils.getRequestExt(request).getDeviceType());
            String sessionid = request.getHttpSession().getId();
            String fromIp = request.getClientIp();
            Kv kv = Kv.by((Object)"groupid", (Object)groupid);
            kv.set((Object)"uid", (Object)curr.getId());
            String text = Json.toJson((Object)kv);
            for (String touid : uids) {
                WxFriendChatReqHandler.p2pChatAndLog((Devicetype)devicetype, (String)sessionid, (String)fromIp, (String)text, (String)curr.getId(), (String)touid, (Byte)8, (byte)2);
            }
        }
        return resp;
    }

    @RequestPath(value="/changeOwner")
    public Resp changeOwner(HttpRequest request, Long groupid, String otherUid) throws Exception {
        User curr = WebUtils.currUser(request);
        User user = UserService.ME.getById(otherUid);
        if (user == null) {
            return Resp.fail().msg("\u65e0\u6548\u8f6c\u8ba9\u7528\u6237");
        }
        Resp resp = WxGroupService.me.changeOwner(curr.getId(), user.getId(), groupid);
        if (resp.isOk()) {
            WxGroupController.clearGroupInfoCache(request, groupid);
            WxGroupController.clearGroupMemberCache(request, groupid);
            RequestExt requestExt = WebUtils.getRequestExt(request);
            String text = user.getNick() + "\u5df2\u6210\u4e3a\u7fa4\u4e3b";
            WxGroupChatReqHandler.groupChatAndLog((Devicetype)Devicetype.from((Byte)requestExt.getDeviceType()), (String)request.getHttpSession().getId(), (String)text, (String)curr.getId(), null, (String)request.getClientIp(), (long)groupid, (Byte)1, (byte)1);
        }
        return resp;
    }

    @RequestPath(value="/queryChatList")
    public Resp queryChatList(HttpRequest request, Long groupid, Long startMid) throws Exception {
        User curr = WebUtils.currUser(request);
        List page = WxGroupService.me.queryChatList(groupid, curr.getId(), startMid);
        return Resp.ok((Object)page);
    }

    @RequestPath(value="/member")
    public Resp member(HttpRequest request, Long groupid, String nick, Integer pageNumber) throws Exception {
        Page page = WxGroupService.me.member(groupid, nick, pageNumber);
        return Resp.ok((Object)page);
    }

    @RequestPath(value="/info")
    public Resp info(HttpRequest request, Long groupid) throws Exception {
        Record record = WxGroupService.me.info(groupid);
        return Resp.ok((Object)record);
    }

    public static void clearGroupInfoCache(HttpRequest request, Long groupid) {
        User curr = WebUtils.currUser(request);
        Kv kv = Kv.by((Object)"groupid", (Object)groupid);
        WebUtils.removeHttpcache("/wx/group/info", (Map<String, Object>)kv, curr.getId());
    }

    public static void clearGroupMemberCache(HttpRequest request, Long groupid) {
        User curr = WebUtils.currUser(request);
        Kv kv = Kv.by((Object)"groupid", (Object)groupid);
        WebUtils.removeHttpcache("/wx/group/member", (Map<String, Object>)kv, curr.getId());
    }

    @RequestPath(value="/createGroup")
    public Resp createGroup(HttpRequest request, WxGroup wxGroup, UploadFile uploadFile, String uidList) throws Exception {
        String name;
        if (StrUtil.isBlank((CharSequence)wxGroup.getName())) {
            return Resp.fail((String)"\u7fa4\u540d\u5b57\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)wxGroup.getAvatar())) {
            if (uploadFile == null) {
                // empty if block
            }
        } else {
            if (StrUtil.isBlank((CharSequence)wxGroup.getIntro())) {
                return Resp.fail((String)"\u7fa4\u7b80\u4ecb\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (wxGroup.getJoinmode() == null) {
                return Resp.fail((String)"\u8fdb\u7fa4\u6a21\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (wxGroup.getJoinmode() > 3 || wxGroup.getJoinmode() < 1) {
                return Resp.fail((String)"\u8fdb\u7fa4\u6a21\u5f0f\u975e\u6cd5");
            }
        }
        name = (name = wxGroup.getName()).length() > 30 ? name.substring(0, 30) : name;
        wxGroup.setName(name);
        String[] uidArr = StrUtil.split((CharSequence)uidList, (CharSequence)",");
        Img img = null;
        User curr = WebUtils.currUser(request);
        if (uploadFile != null) {
            ImgController imgController = (ImgController)Routes.getController(ImgController.class);
            Resp ret = imgController.uploadImg(request, uploadFile, "wx/group/avatar", 512, 128);
            img = (Img)ret.getData();
        } else {
            ArrayList<String> avatarList = new ArrayList<String>();
            avatarList.add(curr.getAvatar());
            int c = 0;
            for (String uidStr : uidArr) {
                User user;
                if (c >= 8) break;
                if (!StrUtil.isNotBlank((CharSequence)uidStr) || StringUtils.equals((CharSequence)uidStr, (CharSequence)curr.getId()) || (user = UserService.ME.getById(uidStr)) == null) continue;
                avatarList.add(user.getAvatar());
                ++c;
            }
            img = WxGroupAvatarUtil.generateGroupAvatar(avatarList, curr.getId());
        }
        wxGroup.setAvatar(img.getCoverurl());
        Resp resp = WxGroupService.me.createGroup(curr, wxGroup, uidList);
        if (resp.isOk()) {
            WxGroupController.clearGroupInfoCache(request, wxGroup.getId());
            String groupid = wxGroup.getId().toString();
            Tio.bindGroup((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)curr.getId().toString(), (String)groupid);
            String nickStrs = curr.getNick();
            if (uidArr != null) {
                for (String uidStr : uidArr) {
                    if (!StrUtil.isNotBlank((CharSequence)uidStr) || StringUtils.equals((CharSequence)uidStr, (CharSequence)curr.getId())) continue;
                    User user = UserService.ME.getById(uidStr);
                    if (user != null) {
                        nickStrs = nickStrs + "," + user.getNick();
                    }
                    Tio.bindGroup((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)uidStr, (String)groupid);
                }
                RequestExt requestExt = WebUtils.getRequestExt(request);
                String text = nickStrs + "\u52a0\u5165\u7fa4\u804a";
                WxGroupChatReqHandler.groupChatAndLog((Devicetype)Devicetype.from((Byte)requestExt.getDeviceType()), (String)request.getHttpSession().getId(), (String)text, (String)curr.getId(), null, (String)request.getClientIp(), (long)wxGroup.getId(), (Byte)1, (byte)1);
            }
        }
        return resp;
    }

    @RequestPath(value="/uploadAvatar")
    public Resp uploadAvatar(HttpRequest request, UploadFile uploadFile) throws Exception {
        ImgController imgController = (ImgController)Routes.getController(ImgController.class);
        return imgController.uploadImg(request, uploadFile, "wx/group/avatar", 512, 128);
    }

    @RequestPath(value="/list")
    public Resp list(HttpRequest request, String groupname) throws Exception {
        User curr = WebUtils.currUser(request);
        List ret = WxGroupService.me.list(curr, groupname);
        return Resp.ok((Object)ret);
    }

    @RequestPath(value="/querylist")
    public Resp querylist(HttpRequest request, String groupname) throws Exception {
        User curr = WebUtils.currUser(request);
        List ret = WxGroupService.me.queryList(curr, groupname);
        return Resp.ok((Object)ret);
    }
}

