/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.http;

import cn.hutool.core.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.session.limiter.SessionRateLimiter;
import org.tio.http.common.session.limiter.SessionRateVo;
import org.tio.sitexxx.service.service.conf.IpWhiteListService;
import org.tio.utils.SystemTimer;
import org.tio.utils.json.Json;
import org.tio.utils.resp.Resp;

public class WebApiSessionRateLimiter
implements SessionRateLimiter {
    private static Logger log = LoggerFactory.getLogger(WebApiSessionRateLimiter.class);
    public static final WebApiSessionRateLimiter me = new WebApiSessionRateLimiter();
    private final Map<String, Integer> intervalMap = new HashMap<String, Integer>();
    private final Map<String, Integer> prefixMap = new HashMap<String, Integer>();
    private final Map<String, Integer> allowCountMap = new HashMap<String, Integer>();
    private HttpResponse response;

    private WebApiSessionRateLimiter() {
        this.prefixMap.put("/product/download/", 120000);
        this.intervalMap.put("/recharge", 1000);
        this.intervalMap.put("/logout", 2000);
        this.intervalMap.put("/register/submit", 5000);
        this.intervalMap.put("/register/retrievePwd", 5000);
        this.intervalMap.put("/register/setNewPwd", 5000);
        this.intervalMap.put("/blog/uploadimg", 3000);
        this.intervalMap.put("/blog/save", 3000);
        this.intervalMap.put("/blog/collect", 1000);
        this.intervalMap.put("/blog/star", 1000);
        this.intervalMap.put("/blog/comment", 5000);
        this.intervalMap.put("/case/save", 5000);
        this.intervalMap.put("/im/uploadimg", 4000);
        this.intervalMap.put("/im/uploadimgs", 4000);
        this.intervalMap.put("/wx/friend/applyFriend", 4000);
        this.intervalMap.put("/chat/createGroup", 3000);
        this.allowCountMap.put("/login", 12);
        this.allowCountMap.put("/im/uploadimg", 10);
        this.allowCountMap.put("/im/uploadimgs", 10);
        this.allowCountMap.put("/im/uploadvideo", 4);
        this.allowCountMap.put("/blog/uploadimg", 10);
        this.allowCountMap.put("/blog/pageMyCollect", 20);
        this.allowCountMap.put("/blog/pageMyLatest", 20);
        this.allowCountMap.put("/user/search", 30);
        this.allowCountMap.put("/im/queryMyFriends", 15);
        this.allowCountMap.put("/im/queryAddMeAsFriends", 15);
        this.allowCountMap.put("/stat/ip", 15);
        this.allowCountMap.put("/wx/friend/replyApplyFriend", 60);
        this.allowCountMap.put("/chat/list", 60);
        this.response = new HttpResponse();
        try {
            this.response.setBody(Json.toJson((Object)Resp.fail((String)"\u64cd\u4f5c\u8fc7\u5feb\uff0c\u8bf7\u7a0d\u540e\u518d\u64cd\u4f5c").code(Integer.valueOf(1005))).getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
        }
        this.response.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.TEXT_PLAIN_JSON);
    }

    public boolean allow(HttpRequest request, SessionRateVo sessionRateVo) {
        if (IpWhiteListService.isWhiteIp((String)request.getClientIp())) {
            return true;
        }
        String path = request.getRequestLine().getPath();
        Integer allowCount = this.allowCountMap.get(path);
        if (allowCount == null) {
            allowCount = 120;
        }
        if (sessionRateVo.getAccessCount().get() > allowCount) {
            return false;
        }
        Integer iv = this.intervalMap.get(path);
        if (iv == null && this.prefixMap.size() > 0) {
            Set<Map.Entry<String, Integer>> set = this.prefixMap.entrySet();
            for (Map.Entry<String, Integer> entry : set) {
                if (!StrUtil.startWith((CharSequence)path, (CharSequence)entry.getKey())) continue;
                iv = entry.getValue();
                break;
            }
        }
        return iv == null || SystemTimer.currTime - sessionRateVo.getLastAccessTime() >= (long)iv.intValue();
    }

    public HttpResponse response(HttpRequest request, SessionRateVo sessionRateVo) {
        return this.response;
    }
}

