/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.http.stat.ip;

import cn.hutool.core.io.FileUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.TioConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.handler.DefaultHttpRequestHandler;
import org.tio.http.server.stat.ip.path.IpAccessStat;
import org.tio.http.server.stat.ip.path.IpPathAccessStat;
import org.tio.http.server.stat.ip.path.IpPathAccessStatListener;
import org.tio.sitexxx.service.model.stat.TioIpPathAccessStat;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.base.TioIpPathAccessStatService;
import org.tio.sitexxx.service.service.conf.ConfService;
import org.tio.sitexxx.service.service.conf.IpWhiteListService;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.web.server.http.WebApiHttpSessionListener;
import org.tio.sitexxx.web.server.utils.TioIpPullblackUtils;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.Json;
import org.tio.utils.lock.MapWithLock;

public class TioSiteIpPathAccessStatListener
implements IpPathAccessStatListener {
    private static Logger log = LoggerFactory.getLogger(TioSiteIpPathAccessStatListener.class);
    public static final TioSiteIpPathAccessStatListener ME_SITE_VIEW = new TioSiteIpPathAccessStatListener(9);
    public static final TioSiteIpPathAccessStatListener ME_SITE_API = new TioSiteIpPathAccessStatListener(8);
    private byte appType = (byte)9;
    private static Set<String> skipExtSet = new HashSet<String>();
    private static final String CONF_PREFIX = "ip.access.";
    private static final int STEP;
    private static final int MAX_NO_SESSION_COUNT;
    private static final int MAX_SESSION_COUNT;
    private static final int G1_MAX_COUNT;
    private static final int G1_MAX_PER_SECOND;
    private static final int G2_MAX_COUNT;
    private static final int G2_MAX_PER_SECOND;

    public TioSiteIpPathAccessStatListener(byte appType) {
        this.appType = appType;
    }

    public TioIpPathAccessStat toDbObj(IpAccessStat ipAccessStat) {
        TioIpPathAccessStat ret = new TioIpPathAccessStat();
        int requestCount = ipAccessStat.count.get();
        long timeCost = ipAccessStat.timeCost.get();
        long duration = ipAccessStat.getDuration();
        ret.setAppType(Byte.valueOf(this.appType));
        ret.setRequestCount(Integer.valueOf(requestCount));
        ret.setTimeCost(Long.valueOf(timeCost));
        ret.setTimeCostPerRequest(Double.valueOf((double)timeCost / (double)requestCount));
        ret.setDuration(Long.valueOf(duration));
        ret.setDurationType(ipAccessStat.getDurationType());
        ret.setFirstAccessTime(new Date(ipAccessStat.getFirstAccessTime()));
        ret.setFormatedDuration(ipAccessStat.getFormatedDuration());
        ret.setIp(ipAccessStat.getIp());
        ret.setIpid(IpInfoService.ME.save(ipAccessStat.getIp()).getId());
        ret.setNoSessionCount(Integer.valueOf(ipAccessStat.noSessionCount.get()));
        ret.setPath(null);
        ret.setRequestCountPerSecond(Double.valueOf(ipAccessStat.getPerSecond()));
        ret.setServer(Const.MY_IP);
        return ret;
    }

    public TioIpPathAccessStat toDbObj(IpPathAccessStat ipPathAccessStat) {
        TioIpPathAccessStat ret = new TioIpPathAccessStat();
        int requestCount = ipPathAccessStat.count.get();
        long timeCost = ipPathAccessStat.timeCost.get();
        long duration = ipPathAccessStat.getDuration();
        ret.setAppType(Byte.valueOf(this.appType));
        ret.setRequestCount(Integer.valueOf(requestCount));
        ret.setTimeCost(Long.valueOf(timeCost));
        ret.setTimeCostPerRequest(Double.valueOf((double)timeCost / (double)requestCount));
        ret.setDuration(Long.valueOf(duration));
        ret.setDurationType(ipPathAccessStat.getDurationType());
        ret.setFirstAccessTime(new Date(ipPathAccessStat.getFirstAccessTime()));
        ret.setFormatedDuration(ipPathAccessStat.getFormatedDuration());
        ret.setIp(ipPathAccessStat.getIp());
        ret.setIpid(IpInfoService.ME.save(ipPathAccessStat.getIp()).getId());
        ret.setNoSessionCount(Integer.valueOf(ipPathAccessStat.noSessionCount.get()));
        ret.setPath(ipPathAccessStat.getPath());
        if (Objects.equals(this.appType, (byte)8)) {
            ret.setRestype("api");
        } else {
            String ext = FileUtil.extName((String)ipPathAccessStat.getPath());
            if (StrUtil.isNotBlank((CharSequence)ext) && ext.length() <= 16) {
                ret.setRestype(ext);
            }
        }
        ret.setRequestCountPerSecond(Double.valueOf(ipPathAccessStat.getPerSecond()));
        ret.setServer(Const.MY_IP);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExpired(TioConfig tioConfig, String ip, IpAccessStat ipAccessStat) {
        if (Objects.equals(ipAccessStat.getDurationType(), Const.IpPathAccessStatDuration.DURATION_2)) {
            TioIpPathAccessStat tioIpAccessStat = this.toDbObj(ipAccessStat);
            TioIpPathAccessStatService.ME.save(tioIpAccessStat);
            MapWithLock ipPathAccessStatMap = ipAccessStat.getIpPathAccessStatMap();
            if (ipPathAccessStatMap != null) {
                ReentrantReadWriteLock.ReadLock readLock = ipPathAccessStatMap.readLock();
                readLock.lock();
                try {
                    Set set;
                    Map map = (Map)ipPathAccessStatMap.getObj();
                    if (map != null && (set = map.entrySet()).size() > 0) {
                        ArrayList<TioIpPathAccessStat> modelList = new ArrayList<TioIpPathAccessStat>();
                        for (Map.Entry entry : set) {
                            TioIpPathAccessStat tioIpPathAccessStat = null;
                            try {
                                IpPathAccessStat ipPathAccessStat = (IpPathAccessStat)entry.getValue();
                                String path = ipPathAccessStat.getPath();
                                String ext = FileUtil.extName((String)path);
                                if (skipExtSet.contains(ext)) continue;
                                if (StrUtil.isNotBlank((CharSequence)path) && path.length() >= 300) {
                                    log.error("ip-path-access-stat\u7edf\u8ba1path\u957f\u5ea6\u5f02\u5e38\uff1apath\u957f\u5ea6\uff1a{}\uff0cpath:{}", (Object)path.length(), (Object)path);
                                    continue;
                                }
                                tioIpPathAccessStat = this.toDbObj(ipPathAccessStat);
                                modelList.add(tioIpPathAccessStat);
                            }
                            catch (Exception e) {
                                log.error(Json.toFormatedJson(tioIpPathAccessStat), (Throwable)e);
                            }
                        }
                        TioIpPathAccessStatService.ME.batchSave(modelList);
                    }
                }
                catch (Throwable e) {
                    log.error("", e);
                }
                finally {
                    readLock.unlock();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("ip:{}, \r\nipAccessStat:{} ", (Object)ip, (Object)Json.toFormatedJson((Object)ipAccessStat));
            }
        }
    }

    public boolean onChanged(HttpRequest httpRequest, String ip, String path, IpAccessStat ipAccessStat, IpPathAccessStat ipPathAccessStat) {
        boolean isOk;
        if (IpWhiteListService.isWhiteIp((String)ip)) {
            return true;
        }
        int allcount = ipAccessStat.count.get();
        if (allcount % STEP != 0) {
            return true;
        }
        log.debug("ip:{}, path:{}", (Object)ip, (Object)path);
        double preSecond = ipAccessStat.getPerSecond();
        int noSessionCount = ipAccessStat.noSessionCount.get();
        String remark = null;
        if (noSessionCount > MAX_NO_SESSION_COUNT) {
            remark = "\u4e0d\u5e26cookie\u7684\u8bf7\u6c42\u6b21\u6570\u8fbe\u5230\u4e0a\u9650[" + MAX_NO_SESSION_COUNT + "]";
            this.pullBlack(httpRequest, ipAccessStat, ipPathAccessStat, remark);
            return false;
        }
        if (ipAccessStat.sessionIds.size() > MAX_SESSION_COUNT) {
            remark = "ip\u8bbf\u95ee\u8fdd\u53cd\u6761\u4ef6\uff1a\u4e0d\u540csessionid\u7684\u6570\u91cf\u8fbe\u5230\u4e0a\u9650[" + MAX_SESSION_COUNT + "]";
            this.pullBlack(httpRequest, ipAccessStat, ipPathAccessStat, remark);
            return false;
        }
        boolean g1 = false;
        boolean g2 = false;
        boolean g1_c1 = allcount > G1_MAX_COUNT;
        boolean g1_c2 = preSecond > (double)G1_MAX_PER_SECOND;
        boolean bl = g1 = g1_c1 && g1_c2;
        if (g1) {
            remark = "ip\u8bbf\u95ee\u8fdd\u53cd\u6761\u4ef6\u7ec41\uff1a\u603b\u8bbf\u95ee\u6b21\u6570" + allcount + "(> " + G1_MAX_COUNT + "), \u5e73\u5747\u6bcf\u79d2\u8bbf\u95ee" + preSecond + "\u6b21 (>" + G1_MAX_PER_SECOND + ")";
            this.pullBlack(httpRequest, ipAccessStat, ipPathAccessStat, remark);
            return false;
        }
        boolean g2_c1 = allcount > G2_MAX_COUNT;
        boolean g2_c2 = preSecond > (double)G2_MAX_PER_SECOND;
        boolean bl2 = g2 = g2_c1 && g2_c2;
        if (g2) {
            remark = "ip\u8bbf\u95ee\u8fdd\u53cd\u6761\u4ef6\u7ec42\uff1a\u603b\u8bbf\u95ee\u6b21\u6570" + allcount + "(> " + G2_MAX_COUNT + "), \u5e73\u5747\u6bcf\u79d2\u8bbf\u95ee" + preSecond + "\u6b21 (>" + G2_MAX_PER_SECOND + ")";
            this.pullBlack(httpRequest, ipAccessStat, ipPathAccessStat, remark);
            return false;
        }
        String sessionId = DefaultHttpRequestHandler.getSessionId((HttpRequest)httpRequest);
        if (!StrUtil.isNotBlank((CharSequence)sessionId) || !(isOk = WebApiHttpSessionListener.isValidSessionId(sessionId))) {
            // empty if block
        }
        return true;
    }

    public void pullBlack(HttpRequest request, IpAccessStat ipAccessStat, IpPathAccessStat ipPathAccessStat, String remark) {
        TioIpPathAccessStat tioIpAccessStat = this.toDbObj(ipAccessStat);
        TioIpPathAccessStatService.ME.save(tioIpAccessStat);
        TioIpPullblackUtils.addToBlack(request, request.getClientIp(), remark, (byte)1);
        request.close();
    }

    public static void main(String[] args) {
        System.out.println(3);
        System.out.println(0);
    }

    static {
        skipExtSet.add("css");
        skipExtSet.add("js");
        skipExtSet.add("ico");
        skipExtSet.add("png");
        skipExtSet.add("jpg");
        skipExtSet.add("swf");
        skipExtSet.add("xml");
        skipExtSet.add("gif");
        skipExtSet.add("jpeg");
        skipExtSet.add("woff");
        skipExtSet.add("map");
        skipExtSet.add("txt");
        skipExtSet.add("mp4");
        skipExtSet.add("m3u8");
        skipExtSet.add("svg");
        STEP = ConfService.getInt((String)"ip.access.STEP", (Integer)200);
        MAX_NO_SESSION_COUNT = ConfService.getInt((String)"ip.access.MAX_NO_SESSION_COUNT", (Integer)1000);
        MAX_SESSION_COUNT = ConfService.getInt((String)"ip.access.MAX_SESSION_COUNT", (Integer)1000);
        G1_MAX_COUNT = ConfService.getInt((String)"ip.access.G1_MAX_COUNT", (Integer)3000);
        G1_MAX_PER_SECOND = ConfService.getInt((String)"ip.access.G1_MAX_PER_SECOND", (Integer)5);
        G2_MAX_COUNT = ConfService.getInt((String)"ip.access.G2_MAX_COUNT", (Integer)1000);
        G2_MAX_PER_SECOND = ConfService.getInt((String)"ip.access.G2_MAX_PER_SECOND", (Integer)50);
    }
}

