/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.recharge;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.sitexxx.service.model.main.RechargeItem;
import org.tio.sitexxx.web.server.recharge.IRechargeProvider;
import org.tio.sitexxx.web.server.recharge.provider.alipay.AlipayAppRechargeProvider;
import org.tio.sitexxx.web.server.recharge.provider.alipay.AlipayH5RechargeProvider;
import org.tio.sitexxx.web.server.recharge.provider.alipay.AlipayRechargeProvider;
import org.tio.sitexxx.web.server.recharge.provider.apple.AppleRechargeProvider;
import org.tio.sitexxx.web.server.recharge.provider.weixin.WxPayAppRechargeProvider;
import org.tio.sitexxx.web.server.recharge.provider.weixin.WxPayH5RechargeProvider;
import org.tio.sitexxx.web.server.recharge.provider.weixin.WxPayJsapiRechargeProvider;
import org.tio.sitexxx.web.server.recharge.provider.weixin.WxPayScan2RechargeProvider;

public class RechargeServiceFactory {
    private static Logger log = LoggerFactory.getLogger(RechargeServiceFactory.class);

    public static IRechargeProvider getThirdRechargeService(Integer paytype) {
        if (Objects.equals(paytype, RechargeItem.Paytype.ALIPAY)) {
            return AlipayRechargeProvider.me;
        }
        if (Objects.equals(paytype, RechargeItem.Paytype.ALIPAY_APP)) {
            return AlipayAppRechargeProvider.me;
        }
        if (Objects.equals(paytype, RechargeItem.Paytype.ALIPAY_H5)) {
            return AlipayH5RechargeProvider.me;
        }
        if (Objects.equals(paytype, RechargeItem.Paytype.WEIXIN)) {
            return WxPayScan2RechargeProvider.me;
        }
        if (Objects.equals(paytype, RechargeItem.Paytype.WEIXIN_APP)) {
            return WxPayAppRechargeProvider.me;
        }
        if (Objects.equals(paytype, RechargeItem.Paytype.WEIXIN_H5)) {
            return WxPayH5RechargeProvider.me;
        }
        if (Objects.equals(paytype, RechargeItem.Paytype.WEIXIN_JSAPI)) {
            return WxPayJsapiRechargeProvider.me;
        }
        if (Objects.equals(paytype, RechargeItem.Paytype.APPLE_APP)) {
            return AppleRechargeProvider.me;
        }
        log.error("paytype:{}, \u627e\u4e0d\u5230\u76f8\u5e94\u7684\u5904\u7406\u7c7b", (Object)paytype);
        return null;
    }

    public static void main(String[] args) {
    }
}

