/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.recharge.provider.alipay;

import cn.hutool.core.util.StrUtil;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.domain.AlipayTradePayModel;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import java.util.HashMap;
import org.slf4j.Logger;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.server.util.Resps;
import org.tio.sitexxx.service.model.main.RechargeItem;
import org.tio.sitexxx.service.utils.LogUtils;
import org.tio.sitexxx.web.server.recharge.RechargeUtils;
import org.tio.sitexxx.web.server.recharge.provider.alipay.AlipayConfig;
import org.tio.sitexxx.web.server.recharge.provider.alipay.AlipayRechargeProvider;
import org.tio.utils.resp.Resp;

public class AlipayAppRechargeProvider
extends AlipayRechargeProvider {
    private static Logger log = LogUtils.getCoinLog();
    public static final AlipayAppRechargeProvider me = new AlipayAppRechargeProvider();

    @Override
    public HttpResponse toThirdRechargePage(HttpRequest request, RechargeItem rechargeItem, int callbackType) throws Exception {
        Integer paytype = rechargeItem.getPaytype();
        String _subject = rechargeItem.getGoods();
        if (StrUtil.isBlank((CharSequence)_subject)) {
            _subject = "\u5145\u503c";
        }
        String total_fee = String.valueOf(rechargeItem.getAmount());
        String body = "";
        AlipayTradePayModel model = new AlipayTradePayModel();
        model.setOutTradeNo(rechargeItem.getTradeno());
        model.setProductCode("QUICK_MSECURITY_PAY");
        model.setTotalAmount(total_fee);
        model.setTimeoutExpress("30m");
        model.setSubject(_subject);
        model.setBody(body);
        AlipayClient alipayClient = AlipayConfig.alipayClient;
        AlipayTradeAppPayRequest alipayRequest = new AlipayTradeAppPayRequest();
        alipayRequest.setReturnUrl(RechargeUtils.getReturnUrl(paytype, request));
        alipayRequest.setNotifyUrl(RechargeUtils.getNotifyUrl(paytype, request));
        alipayRequest.setBizModel((AlipayObject)model);
        String retBody = "";
        try {
            AlipayTradeAppPayResponse alipayTradeAppPayResponse = (AlipayTradeAppPayResponse)alipayClient.sdkExecute((AlipayRequest)alipayRequest);
            if (alipayTradeAppPayResponse != null) {
                retBody = alipayTradeAppPayResponse.getBody();
                HashMap<String, String> ret = new HashMap<String, String>();
                ret.put("alipay", retBody);
                return Resps.json((HttpRequest)request, (Object)Resp.ok(ret));
            }
            return Resps.json((HttpRequest)request, (Object)Resp.fail((String)"\u652f\u4ed8\u5b9dSDK\u751f\u6210\u7684"));
        }
        catch (AlipayApiException e) {
            log.error("\u652f\u4ed8\u5b9d\u652f\u4ed8\u751f\u6210APP\u652f\u4ed8\u9875\u9762\u65f6\u4ea7\u751f\u5f02\u5e38", (Throwable)e);
            return Resps.json((HttpRequest)request, (Object)Resp.fail((String)"\u652f\u4ed8\u5b9d\u652f\u4ed8\u751f\u6210APP\u652f\u4ed8\u9875\u9762\u65f6\u4ea7\u751f\u5f02\u5e38"));
        }
    }
}

