/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.recharge.provider.alipay;

import cn.hutool.core.util.StrUtil;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import org.slf4j.Logger;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.server.util.Resps;
import org.tio.sitexxx.service.model.main.RechargeItem;
import org.tio.sitexxx.service.utils.LogUtils;
import org.tio.sitexxx.web.server.recharge.RechargeUtils;
import org.tio.sitexxx.web.server.recharge.provider.alipay.AlipayConfig;
import org.tio.sitexxx.web.server.recharge.provider.alipay.AlipayRechargeProvider;

public class AlipayH5RechargeProvider
extends AlipayRechargeProvider {
    private static Logger log = LogUtils.getCoinLog();
    public static final AlipayH5RechargeProvider me = new AlipayH5RechargeProvider();

    @Override
    public HttpResponse toThirdRechargePage(HttpRequest request, RechargeItem rechargeItem, int callbackType) throws Exception {
        Integer paytype = rechargeItem.getPaytype();
        String _subject = rechargeItem.getGoods();
        if (StrUtil.isBlank((CharSequence)_subject)) {
            _subject = "\u5145\u503c";
        }
        String total_fee = String.valueOf(rechargeItem.getAmount());
        String body = "";
        AlipayClient alipayClient = AlipayConfig.alipayClient;
        AlipayTradeWapPayRequest alipay_request = new AlipayTradeWapPayRequest();
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(rechargeItem.getTradeno());
        model.setSubject(_subject);
        model.setTotalAmount(total_fee);
        model.setBody(body);
        model.setTimeoutExpress("30m");
        model.setProductCode("QUICK_WAP_WAY");
        alipay_request.setBizModel((AlipayObject)model);
        alipay_request.setNotifyUrl(RechargeUtils.getNotifyUrl(paytype, request));
        alipay_request.setReturnUrl(RechargeUtils.getReturnUrl(paytype, request));
        String form = "";
        try {
            form = ((AlipayTradeWapPayResponse)alipayClient.pageExecute((AlipayRequest)alipay_request)).getBody();
            log.info("\u652f\u4ed8\u5b9d\u751f\u6210\u7684h5\u9875\u9762\r\n{}", (Object)form);
            return Resps.html((HttpRequest)request, (String)form);
        }
        catch (AlipayApiException e) {
            log.error("\u652f\u4ed8\u5b9d\u652f\u4ed8\u751f\u6210H5\u652f\u4ed8\u9875\u9762\u65f6\u4ea7\u751f\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }
}

