/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.recharge.provider.weixin;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.github.wxpay.sdk.WXPayConfig;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.server.util.Resps;
import org.tio.sitexxx.service.model.main.RechargeItem;
import org.tio.sitexxx.service.service.recharge.RechargeItemService;
import org.tio.sitexxx.service.utils.LogUtils;
import org.tio.sitexxx.web.server.recharge.RechargeUtils;
import org.tio.sitexxx.web.server.recharge.provider.weixin.TradeType;
import org.tio.sitexxx.web.server.recharge.provider.weixin.WXPayConfigImpl;
import org.tio.sitexxx.web.server.recharge.provider.weixin.WxPayScan2RechargeProvider;
import org.tio.utils.json.Json;
import org.tio.utils.resp.Resp;

public class WxPayH5RechargeProvider
extends WxPayScan2RechargeProvider {
    private static Logger log = LogUtils.getCoinLog();
    public static final WxPayH5RechargeProvider me = new WxPayH5RechargeProvider();

    protected WxPayH5RechargeProvider() {
    }

    @Override
    public WXPayConfig getWXPayConfig() {
        return WXPayConfigImpl.getInstance();
    }

    @Override
    public HttpResponse toThirdRechargePage(HttpRequest request, RechargeItem rechargeItem, int callbackType) throws Exception {
        Integer paytype = rechargeItem.getPaytype();
        String _subject = rechargeItem.getGoods();
        if (StrUtil.isBlank((CharSequence)_subject)) {
            _subject = "\u5145\u503c";
        }
        String total_fee = String.valueOf((int)NumberUtil.mul((double)rechargeItem.getAmount(), (float)100.0f));
        String tradeno = rechargeItem.getTradeno();
        String ip = request.getClientIp();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("body", _subject);
        data.put("out_trade_no", tradeno);
        data.put("device_info", "");
        data.put("fee_type", "CNY");
        data.put("total_fee", total_fee);
        data.put("spbill_create_ip", ip);
        data.put("notify_url", RechargeUtils.getNotifyUrl(paytype, request));
        data.put("trade_type", TradeType.MWEB.getValue());
        data.put("product_id", tradeno);
        try {
            Map r = this.wxpay.unifiedOrder(data);
            String returnCode = (String)r.get("return_code");
            if ("SUCCESS".equals(returnCode)) {
                String result_code = (String)r.get("result_code");
                if ("SUCCESS".equals(result_code)) {
                    String prepay_id = (String)r.get("prepay_id");
                    if (StrUtil.isNotBlank((CharSequence)prepay_id)) {
                        rechargeItem.setThirdtradeno(prepay_id);
                        RechargeItemService.me.update(rechargeItem);
                        String mweb_url = (String)r.get("mweb_url");
                        HashMap<String, String> respData = new HashMap<String, String>();
                        respData.put("mweb_url", mweb_url);
                        respData.put("tradeno", tradeno);
                        return Resps.json((HttpRequest)request, (Object)Resp.ok(respData));
                    }
                } else {
                    log.error("\u5fae\u4fe1H5\u5145\u503c\uff0c\u63d0\u4ea4\u5931\u8d25:{}", (Object)Json.toJson((Object)r));
                }
            } else {
                log.error("\u5fae\u4fe1H5\u5145\u503c\uff0c\u901a\u8baf\u5931\u8d25:{}", (Object)Json.toJson((Object)r));
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return Resps.json((HttpRequest)request, (Object)Resp.fail());
    }
}

