/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.recharge.provider.weixin;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.github.wxpay.sdk.WXPayConfig;
import com.github.wxpay.sdk.WXPayConstants;
import com.github.wxpay.sdk.WXPayUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.server.util.Resps;
import org.tio.sitexxx.service.model.main.RechargeItem;
import org.tio.sitexxx.service.service.recharge.RechargeItemService;
import org.tio.sitexxx.service.utils.LogUtils;
import org.tio.sitexxx.web.server.recharge.RechargeUtils;
import org.tio.sitexxx.web.server.recharge.provider.weixin.TradeType;
import org.tio.sitexxx.web.server.recharge.provider.weixin.WXJsapiPayConfigImpl;
import org.tio.sitexxx.web.server.recharge.provider.weixin.WxPayScan2RechargeProvider;
import org.tio.sitexxx.web.server.utils.SessionCacheUtils;
import org.tio.utils.json.Json;
import org.tio.utils.resp.Resp;

public class WxPayJsapiRechargeProvider
extends WxPayScan2RechargeProvider {
    private static Logger log = LogUtils.getCoinLog();
    public static final WxPayJsapiRechargeProvider me = new WxPayJsapiRechargeProvider();

    @Override
    public WXPayConfig getWXPayConfig() {
        return WXJsapiPayConfigImpl.getInstance();
    }

    @Override
    public HttpResponse toThirdRechargePage(HttpRequest request, RechargeItem rechargeItem, int callbackType) throws Exception {
        String openid;
        Integer paytype = rechargeItem.getPaytype();
        String _subject = rechargeItem.getGoods();
        if (StrUtil.isBlank((CharSequence)_subject)) {
            _subject = "\u5145\u503c";
        }
        if (StrUtil.isBlank((CharSequence)(openid = (String)((Object)SessionCacheUtils.get(request, "WX_PAY_OPENID"))))) {
            log.error("\u6ca1\u6709\u83b7\u53d6\u5230openid");
            return Resps.json((HttpRequest)request, (Object)Resp.fail());
        }
        String total_fee = String.valueOf((int)NumberUtil.mul((double)rechargeItem.getAmount(), (float)100.0f));
        String tradeno = rechargeItem.getTradeno();
        String ip = request.getClientIp();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("body", _subject);
        data.put("out_trade_no", tradeno);
        data.put("device_info", "");
        data.put("fee_type", "CNY");
        data.put("total_fee", total_fee);
        data.put("spbill_create_ip", ip);
        data.put("notify_url", RechargeUtils.getNotifyUrl(paytype, request));
        data.put("trade_type", TradeType.JSAPI.getValue());
        data.put("product_id", tradeno);
        data.put("openid", openid);
        try {
            Map r = this.wxpay.unifiedOrder(data);
            log.info("\u5fae\u4fe1JSAPI\u652f\u4ed8\uff0c\u7edf\u4e00\u4e0b\u5355\u6536\u5230\u5fae\u4fe1\u7684\u54cd\u5e94\uff1a\r\n{}", (Object)Json.toFormatedJson((Object)r));
            String returnCode = (String)r.get("return_code");
            if ("SUCCESS".equals(returnCode)) {
                String result_code = (String)r.get("result_code");
                if ("SUCCESS".equals(result_code)) {
                    String prepay_id = (String)r.get("prepay_id");
                    if (StrUtil.isNotBlank((CharSequence)prepay_id)) {
                        rechargeItem.setThirdtradeno(prepay_id);
                        RechargeItemService.me.update(rechargeItem);
                        HashMap<String, String> respData = new HashMap<String, String>();
                        respData.put("appId", this.config.getAppID());
                        respData.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
                        respData.put("nonceStr", String.valueOf(System.currentTimeMillis()));
                        respData.put("package", "prepay_id=" + prepay_id);
                        respData.put("signType", "MD5");
                        String paySign = WXPayUtil.generateSignature(respData, (String)this.config.getKey(), (WXPayConstants.SignType)WXPayConstants.SignType.MD5);
                        respData.put("paySign", paySign);
                        respData.put("tradeno", tradeno);
                        log.info("\u5fae\u4fe1JSAPI\u5145\u503c\uff0c\u8fd4\u56de\u7ed9\u524d\u7aef\u9875\u9762\u7684\u53c2\u6570:\r\n{}", (Object)Json.toFormatedJson(respData));
                        return Resps.json((HttpRequest)request, (Object)Resp.ok(respData));
                    }
                } else {
                    log.error("\u5fae\u4fe1JSAPI\u5145\u503c\uff0c\u63d0\u4ea4\u5931\u8d25:{}", (Object)Json.toJson((Object)r));
                }
            } else {
                log.error("\u5fae\u4fe1JSAPI\u5145\u503c\uff0c\u901a\u8baf\u5931\u8d25:{}", (Object)Json.toJson((Object)r));
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return Resps.json((HttpRequest)request, (Object)Resp.fail());
    }
}

