/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.web.server.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.UploadFile;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.conf.AutoAvatar;
import org.tio.sitexxx.service.model.conf.AutoAvatarPlate;
import org.tio.sitexxx.service.model.main.Img;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.web.server.utils.ImgUtils;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;
import org.tio.utils.hutool.ResourceUtil;

public class WxGroupAvatarUtil {
    private static final Logger log = LoggerFactory.getLogger(WxGroupAvatarUtil.class);
    private static final int AVATAR_BASE_WIDTH = 168;
    private static final int AVATAR_BASE_HEIGHT = 168;
    private static final int ONE_IMG_WIDTH = 40;
    private static final int BORDER_WIDTH = 3;
    private static final int CANVANS_W = 132;
    private static final int CANVANS_H = 132;
    private static final int ONE_IMAGE_WIDTH = 126;
    private static final int TWO_IMAGE_WIDTH = 61;
    private static final int FIVE_IMAGE_WIDTH = 40;
    private static List<AutoAvatarPlate> basePlateConf = null;
    private static int plateSize = -1;

    private WxGroupAvatarUtil() {
    }

    public static Img generateGroupAvatar(List<String> paths, String uid) throws Exception {
        ArrayList<BufferedImage> biList = new ArrayList<BufferedImage>();
        int imgCount = paths.size();
        int imageSize = 0;
        imageSize = imgCount <= 1 ? 126 : (imgCount > 1 && imgCount < 5 ? 61 : 40);
        for (int i = 0; i < imgCount; ++i) {
            BufferedImage resize2 = WxGroupAvatarUtil.resize(paths.get(i), imageSize, imageSize, true);
            biList.add(resize2);
        }
        BufferedImage outImage = new BufferedImage(132, 132, 1);
        Graphics g = outImage.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setBackground(new Color(226, 226, 226));
        g2d.clearRect(0, 0, 132, 132);
        block12: for (int i = 1; i <= imgCount; ++i) {
            int index = i - 1;
            BufferedImage bi = (BufferedImage)biList.get(index);
            switch (imgCount) {
                case 1: {
                    g2d.drawImage((Image)bi, 3, 3, null);
                    continue block12;
                }
                case 2: {
                    if (i == 1) {
                        g2d.drawImage((Image)bi, 3, (132 - imageSize) / 2, null);
                        continue block12;
                    }
                    g2d.drawImage((Image)bi, 6 + imageSize, (132 - imageSize) / 2, null);
                    continue block12;
                }
                case 3: {
                    if (i == 1) {
                        g2d.drawImage((Image)bi, (132 - imageSize) / 2, 3, null);
                        continue block12;
                    }
                    g2d.drawImage((Image)bi, (i - 1) * 3 + (i - 2) * imageSize, imageSize + 6, null);
                    continue block12;
                }
                case 4: {
                    if (i <= 2) {
                        g2d.drawImage((Image)bi, i * 3 + (i - 1) * imageSize, 3, null);
                        continue block12;
                    }
                    g2d.drawImage((Image)bi, (i - 2) * 3 + (i - 3) * imageSize, imageSize + 6, null);
                    continue block12;
                }
                case 5: {
                    if (i <= 2) {
                        g2d.drawImage((Image)bi, (132 - 2 * imageSize - 3) / 2 + (i - 1) * imageSize + (i - 1) * 3, (132 - 2 * imageSize - 3) / 2, null);
                        continue block12;
                    }
                    g2d.drawImage((Image)bi, (i - 2) * 3 + (i - 3) * imageSize, (132 - 2 * imageSize - 3) / 2 + imageSize + 3, null);
                    continue block12;
                }
                case 6: {
                    if (i <= 3) {
                        g2d.drawImage((Image)bi, 3 * i + imageSize * (i - 1), (132 - 2 * imageSize - 3) / 2, null);
                        continue block12;
                    }
                    g2d.drawImage((Image)bi, (i - 3) * 3 + (i - 4) * imageSize, (132 - 2 * imageSize - 3) / 2 + imageSize + 3, null);
                    continue block12;
                }
                case 7: {
                    if (i <= 1) {
                        g2d.drawImage((Image)bi, 6 + imageSize, 3, null);
                    }
                    if (i <= 4 && i > 1) {
                        g2d.drawImage((Image)bi, (i - 1) * 3 + (i - 2) * imageSize, 6 + imageSize, null);
                    }
                    if (i > 7 || i <= 4) continue block12;
                    g2d.drawImage((Image)bi, (i - 4) * 3 + (i - 5) * imageSize, 9 + 2 * imageSize, null);
                    continue block12;
                }
                case 8: {
                    if (i <= 2) {
                        g2d.drawImage((Image)bi, (132 - 2 * imageSize - 3) / 2 + (i - 1) * imageSize + (i - 1) * 3, 3, null);
                    }
                    if (i <= 5 && i > 2) {
                        g2d.drawImage((Image)bi, (i - 2) * 3 + (i - 3) * imageSize, 6 + imageSize, null);
                    }
                    if (i > 8 || i <= 5) continue block12;
                    g2d.drawImage((Image)bi, (i - 5) * 3 + (i - 6) * imageSize, 9 + 2 * imageSize, null);
                    continue block12;
                }
                case 9: {
                    if (i <= 3) {
                        g2d.drawImage((Image)bi, i * 3 + (i - 1) * imageSize, 3, null);
                    }
                    if (i <= 6 && i > 3) {
                        g2d.drawImage((Image)bi, (i - 3) * 3 + (i - 4) * imageSize, 6 + imageSize, null);
                    }
                    if (i > 9 || i <= 6) continue block12;
                    g2d.drawImage((Image)bi, (i - 6) * 3 + (i - 7) * imageSize, 9 + 2 * imageSize, null);
                    continue block12;
                }
            }
        }
        String ext = "jpg";
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)outImage, ext, output);
        UploadFile uploadFile = new UploadFile();
        uploadFile.setData(output.toByteArray());
        uploadFile.setName("wxgroup_avatar." + ext);
        uploadFile.setSize(uploadFile.getData().length);
        Img img = ImgUtils.processImg("wx/group/avatar", uid, uploadFile, 1.0f);
        return img;
    }

    public static String pressUserAvatar(String nickFristChar) throws Exception {
        String key;
        ICache cache;
        String path;
        if (nickFristChar.length() > 1) {
            nickFristChar = nickFristChar.substring(0, 1).toUpperCase();
        }
        if (StrUtil.isBlank((CharSequence)(path = (String)((Object)CacheUtils.get((ICache)(cache = Caches.getCache((CacheConfig)CacheConfig.AUTO_AVATAR)), (String)(key = nickFristChar), (boolean)true, (FirsthandCreater)new FirsthandCreater<String>(){

            public String create() {
                String sql = "select path from auto_avatar where chatindex = ? limit 0,1";
                String path = Db.use((String)"tio_site_conf").queryStr(sql, new Object[]{key});
                if (StrUtil.isNotBlank((CharSequence)path)) {
                    return path;
                }
                Img img = null;
                try {
                    img = WxGroupAvatarUtil.imgPressText(key + "_avatar.png", "user/base/avatar", key, Const.USER_AVATAR_BASE_BACKGROUND_IMG, Const.USER_AVATAR_MEDIUM_FONT_SIZE, 1);
                    if (img == null || StrUtil.isBlank((CharSequence)img.getCoverurl())) {
                        log.error("\u5934\u50cf\u751f\u6210\u9519\u8bef");
                        return null;
                    }
                    AutoAvatar autoAvatar = new AutoAvatar();
                    autoAvatar.setPath(img.getCoverurl());
                    autoAvatar.setChatindex(key);
                    autoAvatar.setRemark(key);
                    autoAvatar.save();
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
                return img.getCoverurl();
            }
        }))))) {
            path = (String)((Object)CacheUtils.get((ICache)cache, (String)"#", (boolean)true, (FirsthandCreater)new FirsthandCreater<String>(){

                public String create() {
                    String sql = "select path from auto_avatar where chatindex = ? limit 0,1";
                    String path = Db.use((String)"tio_site_conf").queryStr(sql, new Object[]{"#"});
                    if (StrUtil.isNotBlank((CharSequence)path)) {
                        return path;
                    }
                    Img img = null;
                    try {
                        img = WxGroupAvatarUtil.imgPressText("u#_avatar.png", "user/base/avatar", "#", Const.USER_AVATAR_BASE_BACKGROUND_IMG, Const.USER_AVATAR_MEDIUM_FONT_SIZE, 1);
                        if (img == null || StrUtil.isBlank((CharSequence)img.getCoverurl())) {
                            return null;
                        }
                        AutoAvatar autoAvatar = new AutoAvatar();
                        autoAvatar.setPath(img.getCoverurl());
                        autoAvatar.setChatindex("#");
                        autoAvatar.setRemark("#");
                        autoAvatar.save();
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                    return img.getCoverurl();
                }
            }));
        }
        return path;
    }

    public static Img imgPressText(String name, String dir, String str, String basePlatePath, int fontsize, int alpha) throws Exception {
        BufferedImage srcImg = null;
        if (CollectionUtil.isEmpty(basePlateConf)) {
            File srcImgFile = new File(ResourceUtil.getAbsolutePath((String)basePlatePath));
            srcImg = ImageIO.read(srcImgFile);
        } else {
            srcImg = new BufferedImage(168, 168, 1);
            Graphics g = ((Image)srcImg).getGraphics();
            AutoAvatarPlate plate = WxGroupAvatarUtil.getAvatarPlate();
            g.setColor(new Color(plate.getR(), plate.getB(), plate.getG()));
            g.fillRect(0, 0, 168, 168);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ImgUtil.pressText((Image)srcImg, (OutputStream)output, (String)str, (Color)Color.WHITE, (Font)WxGroupAvatarUtil.getMediumFont(0, fontsize), (int)0, (int)0, (float)alpha);
        UploadFile uploadFile = new UploadFile();
        uploadFile.setData(output.toByteArray());
        uploadFile.setName(name);
        uploadFile.setSize(uploadFile.getData().length);
        try {
            Img img = ImgUtils.processImg(dir, uploadFile);
            return img;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static BufferedImage resize(String path, int height, int width, boolean bb) {
        try {
            double ratio = 0.0;
            String urlPath = WebUtils.resUrl(path);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            HttpResponse response = HttpRequest.get((String)urlPath).executeAsync();
            if (!response.isOk()) {
                throw new HttpException("Server response error with status code: [{}]", new Object[]{response.getStatus()});
            }
            response.writeBody((OutputStream)out, true, null);
            byte[] bytes = out.toByteArray();
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            BufferedImage bi = ImageIO.read(input);
            Image itemp = bi.getScaledInstance(width, height, 4);
            if (bi.getHeight() > height || bi.getWidth() > width) {
                ratio = bi.getHeight() > bi.getWidth() ? new Integer(height).doubleValue() / (double)bi.getHeight() : new Integer(width).doubleValue() / (double)bi.getWidth();
                AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
                itemp = op.filter(bi, null);
            }
            if (bb) {
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D g = image.createGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, width, height);
                if (width == itemp.getWidth(null)) {
                    g.drawImage(itemp, 0, (height - itemp.getHeight(null)) / 2, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                } else {
                    g.drawImage(itemp, (width - itemp.getWidth(null)) / 2, 0, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                }
                g.dispose();
                itemp = image;
            }
            return (BufferedImage)itemp;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font getMediumFont(int ft, float fs) {
        String fontUrl = ResourceUtil.getAbsolutePath((String)Const.MEDIUM_FONT_TTF_FILE);
        FileInputStream is = null;
        Font definedFont = null;
        BufferedInputStream bis = null;
        try {
            is = new FileInputStream(new File(fontUrl));
            bis = new BufferedInputStream(is);
            definedFont = Font.createFont(ft, is);
            definedFont = definedFont.deriveFont(fs);
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != bis) {
                    bis.close();
                }
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return definedFont;
    }

    public static AutoAvatarPlate getAvatarPlate() {
        int index = RandomUtil.randomInt((int)0, (int)plateSize);
        return basePlateConf.get(index);
    }

    public static void main(String[] args) throws IOException {
        BufferedImage img = new BufferedImage(168, 168, 1);
        Graphics g = img.getGraphics();
        g.setColor(new Color(108, 168, 238));
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        FileOutputStream output = new FileOutputStream("D:/xufei/11.png");
        ImgUtil.pressText((Image)img, (OutputStream)output, (String)"#", (Color)Color.WHITE, (Font)WxGroupAvatarUtil.getMediumFont(0, 80.0f), (int)0, (int)0, (float)1.0f);
    }

    static {
        if (basePlateConf == null && (basePlateConf = AutoAvatarPlate.dao.find("select id,r,g,b from auto_avatar_plate")) != null) {
            plateSize = basePlateConf.size();
        }
    }
}

