/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.view;

import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.flash.policy.server.FlashPolicyServerStarter;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.init.JFInit;
import org.tio.sitexxx.service.init.PropInit;
import org.tio.sitexxx.service.init.RedisInit;
import org.tio.sitexxx.service.ip2region.Ip2RegionInit;
import org.tio.sitexxx.service.service.conf.ConfService;
import org.tio.sitexxx.service.utils.LogUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.view.http.WebViewInit;
import org.tio.sitexxx.view.http.WebViewModelGenerator;
import org.tio.sitexxx.view.http.pathmodel.PathModelGenerator;
import org.tio.sitexxx.view.init.TopicInit;
import org.tio.utils.jfinal.P;
import org.tio.utils.json.Json;
import org.tio.webpack.model.Root;

public class WebViewStarter {
    private static Logger log = LoggerFactory.getLogger(WebViewStarter.class);
    public static Root model = null;
    public static Map<Object, Object> mapModel = null;
    public static WebViewModelGenerator tioWebpackModelGenerator;

    public static void main(String[] args) throws Exception {
        try {
            PropInit.init();
            Ip2RegionInit.init();
            Caches.init();
            JFInit.init();
            RedisInit.init((boolean)true);
            TopicInit.init();
            WebViewStarter.initView(args);
            if (P.getBoolean((String)"start.843", (Boolean)false).booleanValue()) {
                FlashPolicyServerStarter.start(null, null);
            }
        }
        catch (Throwable e) {
            log.error("", e);
            System.exit(1);
        }
    }

    private static void initView1() {
        model = null;
        String modelFilePath = P.get((String)"view.model.config.file", (String)"webpack.json");
        String modelAbsFile = FileUtil.getAbsolutePath((String)("classpath:" + modelFilePath));
        File modelFile = new File(modelAbsFile);
        log.info("modelAbsFile:{}", (Object)modelAbsFile);
        String content = FileUtil.readString((File)modelFile, (String)"utf-8");
        model = (Root)Json.toBean((String)content, Root.class);
        mapModel = (Map)Json.toBean((String)content, Map.class);
        String title = ConfService.getString((String)"seo.title", (String)"t-io - \u8ba9\u5929\u4e0b\u6ca1\u6709\u96be\u5f00\u53d1\u7684\u7f51\u7edc\u901a\u8baf, \u5355\u673a\u4e0d\u4ec5\u4ec5\u662f\u652f\u630130\u4e07\u957f\u8fde\u63a5");
        String keywords = ConfService.getString((String)"seo.keywords", (String)"t-io,tio,\u5f00\u6e90,netty,mina,rpc,jfinal,layui,hutool,osc,io,socket,tcp,nio,aio,nio2,im,\u6e38\u620f,java,\u957f\u8fde\u63a5");
        String description = ConfService.getString((String)"seo.description", (String)"t-io/tio\u662f\u4e00\u4e2a\u7f51\u7edc\u7f16\u7a0b\u6846\u67b6\uff0c\u4e5f\u53ef\u4ee5\u53ebTCP\u957f\u8fde\u63a5\u6846\u67b6\uff0c\u4ece\u8fd9\u4e00\u70b9\u6765\u8bf4\u662f\u6709\u70b9\u50cfnetty\u7684\uff0c\u4f46t-io\u4e3a\u5e38\u89c1\u548c\u7f51\u7edc\u76f8\u5173\u7684\u4e1a\u52a1\uff08\u5982IM\u3001\u6d88\u606f\u63a8\u9001\u3001RPC\u3001\u76d1\u63a7\uff09\u63d0\u4f9b\u4e86\u8fd1\u4e4e\u4e8e\u73b0\u6210\u7684\u89e3\u51b3\u65b9\u6848\uff0c\u5373\u4e30\u5bcc\u7684\u7f16\u7a0bAPI\uff0c\u6781\u5927\u51cf\u5c11\u4e1a\u52a1\u5c42\u7684\u7f16\u7a0b\u96be\u5ea6");
        String jsVersion = ConfService.getString((String)"js_version", (String)"1");
        mapModel.put("title", title);
        mapModel.put("keywords", keywords);
        mapModel.put("description", description);
        mapModel.put("res_server", Const.RES_SERVER);
        mapModel.put("js_version", jsVersion);
        mapModel.put("api_ctx", Const.API_CONTEXTPATH);
        mapModel.put("api_suf", Const.API_SUFFIX);
        mapModel.put("session_cookie_name", Const.Http.SESSION_COOKIE_NAME);
        mapModel.put("sitename", ConfService.getString((String)"sitename", (String)"t-io\u793e\u4ea4IM\u5e73\u53f0"));
        String tioim_title = ConfService.getString((String)"tioim.title", (String)"\u8c2d\u804a\uff0c\u8ba9\u6240\u6709\u516c\u53f8\u7528\u5f97\u4e0a\u9760\u8c31\u7684IM");
        String tioim_keywords = ConfService.getString((String)"tioim.keywords", (String)"IM,t-io,\u9ad8\u5e76\u53d1,\u96c6\u7fa4,\u79c1\u6709\u90e8\u7f72");
        String tioim_description = ConfService.getString((String)"tioim.description", (String)"\u8c2d\u804a\u662f\u57fa\u4e8et-io\u7814\u53d1\u7684\u7c7b\u4f3c\u5fae\u4fe1\u7684\u5b8c\u6574IM\uff0c\u652f\u6301\u96c6\u7fa4\u3001\u8bed\u97f3\u901a\u8bdd\u3001\u89c6\u9891\u901a\u8bdd\u3001\u79c1\u804a\u3001\u7fa4\u804a");
        mapModel.put("tioim_title", tioim_title);
        mapModel.put("tioim_keywords", tioim_keywords);
        mapModel.put("tioim_description", tioim_description);
        tioWebpackModelGenerator = new WebViewModelGenerator(mapModel, new String[]{PathModelGenerator.class.getPackage().getName()});
    }

    public static void initView(String[] args) throws Exception {
        WebViewStarter.initView1();
        LogUtils.logJvmStartTime((String)(WebViewStarter.class.getName() + ".initView1()"));
        WebViewInit.init(model, tioWebpackModelGenerator);
        LogUtils.logJvmStartTime((String)(WebViewInit.class.getName() + ".init()"));
    }
}

