/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.view.http;

import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.view.freemarker.ConfigurationCreater;
import org.tio.sitexxx.view.http.WebViewInit;
import org.tio.utils.freemarker.ShortMessageTemplateExceptionHandler;

public class FreemarkerConfigurationCreater
implements ConfigurationCreater {
    public static final FreemarkerConfigurationCreater me = new FreemarkerConfigurationCreater();

    private FreemarkerConfigurationCreater() {
    }

    public Configuration createConfiguration(HttpConfig httpConfig, String root) throws IOException {
        Configuration cfg = new Configuration(Configuration.getVersion());
        if (httpConfig.isPageInClasspath()) {
            cfg.setClassForTemplateLoading(this.getClass(), root);
        } else {
            cfg.setDirectoryForTemplateLoading(new File(root));
        }
        cfg.setDefaultEncoding(httpConfig.getCharset());
        if (WebViewInit.devMode == 1) {
            cfg.setLogTemplateExceptions(true);
        } else {
            cfg.setLogTemplateExceptions(false);
        }
        cfg.setWrapUncheckedExceptions(true);
        cfg.setTemplateExceptionHandler((TemplateExceptionHandler)ShortMessageTemplateExceptionHandler.me);
        cfg.setLocale(Locale.SIMPLIFIED_CHINESE);
        cfg.setNumberFormat("#");
        return cfg;
    }

    public static void main(String[] args) {
    }
}

