/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.view.http;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseStatus;
import org.tio.http.common.MimeType;
import org.tio.http.common.RequestLine;
import org.tio.http.common.session.HttpSession;
import org.tio.http.server.intf.HttpServerInterceptor;
import org.tio.http.server.util.Resps;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.LoginLog;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.conf.ConfService;
import org.tio.sitexxx.service.vo.RequestExt;
import org.tio.sitexxx.service.vo.SessionExt;
import org.tio.sitexxx.view.WebViewStarter;
import org.tio.sitexxx.view.http.WebViewInit;
import org.tio.sitexxx.web.server.auth.AccessCtrlConfig;
import org.tio.sitexxx.web.server.auth.AccessCtrlService;
import org.tio.sitexxx.web.server.http.WebApiHttpServerInterceptor;
import org.tio.sitexxx.web.server.utils.WebUtils;
import org.tio.utils.SystemTimer;
import org.tio.utils.cache.ICache;
import org.tio.utils.jfinal.P;
import org.tio.utils.lock.LockUtils;
import org.tio.utils.lock.MapWithLock;
import org.tio.webpack.cache.CacheVo;
import org.tio.webpack.compress.ResCompressor;
import org.tio.webpack.compress.ResCompressorFactory;
import org.tio.webpack.model.Root;

public class WebViewHttpServerInterceptor
implements HttpServerInterceptor {
    private static Logger log = LoggerFactory.getLogger(WebViewHttpServerInterceptor.class);
    private AccessCtrlConfig accessCtrlConfig = null;
    public static final WebViewHttpServerInterceptor me = new WebViewHttpServerInterceptor();
    private final String httpCacheLockKey = this.getClass().getName() + ".httpCacheLockKey";
    private static boolean useHttpcache = P.getInt((String)"web.view.use.http.cache", (Integer)1) == 1;
    public static final HeaderName tio_view_from_cache = HeaderName.from((String)"tio_view_from_cache");
    public static final HeaderValue tio_view_from_cache_value = HeaderValue.from((String)"1");
    private static final Set<String> noCachePaths = new HashSet<String>();
    private static final Set<String> skipCompressPaths = new HashSet<String>();
    private static final Set<String> skipCompressPathItems = new HashSet<String>();
    private static final MapWithLock<String, CacheVo> CACHEMAP_NOT_NEED_COMPARE;
    private Root model;
    private final String fromCache = "fromCache";

    private WebViewHttpServerInterceptor() {
    }

    public HttpResponse doBeforeHandler(HttpRequest request, RequestLine requestLine, HttpResponse responseFromCache) throws Exception {
        RequestExt requestExt = new RequestExt();
        request.setAttribute("TIO_SITE_REQUESTEXT", (Serializable)requestExt);
        String path = requestLine.getPath();
        HttpSession session = request.getHttpSession();
        User user = WebUtils.currUser((HttpRequest)request);
        String userid = null;
        if (user != null) {
            userid = user.getId();
        }
        boolean b = AccessCtrlService.canAccess((AccessCtrlConfig)this.accessCtrlConfig, (String)userid, (String)path);
        HttpConfig httpConfig = request.httpConfig;
        if (!b) {
            String msg = null;
            int showLogin = 1;
            if (user != null) {
                showLogin = 2;
                msg = "\u8be5\u9875\u9762\u53ea\u5bf9\u90e8\u5206\u7528\u6237\u5f00\u653e";
            } else {
                SessionExt sessionExt = WebUtils.getSessionExt((HttpSession)session);
                LoginLog loginLog = sessionExt.getKickedInfo();
                if (loginLog != null) {
                    String ip = loginLog.getIp();
                    Date time = loginLog.getTime();
                    String deviceinfo = loginLog.getDeviceinfo();
                    msg = "\u5f02\u5730\u767b\u5f55\uff0c\u60a8\u7684\u5e10\u53f7\u4e8e" + DateUtil.formatDateTime((Date)time) + "\u5728" + ip + "\u767b\u5f55\u8fc7";
                    if (StrUtil.isNotBlank((CharSequence)deviceinfo)) {
                        msg = msg + "\uff0c\u767b\u5f55\u8bbe\u5907\u3010" + deviceinfo + "\u3011";
                    }
                } else {
                    msg = "\u60a8\u5c1a\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6";
                }
            }
            StringBuilder sb = new StringBuilder(64);
            sb.append("/login/index.html");
            sb.append("?").append("redirect_uri_after_login").append("=").append(URLEncoder.encode(request.requestLine.getPathAndQuery(), httpConfig.getCharset()));
            sb.append("&msg=").append(URLEncoder.encode(msg, httpConfig.getCharset()));
            sb.append("&showLogin=").append(showLogin);
            return Resps.forward((HttpRequest)request, (String)sb.toString());
        }
        ICache cache = null;
        String cachePath = WebViewHttpServerInterceptor.getCachePath(request);
        HttpResponse responseInCache = null;
        if (StrUtil.isNotBlank((CharSequence)cachePath)) {
            cache = Caches.getCache((CacheConfig)CacheConfig.VIEW_HTML);
            responseInCache = (HttpResponse)cache.get(cachePath, HttpResponse.class);
        }
        if (responseInCache != null) {
            responseInCache = HttpResponse.cloneResponse((HttpRequest)request, responseInCache);
            request.setAttribute("fromCache", (Serializable)Integer.valueOf(1));
            String If_Modified_Since = request.getHeader("if-modified-since");
            if (StrUtil.isNotBlank((CharSequence)If_Modified_Since)) {
                try {
                    HeaderValue Last_Modified = responseInCache.getLastModified();
                    if (Last_Modified != null && Objects.equals(Last_Modified.value, If_Modified_Since)) {
                        HttpResponse ret = new HttpResponse(request);
                        ret.setStatus(HttpResponseStatus.C304);
                        return ret;
                    }
                }
                catch (NumberFormatException e) {
                    log.warn("{}, {}\u4e0d\u662f\u6574\u6570\uff0c\u6d4f\u89c8\u5668\u4fe1\u606f:{}", new Object[]{request.getClientIp(), If_Modified_Since, request.getUserAgent()});
                }
            }
        } else {
            responseInCache = WebApiHttpServerInterceptor.doHttpCacheOnBeforeHandler((HttpRequest)request, (RequestExt)requestExt, (String)path, (String)this.httpCacheLockKey, (boolean)useHttpcache);
        }
        return responseInCache;
    }

    private CacheVo processCompress(byte[] respBodyInitBytes, ResCompressor resCompressor, HttpRequest request, String path) throws Exception {
        byte[] compressedBytes = this.getCompressedBytes(respBodyInitBytes, resCompressor, request, path);
        CacheVo cacheVo = new CacheVo();
        cacheVo.setInitBytes(respBodyInitBytes);
        cacheVo.setCompressedBytes(compressedBytes);
        return cacheVo;
    }

    private boolean skipJsCompress(String path) {
        if (skipCompressPathItems.contains(path)) {
            return true;
        }
        if (skipCompressPaths != null && !skipCompressPaths.isEmpty()) {
            for (String skipCompressPath : skipCompressPaths) {
                if (!path.startsWith(skipCompressPath)) continue;
                skipCompressPathItems.add(path);
                return true;
            }
        }
        return false;
    }

    private byte[] getCompressedBytes(byte[] respBodyInitBytes, ResCompressor resCompressor, HttpRequest request, String path) throws Exception {
        String initStr = new String(respBodyInitBytes, request.getCharset());
        byte[] compressedBytes = null;
        compressedBytes = initStr != null && initStr.length() > 256 && !this.skipJsCompress(path) ? resCompressor.compress(path, initStr).getBytes(request.getCharset()) : respBodyInitBytes;
        return compressedBytes;
    }

    private static void putToCache(String path, CacheVo cacheVo) {
        CACHEMAP_NOT_NEED_COMPARE.put((Object)path, (Object)cacheVo);
    }

    private static CacheVo getCache(String path) {
        CacheVo ret = (CacheVo)CACHEMAP_NOT_NEED_COMPARE.get((Object)path);
        return ret;
    }

    public static void clearCache() {
        CACHEMAP_NOT_NEED_COMPARE.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAfterHandler(HttpRequest request, RequestLine requestLine, HttpResponse response, long cost) throws Exception {
        RequestExt requestExt = WebUtils.getRequestExt((HttpRequest)request);
        try {
            String cachePath;
            HttpResponseStatus status;
            if (response == null) {
                return;
            }
            if (Objects.equals(1, request.getAttribute("fromCache"))) {
                return;
            }
            if (requestExt.isFromCache()) {
                return;
            }
            HeaderValue contentType = response.getContentType();
            if (contentType == null) {
                return;
            }
            MimeType mimeType = MimeType.fromType((String)contentType.value);
            if (mimeType != null) {
                String extension = mimeType.getExtension();
                String path = requestLine.getPath();
                ResCompressor resCompressor1 = null;
                boolean needCompress = WebViewHttpServerInterceptor.neededCompress(path);
                if (needCompress && (needCompress = ResCompressorFactory.isNeedCompress((Root)this.model, (String)extension))) {
                    resCompressor1 = ResCompressorFactory.get((String)extension);
                    boolean bl = needCompress = resCompressor1 != null;
                }
                if (needCompress) {
                    ResCompressor resCompressor = resCompressor1;
                    byte[] respBodyInitBytes = response.getBody();
                    if (WebViewHttpServerInterceptor.getCachePath(request) != null) {
                        byte[] compressedBsInCache = null;
                        CacheVo cacheVo = WebViewHttpServerInterceptor.getCache(path);
                        if (cacheVo == null) {
                            LockUtils.runWriteOrWaitRead((String)("_tiohttp_view_wv_" + path), (Object)this, () -> {
                                if (WebViewHttpServerInterceptor.getCache(path) == null) {
                                    WebViewHttpServerInterceptor.putToCache(path, this.processCompress(respBodyInitBytes, resCompressor, request, path));
                                }
                            });
                            cacheVo = WebViewHttpServerInterceptor.getCache(path);
                            if (cacheVo == null) {
                                User curr = WebUtils.currUser((HttpRequest)request);
                                String nick = null;
                                nick = curr != null ? curr.getNick() : "null";
                                log.error("path:{}, curr:{}, ip:{}", new Object[]{path, nick, request.getClientIp()});
                            } else {
                                compressedBsInCache = cacheVo.getCompressedBytes();
                            }
                        }
                        boolean isSame = false;
                        isSame = WebViewInit.isDevMode ? Arrays.equals(respBodyInitBytes, cacheVo.getInitBytes()) : true;
                        if (isSame) {
                            compressedBsInCache = cacheVo.getCompressedBytes();
                            response.addHeader(HeaderName.tio_webpack_used_cache, HeaderValue.Tio_Webpack_Used_Cache.V_1);
                        } else {
                            cacheVo = this.processCompress(respBodyInitBytes, resCompressor, request, path);
                            compressedBsInCache = cacheVo.getCompressedBytes();
                            if (WebViewHttpServerInterceptor.getCachePath(request) != null) {
                                WebViewHttpServerInterceptor.putToCache(path, cacheVo);
                            }
                        }
                        response.setBody(compressedBsInCache);
                    } else {
                        byte[] compressedBytes = this.getCompressedBytes(respBodyInitBytes, resCompressor, request, path);
                        response.setBody(compressedBytes);
                    }
                }
            }
            if (!WebViewInit.isDevMode && Objects.equals(status = response.getStatus(), HttpResponseStatus.C200) && StrUtil.isNotBlank((CharSequence)(cachePath = WebViewHttpServerInterceptor.getCachePath(request)))) {
                HeaderValue lastModified = HeaderValue.from((String)(SystemTimer.currTime + ""));
                response.addHeader(HeaderName.Cache_Control, HeaderValue.Cache_Control.MAX_AGE_60);
                response.setLastModified(lastModified);
                HeaderValue contentEncoding = response.getHeader(HeaderName.Content_Encoding);
                HashMap<HeaderName, HeaderValue> headersInCache = new HashMap<HeaderName, HeaderValue>();
                if (contentType != null) {
                    headersInCache.put(HeaderName.Content_Type, contentType);
                }
                if (contentEncoding != null) {
                    headersInCache.put(HeaderName.Content_Encoding, contentEncoding);
                }
                headersInCache.put(HeaderName.Cache_Control, response.getHeader(HeaderName.Cache_Control));
                HttpResponse responseInCache = new HttpResponse(request);
                responseInCache.setStatus(response.getStatus());
                responseInCache.addHeaders(headersInCache);
                responseInCache.setLastModified(lastModified);
                responseInCache.setBody(response.getBody());
                responseInCache.setHasGzipped(response.isHasGzipped());
                responseInCache.addHeader(tio_view_from_cache, tio_view_from_cache_value);
                ICache cache = Caches.getCache((CacheConfig)CacheConfig.VIEW_HTML);
                cache.put(cachePath, (Serializable)responseInCache);
            }
        }
        catch (Exception e) {
            log.error(requestLine.toString(), (Throwable)e);
        }
        finally {
            response = WebApiHttpServerInterceptor.doHttpCacheOnAfterHandler((HttpResponse)response, (HttpRequest)request, (RequestExt)requestExt, (String)requestLine.path, (boolean)useHttpcache, (String)this.httpCacheLockKey);
            WebApiHttpServerInterceptor.saveSlowRequest((HttpRequest)request, (RequestLine)requestLine, (HttpResponse)response, (long)cost, (byte)2);
        }
    }

    public static String getCachePath(HttpRequest request) {
        RequestLine requestLine = request.getRequestLine();
        String path = requestLine.getPath();
        if (noCachePaths.contains(path)) {
            return null;
        }
        if (WebViewStarter.tioWebpackModelGenerator.generatorMap.containsKey(path)) {
            return null;
        }
        return path;
    }

    public static boolean neededCompress(String path) {
        return true;
    }

    public Root getModel() {
        return this.model;
    }

    public void setModel(Root model) {
        this.model = model;
    }

    public AccessCtrlConfig getAccessCtrlConfig() {
        return this.accessCtrlConfig;
    }

    public void setAccessCtrlConfig(AccessCtrlConfig accessCtrlConfig) {
        this.accessCtrlConfig = accessCtrlConfig;
    }

    static {
        noCachePaths.add("/recharge/wechatPay.html");
        noCachePaths.add("/http-api/app/httpclient-lixian-data.js");
        String skipCompressPathStr = ConfService.getString((String)"web.view.skip.js.compress", (String)"");
        if (StrUtil.isNotBlank((CharSequence)skipCompressPathStr)) {
            String[] skipCompressPathArray = StrUtil.split((CharSequence)skipCompressPathStr, (CharSequence)";");
            StrUtil.trim((String[])skipCompressPathArray);
            Collections.addAll(skipCompressPaths, skipCompressPathArray);
        }
        CACHEMAP_NOT_NEED_COMPARE = new MapWithLock(512);
    }
}

