/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.view.http;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.TioConfig;
import org.tio.core.stat.IpStatListener;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.common.session.id.ISessionIdGenerator;
import org.tio.http.common.session.id.impl.SnowflakeSessionIdGenerator;
import org.tio.http.common.session.limiter.SessionRateLimiter;
import org.tio.http.common.view.ModelGenerator;
import org.tio.http.common.view.freemarker.ConfigurationCreater;
import org.tio.http.common.view.freemarker.FreemarkerConfig;
import org.tio.http.server.HttpServerStarter;
import org.tio.http.server.handler.DefaultHttpRequestHandler;
import org.tio.http.server.intf.CurrUseridGetter;
import org.tio.http.server.intf.HttpServerInterceptor;
import org.tio.http.server.intf.ThrowableHandler;
import org.tio.http.server.mvc.Routes;
import org.tio.http.server.session.DomainSessionCookieDecorator;
import org.tio.http.server.session.HttpSessionListener;
import org.tio.http.server.session.SessionCookieDecorator;
import org.tio.http.server.stat.StatPathFilter;
import org.tio.http.server.stat.ip.path.IpPathAccessStatListener;
import org.tio.http.server.stat.ip.path.IpPathAccessStats;
import org.tio.http.server.stat.token.TokenGetter;
import org.tio.http.server.stat.token.TokenPathAccessStatListener;
import org.tio.http.server.stat.token.TokenPathAccessStats;
import org.tio.server.ServerTioConfig;
import org.tio.sitexxx.service.init.RedisInit;
import org.tio.sitexxx.service.service.conf.ConfService;
import org.tio.sitexxx.service.tio.TioSiteIpStatListener;
import org.tio.sitexxx.service.utils.LogUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.view.http.FreemarkerConfigurationCreater;
import org.tio.sitexxx.view.http.TioSiteViewThrowableHandler;
import org.tio.sitexxx.view.http.WebViewHttpServerInterceptor;
import org.tio.sitexxx.view.http.WebViewSessionRateLimiter;
import org.tio.sitexxx.web.server.auth.AccessCtrlConfig;
import org.tio.sitexxx.web.server.http.WebApiHttpSessionListener;
import org.tio.sitexxx.web.server.http.stat.TioSiteStatPathFilter;
import org.tio.sitexxx.web.server.http.stat.ip.TioSiteIpPathAccessStatListener;
import org.tio.sitexxx.web.server.http.stat.token.TioSiteCurrUseridGetter;
import org.tio.sitexxx.web.server.http.stat.token.TioSiteTokenGetter;
import org.tio.sitexxx.web.server.http.stat.token.TioSiteTokenPathAccessStatListener;
import org.tio.utils.Threads;
import org.tio.utils.cache.ICache;
import org.tio.utils.cache.caffeineredis.CaffeineRedisCache;
import org.tio.utils.jfinal.P;
import org.tio.utils.json.Json;
import org.tio.utils.resp.Resp;
import org.tio.webpack.model.Root;

public class WebViewInit {
    private static Logger log = LoggerFactory.getLogger(WebViewInit.class);
    public static HttpServerStarter httpServerStarter;
    public static ServerTioConfig serverTioConfig;
    public static HttpConfig httpConfig;
    public static Routes routes;
    public static DefaultHttpRequestHandler requestHandler;
    public static Integer maxLiveTimeOfStaticRes;
    public static int devMode;
    public static boolean isDevMode;

    public static void initWsBs(String pageRoot) {
        File wxbsDir = new File(pageRoot, "tx/ws/bs");
        Object[] files = wxbsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !"bs".equals(FileUtil.mainName((File)pathname));
            }
        });
        StringBuilder sb = new StringBuilder(512);
        sb.append("/*\r\n    \u6ce8\u610f\uff1a\r\n    1\u3001\u8be5\u6587\u4ef6\u5185\u5bb9\u4f1a\u81ea\u52a8\u5c06bs\u76ee\u5f55\u4e0b\u7684\u6587\u4ef6\u6dfb\u52a0\u8fdb\u6765\uff0c\u4e0d\u9700\u8981\u624b\u52a8\u6dfb\u52a0\r\n    2\u3001\u4e0d\u8981\u5728bs\u76ee\u5f55\u653e\u547d\u4ee4\u6267\u884c\u51fd\u6570\u4ee5\u5916\u7684\u6587\u4ef6\r\n*/\r\n");
        if (ArrayUtil.isNotEmpty((Object[])files)) {
            for (int i = 0; i < files.length; ++i) {
                Object file = files[i];
                sb.append("<#include \"/tx/ws/bs/").append(FileUtil.getName((File)file)).append("\" >").append("\r\n\r\n");
            }
        }
        FileUtil.writeUtf8String((String)sb.toString(), (File)new File(pageRoot, "tx/ws/bs.js"));
    }

    public static void init(Root model, ModelGenerator modelGenerator) throws Exception {
        Integer max_length_of_post_body;
        Integer max_length_of_multi_body;
        devMode = P.getInt((String)"dev.mode", (Integer)3);
        String pageRoot = P.get((String)"http.view.page", null);
        WebViewInit.initWsBs(pageRoot);
        LogUtils.logJvmStartTime((String)(WebViewInit.class.getName() + ".initWsBs()"));
        int port = P.getInt((String)"http.view.port");
        long sessionTimeout = P.getLong((String)"http.session.timeout", (Long)1800L);
        String contextpath = P.get((String)"http.view.contextpath", (String)"");
        String suffix = P.get((String)"http.view.suffix", (String)"");
        httpConfig = new HttpConfig(Integer.valueOf(port), Long.valueOf(sessionTimeout), contextpath, suffix);
        httpConfig.setSessionCacheName(P.get((String)"http.session.cache.name", (String)"tio-h-s"));
        httpConfig.setPageRoot(pageRoot);
        httpConfig.setWelcomeFile("index.html");
        httpConfig.setAppendRequestHeaderString(true);
        httpConfig.setPage404(P.get((String)"http.view.page404", (String)"/p400/404.html"));
        httpConfig.setPage500(P.get((String)"http.view.page500", (String)"/p500/500.html"));
        maxLiveTimeOfStaticRes = null;
        if (devMode == 1) {
            maxLiveTimeOfStaticRes = -1;
            isDevMode = true;
        } else {
            maxLiveTimeOfStaticRes = devMode == 2 ? Integer.valueOf(30) : P.getInt((String)"http.maxLiveTimeOfStaticRes");
        }
        if (maxLiveTimeOfStaticRes != null) {
            httpConfig.setMaxLiveTimeOfStaticRes(maxLiveTimeOfStaticRes.intValue());
        }
        if ((max_length_of_multi_body = P.getInt((String)"http.max_length_of_multi_body")) != null) {
            httpConfig.setMaxLengthOfMultiBody(max_length_of_multi_body * 1024);
        }
        if ((max_length_of_post_body = P.getInt((String)"http.max_length_of_post_body")) != null) {
            httpConfig.setMaxLengthOfPostBody(max_length_of_post_body * 1024);
        }
        byte[] bs = Json.toJson((Object)Resp.fail((String)"Your IP is on the blacklist")).getBytes();
        httpConfig.setRespForBlackIp(new HttpResponse(null, bs));
        httpConfig.setSessionRateLimiter((SessionRateLimiter)WebViewSessionRateLimiter.me);
        httpConfig.setProxied(P.getBoolean((String)"http.isproxied", (Boolean)false).booleanValue());
        requestHandler = new DefaultHttpRequestHandler(httpConfig, routes);
        requestHandler.setCompatibilityAssignment(false);
        String[] suffixes = StrUtil.split((CharSequence)P.get((String)"freemarker.suffix", (String)""), (CharSequence)"|");
        FreemarkerConfig freemarkerConfig = new FreemarkerConfig(httpConfig, modelGenerator, suffixes, (ConfigurationCreater)FreemarkerConfigurationCreater.me);
        String skipFkPathStr = ConfService.getString((String)"web.view.skip.fk", (String)"");
        if (StrUtil.isNotBlank((CharSequence)skipFkPathStr)) {
            String[] skipFkPathArray = StrUtil.split((CharSequence)skipFkPathStr, (CharSequence)";");
            StrUtil.trim((String[])skipFkPathArray);
            Collections.addAll(freemarkerConfig.getSkipPaths(), skipFkPathArray);
        }
        LogUtils.logJvmStartTime((String)(WebViewInit.class.getName() + ": ConfService.getString(\"web.view.skip.fk\", \"\")"));
        String cookieDomain = P.get((String)"http.cookie.domain");
        DomainSessionCookieDecorator domainSessionCookieDecorator = new DomainSessionCookieDecorator(cookieDomain);
        requestHandler.setSessionCookieDecorator((SessionCookieDecorator)domainSessionCookieDecorator);
        int workerid = P.getInt((String)"uuid.workerid");
        int datacenter = P.getInt((String)"uuid.datacenter");
        SnowflakeSessionIdGenerator sessionIdGenerator = new SnowflakeSessionIdGenerator(workerid, datacenter);
        httpConfig.setSessionIdGenerator((ISessionIdGenerator)sessionIdGenerator);
        httpConfig.setSessionCookieName(Const.Http.SESSION_COOKIE_NAME);
        CaffeineRedisCache caffeineRedisCache = CaffeineRedisCache.register((RedissonClient)RedisInit.get(), (String)httpConfig.getSessionCacheName(), null, (Long)sessionTimeout);
        httpConfig.setSessionStore((ICache)caffeineRedisCache);
        requestHandler.setThrowableHandler((ThrowableHandler)TioSiteViewThrowableHandler.ME);
        requestHandler.setHttpSessionListener((HttpSessionListener)WebApiHttpSessionListener.ME);
        LogUtils.logJvmStartTime((String)(WebViewInit.class.getName() + "\uff1arequestHandler.setHttpSessionListener(WebApiHttpSessionListener.ME)"));
        WebViewHttpServerInterceptor.me.setModel(model);
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AccessCtrlConfig accessCtrlConfig = new AccessCtrlConfig("access-url-role-view.properties", httpConfig.getStaticPaths(), true);
                LogUtils.logJvmStartTime((String)(WebViewInit.class.getName() + "\uff1aAccessCtrlConfig accessCtrlConfig = new AccessCtrlConfig("));
                WebViewHttpServerInterceptor.me.setAccessCtrlConfig(accessCtrlConfig);
                requestHandler.setHttpServerInterceptor((HttpServerInterceptor)WebViewHttpServerInterceptor.me);
            }
        });
        LogUtils.logJvmStartTime((String)(WebViewInit.class.getName() + "\uff1arequestHandler.setHttpServerInterceptor"));
        httpConfig.setName("Web-View");
        httpServerStarter = new HttpServerStarter(httpConfig, (HttpRequestHandler)requestHandler, Threads.getTioExecutor(), Threads.getGroupExecutor());
        httpServerStarter.getTioServer().setCheckLastVersion(P.getBoolean((String)"tio.setCheckLastVersion", (Boolean)false).booleanValue());
        serverTioConfig = httpServerStarter.getServerTioConfig();
        serverTioConfig.setName("Tio-Site View HttpServer");
        serverTioConfig.setReadBufferSize(P.getInt((String)"http.view.readbuffersize", (Integer)1024).intValue());
        serverTioConfig.setIpStatListener((IpStatListener)TioSiteIpStatListener.web_view);
        WebViewInit.serverTioConfig.ipStats.addDurations(Const.IpStatDuration.IPSTAT_DURATIONS);
        WebViewInit.serverTioConfig.logWhenDecodeError = P.getBoolean((String)"http.view.logWhenDecodeError", (Boolean)false);
        IpPathAccessStats ipPathAccessStats = new IpPathAccessStats((StatPathFilter)TioSiteStatPathFilter.me, (TioConfig)serverTioConfig, (IpPathAccessStatListener)TioSiteIpPathAccessStatListener.ME_SITE_VIEW, Const.IpPathAccessStatDuration.IP_PATH_ACCESS_STAT_DURATIONS);
        requestHandler.setIpPathAccessStats(ipPathAccessStats);
        TokenPathAccessStats tokenPathAccessStats = new TokenPathAccessStats((StatPathFilter)TioSiteStatPathFilter.me, (TokenGetter)TioSiteTokenGetter.me, (CurrUseridGetter)TioSiteCurrUseridGetter.me, (TioConfig)serverTioConfig, (TokenPathAccessStatListener)TioSiteTokenPathAccessStatListener.ME_SITE_VIEW, Const.TokenPathAccessStatDuration.TOKEN_PATH_ACCESS_STAT_DURATIONS);
        requestHandler.setTokenPathAccessStats(tokenPathAccessStats);
        LogUtils.logJvmStartTime((String)(WebViewInit.class.getName() + "\uff1arequestHandler.setTokenPathAccessStats(tokenPathAccessStats)"));
        httpServerStarter.start(P.getInt((String)"view.preAccess", (Integer)1) == 1);
        LogUtils.logJvmStartTime((String)(WebViewInit.class.getName() + "\uff1ahttpServerStarter.start(P.getInt"));
    }

    public static void main(String[] args) {
        Object[] sss = StrUtil.split((CharSequence)"txt|js|css|html|htm|json|xml", (CharSequence)"|");
        System.out.println(Arrays.toString(sss));
        boolean xx = ArrayUtil.contains((Object[])sss, (Object)"txt");
        System.out.println(xx);
    }

    static {
        routes = null;
        maxLiveTimeOfStaticRes = 0;
        devMode = 1;
        isDevMode = false;
    }
}

