/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.view.http;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.RequestLine;
import org.tio.http.common.view.ModelGenerator;
import org.tio.sitexxx.view.annotaion.ModelGeneratorPath;
import org.tio.sitexxx.view.http.pathmodel.PathModelGenerator;
import org.tio.utils.hutool.ClassScanAnnotationHandler;
import org.tio.utils.hutool.ClassScanHandler;
import org.tio.utils.hutool.ClassUtil;
import org.tio.utils.json.Json;

public class WebViewModelGenerator
implements ModelGenerator {
    private static Logger log = LoggerFactory.getLogger(WebViewModelGenerator.class);
    private Map<Object, Object> mapModel;
    public Map<String, PathModelGenerator> generatorMap = new HashMap<String, PathModelGenerator>();
    public Map<String, Class<?>> pathClassMap = new TreeMap();

    public WebViewModelGenerator(Map<Object, Object> mapModel, String[] scanPackages) {
        this.mapModel = mapModel;
        if (scanPackages != null) {
            for (String pkg : scanPackages) {
                try {
                    ClassUtil.scanPackage((String)pkg, (ClassScanHandler)new ClassScanAnnotationHandler(ModelGeneratorPath.class){

                        public void handlerAnnotation(Class<?> clazz) {
                            try {
                                String[] pathes;
                                Object bean = clazz.newInstance();
                                if (!(bean instanceof PathModelGenerator)) {
                                    log.error("{}\u6ca1\u6709\u5b9e\u73b0 {}", (Object)clazz.getName(), (Object)PathModelGenerator.class.getName());
                                    return;
                                }
                                PathModelGenerator pathModelGenerator = (PathModelGenerator)bean;
                                ModelGeneratorPath mapping = clazz.getAnnotation(ModelGeneratorPath.class);
                                for (String path : pathes = mapping.value()) {
                                    PathModelGenerator obj = WebViewModelGenerator.this.generatorMap.get(path);
                                    if (obj != null) {
                                        log.error("mapping[{}] already exists in class [{}]", (Object)path, (Object)obj.getClass().getName());
                                        continue;
                                    }
                                    WebViewModelGenerator.this.generatorMap.put(path, pathModelGenerator);
                                    WebViewModelGenerator.this.pathClassMap.put(path, clazz);
                                }
                            }
                            catch (Exception e) {
                                log.error(clazz.getName(), (Throwable)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
            log.warn("command mapping\r\n{}", (Object)Json.toFormatedJson(this.pathClassMap));
        }
    }

    public Object generate(HttpRequest request) throws Exception {
        HttpResponse response;
        RequestLine requestLine = request.getRequestLine();
        String path = requestLine.getPath();
        String ext = FileUtil.extName((String)path);
        if (!"css".equalsIgnoreCase(ext) && !"js".equalsIgnoreCase(ext) && !"html".equalsIgnoreCase(ext) && StrUtil.endWith((CharSequence)path, (CharSequence)"/")) {
            return this.mapModel;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.putAll(this.mapModel);
        PathModelGenerator pathModelGenerator = this.generatorMap.get(path);
        if (pathModelGenerator != null && (response = pathModelGenerator.generate(request, path, map)) != null) {
            return response;
        }
        return map;
    }

    public static void main(String[] args) {
    }
}

