/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.view.http;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.session.limiter.SessionRateLimiter;
import org.tio.http.common.session.limiter.SessionRateVo;
import org.tio.sitexxx.service.service.conf.IpWhiteListService;
import org.tio.utils.SystemTimer;
import org.tio.utils.hutool.FileUtil;

public class WebViewSessionRateLimiter
implements SessionRateLimiter {
    private static Logger log = LoggerFactory.getLogger(WebViewSessionRateLimiter.class);
    public static final WebViewSessionRateLimiter me = new WebViewSessionRateLimiter();
    private final Map<String, Integer> allowCountMap = new HashMap<String, Integer>();
    private final Map<String, Integer> extAllowCountMap = new HashMap<String, Integer>();
    private final Map<String, Integer> map = new HashMap<String, Integer>();
    private final int DEFAULT_JS_ALLOW_COUNT = 50;
    private final int DEFAULT_CSS_ALLOW_COUNT = 50;
    private final int DEFAULT_OTHER_ALLOW_COUNT = 30;
    private final int DEFAULT_HTML_ALLOW_COUNT = 40;
    private HttpResponse response;

    private WebViewSessionRateLimiter() {
        this.map.put("/blog/r/blog-view-onlyhtml.html", 20);
        this.extAllowCountMap.put("html", 40);
        this.extAllowCountMap.put("js", 50);
        this.extAllowCountMap.put("css", 50);
        this.response = new HttpResponse();
        try {
            this.response.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.TEXT_HTML_HTML);
            this.response.setBody("\u64cd\u4f5c\u8fc7\u5feb\uff0c\u8bf7\u7a0d\u540e\u518d\u64cd\u4f5c".getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
        }
        this.response.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.TEXT_PLAIN_JSON);
    }

    public boolean allow(HttpRequest request, SessionRateVo sessionRateVo) {
        String ext;
        if (IpWhiteListService.isWhiteIp((String)request.getClientIp())) {
            return true;
        }
        String path = request.getRequestLine().getPath();
        Integer allowCount = this.allowCountMap.get(path);
        if (allowCount == null && (allowCount = this.extAllowCountMap.get(ext = FileUtil.extName((String)path))) == null) {
            allowCount = 30;
        }
        if (sessionRateVo.getAccessCount().get() > allowCount) {
            return false;
        }
        Integer iv = this.map.get(path);
        return iv == null || SystemTimer.currTime - sessionRateVo.getLastAccessTime() >= (long)iv.intValue();
    }

    public HttpResponse response(HttpRequest request, SessionRateVo sessionRateVo) {
        return this.response;
    }
}

