/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.common;

import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.intf.Packet;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.WsResponseExt;
import org.tio.sitexxx.im.common.bs.base.Base;
import org.tio.utils.json.Json;
import org.tio.utils.lock.LockUtils;
import org.tio.websocket.common.Opcode;

public class ImPacket
extends Packet {
    private static final long serialVersionUID = 4910397844111262804L;
    private static Logger log = LoggerFactory.getLogger(ImPacket.class);
    public static final byte HEARTBEAT_BYTE = -128;
    public static final byte HANDSHAKE_BYTE = -127;
    public static final byte VERSION = 1;
    public static final byte[] BYTES_X = new byte[2];
    public static final int MAX_LENGTH_OF_BODY = 0x219999;
    public static final int LEAST_HEADER_LENGTH = 5;
    private byte[] body;
    private String bodyStr;
    private Object bodyObj;
    private Command command = null;
    private WsResponseExt wsPacket = null;

    public String toString() {
        return "ImPacket [bodyStr=" + this.bodyStr + ", command=" + (Object)((Object)this.command) + "]";
    }

    public static void main(String[] args) {
        String str = String.format("%05d", (byte)1);
        System.out.println("" + str);
    }

    public ImPacket() {
    }

    public ImPacket(Command command) {
        this();
        this.setCommand(command);
    }

    public ImPacket(Command command, byte[] body) {
        this(command);
        this.body = body;
    }

    public ImPacket(Command command, Object bodyObj) {
        this(command);
        this.bodyObj = bodyObj;
    }

    public ImPacket(Command command, String bodyStr) {
        this(command);
        this.bodyStr = bodyStr;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyStr() {
        return this.bodyStr;
    }

    public Command getCommand() {
        return this.command;
    }

    public WsResponseExt toWs() {
        if (this.wsPacket != null) {
            return this.wsPacket;
        }
        try {
            LockUtils.runWriteOrWaitRead((String)(((Object)((Object)this)).hashCode() + ""), (Object)((Object)this), () -> {
                String commandStr;
                if (this.wsPacket != null) {
                    return;
                }
                short commandValue = this.command.getValue();
                String text = commandStr = String.format("%05d", commandValue);
                if (StrUtil.isNotBlank((CharSequence)this.bodyStr)) {
                    text = text + this.bodyStr;
                } else if (this.bodyObj != null) {
                    text = text + Json.toJson((Object)this.bodyObj);
                }
                WsResponseExt wsResponse = new WsResponseExt();
                boolean isZipped = false;
                try {
                    byte[] bodyBytes = text.getBytes("utf-8");
                    if (bodyBytes.length > 300) {
                        try {
                            byte[] gzipedbody = ZipUtil.gzip((byte[])bodyBytes);
                            if (gzipedbody.length < bodyBytes.length) {
                                log.info("{}, \u538b\u7f29\u524d:{}, \u538b\u7f29\u540e:{}", new Object[]{this.command, bodyBytes.length, gzipedbody.length});
                                bodyBytes = gzipedbody;
                                isZipped = true;
                                wsResponse.setBodys(new byte[][]{BYTES_X, bodyBytes});
                                wsResponse.setBody(null);
                            }
                        }
                        catch (Throwable e) {
                            log.error(e.getMessage(), e);
                        }
                    }
                    if (!isZipped) {
                        wsResponse.setBody(bodyBytes);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    log.error("", (Throwable)e);
                }
                wsResponse.setWsOpcode(Opcode.BINARY);
                wsResponse.setInitPacket(this);
                this.wsPacket = wsResponse;
            });
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return this.wsPacket;
    }

    public String logstr() {
        if (this.command != null) {
            return "impacket: command\u3010" + this.command.name() + "\u3011";
        }
        return null;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setBodyStr(String bodyStr) {
        this.bodyStr = bodyStr;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public Object getBodyObj() {
        return this.bodyObj;
    }

    public void setBodyObj(Base bodyObj) {
        this.bodyObj = bodyObj;
    }

    static {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.putChar('x');
        byteBuffer.flip();
        byteBuffer.get(BYTES_X);
    }
}

