/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.Week;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.server.ServerTioConfig;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.ImSessionContext;
import org.tio.sitexxx.im.common.bs.wx.WxHandshakeResp;
import org.tio.sitexxx.im.server.TioSiteImServerStarter;
import org.tio.sitexxx.im.server.utils.ImUtils;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.GroupStat;
import org.tio.sitexxx.service.vo.LoadData;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;

public class Ims {
    private static Logger log = LoggerFactory.getLogger(Ims.class);
    static final int multiple4Real = 1;
    static final int multiple4Robot = 1;
    static final Map<Integer, Integer> ROBOT_HOUR_COUNT_MAP = new HashMap<Integer, Integer>();

    public static void main(String[] args) {
        Date date = new Date();
        int hour = DateUtil.hour((Date)date, (boolean)true);
        int step = ROBOT_HOUR_COUNT_MAP.get(hour);
        System.out.println(step);
    }

    public static void send(ChannelContext channelContext, ImPacket imPacket) {
        Tio.send((ChannelContext)channelContext, (Packet)imPacket);
    }

    public static void sendHandshake(ChannelContext channelContext) {
        ImSessionContext imSessionContext = ImUtils.getImSessionContext((ChannelContext)channelContext);
        ImPacket handshakeRespPacket = null;
        if (!imSessionContext.isWx()) {
            Tio.remove((ChannelContext)channelContext, (String)"\u4e0d\u652f\u6301\u975ewx\u63e1\u624b");
            return;
        }
        WxHandshakeResp handshakeResp = new WxHandshakeResp();
        handshakeResp.setCid(channelContext.getId());
        handshakeRespPacket = new ImPacket(Command.WxHandshakeResp, (Object)handshakeResp);
        Ims.send(channelContext, handshakeRespPacket);
    }

    public static void sendToGroup(String groupid, ImPacket imPacket) {
        Tio.sendToGroup((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)groupid, (Packet)imPacket);
    }

    public static void sendToGroup(Long groupid, ImPacket imPacket) {
        Tio.sendToGroup((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)groupid.toString(), (Packet)imPacket);
    }

    public static void sendToUser(String userid, ImPacket imPacket) {
        Tio.sendToUser((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)userid, (Packet)imPacket);
    }

    public static void sendToUser(Integer userid, ImPacket imPacket) {
        Ims.sendToUser("" + userid, imPacket);
    }

    public static boolean isInGroup(String group, ChannelContext channelContext) {
        return Tio.isInGroup((String)group, (ChannelContext)channelContext);
    }

    public static void sendToToken(String token, ImPacket imPacket) {
        Tio.sendToToken((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)token, (Packet)imPacket);
    }

    public static int getIpCount() {
        return TioSiteImServerStarter.serverTioConfigWs.ips.getIpmap().size();
    }

    public static void sendToIp(String ip, ImPacket imPacket) {
        Tio.sendToIp((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)ip, (Packet)imPacket);
    }

    public static void sendToId(String channelContextId, ImPacket imPacket) {
        Tio.sendToId((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)channelContextId, (Packet)imPacket);
    }

    public static int groupCount(String group) {
        int c1 = Tio.groupCount((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)group);
        return c1;
    }

    public static ChannelContext getByCid(String cid) {
        return Tio.getByChannelContextId((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)cid);
    }

    public static int groupCount(Devicetype devicetype, String group) {
        int c1 = Tio.groupCount((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)group);
        return c1;
    }

    public static ServerTioConfig getServerTioConfig(Devicetype devicetype) {
        if (devicetype == Devicetype.PC) {
            return TioSiteImServerStarter.serverTioConfigWs;
        }
        if (devicetype == Devicetype.ANDROID || devicetype == Devicetype.IOS) {
            return TioSiteImServerStarter.serverTioConfigApp;
        }
        return null;
    }

    public static void sendToAll(ImPacket imPacket) {
        Tio.sendToAll((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (Packet)imPacket);
    }

    public static LoadData createLoadData() {
        LoadData loadData = new LoadData();
        loadData.setPcCount(TioSiteImServerStarter.serverTioConfigWs.connections.size());
        return loadData;
    }

    public static GroupStat createGroupStat(String group) {
        int maxRealOnlineInCache = 0;
        int maxCalcOnlineInCache = 0;
        ICache groupStatCache = Caches.getCache((CacheConfig)CacheConfig.GROUP_STAT);
        GroupStat groupStat = (GroupStat)groupStatCache.get(group, GroupStat.class);
        if (groupStat != null) {
            maxRealOnlineInCache = groupStat.getMaxRealOnline();
            maxCalcOnlineInCache = groupStat.getMaxCalcOnline();
        }
        groupStat = Ims.createGroupStat1(group);
        groupStat.setMaxRealOnline(Math.max(maxRealOnlineInCache, groupStat.getMaxRealOnline()));
        groupStat.setMaxCalcOnline(Math.max(maxCalcOnlineInCache, groupStat.getMaxCalcOnline()));
        groupStatCache.put(group, (Serializable)groupStat);
        return groupStat;
    }

    private static GroupStat createGroupStat1(String group) {
        GroupStat groupStat = new GroupStat();
        int pcOnlineWithRobot = Ims.groupCount(Devicetype.PC, "_$x-__" + Devicetype.PC + group);
        int realPcOnline = Ims.groupCount(Devicetype.PC, "_$x-__real_" + Devicetype.PC + group);
        int androidOnlineWithRobot = Ims.groupCount(Devicetype.ANDROID, "_$x-__" + Devicetype.ANDROID + group);
        int realAndroidOnline = Ims.groupCount(Devicetype.ANDROID, "_$x-__real_" + Devicetype.ANDROID + group);
        int iosOnlineWithRobot = Ims.groupCount(Devicetype.IOS, "_$x-__" + Devicetype.IOS + group);
        int realIosOnline = Ims.groupCount(Devicetype.IOS, "_$x-__real_" + Devicetype.IOS + group);
        int countWithRobot = pcOnlineWithRobot + androidOnlineWithRobot + iosOnlineWithRobot;
        int realCount = realPcOnline + realAndroidOnline + realIosOnline;
        int online = Ims.groupCount(Devicetype.PC, group);
        int calcOnline = realPcOnline * 1 + realAndroidOnline * 1 + realIosOnline * 1 + (countWithRobot - realCount) * 1;
        calcOnline = online;
        ICache cache = Caches.getCache((CacheConfig)CacheConfig.TIME_TO_LIVE_MINUTE_5_LOCAL);
        String key = "LIVESTAT.XX";
        Integer step = (Integer)CacheUtils.get((ICache)cache, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<Integer>(){

            public Integer create() {
                Date date = new Date();
                int hour = DateUtil.hour((Date)date, (boolean)true);
                int step = ROBOT_HOUR_COUNT_MAP.get(hour);
                Week week = DateUtil.dayOfWeekEnum((Date)date);
                if (week == Week.SUNDAY || week == Week.SATURDAY) {
                    step -= 5;
                }
                if (step < 0) {
                    step = 0;
                }
                return step;
            }
        });
        int maxRealOnline = realCount;
        int maxCalcOnline = calcOnline += step.intValue();
        groupStat.setPcOnline(realPcOnline);
        groupStat.setAndroidOnline(realAndroidOnline);
        groupStat.setCalcOnline(calcOnline);
        groupStat.setIosOnline(realIosOnline);
        groupStat.setMaxCalcOnline(maxCalcOnline);
        groupStat.setMaxRealOnline(maxRealOnline);
        return groupStat;
    }

    static {
        ROBOT_HOUR_COUNT_MAP.put(0, 10);
        ROBOT_HOUR_COUNT_MAP.put(1, 10);
        ROBOT_HOUR_COUNT_MAP.put(2, 10);
        ROBOT_HOUR_COUNT_MAP.put(3, 10);
        ROBOT_HOUR_COUNT_MAP.put(4, 10);
        ROBOT_HOUR_COUNT_MAP.put(5, 10);
        ROBOT_HOUR_COUNT_MAP.put(6, 10);
        ROBOT_HOUR_COUNT_MAP.put(7, 30);
        ROBOT_HOUR_COUNT_MAP.put(8, 30);
        ROBOT_HOUR_COUNT_MAP.put(9, 40);
        ROBOT_HOUR_COUNT_MAP.put(10, 40);
        ROBOT_HOUR_COUNT_MAP.put(11, 40);
        ROBOT_HOUR_COUNT_MAP.put(12, 40);
        ROBOT_HOUR_COUNT_MAP.put(13, 40);
        ROBOT_HOUR_COUNT_MAP.put(14, 40);
        ROBOT_HOUR_COUNT_MAP.put(15, 40);
        ROBOT_HOUR_COUNT_MAP.put(16, 40);
        ROBOT_HOUR_COUNT_MAP.put(17, 40);
        ROBOT_HOUR_COUNT_MAP.put(18, 40);
        ROBOT_HOUR_COUNT_MAP.put(19, 40);
        ROBOT_HOUR_COUNT_MAP.put(20, 40);
        ROBOT_HOUR_COUNT_MAP.put(21, 40);
        ROBOT_HOUR_COUNT_MAP.put(22, 30);
        ROBOT_HOUR_COUNT_MAP.put(23, 30);
        ROBOT_HOUR_COUNT_MAP.put(24, 10);
    }
}

