/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.http.common.HttpRequest;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.ImSessionContext;
import org.tio.sitexxx.im.common.bs.HandshakeReq;
import org.tio.sitexxx.im.common.utils.ImUtils;
import org.tio.sitexxx.im.server.Ims;
import org.tio.sitexxx.im.server.handler.AbsImServerHandler;
import org.tio.sitexxx.im.server.handler.wx.WxChatApi;
import org.tio.sitexxx.im.server.handler.wx.call.WxCallUtils;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.ChatroomJoinLeave;
import org.tio.sitexxx.service.model.main.IpInfo;
import org.tio.sitexxx.service.model.main.LoginLog;
import org.tio.sitexxx.service.model.main.UserAgent;
import org.tio.sitexxx.service.model.main.WxChatUserItem;
import org.tio.sitexxx.service.model.main.WxJpushUser;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.base.LoginLogService;
import org.tio.sitexxx.service.service.chat.ChatIndexService;
import org.tio.sitexxx.service.service.chat.SynService;
import org.tio.sitexxx.service.utils.PeriodUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.MobileInfo;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.utils.cache.ICache;
import org.tio.utils.json.Json;
import org.tio.websocket.common.util.Md5;

@CommandHandler(value=Command.WxHandshakeReq)
public class WxHandshakeReqHandler
extends AbsImServerHandler {
    private static Logger log = LoggerFactory.getLogger(WxHandshakeReqHandler.class);
    public static final WxHandshakeReqHandler me = new WxHandshakeReqHandler();

    @Override
    public boolean needLogin() {
        return false;
    }

    @Override
    public void handler(ImPacket packet, ChannelContext channelContext, boolean isWebsocket, User curr, SimpleUser currSimpleUser) throws Exception {
        Byte exist;
        ImSessionContext imSessionContext = ImUtils.getImSessionContext((ChannelContext)channelContext);
        imSessionContext.setWx(true);
        HandshakeReq handshakeReq = null;
        handshakeReq = isWebsocket ? (HandshakeReq)packet.getBodyObj() : (HandshakeReq)Json.toBean((String)packet.getBodyStr(), HandshakeReq.class);
        String token = handshakeReq.getToken();
        MobileInfo mobileInfo = handshakeReq.getMobileInfo();
        Devicetype devicetype = null;
        if (token == null) {
            token = "";
        }
        if (isWebsocket) {
            devicetype = Devicetype.PC;
        } else {
            mobileInfo = handshakeReq.getMobileInfo();
            String version = mobileInfo.getAppversion();
            String imei = mobileInfo.getImei();
            String deviceinfo = mobileInfo.getDeviceinfo();
            String cid = mobileInfo.getCid();
            String sign = handshakeReq.getSign();
            Byte devicetypeValue = handshakeReq.getDevicetype();
            String mysign = null;
            boolean signOk = false;
            devicetype = Devicetype.from((Byte)devicetypeValue);
            mysign = Md5.getMD5((String)(token + imei + deviceinfo + devicetype.getValue() + (String)cid + "NdLyxD7o"));
            if (Objects.equals(sign, mysign)) {
                signOk = true;
                mobileInfo.setDevicetype(devicetypeValue);
                if (Objects.equals(devicetypeValue, Devicetype.IOS.getValue()) || Objects.equals(devicetypeValue, Devicetype.ANDROID.getValue())) {
                    mobileInfo.setFromApp(true);
                }
            }
            if (!signOk) {
                Tio.remove((ChannelContext)channelContext, (String)"\u63e1\u624b\u8fc7\u7a0b\u4e2d\uff0c\u9a8c\u7b7e\u5931\u8d25");
                return;
            }
        }
        User user = null;
        if (StrUtil.isNotBlank((CharSequence)token)) {
            Tio.unbindToken((ChannelContext)channelContext);
            Tio.bindToken((ChannelContext)channelContext, (String)token);
            user = ImUtils.getUser((String)token);
            if (user != null) {
                ICache cache;
                Long callId;
                String userid = user.getId();
                if (WxChatApi.isOutline(userid)) {
                    SynService.me.clearCluChatCache(userid);
                }
                Tio.bindUser((ChannelContext)channelContext, (String)(userid + ""));
                imSessionContext.setUid(userid);
                List userItems = ChatIndexService.me.getLinkActUserIndex(userid, Byte.valueOf((byte)2), Byte.valueOf((byte)1), Byte.valueOf((byte)1));
                if (CollUtil.isNotEmpty((Collection)userItems)) {
                    for (WxChatUserItem index : userItems) {
                        if (Objects.equals(index.getViewflag(), (byte)2)) continue;
                        Tio.bindGroup((ChannelContext)channelContext, (String)(index.getBizid() + ""));
                    }
                }
                if ((callId = (Long)(cache = Caches.getCache((CacheConfig)CacheConfig.WX_IS_CALLING)).get(user.getId() + "_" + devicetype, Long.class)) != null) {
                    WxCallUtils.endCall(channelContext, callId, user.getId(), (byte)7);
                    log.error("\u957f\u94fe\u63a5\u63e1\u624b\u53d1\u73b0\u672a\u65ad\u5f00\u89c6\u9891\u94fe\u63a5\u901a\u8bdd\uff1auid:{},callid\uff1a{}", (Object)userid, (Object)callId);
                }
                if (Const.JPushConfig.OPENFLAG && !isWebsocket && StrUtil.isNotBlank((CharSequence)handshakeReq.getJpushinfo())) {
                    WxJpushUser jpushUser = new WxJpushUser();
                    jpushUser.setUid(userid);
                    jpushUser.setRegid(handshakeReq.getJpushinfo());
                    jpushUser.replaceSave();
                }
            }
        }
        imSessionContext.setHandshakeReq(handshakeReq);
        if (imSessionContext.isHandshaked()) {
            ImUtils.rebindGroups((ChannelContext)channelContext);
        } else {
            User user1;
            SimpleUser may = null;
            if (user == null && (user1 = LoginLogService.me.selectLastLoginUser(token)) != null) {
                may = SimpleUser.fromUser((User)user1);
                ImUtils.completeSimpleUser((SimpleUser)may, (ChannelContext)channelContext);
            }
            ImUtils.setHandshakeUser((ChannelContext)channelContext, (User)user, may);
        }
        imSessionContext.setHandshaked(true);
        if (!isWebsocket) {
            Ims.sendHandshake(channelContext);
        } else {
            IpInfo ipinfo = IpInfoService.ME.save(channelContext.getClientNode().getIp());
            ChatroomJoinLeave chatroomJoinLeave = new ChatroomJoinLeave();
            chatroomJoinLeave.setDevice(devicetype.getValue());
            HttpRequest httpRequest = ImUtils.getImSessionContext((ChannelContext)channelContext).getWsSessionContext().getHandshakeRequest();
            chatroomJoinLeave.setGroupid(httpRequest.getParam("frompath"));
            if (StrUtil.isBlank((CharSequence)chatroomJoinLeave.getGroupid())) {
                chatroomJoinLeave.setGroupid("/h5/wx/index.html");
            }
            chatroomJoinLeave.setChat(true);
            chatroomJoinLeave.setIpid(ipinfo.getId());
            chatroomJoinLeave.setJointime(new Date());
            chatroomJoinLeave.setSession(ImUtils.getToken((ChannelContext)channelContext));
            chatroomJoinLeave.setUid(ImUtils.getUid((ChannelContext)channelContext));
            chatroomJoinLeave.setStatus(Byte.valueOf((byte)9));
            chatroomJoinLeave.setServer(Const.MY_IP);
            chatroomJoinLeave.save();
            imSessionContext.setChatroomJoinLeave(chatroomJoinLeave);
        }
        if (user != null && (exist = (Byte)Caches.getCache((CacheConfig)CacheConfig.WX_USER_LOGIN_TOKEN_1).get(token)) == null) {
            Caches.getCache((CacheConfig)CacheConfig.WX_USER_LOGIN_TOKEN_1).put(token, (Serializable)Byte.valueOf((byte)1));
            LoginLog loginLog = new LoginLog();
            Date time = new Date();
            IpInfo ipinfo = IpInfoService.ME.save(channelContext.getClientNode().getIp());
            loginLog.setIp(ipinfo.getIp());
            loginLog.setIpid(ipinfo.getId());
            loginLog.setSessionid(token);
            loginLog.setUid(user.getId());
            loginLog.setDevicetype(devicetype.getValue());
            loginLog.setTime(time);
            loginLog.setType(Byte.valueOf((byte)2));
            loginLog.setDayperiod(PeriodUtils.dateToPeriodByType((Date)time, (byte)1));
            loginLog.setTimeperiod(PeriodUtils.dateToPeriodByType((Date)time, (byte)7));
            loginLog.setHourperiod(PeriodUtils.dateToPeriodByType((Date)time, (byte)6));
            if (mobileInfo != null) {
                loginLog.setDeviceinfo("\u81ea-" + StringUtils.substring((String)mobileInfo.getDeviceinfo(), (int)0, (int)128));
                loginLog.setImei(mobileInfo.getImei());
                loginLog.setAppversion(mobileInfo.getAppversion());
            } else {
                UserAgent userAgent = currSimpleUser.getUserAgent();
                if (userAgent != null) {
                    if (userAgent.getId() != null) {
                        loginLog.setUaid(userAgent.getId());
                    }
                    loginLog.setDeviceinfo("\u81ea-" + userAgent.getOsName() + " " + userAgent.getOsVersion() + "/" + userAgent.getAgentName() + " " + userAgent.getAgentVersionMajor());
                } else {
                    loginLog.setDeviceinfo("\u81ea-userAgent\u9ed8\u8ba4\u7a7a");
                }
            }
            LoginLogService.me.add(loginLog);
        }
    }
}

