/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.bs.wx.WxWithdrawMsgNtf;
import org.tio.sitexxx.im.common.bs.wx.WxWithdrawMsgReq;
import org.tio.sitexxx.im.server.Ims;
import org.tio.sitexxx.im.server.handler.AbsImServerHandler;
import org.tio.sitexxx.im.server.utils.ImUtils;
import org.tio.sitexxx.service.model.main.WxFriendMsg;
import org.tio.sitexxx.service.model.main.WxGroupMsg;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.service.wx.WxFriendService;
import org.tio.sitexxx.service.service.wx.WxGroupService;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.utils.SystemTimer;
import org.tio.utils.json.Json;

@CommandHandler(value=Command.WxWithdrawMsgReq)
public class WxWithdrawMsgReqHandler
extends AbsImServerHandler {
    private static Logger log = LoggerFactory.getLogger(WxWithdrawMsgReqHandler.class);

    @Override
    public void handler(ImPacket packet, ChannelContext channelContext, boolean isWebsocket, User curr, SimpleUser currSimpleUser) throws Exception {
        boolean isGroupChat;
        WxWithdrawMsgReq wxWithdrawMsgReq = (WxWithdrawMsgReq)Json.toBean((String)packet.getBodyStr(), WxWithdrawMsgReq.class);
        Long mid = wxWithdrawMsgReq.getMid();
        Long groupid = wxWithdrawMsgReq.getG();
        String uid = null;
        Long time = null;
        WxGroupMsg wxGroupMsg = null;
        WxFriendMsg wxFriendMsg = null;
        boolean bl = isGroupChat = groupid != null;
        if (isGroupChat) {
            wxGroupMsg = (WxGroupMsg)WxGroupMsg.dao.findById((Object)mid);
            if (wxGroupMsg == null) {
                return;
            }
            uid = wxGroupMsg.getUid();
            time = wxGroupMsg.getTime().getTime();
        } else {
            wxFriendMsg = (WxFriendMsg)WxFriendMsg.dao.findById((Object)mid);
            if (wxFriendMsg == null) {
                return;
            }
            uid = wxFriendMsg.getUid();
            time = wxFriendMsg.getTime().getTime();
        }
        User user = UserService.ME.getById(uid);
        boolean isSelf = Objects.equals(uid, curr.getId());
        if (!UserService.isSuper((User)curr)) {
            if (isSelf) {
                if (SystemTimer.currTime - time > 120000L) {
                    ImUtils.info(channelContext, "\u6d88\u606f\u5df2\u8d85\u8fc7\u4e24\u5206\u949f\uff0c\u81ea\u5df1\u4e0d\u80fd\u64a4\u56de\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u64a4\u56de", null);
                    return;
                }
            } else {
                ImUtils.info(channelContext, "\u5c0f\u4f19\u5b50\uff0c\u8fd8\u60f3\u64a4\u522b\u4eba\u5bb6\u7684\u6d88\u606f", null);
                return;
            }
        }
        byte status = isSelf ? (byte)2 : 3;
        WxWithdrawMsgNtf wxWithdrawMsgNtf = new WxWithdrawMsgNtf();
        wxWithdrawMsgNtf.setMid(mid);
        wxWithdrawMsgNtf.setG(groupid);
        wxWithdrawMsgNtf.setOperUid(curr.getId());
        wxWithdrawMsgNtf.setUid(user.getId());
        ImPacket imPacket = new ImPacket(Command.WxWithdrawMsgNtf, (Object)wxWithdrawMsgNtf);
        if (isGroupChat) {
            WxGroupService.me.updateStatus(mid, status);
            Ims.sendToGroup(groupid, imPacket);
        } else {
            WxFriendService.me.updateStatus(mid, status, wxFriendMsg);
            Ims.sendToUser(wxFriendMsg.getUid(), imPacket);
            if (!Objects.equals(wxFriendMsg.getUid(), wxFriendMsg.getTouid())) {
                Ims.sendToUser(wxFriendMsg.getTouid(), imPacket);
            }
        }
    }
}

