/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx.chatitem;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.bs.wx.chatitem.WxSessionOperReq;
import org.tio.sitexxx.im.server.handler.AbsImServerHandler;
import org.tio.sitexxx.im.server.handler.wx.WxChatQueueApi;
import org.tio.sitexxx.im.server.utils.ImUtils;
import org.tio.sitexxx.service.model.main.IpInfo;
import org.tio.sitexxx.service.model.main.WxChatGroupItem;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.chat.ChatIndexService;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.utils.json.Json;

@CommandHandler(value=Command.WxSessionOperReq)
public class WxSessionOperReqHandler
extends AbsImServerHandler {
    private static Logger log = LoggerFactory.getLogger(WxSessionOperReqHandler.class);
    public static final WxSessionOperReqHandler me = new WxSessionOperReqHandler();

    @Override
    public boolean needLogin() {
        return true;
    }

    @Override
    public void handler(ImPacket packet, ChannelContext channelContext, boolean isWebsocket, User curr, SimpleUser currSimpleUser) throws Exception {
        WxSessionOperReq req = (WxSessionOperReq)Json.toBean((String)packet.getBodyStr(), WxSessionOperReq.class);
        Byte oper = req.getOper();
        if (Objects.equals((byte)2, oper)) {
            this.leave(channelContext, curr);
        } else if (Objects.equals((byte)1, oper)) {
            Long chatlinkid = req.getChatlinkid();
            if (chatlinkid == null) {
                ImUtils.info(channelContext, "\u4f1a\u8bddid\u4e3a\u7a7a", null);
                return;
            }
            this.join(channelContext, chatlinkid, curr);
        } else {
            ImUtils.info(channelContext, "\u65e0\u6548\u64cd\u4f5c", null);
            return;
        }
    }

    private void leave(ChannelContext channelContext, User curr) {
        Devicetype devicetype = ImUtils.getDevicetype((ChannelContext)channelContext);
        if (Objects.equals(devicetype.getValue(), Devicetype.IOS.getValue()) || Objects.equals(devicetype.getValue(), Devicetype.ANDROID.getValue())) {
            devicetype = Devicetype.APP;
        }
        WxChatQueueApi.leaveFocusQueue(curr, devicetype.getValue(), channelContext.getId());
    }

    private void join(ChannelContext channelContext, Long chatlinkid, User curr) {
        String uid = curr.getId();
        Byte chatmode = 1;
        Long groupid = null;
        if (chatlinkid <= 0L) {
            chatmode = 2;
            groupid = -chatlinkid.longValue();
            WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)uid, (Long)groupid);
            if (groupItem == null || groupItem.getChatlinkid() == null) {
                ImUtils.info(channelContext, "\u4f1a\u8bddid\u4e3a\u7a7a", null);
                return;
            }
            chatlinkid = groupItem.getChatlinkid();
        }
        Devicetype devicetype = ImUtils.getDevicetype((ChannelContext)channelContext);
        IpInfo ipInfo = IpInfoService.ME.save(channelContext.getClientNode().getIp());
        WxChatQueueApi.joinFocusQueue(channelContext, curr, chatlinkid, groupid, chatmode, devicetype.getValue(), ipInfo.getId());
    }
}

