/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import java.util.Date;
import java.util.Objects;

public class PeriodUtils {
    public static String dateToPeriodByType(Date date, byte periodType) {
        if (periodType == 9) {
            return "total";
        }
        String periodFormat = "yyyyMMdd";
        if (Objects.equals(periodType, (byte)4)) {
            periodFormat = periodFormat.substring(0, 4);
        } else if (Objects.equals(periodType, (byte)3)) {
            periodFormat = periodFormat.substring(0, 6);
        } else if (Objects.equals(periodType, (byte)2)) {
            date = DateUtil.beginOfWeek((Date)date);
        } else if (Objects.equals(periodType, (byte)5)) {
            date = DateUtil.beginOfQuarter((Date)date);
        } else if (Objects.equals(periodType, (byte)6)) {
            periodFormat = "HH";
        } else if (Objects.equals(periodType, (byte)7)) {
            periodFormat = "HH:mm";
        }
        String period = DateUtil.format((Date)date, (String)periodFormat);
        if (Objects.equals(periodType, (byte)2)) {
            period = period + "W";
        } else if (Objects.equals(periodType, (byte)5)) {
            period = period + "Q";
        }
        return period;
    }

    public static DateTime getDateByPeriod(String period) {
        int length = period.length();
        if (length == 5) {
            return new DateTime();
        }
        if (period.indexOf("W") >= 0) {
            period = period.substring(0, period.length() - 1);
        }
        if (period.indexOf("Q") >= 0) {
            period = period.substring(0, period.length() - 1);
        }
        if (period.length() == 4) {
            period = period + "0101";
        }
        if (period.length() == 6) {
            period = period + "01";
        }
        if (period.length() == 10) {
            period = period + "0000";
        }
        return DateUtil.parse((CharSequence)period);
    }

    public static int getDayByPeriodNum(Byte periodType, Integer num) {
        int result = num;
        switch (periodType) {
            case 1: {
                break;
            }
            case 2: {
                result = num * 7;
                break;
            }
            case 3: {
                result = num * 30;
                break;
            }
            case 5: {
                result = num * 90;
                break;
            }
            case 4: {
                result = num * 365;
                break;
            }
        }
        return result;
    }

    public static Date getCouponPeriod(Byte periodType, Integer num, Date date) {
        if (num <= 0) {
            num = 1;
        }
        if (date == null) {
            date = new DateTime();
        }
        DateTime result = null;
        switch (periodType) {
            case 1: {
                result = DateUtil.offsetDay((Date)date, (int)num);
                break;
            }
            case 2: {
                result = DateUtil.offsetWeek((Date)date, (int)num);
                break;
            }
            case 3: {
                result = DateUtil.offsetMonth((Date)date, (int)num);
                break;
            }
            case 5: {
                result = DateUtil.offsetMonth((Date)date, (int)(num * 3));
                break;
            }
            case 4: {
                result = DateUtil.offsetMonth((Date)date, (int)(num * 12));
                break;
            }
            default: {
                result = DateUtil.offsetDay((Date)date, (int)num);
            }
        }
        return result;
    }

    public static void main(String[] args) {
    }
}

