/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.cache;

import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.CacheType;
import org.tio.sitexxx.service.init.RedisInit;
import org.tio.sitexxx.service.vo.Const;
import org.tio.utils.cache.ICache;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.cache.caffeineredis.CaffeineRedisCache;
import org.tio.utils.cache.redis.RedisCache;

public class Caches {
    private static Logger log = LoggerFactory.getLogger(Caches.class);
    private static final String CACHE_PREFIX = "chat200301";
    public static final String SINGLE_KEY = "y";

    public static ICache getCache(CacheConfig cacheConfig) {
        String cacheName = CACHE_PREFIX + cacheConfig.getCacheName();
        CacheType cacheType = cacheConfig.getCacheType();
        RedisCache ret = null;
        switch (cacheType) {
            case REDIS: {
                ret = RedisCache.getCache((String)cacheName);
                break;
            }
            case CAFFEINE_REDIS: {
                ret = CaffeineRedisCache.getCache((String)cacheName);
                break;
            }
            case CAFFEINE: {
                ret = CaffeineCache.getCache((String)cacheName);
                break;
            }
            case CASE_1_2: {
                if (!Const.USE_TIO_CLU) {
                    ret = CaffeineCache.getCache((String)cacheName);
                    break;
                }
                ret = RedisCache.getCache((String)cacheName);
                break;
            }
            case CASE_1_12: {
                if (!Const.USE_TIO_CLU) {
                    ret = CaffeineCache.getCache((String)cacheName);
                    break;
                }
                ret = CaffeineRedisCache.getCache((String)cacheName);
                break;
            }
        }
        if (ret == null) {
            log.error("cacheName[{}]\u8fd8\u6ca1\u6ce8\u518c", (Object)cacheName);
        }
        return ret;
    }

    public static void init() {
        CacheConfig[] values;
        for (CacheConfig cacheConfig : values = CacheConfig.values()) {
            String cacheName = CACHE_PREFIX + cacheConfig.getCacheName();
            Long timeToLiveSeconds = cacheConfig.getTimeToLiveSeconds();
            Long timeToIdleSeconds = cacheConfig.getTimeToIdleSeconds();
            CacheType cacheType = cacheConfig.getCacheType();
            if (cacheType == CacheType.REDIS) {
                RedisCache.register((RedissonClient)RedisInit.get(), (String)cacheName, (Long)timeToLiveSeconds, (Long)timeToIdleSeconds);
                continue;
            }
            if (cacheType == CacheType.CAFFEINE_REDIS) {
                CaffeineRedisCache.register((RedissonClient)RedisInit.get(), (String)cacheName, (Long)timeToLiveSeconds, (Long)timeToIdleSeconds);
                continue;
            }
            if (cacheType == CacheType.CAFFEINE) {
                CaffeineCache.register((String)cacheName, (Long)timeToLiveSeconds, (Long)timeToIdleSeconds);
                continue;
            }
            if (cacheType == CacheType.CASE_1_2) {
                if (!Const.USE_TIO_CLU) {
                    CaffeineCache.register((String)cacheName, (Long)timeToLiveSeconds, (Long)timeToIdleSeconds);
                    continue;
                }
                RedisCache.register((RedissonClient)RedisInit.get(), (String)cacheName, (Long)timeToLiveSeconds, (Long)timeToIdleSeconds);
                continue;
            }
            if (cacheType != CacheType.CASE_1_12) continue;
            if (!Const.USE_TIO_CLU) {
                CaffeineCache.register((String)cacheName, (Long)timeToLiveSeconds, (Long)timeToIdleSeconds);
                continue;
            }
            CaffeineRedisCache.register((RedissonClient)RedisInit.get(), (String)cacheName, (Long)timeToLiveSeconds, (Long)timeToIdleSeconds);
        }
    }
}

