/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.init;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.plugin.activerecord.ActiveRecordPlugin;
import org.tio.jfinal.plugin.activerecord.IDataSourceProvider;
import org.tio.jfinal.plugin.activerecord.dialect.Dialect;
import org.tio.jfinal.plugin.druid.DruidPlugin;
import org.tio.jfinal.template.Engine;
import org.tio.jfinal.template.source.ClassPathSourceFactory;
import org.tio.jfinal.template.source.ISourceFactory;
import org.tio.sitexxx.service.init.PropInit;
import org.tio.sitexxx.service.jf.TioMysqlDialect;
import org.tio.utils.jfinal.P;

public class JFInit {
    private static Logger log = LoggerFactory.getLogger(JFInit.class);
    public static DruidPlugin[] plugins;
    public static int dbCount;
    public static String[] dbNames;

    public static void init() {
        PropInit.init();
        dbNames = P.get((String)"db.jdbc.multi.name").split(",");
        dbCount = dbNames.length;
        plugins = new DruidPlugin[dbCount];
        for (int i = 0; i < dbCount; ++i) {
            String dbName = dbNames[i];
            String jdbcUrl = P.get((String)(dbName + ".jdbc.url"));
            String jdbcUsername = P.get((String)(dbName + ".jdbc.username"));
            String jdbcPwd = P.get((String)(dbName + ".jdbc.password"));
            Integer jdbcPoolInitSize = P.getInt((String)"db.jdbc.pool.initialSize");
            Integer jdbcPoolMinIdle = P.getInt((String)"db.jdbc.pool.minIdle");
            Integer jdbcPoolMaxActive = P.getInt((String)"db.jdbc.pool.maxActive");
            DruidPlugin druidPlugin = new DruidPlugin(jdbcUrl, jdbcUsername, jdbcPwd);
            druidPlugin.set(jdbcPoolInitSize.intValue(), jdbcPoolMinIdle.intValue(), jdbcPoolMaxActive.intValue());
            druidPlugin.setFilters(P.get((String)"db.jdbc.filters", (String)"stat,wall"));
            druidPlugin.setValidationQuery(P.get((String)"db.jdbc.validationQuery"));
            druidPlugin.setDriverClass(P.get((String)"db.jdbc.driverClassName"));
            druidPlugin.setConnectionInitSql("set names utf8mb4");
            druidPlugin.start();
            JFInit.plugins[i] = druidPlugin;
            ActiveRecordPlugin arp = new ActiveRecordPlugin(dbName, (IDataSourceProvider)druidPlugin);
            arp.setDialect((Dialect)new TioMysqlDialect());
            arp.setTransactionLevel(2);
            arp.getConfig().getDialect().setKeepByteAndShort(true);
            try {
                String[] xx = dbName.split("_");
                Class.forName("org.tio.sitexxx.service.model." + xx[xx.length - 1] + "._MappingKit").getMethod("mapping", ActiveRecordPlugin.class).invoke(null, arp);
            }
            catch (Exception e) {
                log.error("\u52a0\u8f7d\u6570\u636e\u5e93\u6620\u5c04\u5173\u7cfb\u9519\u8bef");
            }
            arp.setShowSql(true);
            Engine engine = arp.getSqlKit().getEngine();
            engine.setBaseTemplatePath(null);
            engine.setSourceFactory((ISourceFactory)new ClassPathSourceFactory());
            arp.addSqlTemplate("sql/_all.sql");
            arp.start();
        }
    }
}

