/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.model.stat;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.TioConfig;
import org.tio.core.stat.IpStat;
import org.tio.sitexxx.service.model.main.IpInfo;
import org.tio.sitexxx.service.model.stat.base.BaseTioIpStat;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.vo.Const;
import org.tio.utils.lock.SetWithLock;

public class TioIpStat
extends BaseTioIpStat<TioIpStat> {
    public static final TioIpStat dao = (TioIpStat)new TioIpStat().dao();
    private static Logger log = LoggerFactory.getLogger(TioIpStat.class);

    public static TioIpStat from(TioConfig tioConfig, IpStat ipStat, Byte appType) {
        TioIpStat tioIpStat = new TioIpStat();
        SetWithLock setOfIp = tioConfig.ips.clients(tioConfig, ipStat.getIp());
        if (setOfIp != null) {
            tioIpStat.setActivatedCount(((Set)setOfIp.getObj()).size());
        } else {
            log.info("{}, {} \u5728ips\u5bf9\u8c61\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684SetWithLock", (Object)tioConfig.getName(), (Object)ipStat.getIp());
            tioIpStat.setActivatedCount(0);
        }
        IpInfo ipInfo = IpInfoService.ME.save(ipStat.getIp());
        tioIpStat.setAppType(appType);
        tioIpStat.setBytesPerTcpReceive(ipStat.getBytesPerTcpReceive());
        tioIpStat.setDecodeErrorCount(ipStat.getDecodeErrorCount().get());
        tioIpStat.setDuration(ipStat.getDuration());
        tioIpStat.setDurationType(ipStat.getDurationType());
        tioIpStat.setFormatedDuration(ipStat.getFormatedDuration());
        tioIpStat.setHandledBytes(ipStat.getHandledBytes().get());
        tioIpStat.setHandledPackets(ipStat.getHandledPackets().get());
        if (ipInfo != null) {
            tioIpStat.setIpid(ipInfo.getId());
        }
        tioIpStat.setReceivedBytes(ipStat.getReceivedBytes().get());
        tioIpStat.setReceivedPackets(ipStat.getReceivedPackets().get());
        tioIpStat.setReceivedTcps(ipStat.getReceivedTcps().get());
        tioIpStat.setRequestCount(ipStat.getRequestCount().get());
        tioIpStat.setSentBytes(ipStat.getSentBytes().get());
        tioIpStat.setSentPackets(ipStat.getSentPackets().get());
        tioIpStat.setServer(Const.MY_IP);
        tioIpStat.setStart(ipStat.getStart());
        tioIpStat.setPacketsPerTcpReceive(ipStat.getPacketsPerTcpReceive());
        return tioIpStat;
    }
}

