/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.conf.Area;
import org.tio.sitexxx.service.model.conf.Dict;
import org.tio.sitexxx.service.model.system.UserBase;
import org.tio.sitexxx.service.service.conf.AreaService;
import org.tio.sitexxx.service.service.conf.DictService;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;
import org.tio.utils.resp.Resp;

public class UserBaseService {
    private static Logger log = LoggerFactory.getLogger(UserBaseService.class);
    public static final UserBaseService me = new UserBaseService();
    final UserBase userBaseDao = (UserBase)new UserBase().dao();

    public UserBase getUserBaseByUid(final String uid) {
        ICache userbaseCache = Caches.getCache(CacheConfig.USERID_BASE);
        String key = uid + "";
        UserBase userBase1 = (UserBase)((Object)CacheUtils.get((ICache)userbaseCache, (String)key, (FirsthandCreater)new FirsthandCreater<UserBase>(){

            public UserBase create() {
                UserBase userBase = (UserBase)UserBaseService.this.userBaseDao.findFirst("select * from f_userinfo where user_code = ?", new Object[]{uid});
                if (userBase != null) {
                    Dict dict;
                    String position;
                    Dict dict2;
                    String industry;
                    Dict dict3;
                    String income;
                    Area area;
                    String areaCode = userBase.getArea();
                    if (StrUtil.isNotBlank((CharSequence)areaCode) && (area = AreaService.getParent(areaCode)) != null) {
                        ArrayList<String> areaNameList = new ArrayList<String>();
                        ArrayList<String> areaCodeList = new ArrayList<String>();
                        areaNameList.add(area.getName());
                        areaCodeList.add(area.getCode());
                        while (area.getParentArea() != null) {
                            area = area.getParentArea();
                            areaNameList.add(area.getName());
                            areaCodeList.add(area.getCode());
                        }
                        userBase.setAreas(areaNameList);
                        userBase.setAreacodes(areaCodeList);
                    }
                    if (StrUtil.isNotBlank((CharSequence)(income = userBase.getIncome())) && (dict3 = DictService.getDictByCode(income)) != null) {
                        userBase.setIncomeName(dict3.getName());
                    }
                    if (StrUtil.isNotBlank((CharSequence)(industry = userBase.getIndustry())) && (dict2 = DictService.getDictByCode(industry)) != null) {
                        userBase.setIndustryName(dict2.getName());
                    }
                    if (StrUtil.isNotBlank((CharSequence)(position = userBase.getPosition())) && (dict = DictService.getDictByCode(position)) != null) {
                        userBase.setPositionName(dict.getName());
                    }
                }
                return userBase;
            }
        }));
        return userBase1;
    }

    public Resp updateBase(UserBase userBase) {
        boolean isUpdate = userBase.update();
        if (!isUpdate) {
            return Resp.fail((String)"\u7528\u6237\u57fa\u7840\u4fe1\u606f\u4fee\u6539\u5931\u8d25");
        }
        Caches.getCache(CacheConfig.USERID_BASE).remove(userBase.getUid() + "");
        return Resp.ok((Object)"\u7528\u6237\u4fee\u6539\u6210\u529f.");
    }

    public static void main(String[] args) throws Exception {
    }
}

