/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.base;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.dfa.WordTree;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.jfinal.P;

public class SensitiveWordsService {
    private static Logger log = LoggerFactory.getLogger(SensitiveWordsService.class);
    public static final WordTree wordTree = new WordTree();

    public static void init() {
        String rootDirStr = FileUtil.getAbsolutePath((String)"classpath:config/sensitive/");
        File rootDir = new File(rootDirStr);
        if (!rootDir.exists()) {
            log.warn("\u6587\u4ef6[{}]\u4e0d\u5b58\u5728", (Object)rootDir.getAbsolutePath());
            return;
        }
        File[] files = rootDir.listFiles();
        int count = 0;
        if (files != null) {
            for (File file : files) {
                List lines = FileUtil.readLines((File)file, (String)"utf-8");
                for (String line : lines) {
                    wordTree.addWord(line);
                    ++count;
                }
            }
        }
        log.info("\u8bcd\u5e93\u4e2d\u4e00\u5171\u6709{}\u4e2a\u654f\u611f\u8bcd", (Object)count);
    }

    public static boolean isMatch(String text) {
        return wordTree.isMatch(text);
    }

    public static String findAndReplace(String initText, SensitiveWordsHandler sensitiveWordsHandler, Object logstr) {
        List list = wordTree.matchAll(initText);
        if (list != null && list.size() > 0) {
            String ret = initText;
            for (String word : list) {
                ret = sensitiveWordsHandler.replace(ret, word);
            }
            if (logstr != null) {
                log.error("{}, \u627e\u5230\u654f\u611f\u8bcd\uff0c\u539f\u6587:\u3010{}\u3011\uff0c\u66ff\u6362\u540e\u7684:\u3010{}\u3011", new Object[]{logstr, initText, ret});
            } else {
                log.error("\u627e\u5230\u654f\u611f\u8bcd\uff0c\u539f\u6587:\u3010{}\u3011\uff0c\u66ff\u6362\u540e\u7684:\u3010{}\u3011", (Object)initText, (Object)ret);
            }
            return ret;
        }
        return initText;
    }

    public static String findAndReplace(String initText, String replaceText) {
        return SensitiveWordsService.findAndReplaceWithLog(initText, replaceText, null);
    }

    public static String findAndReplaceWithLog(String initText, String replaceText, Object logstr) {
        List list = wordTree.matchAll(initText);
        if (list != null && list.size() > 0) {
            String ret = initText;
            for (String word : list) {
                String xx = StrUtil.repeat((CharSequence)replaceText, (int)word.length());
                ret = StrUtil.replace((CharSequence)ret, (CharSequence)word, (CharSequence)xx);
            }
            if (logstr != null) {
                log.warn("{}, \u627e\u5230\u654f\u611f\u8bcd\uff0c\u539f\u6587:\u3010{}\u3011\uff0c\u66ff\u6362\u540e\u7684:\u3010{}\u3011", new Object[]{logstr, initText, ret});
            } else {
                log.warn("\u627e\u5230\u654f\u611f\u8bcd\uff0c\u539f\u6587:\u3010{}\u3011\uff0c\u66ff\u6362\u540e\u7684:\u3010{}\u3011", (Object)initText, (Object)ret);
            }
            return ret;
        }
        return initText;
    }

    public static String findAndReplace(String initText) {
        return SensitiveWordsService.findAndReplace(initText, P.get((String)"sensitive.words.replace.text"));
    }

    public static String findAndReplaceWithLog(String initText, String logstr) {
        return SensitiveWordsService.findAndReplaceWithLog(initText, P.get((String)"sensitive.words.replace.text"), logstr);
    }

    private SensitiveWordsService() {
    }

    public static interface SensitiveWordsHandler {
        public String replace(String var1, String var2);
    }
}

