/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.base;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.MD5;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.redisson.api.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.init.RedisInit;
import org.tio.sitexxx.service.model.main.IpInfo;
import org.tio.sitexxx.service.model.main.LoginLog;
import org.tio.sitexxx.service.model.main.UserAddress;
import org.tio.sitexxx.service.model.main.UserInfoSyn;
import org.tio.sitexxx.service.model.main.UserThird;
import org.tio.sitexxx.service.model.main.UserThirdOsc;
import org.tio.sitexxx.service.model.main.UserlogModifyAvatar;
import org.tio.sitexxx.service.model.main.UserlogModifyNick;
import org.tio.sitexxx.service.model.stat.UserIpLoginStat;
import org.tio.sitexxx.service.model.stat.UserTimeLoginStat;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.model.system.UserBase;
import org.tio.sitexxx.service.service.UserBaseService;
import org.tio.sitexxx.service.service.atom.AbsAtom;
import org.tio.sitexxx.service.service.atom.AbsTxAtom;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.base.RoleService;
import org.tio.sitexxx.service.service.base.SensitiveWordsService;
import org.tio.sitexxx.service.service.base.UserRoleService;
import org.tio.sitexxx.service.service.base.UserThirdOscService;
import org.tio.sitexxx.service.service.base.UserThirdService;
import org.tio.sitexxx.service.service.stat.StatService;
import org.tio.sitexxx.service.utils.CommonUtils;
import org.tio.sitexxx.service.utils.PeriodUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.service.vo.topic.TopicVo;
import org.tio.utils.BinaryUtils;
import org.tio.utils.Threads;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;
import org.tio.utils.hutool.CollUtil;
import org.tio.utils.lock.LockUtils;
import org.tio.utils.resp.Resp;

public class UserService {
    private static Logger log = LoggerFactory.getLogger(UserService.class);
    public static final UserService ME = new UserService();
    public static final RoleService roleService = RoleService.me;
    public static final User nullUser = new User();
    public static final String[] AVATARS = new String[]{"/img/avatar/1.png", "/img/avatar/10171119181614.jpg", "/img/avatar/1106070_jc1127.png", "/img/avatar/1168934_100.jpeg", "/img/avatar/1485256_wooxz.png", "/img/avatar/2.jpg", "/img/avatar/20171118121406.png", "/img/avatar/20171118122407.jpg", "/img/avatar/20171118124108.jpg", "/img/avatar/20171118124247.png", "/img/avatar/20171118124927.jpg", "/img/avatar/20171118125112.jpg", "/img/avatar/20171118125630.jpg", "/img/avatar/20171118181652.jpg", "/img/avatar/20171119182050.jpg", "/img/avatar/20180416154203.jpg", "/img/avatar/20180416155040.jpg", "/img/avatar/20180429093933.jpg", "/img/avatar/2232696_talent-iofan.png", "/img/avatar/302580_wu1g119.png", "/img/avatar/3196787_100.jpg", "/img/avatar/3440734_100.jpeg", "/img/avatar/3802362_50.jpeg", "/img/avatar/463940_hehui082452239.jpg", "/img/avatar/512121_SJRSB.png", "/img/avatar/556878_100.gif", "/img/avatar/636232_meallon.png", "/img/avatar/87d66e45edd0274fe9c29b8cb54f9258_1.jpg", "/img/avatar/a.jpg", "/img/avatar/beimi.jpeg", "/img/avatar/cc.png", "/img/avatar/eee.png", "/img/avatar/fds.png", "/img/avatar/fdsse.png", "/img/avatar/gopush.jpeg", "/img/avatar/l.png", "/img/avatar/liyus.jpg", "/img/avatar/luxiaolei.jpg", "/img/avatar/orpherus.jpg", "/img/avatar/qbug.png", "/img/avatar/shts.jpg", "/img/avatar/springForAll.png", "/img/avatar/xianxin.jpg", "/img/avatar/zhishu.png"};
    public static List<Integer> robots = null;

    private UserService() {
    }

    public Record info1(User currUser, String uid) throws Exception {
        boolean isSuper = UserService.isSuper(currUser);
        ICache cache = Caches.getCache(CacheConfig.USER_INFO);
        String key = String.valueOf(isSuper) + uid;
        boolean putTempToCacheIfNull = true;
        Record record = (Record)CacheUtils.get((ICache)cache, (String)key, (boolean)putTempToCacheIfNull, () -> {
            User user = ME.getById(uid);
            if (user == null) {
                return null;
            }
            Record record1 = new Record();
            record1.set("nick", (Object)user.getNick());
            record1.set("id", (Object)user.getId());
            record1.set("avatar", (Object)user.getAvatar());
            this.perfectUserInfo(isSuper, record1);
            UserBase userBase = UserBaseService.me.getUserBaseByUid(uid);
            if (userBase != null) {
                record1.set("sex", (Object)userBase.getSex());
                record1.set("sign", (Object)userBase.getSign());
            }
            return record1;
        });
        return record;
    }

    public Record info(String uid) throws Exception {
        return this.info1(null, uid);
    }

    public Page<Record> search(User currUser, String nick, String uid, String loginname, Integer pageNumber, Integer pageSize) throws Exception {
        if (pageNumber == null) {
            pageNumber = 1;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        final Integer pageNumber1 = pageNumber;
        final Integer pageSize1 = pageSize;
        final boolean isSuper = UserService.isSuper(currUser);
        if (!isSuper) {
            loginname = null;
        }
        ICache cache = Caches.getCache(CacheConfig.SEARCH_USER);
        Page page = null;
        final Kv params = Kv.by((Object)"isSuper", (Object)isSuper);
        if (uid != null) {
            params.set((Object)"uid", (Object)uid);
            SqlPara sqlPara = User.dao.getSqlPara("user.searchByUid", (Map)params);
            page = Db.paginate((int)pageNumber, (int)pageSize, (SqlPara)sqlPara);
            this.perfectUserInfo(isSuper, page.getList());
        } else if (StrUtil.isNotBlank((CharSequence)loginname)) {
            params.set((Object)"loginname", (Object)loginname);
            SqlPara sqlPara = User.dao.getSqlPara("user.searchByLoginname", (Map)params);
            page = Db.paginate((int)pageNumber, (int)pageSize, (SqlPara)sqlPara);
            this.perfectUserInfo(isSuper, page.getList());
        } else if (StrUtil.isNotBlank((CharSequence)nick)) {
            nick = nick.trim();
            if (!isSuper) {
                if (StrUtil.containsAny((CharSequence)nick, (CharSequence[])new CharSequence[]{"%"})) {
                    return null;
                }
                loginname = null;
            }
            Pattern p = Pattern.compile("\\s+");
            Matcher m = p.matcher(nick);
            final String searchNick = m.replaceAll("%");
            String key = isSuper + "_" + pageNumber + "_" + pageSize + "_" + searchNick;
            boolean putTempToCacheIfNull = true;
            page = (Page)CacheUtils.get((ICache)cache, (String)key, (boolean)putTempToCacheIfNull, (FirsthandCreater)new FirsthandCreater<Page<Record>>(){

                public Page<Record> create() throws Exception {
                    params.set((Object)"nick", (Object)("%" + searchNick + "%"));
                    SqlPara sqlPara = User.dao.getSqlPara("user.searchByNick", (Map)params);
                    Page page = Db.paginate((int)pageNumber1, (int)pageSize1, (SqlPara)sqlPara);
                    UserService.this.perfectUserInfo(isSuper, page.getList());
                    return page;
                }
            });
        } else {
            return null;
        }
        return page;
    }

    public void perfectUserInfo(boolean isSuper, List<Record> list) throws Exception {
        if (list != null) {
            for (Record record : list) {
                this.perfectUserInfo(isSuper, record);
            }
        }
    }

    public void perfectUserInfo(boolean isSuper, Record record) throws Exception {
        if (record == null) {
            return;
        }
        String uid = record.getStr("id");
        if (uid != null) {
            User user = ME.getById(uid);
            record.set("roles", user.getRoles());
            if (user.getIpid() != null) {
                UserThird userThird;
                IpInfo ipInfo = IpInfoService.ME.getById(user.getIpid());
                if (ipInfo != null) {
                    record.set("country", (Object)ipInfo.getCountry());
                    record.set("province", (Object)ipInfo.getProvince());
                    record.set("city", (Object)ipInfo.getCity());
                }
                UserThirdOsc userThirdOsc = null;
                if ("5".equals(user.getPwd()) && user.getLoginname().startsWith("__osc_") && (userThird = UserThirdService.me.getByUid(uid)) != null && (userThirdOsc = UserThirdOscService.me.getByUserThirdId(userThird.getId())) != null) {
                    record.set("osc_url", (Object)userThirdOsc.getUrl());
                }
                if (isSuper) {
                    if (ipInfo != null) {
                        record.set("ip", (Object)ipInfo.getIp());
                    }
                    record.set("createtime", (Object)user.getCreatetime());
                    record.set("loginname", (Object)user.getLoginname());
                    if (userThirdOsc != null) {
                        record.set("osc_email", (Object)userThirdOsc.getEmail());
                    }
                }
            }
        }
    }

    public void _clearCache(String uid) {
        if (uid == null) {
            Caches.getCache(CacheConfig.USERID_USER_3).clear();
            Caches.getCache(CacheConfig.LOGINNAME_USER).clear();
            Caches.getCache(CacheConfig.USER_INFO).clear();
            Caches.getCache(CacheConfig.USERID_BASE).clear();
        } else {
            User user = ME.getById(uid);
            if (user != null) {
                Caches.getCache(CacheConfig.LOGINNAME_USER).remove(user.getLoginname());
            }
            String key = uid + "";
            Caches.getCache(CacheConfig.USERID_USER_3).remove(key);
            ICache cache = Caches.getCache(CacheConfig.USER_INFO);
            cache.remove(String.valueOf(false) + key);
            cache.remove(String.valueOf(true) + key);
            Caches.getCache(CacheConfig.USERID_BASE).remove(key);
        }
    }

    public void notifyClearCache(String uid) {
        this._clearCache(uid);
        TopicVo topicVo = new TopicVo();
        topicVo.setType(Byte.valueOf((byte)4));
        topicVo.setValue((Serializable)((Object)uid));
        RTopic topic = RedisInit.get().getTopic("COMMON_TOPIC");
        topic.publish((Object)topicVo);
    }

    public User getById(final String uid) {
        if (uid == null) {
            return null;
        }
        User user1 = (User)((Object)CacheUtils.get((ICache)Caches.getCache(CacheConfig.USERID_USER_3), (String)uid, (boolean)true, (FirsthandCreater)new FirsthandCreater<User>(){

            public User create() {
                UserBase userBase;
                User user = (User)User.dao.findById(uid);
                if (user == null) {
                    return null;
                }
                if (Const.USE_ANONYMOUS && user.getXx() == 1) {
                    user.setAvatar(AVATARS[BinaryUtils.uidIndex((String)uid) % AVATARS.length]);
                }
                roleService.setRoles(user);
                IpInfo ipInfo = IpInfoService.ME.getById(user.getIpid());
                user.setIpInfo(ipInfo);
                UserThird userThird = UserThirdService.me.getByUid(user.getId());
                user.setUserThird(userThird);
                if (StrUtil.isBlank((CharSequence)user.getAvatar())) {
                    user.setAvatar("/img/tio.jpg");
                }
                if (StrUtil.isBlank((CharSequence)user.getAvatarbig())) {
                    user.setAvatarbig(user.getAvatar());
                }
                if ((userBase = UserBaseService.me.getUserBaseByUid(user.getId())) != null) {
                    user.setPhone(userBase.getPhone());
                    user.setSign(userBase.getSign());
                    user.setSex(userBase.getSex());
                }
                return user;
            }
        }));
        return user1;
    }

    public User save(User user) {
        IpInfo ip = user.getIpInfo();
        if ((ip = IpInfoService.ME.save(ip)) != null) {
            user.setIpid(ip.getId());
            boolean ff = user.save();
            if (ff) {
                user.setIpInfo(ip);
                return user;
            }
        }
        return null;
    }

    public User userUnionSave(User user) {
        return null;
    }

    public int getUserCount() {
        ICache cache = Caches.getCache(CacheConfig.USER_COUNT);
        String key = "y";
        Integer count = (Integer)CacheUtils.get((ICache)cache, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<Integer>(){

            public Integer create() {
                String sql = "select count(*) from user";
                return Db.use((String)"tio_site_main").queryInt(sql);
            }
        });
        return count;
    }

    public User getByLoginname(String loginname, Byte status) {
        ICache loginnameAndUserCache = Caches.getCache(CacheConfig.LOGINNAME_USER);
        User user = (User)((Object)loginnameAndUserCache.get(loginname));
        if (user == null) {
            user = (User)User.dao.findFirst("select * from f_userinfo where login_name = ? ", new Object[]{loginname});
            if (user != null) {
                user = this.getById(user.getId());
            }
            if (user != null) {
                loginnameAndUserCache.put(loginname, (Serializable)((Object)user));
            } else {
                loginnameAndUserCache.putTemporary(loginname, (Serializable)((Object)nullUser));
            }
        } else {
            if (user.getId() == null) {
                return null;
            }
            if (status == null) {
                return user;
            }
            if (!Objects.equals(status, user.getStatus())) {
                return null;
            }
        }
        return user;
    }

    public Ret login(String loginname, String pd5, boolean isThirdLogin) {
        String code = "code";
        if (StrUtil.isBlank((CharSequence)loginname)) {
            return Ret.fail((Object)code, (Object)1);
        }
        User user = this.getByLoginname(loginname, null);
        if (user == null) {
            log.info("can find user by loginname:\u3010{}\u3011", (Object)loginname);
            return Ret.fail((Object)code, (Object)1);
        }
        if (!isThirdLogin && !Objects.equals(pd5, MD5.create().digestHex("centit.1"))) {
            log.info("password is invalid, loginname:[{}], md5pwd:[{}], need md5pwd:[{}]", new Object[]{loginname, pd5, user.getPwd()});
            return Ret.fail((Object)code, (Object)2);
        }
        return Ret.ok((Object)"user", (Object)((Object)user));
    }

    public Resp updateNick(User user, String newNick, String avatarPath) {
        String sql;
        if (newNick.equals(user.getNick())) {
            return Resp.fail((String)"\u539f\u6765\u7684\u6635\u79f0\u5c31\u662f\u8fd9\u4e2a\u54e6\uff01");
        }
        Resp resp = CommonUtils.checkGroupName(newNick, "\u6635\u79f0");
        if (!resp.isOk()) {
            return resp;
        }
        UserlogModifyNick userlogModifyNick = new UserlogModifyNick();
        userlogModifyNick.setNewnick(newNick);
        userlogModifyNick.setOldnick(user.getNick());
        userlogModifyNick.setUid(user.getId());
        if (StrUtil.isNotBlank((CharSequence)newNick)) {
            String check = Db.use((String)"tio_site_system").queryStr("select user_code from f_userinfo where login_name = ? and user_code != ? limit 1", new Object[]{newNick, user.getId()});
            if (check != null) {
                return Resp.fail((String)"\u6635\u79f0\u5df2\u5b58\u5728");
            }
            String filterContent = newNick;
            filterContent = SensitiveWordsService.findAndReplace(filterContent);
            filterContent = StringEscapeUtils.escapeHtml4((String)filterContent);
            user.setNick(filterContent);
        }
        int c = -1;
        if (StrUtil.isBlank((CharSequence)avatarPath)) {
            sql = "update user set nick = ? where id = ?";
            c = Db.update((String)sql, (Object[])new Object[]{newNick, user.getId()});
        } else {
            sql = "update user set nick = ?,avatar = ?,avatarbig = ? where id = ?";
            c = Db.update((String)sql, (Object[])new Object[]{newNick, avatarPath, avatarPath, user.getId()});
        }
        if (c < 1) {
            return Resp.fail((String)"\u7528\u6237\u6635\u79f0\u4fee\u6539\u5931\u8d25");
        }
        this.notifyClearCache(user.getId());
        userlogModifyNick.save();
        this.initSynInfo(user.getId(), (byte)1, newNick, null);
        if (StrUtil.isNotBlank((CharSequence)avatarPath)) {
            this.initSynInfo(user.getId(), (byte)2, avatarPath, null);
        }
        return Resp.ok().msg("\u7528\u6237\u6635\u79f0\u4fee\u6539\u6210\u529f");
    }

    public Resp updateAvatar(User user, String newavatar, String newavatarbig) {
        UserlogModifyAvatar userlogModifyAvatar = new UserlogModifyAvatar();
        userlogModifyAvatar.setNewavatar(newavatar);
        userlogModifyAvatar.setNewavatarbig(newavatarbig);
        userlogModifyAvatar.setOldavatar(user.getAvatar());
        userlogModifyAvatar.setOldavatarbig(user.getAvatarbig());
        userlogModifyAvatar.setUid(user.getId());
        String sql = "update user set avatar = ?, avatarbig = ? where id = ?";
        int c = Db.update((String)sql, (Object[])new Object[]{newavatar, newavatarbig, user.getId()});
        if (c < 1) {
            return Resp.fail((String)"\u7528\u6237\u5934\u50cf\u4fee\u6539\u5931\u8d25");
        }
        this.notifyClearCache(user.getId());
        userlogModifyAvatar.save();
        this.initSynInfo(user.getId(), (byte)2, newavatar, null);
        return Resp.ok().msg("\u7528\u6237\u5934\u50cf\u4fee\u6539\u6210\u529f");
    }

    public Resp updateFdvalidtype(User user, Byte fdvalidtype) {
        String sql = "update user set fdvalidtype = ? where id = ?";
        int c = Db.update((String)sql, (Object[])new Object[]{fdvalidtype, user.getId()});
        if (c < 1) {
            return Resp.fail((String)"\u7528\u6237\u9a8c\u8bc1\u65b9\u5f0f\u5931\u8d25");
        }
        this.notifyClearCache(user.getId());
        return Resp.ok().msg("\u7528\u6237\u9a8c\u8bc1\u65b9\u5f0f\u6210\u529f");
    }

    public Resp updateRemind(User user, Byte remindflag) {
        String sql = "update user set msgremindflag = ? where id = ?";
        int c = Db.update((String)sql, (Object[])new Object[]{remindflag, user.getId()});
        if (c < 1) {
            return Resp.fail((String)"\u7528\u6237\u6d88\u606f\u63d0\u9192\u8bbe\u7f6e\u5931\u8d25");
        }
        this.notifyClearCache(user.getId());
        return Resp.ok().msg("\u7528\u6237\u6d88\u606f\u63d0\u9192\u8bbe\u7f6e\u6210\u529f");
    }

    public Resp updatePhone(User user, String phone) {
        if (phone == null) {
            phone = "";
        }
        String sql = "update user_base set phone = ? where uid = ?";
        int c = Db.update((String)sql, (Object[])new Object[]{phone, user.getId()});
        if (c < 1) {
            return Resp.fail((String)"\u7528\u6237\u4fee\u6539\u7535\u8bdd\u5931\u8d25");
        }
        this.notifyClearCache(user.getId());
        return Resp.ok().msg("\u7528\u6237\u4fee\u6539\u7535\u8bdd\u6210\u529f");
    }

    public Resp updateSign(User user, String sign) {
        if (sign == null) {
            sign = "";
        }
        String sql = "update user_base set sign = ? where uid = ?";
        int c = Db.update((String)sql, (Object[])new Object[]{sign, user.getId()});
        if (c < 1) {
            return Resp.fail((String)"\u7528\u6237\u4fee\u6539\u7b7e\u540d\u5931\u8d25");
        }
        this.notifyClearCache(user.getId());
        return Resp.ok().msg("\u7528\u6237\u4fee\u6539\u7b7e\u540d\u6210\u529f");
    }

    public Resp updateUser(final User curr, final User update) {
        if (update == null) {
            return Resp.fail().msg("\u65e0\u6548\u53c2\u6570");
        }
        if (StrUtil.isNotBlank((CharSequence)update.getNick())) {
            String check = Db.use((String)"tio_site_system").queryStr("select user_code from f_userinfo where login_name = ? and user_code != ? limit 1", new Object[]{update.getNick(), curr.getId()});
            if (check != null) {
                return Resp.fail((String)"\u6635\u79f0\u5df2\u5b58\u5728");
            }
            String filterContent = update.getNick();
            filterContent = SensitiveWordsService.findAndReplace(filterContent);
            filterContent = StringEscapeUtils.escapeHtml4((String)filterContent);
            update.setNick(filterContent);
        }
        AbsTxAtom absTxAtom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                Kv param = Kv.by((Object)"uid", (Object)curr.getId());
                if (StrUtil.isBlank((CharSequence)update.getSign())) {
                    param.set((Object)"sign", (Object)"");
                } else {
                    param.set((Object)"sign", (Object)update.getSign());
                }
                if (update.getSex() != null) {
                    param.set((Object)"sex", (Object)update.getSex());
                }
                SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("user.updateBase", (Map)param);
                Db.use((String)"tio_site_main").update(sqlPara);
                update.setId(curr.getId());
                return update.update();
            }
        };
        boolean atom = Db.use((String)"tio_site_main").tx((IAtom)absTxAtom);
        if (!atom) {
            return Resp.fail((String)"\u7528\u6237\u4fee\u6539\u5931\u8d25");
        }
        this.notifyClearCache(curr.getId());
        if (StrUtil.isNotBlank((CharSequence)update.getNick()) && !curr.getNick().equals(update.getNick())) {
            this.initSynInfo(update.getId(), (byte)1, update.getNick(), null);
        }
        if (StrUtil.isNotBlank((CharSequence)update.getAvatar()) && !curr.getAvatar().equals(update.getAvatar())) {
            this.initSynInfo(update.getId(), (byte)2, update.getAvatar(), null);
        }
        return Resp.ok().msg("\u7528\u6237\u4fee\u6539\u6210\u529f");
    }

    public Resp updateSex(User user, Byte sex) {
        if (sex == null) {
            sex = 1;
        }
        String sql = "update user_base set sex = ? where uid = ?";
        int c = Db.update((String)sql, (Object[])new Object[]{sex, user.getId()});
        if (c < 1) {
            return Resp.fail((String)"\u7528\u6237\u4fee\u6539\u6027\u522b\u5931\u8d25");
        }
        this.notifyClearCache(user.getId());
        return Resp.ok().msg("\u7528\u6237\u4fee\u6539\u6027\u522b\u6210\u529f");
    }

    public Resp updateSearchFlag(User user, Byte searchflag) {
        String sql = "update user set searchflag = ? where id = ?";
        int c = Db.update((String)sql, (Object[])new Object[]{searchflag, user.getId()});
        if (c < 1) {
            return Resp.fail((String)"\u7528\u6237\u8bbe\u7f6e\u522b\u4eba\u641c\u7d22\u5f00\u5173\u5931\u8d25");
        }
        this.notifyClearCache(user.getId());
        return Resp.ok().msg("\u7528\u6237\u8bbe\u7f6e\u522b\u4eba\u641c\u7d22\u5f00\u5173\u6210\u529f");
    }

    public Resp updatePwd(User user, String initPwd, String newPwd) {
        String loginname = user.getLoginname();
        String md5pwd = UserService.getMd5Pwd(loginname, initPwd);
        if (!Objects.equals(md5pwd, user.getPwd())) {
            return Resp.fail((String)"\u539f\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        String newmd5pwd = newPwd;
        String sql = "update user set pwd = ? where id = ?";
        int c = Db.update((String)sql, (Object[])new Object[]{newmd5pwd, user.getId()});
        if (c > 0) {
            this.notifyClearCache(user.getId());
        }
        return Resp.ok();
    }

    public Resp addRoleByLoginname(String loginname, byte roleid) {
        User user = this.getByLoginname(loginname, (byte)1);
        if (user == null) {
            return Resp.fail((String)"\u7528\u6237\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u4e0d\u6b63\u5e38");
        }
        return this.addRole(user, roleid);
    }

    public Resp addRoleByNick(String nick, byte roleid) {
        User user = this.getByNick(nick);
        if (user == null) {
            return Resp.fail((String)"\u6635\u79f0\u4e0d\u5b58\u5728");
        }
        if (!Objects.equals(user.getStatus(), (byte)1)) {
            return Resp.fail((String)"\u7528\u6237\u72b6\u6001\u4e0d\u5bf9");
        }
        return this.addRole(user, roleid);
    }

    public Resp addRole(final User user, final byte roleid) {
        if (user == null) {
            return Resp.fail((String)"\u7528\u6237\u4e3a\u7a7a");
        }
        boolean f = Db.use((String)"tio_site_main").tx(new IAtom(){

            public boolean run() throws SQLException {
                UserService.this.removeRole(user, roleid, false);
                String sql = "insert into user_role (uid, rid, status) values (?,?,?)";
                Db.use((String)"tio_site_main").update(sql, new Object[]{user.getId(), roleid, 1});
                return true;
            }
        });
        if (f) {
            this.notifyClearCache(user.getId());
            return Resp.ok();
        }
        return Resp.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    public Resp removeRole(User user, byte roleid) {
        return this.removeRole(user, roleid, true);
    }

    public Resp removeRole(User user, byte roleid, boolean clearCache) {
        String sql = "delete from user_role where uid = ? and rid = ?";
        Db.use((String)"tio_site_main").update(sql, new Object[]{user.getId(), roleid});
        if (clearCache) {
            this.notifyClearCache(user.getId());
        }
        return Resp.ok();
    }

    public List<Record> getTortAvatarUser() {
        String sql = "select u.id,nick,avatar,b.sex from `user` u INNER JOIN user_base b on u.id = b.uid where avatar not like '/user/avatar/%' and avatar not like 'http%'";
        List users = Db.use((String)"tio_site_main").find(sql);
        return users;
    }

    public static String getMd5Pwd(String loginname, String plainpwd) {
        String pwd = SecureUtil.md5((String)("${" + StrUtil.trim((CharSequence)loginname) + "}" + StrUtil.trim((CharSequence)plainpwd)));
        return pwd;
    }

    public Ret updateUserAddress(String uid, UserAddress userAddress) {
        if (userAddress == null || uid == null) {
            return Ret.fail().set((Object)"msg", (Object)"\u65e0\u6548\u53c2\u6570");
        }
        userAddress.setUid(uid);
        userAddress.update();
        return Ret.ok().set((Object)"data", (Object)userAddress);
    }

    public List<User> getRobotUserList() {
        Kv params = Kv.by((Object)"robot", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("user.robotUser", (Map)params);
        List list = User.dao.find(sqlPara);
        if (Const.USE_ANONYMOUS && list != null) {
            for (User user : list) {
                user.setAvatar(AVATARS[RandomUtil.randomInt() % AVATARS.length]);
            }
        }
        return list;
    }

    public static final boolean isSuper(User user) {
        if (user == null) {
            return false;
        }
        return UserRoleService.hasRole(user, (byte)99);
    }

    public int updateUserStatusByNick(String nick, byte newStatus) {
        if (StrUtil.isBlank((CharSequence)nick)) {
            return 0;
        }
        String uid = this.getUidByNick(nick);
        return this.updateUserStatus(uid, newStatus);
    }

    public int updateUserStatus(String uid, byte newStatus) {
        if (uid == null) {
            return 0;
        }
        String sql = "update user set status = ? where id = ?";
        int c = Db.update((String)sql, (Object[])new Object[]{newStatus, uid});
        this.notifyClearCache(uid);
        return c;
    }

    public int pullBlackUserByNick(String nick) throws SQLException {
        String uid = this.getUidByNick(nick);
        return this.pullBlackUserByUid(uid);
    }

    public int pullBlackUserByUid(final String uid) throws SQLException {
        AbsAtom atom;
        boolean flag;
        if (uid != null && (flag = (atom = new AbsAtom(){

            public boolean run() throws SQLException {
                UserService.this.updateUserStatus(uid, (byte)5);
                return true;
            }
        }).run())) {
            return 1;
        }
        return 0;
    }

    public int normalUserByNick(String nick) {
        String uid = this.getUidByNick(nick);
        return this.normalUserByUid(uid);
    }

    public int normalUserByUid(String uid) {
        return this.updateUserStatus(uid, (byte)1);
    }

    public String getUidByNick(final String nick) {
        if (StrUtil.isBlank((CharSequence)nick)) {
            return null;
        }
        ICache cache = Caches.getCache(CacheConfig.TIME_TO_LIVE_SECONDS_5);
        String key = "user_nick_id:" + nick;
        String uid = (String)((Object)CacheUtils.get((ICache)cache, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<String>(){

            public String create() {
                String sql = "select user_code from f_userinfo where login_name = ?";
                return Db.use((String)"tio_site_system").queryStr(sql, new Object[]{nick});
            }
        }));
        return uid;
    }

    public User getByNick(String nick) {
        String uid = this.getUidByNick(nick);
        if (uid != null) {
            return this.getById(uid);
        }
        return null;
    }

    public String getUidByIpid(Integer ipid) {
        if (ipid == null) {
            return null;
        }
        String sql = "SELECT uid FROM `tio_token_path_access_stat` where ipid=? and uid is not null order by firstAccessTime desc LIMIT 0, 1";
        return Db.use((String)"tio_site_stat").queryStr(sql, new Object[]{ipid});
    }

    public static void completeUser(Record record, Map<String, Object> ext, String uidKey) {
        String uid = record.getStr(uidKey);
        if (uid != null) {
            if (ext.get(uid) != null) {
                return;
            }
            User user = ME.getById(uid);
            if (user != null) {
                Kv kv = Kv.by((Object)"nick", (Object)user.getNick()).set((Object)"avatar", (Object)user.getAvatar()).set((Object)"roles", user.getRoles());
                ext.put(uid, kv);
            }
        }
    }

    public static void completeUser(List<Record> list, Map<String, Object> ext, String uidKey) {
        if (list != null) {
            for (Record record : list) {
                UserService.completeUser(record, ext, uidKey);
            }
        }
    }

    public static void completeUser(Page<Record> page, String uidKey) {
        List list = page.getList();
        if (list != null) {
            HashMap<String, Object> ext = new HashMap<String, Object>();
            page.setExt(ext);
            for (Record record : list) {
                UserService.completeUser(record, ext, uidKey);
            }
        }
    }

    public static boolean hasRole(User user, Byte code) {
        return UserRoleService.hasRole(user, code);
    }

    public static User getByLoginnameOrNick(String loginname, String nick) {
        User user = null;
        user = StrUtil.isNotBlank((CharSequence)loginname) ? ME.getByLoginname(loginname, (byte)1) : ME.getByNick(nick);
        return user;
    }

    public static String twoUid(String uid1, String uid2) {
        return uid1.compareTo(uid2) > 0 ? uid1 + "_" + uid2 : uid2 + "_" + uid1;
    }

    public void initRobot() {
        if (robots != null) {
            return;
        }
        try {
            LockUtils.runWriteOrWaitRead((String)(UserService.class.getName() + ".initRobot"), (Object)this, () -> {
                List list;
                if (robots != null) {
                    return;
                }
                int maxId = 23356;
                int count = 2000;
                int start = 0;
                robots = list = Db.use((String)"tio_site_main").query("select id from user where id <= ? limit ?,?", new Object[]{maxId, start, count});
            });
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public void initSynInfo(final String uid, final Byte type, final String bizStr, final Long bizbigint) {
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    UserInfoSyn infoSyn = new UserInfoSyn();
                    switch (type) {
                        case 1: {
                            infoSyn.setBizstr(bizStr);
                            break;
                        }
                        case 2: {
                            infoSyn.setBizstr(bizStr);
                            break;
                        }
                        case 3: {
                            infoSyn.setBizstr(bizStr);
                            infoSyn.setBizbigint(bizbigint);
                            break;
                        }
                    }
                    infoSyn.setType(type);
                    infoSyn.setUid(uid);
                    infoSyn.replaceSave();
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        });
    }

    public void loginTimeStat(Date date) {
        DateTime dateTime = DateUtil.offsetDay((Date)date, (int)-1);
        String dayPeriod = PeriodUtils.dateToPeriodByType((Date)dateTime, (byte)1);
        List records = Db.use((String)"tio_site_main").find("select dayperiod,count(DISTINCT uid) uidcount,count(1) logincount from login_log where dayperiod =?", new Object[]{dayPeriod});
        if (CollectionUtil.isEmpty((Collection)records)) {
            return;
        }
        int usercount = ((Record)records.get(0)).getInt("uidcount");
        int totalcount = ((Record)records.get(0)).getInt("logincount");
        if (usercount == 0 || totalcount == 0) {
            return;
        }
        UserTimeLoginStat daystat = new UserTimeLoginStat();
        daystat.setUid("-1");
        daystat.setDayperiod(dayPeriod);
        daystat.setUsercount(usercount);
        daystat.setTotalcount(totalcount);
        daystat.setRemark("\u5929\u7edf\u8ba1");
        daystat.replaceSave();
        List userLogins = Db.use((String)"tio_site_main").find("select  uid,count(1) logincount from login_log where dayperiod = ? group by uid", new Object[]{dayPeriod});
        if (CollectionUtil.isEmpty((Collection)userLogins)) {
            log.error("\u767b\u5f55\u7edf\u8ba1\u5f02\u5e38\uff1a\u7528\u6237\u767b\u5f55\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        for (Record userLogin : userLogins) {
            String uid = userLogin.getStr("uid");
            int count = userLogin.getInt("logincount");
            List hourLogins = Db.use((String)"tio_site_main").find("select hourperiod,count(1) hourcount from login_log where dayperiod = ?  and uid = ? group by hourperiod", new Object[]{dayPeriod, uid});
            if (CollectionUtil.isEmpty((Collection)hourLogins)) {
                log.error("\u767b\u5f55\u7edf\u8ba1\u5f02\u5e38\uff1a\u7528\u6237\u767b\u5f55\u8bb0\u5f55\u4e0d\u5b58\u5728-\u5c0f\u65f6");
                continue;
            }
            UserTimeLoginStat userStat = new UserTimeLoginStat();
            userStat.setUid(uid);
            userStat.setDayperiod(dayPeriod);
            userStat.setTotalcount(count);
            for (Record hourLogin : hourLogins) {
                UserService.dateToLoginStat(userStat, hourLogin.getStr("hourperiod"), (int)hourLogin.getInt("hourcount"));
            }
            userStat.replaceSave();
            UserTimeLoginStat record = (UserTimeLoginStat)UserTimeLoginStat.dao.findFirst("select  * from user_time_login_stat where uid = ? and dayperiod = -1", new Object[]{uid});
            if (record == null) {
                record = new UserTimeLoginStat();
                record.setUid(uid);
                record.setDayperiod("-1");
                record.setUsercount(1);
                record.setTotalcount(count);
                record.setRemark("\u7528\u6237\u603b\u7edf\u8ba1");
                record.replaceSave();
                continue;
            }
            Db.use((String)"tio_site_stat").update("update user_time_login_stat set totalcount = totalcount + ? where id = ? ", new Object[]{count, record.getId()});
        }
    }

    public void singleLoginTimeStat(LoginLog loginLog) {
        UserTimeLoginStat daystat;
        String dayPeriod = PeriodUtils.dateToPeriodByType((Date)loginLog.getTime(), (byte)1);
        String uid = loginLog.getUid();
        boolean userInit = false;
        UserTimeLoginStat userStat = (UserTimeLoginStat)UserTimeLoginStat.dao.findFirst("select  * from user_time_login_stat where uid = ? and dayperiod = ?", new Object[]{uid, dayPeriod});
        if (userStat == null) {
            userStat = new UserTimeLoginStat();
            userStat.setUid(uid);
            userStat.setDayperiod(dayPeriod);
            userStat.setTotalcount(0);
            userStat.setUsercount(1);
            int save = userStat.ignoreSave();
            if (save <= 0) {
                userInit = true;
            }
        } else {
            userInit = true;
        }
        String hourPeriod = loginLog.getHourperiod();
        Db.use((String)"tio_site_stat").update("update user_time_login_stat set totalcount = totalcount + 1,hour" + Integer.parseInt(hourPeriod) + " = hour" + Integer.parseInt(hourPeriod) + " + 1 where uid = ? and dayperiod = ?", new Object[]{uid, dayPeriod});
        UserTimeLoginStat record = (UserTimeLoginStat)UserTimeLoginStat.dao.findFirst("select  * from user_time_login_stat where uid = ? and dayperiod = -1", new Object[]{uid});
        if (record == null) {
            record = new UserTimeLoginStat();
            record.setUid(uid);
            record.setDayperiod("-1");
            record.setUsercount(1);
            record.setTotalcount(1);
            record.setRemark("\u7528\u6237\u603b\u7edf\u8ba1");
            if (record.ignoreSave() <= 0) {
                Db.use((String)"tio_site_stat").update("update user_time_login_stat set totalcount = totalcount + 1 where uid = ? and dayperiod = -1", new Object[]{uid});
            }
        } else {
            Db.use((String)"tio_site_stat").update("update user_time_login_stat set totalcount = totalcount + 1 where id = ? ", new Object[]{record.getId()});
        }
        if ((daystat = (UserTimeLoginStat)UserTimeLoginStat.dao.findFirst("select  * from user_time_login_stat where uid = -1 and dayperiod = ?", new Object[]{dayPeriod})) == null) {
            daystat = new UserTimeLoginStat();
            daystat.setUid("-1");
            daystat.setDayperiod(dayPeriod);
            daystat.setUsercount(1);
            daystat.setTotalcount(1);
            daystat.setRemark("\u5929\u7edf\u8ba1");
            if (daystat.ignoreSave() <= 0) {
                if (userInit) {
                    Db.use((String)"tio_site_stat").update("update user_time_login_stat set totalcount = totalcount + 1 where uid = -1 and dayperiod = ?", new Object[]{dayPeriod});
                } else {
                    Db.use((String)"tio_site_stat").update("update user_time_login_stat set totalcount = totalcount + 1,usercount = usercount + 1 where uid = -1 and dayperiod = ?", new Object[]{dayPeriod});
                }
            }
        } else if (userInit) {
            Db.use((String)"tio_site_stat").update("update user_time_login_stat set totalcount = totalcount + 1 where id = ?", new Object[]{daystat.getId()});
        } else {
            Db.use((String)"tio_site_stat").update("update user_time_login_stat set totalcount = totalcount + 1,usercount = usercount + 1 where id = ?", new Object[]{daystat.getId()});
        }
    }

    public void loginIpStat(Date date) {
        DateTime dateTime = DateUtil.offsetDay((Date)date, (int)-1);
        String dayPeriod = PeriodUtils.dateToPeriodByType((Date)dateTime, (byte)1);
        List records = Db.use((String)"tio_site_main").find("select ip,ipid,count(1) totalcount,count(DISTINCT uid) uidcount from login_log where dayperiod = ? GROUP BY ip,ipid", new Object[]{dayPeriod});
        if (CollectionUtil.isEmpty((Collection)records)) {
            return;
        }
        for (Record ipRecord : records) {
            List useRecords;
            String ip = ipRecord.getStr("ip");
            Integer ipid = ipRecord.getInt("ipid");
            int uidcount = ipRecord.getInt("uidcount");
            int totalcount = ipRecord.getInt("totalcount");
            UserIpLoginStat ipstat = (UserIpLoginStat)UserIpLoginStat.dao.findFirst("select * from user_ip_login_stat where ip = ? and uid = -1 and dayperiod = '-1'", new Object[]{ip});
            boolean isInit = false;
            if (ipstat == null) {
                isInit = true;
                ipstat = new UserIpLoginStat();
                ipstat.setIp(ip);
                ipstat.setIpid(ipid);
                ipstat.setUsercount(uidcount);
                ipstat.setTotalcount(totalcount);
                ipstat.setDayperiod("-1");
                ipstat.setUid("-1");
                ipstat.replaceSave();
            }
            if (CollectionUtil.isEmpty((Collection)(useRecords = Db.use((String)"tio_site_main").find("select uid,count(1) logincount from login_log where dayperiod = ? and ip = ? GROUP BY uid", new Object[]{dayPeriod, ip})))) {
                log.error("\u767b\u5f55\u7edf\u8ba1\u5f02\u5e38\uff1a\u7528\u6237\u767b\u5f55\u8bb0\u5f55\u4e0d\u5b58\u5728-ip");
                return;
            }
            UserIpLoginStat daystat = new UserIpLoginStat();
            daystat.setUid("-1");
            daystat.setDayperiod(dayPeriod);
            daystat.setIp(ip);
            daystat.setIpid(ipid);
            daystat.setUsercount(uidcount);
            daystat.setTotalcount(totalcount);
            daystat.setRemark("\u5929\u7edf\u8ba1");
            daystat.replaceSave();
            for (Record userLogin : useRecords) {
                String uid = userLogin.getStr("uid");
                int userLoginCount = userLogin.getInt("logincount");
                List hourLogins = Db.use((String)"tio_site_main").find("select hourperiod,count(1) hourcount from login_log  where dayperiod = ? and ip = ? and uid = ? group by hourperiod", new Object[]{dayPeriod, ip, uid});
                if (CollectionUtil.isEmpty((Collection)hourLogins)) {
                    log.error("\u767b\u5f55\u7edf\u8ba1\u5f02\u5e38\uff1a\u7528\u6237\u767b\u5f55\u8bb0\u5f55\u4e0d\u5b58\u5728-\u5c0f\u65f6-ip");
                    continue;
                }
                UserIpLoginStat userStat = new UserIpLoginStat();
                userStat.setUid(uid);
                userStat.setTotalcount(userLoginCount);
                userStat.setDayperiod(dayPeriod);
                userStat.setIp(ip);
                userStat.setIpid(ipid);
                for (Record hourLogin : hourLogins) {
                    UserService.dateToLoginStat(userStat, hourLogin.getStr("hourperiod"), (int)hourLogin.getInt("hourcount"));
                }
                userStat.replaceSave();
            }
            if (isInit) continue;
            Record record = Db.use((String)"tio_site_stat").findFirst("select count(DISTINCT uid) ipuidcount from user_ip_login_stat where ip = ? and uid != -1", new Object[]{ip});
            if (record == null) {
                log.error("\u767b\u5f55\u7edf\u8ba1\u5f02\u5e38\uff1a\u603b\u8bb0\u5f55\u66f4\u65b0\u5f02\u5e38");
                continue;
            }
            int totaluid = record.getInt("ipuidcount");
            if (totaluid == 0) {
                log.error("\u767b\u5f55\u7edf\u8ba1\u5f02\u5e38\uff1a\u603b\u8bb0\u5f55\u66f4\u65b0\u5f02\u5e38,\u7edf\u8ba1\u603b\u6570\u4e3a0");
                continue;
            }
            UserIpLoginStat ipStatUpdate = new UserIpLoginStat();
            ipStatUpdate.setId(ipstat.getId());
            ipStatUpdate.setUsercount(totaluid);
            ipStatUpdate.setTotalcount(ipstat.getTotalcount() + totalcount);
            ipStatUpdate.update();
        }
    }

    public void singleLoginIpStat(LoginLog loginLog) {
        UserIpLoginStat ipstat;
        String dayPeriod = PeriodUtils.dateToPeriodByType((Date)loginLog.getTime(), (byte)1);
        String ip = loginLog.getIp();
        Integer ipid = loginLog.getIpid();
        String uid = loginLog.getUid();
        boolean userInit = false;
        UserIpLoginStat userStat = (UserIpLoginStat)UserIpLoginStat.dao.findFirst("select * from user_ip_login_stat where ip = ? and uid = ? and dayperiod = ?", new Object[]{ip, uid, dayPeriod});
        if (userStat == null) {
            userStat = new UserIpLoginStat();
            userStat.setUid(uid);
            userStat.setTotalcount(0);
            userStat.setDayperiod(dayPeriod);
            userStat.setIp(ip);
            userStat.setIpid(ipid);
            int save = userStat.ignoreSave();
            if (save <= 0) {
                userInit = true;
            }
        } else {
            userInit = true;
        }
        String hourPeriod = loginLog.getHourperiod();
        hourPeriod = "01";
        Db.use((String)"tio_site_stat").update("update user_ip_login_stat set totalcount = totalcount + 1,hour" + Integer.parseInt(hourPeriod) + " = hour" + Integer.parseInt(hourPeriod) + " + 1 where ip = ? and uid = ? and dayperiod = ?", new Object[]{ip, uid, dayPeriod});
        UserIpLoginStat daystat = (UserIpLoginStat)UserIpLoginStat.dao.findFirst("select * from user_ip_login_stat where ip = ? and uid = -1 and dayperiod = ?", new Object[]{ip, dayPeriod});
        if (daystat == null) {
            daystat = new UserIpLoginStat();
            daystat.setUid("-1");
            daystat.setDayperiod(dayPeriod);
            daystat.setIp(ip);
            daystat.setIpid(ipid);
            daystat.setUsercount(1);
            daystat.setTotalcount(1);
            daystat.setRemark("\u5929\u7edf\u8ba1");
            if (daystat.ignoreSave() <= 0) {
                if (userInit) {
                    Db.use((String)"tio_site_stat").update("update user_ip_login_stat set totalcount = totalcount + 1 where ip = ? and uid = -1 and dayperiod = ?", new Object[]{ip, dayPeriod});
                } else {
                    Db.use((String)"tio_site_stat").update("update user_ip_login_stat set totalcount = totalcount + 1,usercount = usercount + 1 where ip = ? and uid = -1 and dayperiod = ?", new Object[]{ip, dayPeriod});
                }
            }
        } else if (userInit) {
            Db.use((String)"tio_site_stat").update("update user_ip_login_stat set totalcount = totalcount + 1 where id = ?", new Object[]{daystat.getId()});
        } else {
            Db.use((String)"tio_site_stat").update("update user_ip_login_stat set totalcount = totalcount + 1,usercount = usercount + 1 where id = ?", new Object[]{daystat.getId()});
        }
        if ((ipstat = (UserIpLoginStat)UserIpLoginStat.dao.findFirst("select * from user_ip_login_stat where ip = ? and uid = -1 and dayperiod = '-1'", new Object[]{ip})) == null) {
            ipstat = new UserIpLoginStat();
            ipstat.setIp(ip);
            ipstat.setIpid(ipid);
            ipstat.setUsercount(1);
            ipstat.setTotalcount(1);
            ipstat.setDayperiod("-1");
            ipstat.setUid("-1");
            if (ipstat.ignoreSave() <= 0) {
                if (userInit) {
                    Db.use((String)"tio_site_stat").update("update user_ip_login_stat set totalcount = totalcount + 1 where ip = ? and uid = -1 and dayperiod = '-1'", new Object[]{ip});
                } else {
                    Db.use((String)"tio_site_stat").update("update user_ip_login_stat set totalcount = totalcount + 1,usercount = usercount + 1 where ip = ? and uid = -1 and dayperiod = '-1'", new Object[]{ip});
                }
            }
        } else if (userInit) {
            Db.use((String)"tio_site_stat").update("update user_ip_login_stat set totalcount = totalcount + 1 where id = ?", new Object[]{ipstat.getId()});
        } else {
            Db.use((String)"tio_site_stat").update("update user_ip_login_stat set totalcount = totalcount + 1,usercount = usercount + 1 where id = ?", new Object[]{ipstat.getId()});
        }
    }

    public void singleLoginInit(final LoginLog loginLog) {
        final Integer threadid = StatService.me.threadInit(loginLog.getId(), "", (byte)2);
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AbsTxAtom absTxAtom = new AbsTxAtom(){

                        @Override
                        public boolean noTxRun() {
                            UserService.this.singleLoginIpStat(loginLog);
                            UserService.this.singleLoginTimeStat(loginLog);
                            return true;
                        }
                    };
                    boolean save = Db.use((String)"tio_site_stat").tx((IAtom)absTxAtom);
                    if (!save) {
                        return;
                    }
                    StatService.me.threadDeal(threadid);
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        });
    }

    public void loginInit() {
        Db.use((String)"tio_site_stat").update("truncate table user_ip_login_stat");
        Db.use((String)"tio_site_stat").update("truncate table user_time_login_stat");
        Record maxRecord = Db.use((String)"tio_site_main").findFirst("select min(time) mintime from login_log");
        if (maxRecord == null) {
            return;
        }
        Date date = maxRecord.getDate("mintime");
        DateTime begiTime = DateUtil.beginOfDay((Date)date);
        DateTime startime = DateUtil.offsetDay((Date)begiTime, (int)1);
        DateTime curTime = DateUtil.beginOfDay((Date)new Date());
        int count = 0;
        long start = System.currentTimeMillis();
        log.error("\u5f00\u59cb\u767b\u5f55\u65e5\u5fd7\u8ba1\u7b97\uff1a{}", (Object)begiTime);
        while (curTime.getTime() >= startime.getTime()) {
            this.loginTimeStat((Date)startime);
            this.loginIpStat((Date)startime);
            startime = DateUtil.offsetDay((Date)startime, (int)1);
            ++count;
        }
        long end = System.currentTimeMillis();
        long exe = (end - start) / 60000L;
        log.error("\u767b\u5f55\u65e5\u5fd7\u8ba1\u7b97\uff0c\u6b21\u6570\uff1a" + count + ",\u603b\u65f6\u95f4\uff1a" + exe + ",\u5f00\u59cb\u65e5\u671f (+1)\uff1a" + begiTime + ",\u7ed3\u675f\u65e5\u671f\uff1a" + startime);
    }

    public static void dateToLoginStat(UserTimeLoginStat stat, String field, int value) {
        switch (field) {
            case "00": {
                stat.setHour0(value);
                break;
            }
            case "01": {
                stat.setHour1(value);
                break;
            }
            case "02": {
                stat.setHour2(value);
                break;
            }
            case "03": {
                stat.setHour3(value);
                break;
            }
            case "04": {
                stat.setHour4(value);
                break;
            }
            case "05": {
                stat.setHour5(value);
                break;
            }
            case "06": {
                stat.setHour6(value);
                break;
            }
            case "07": {
                stat.setHour7(value);
                break;
            }
            case "08": {
                stat.setHour8(value);
                break;
            }
            case "09": {
                stat.setHour9(value);
                break;
            }
            case "10": {
                stat.setHour10(value);
                break;
            }
            case "11": {
                stat.setHour11(value);
                break;
            }
            case "12": {
                stat.setHour12(value);
                break;
            }
            case "13": {
                stat.setHour13(value);
                break;
            }
            case "14": {
                stat.setHour14(value);
                break;
            }
            case "15": {
                stat.setHour15(value);
                break;
            }
            case "16": {
                stat.setHour16(value);
                break;
            }
            case "17": {
                stat.setHour17(value);
                break;
            }
            case "18": {
                stat.setHour18(value);
                break;
            }
            case "19": {
                stat.setHour19(value);
                break;
            }
            case "20": {
                stat.setHour20(value);
                break;
            }
            case "21": {
                stat.setHour21(value);
                break;
            }
            case "22": {
                stat.setHour22(value);
                break;
            }
            case "23": {
                stat.setHour23(value);
                break;
            }
        }
    }

    public static void dateToLoginStat(UserIpLoginStat stat, String field, int value) {
        switch (field) {
            case "00": {
                stat.setHour0(value);
                break;
            }
            case "01": {
                stat.setHour1(value);
                break;
            }
            case "02": {
                stat.setHour2(value);
                break;
            }
            case "03": {
                stat.setHour3(value);
                break;
            }
            case "04": {
                stat.setHour4(value);
                break;
            }
            case "05": {
                stat.setHour5(value);
                break;
            }
            case "06": {
                stat.setHour6(value);
                break;
            }
            case "07": {
                stat.setHour7(value);
                break;
            }
            case "08": {
                stat.setHour8(value);
                break;
            }
            case "09": {
                stat.setHour9(value);
                break;
            }
            case "10": {
                stat.setHour10(value);
                break;
            }
            case "11": {
                stat.setHour11(value);
                break;
            }
            case "12": {
                stat.setHour12(value);
                break;
            }
            case "13": {
                stat.setHour13(value);
                break;
            }
            case "14": {
                stat.setHour14(value);
                break;
            }
            case "15": {
                stat.setHour15(value);
                break;
            }
            case "16": {
                stat.setHour16(value);
                break;
            }
            case "17": {
                stat.setHour17(value);
                break;
            }
            case "18": {
                stat.setHour18(value);
                break;
            }
            case "19": {
                stat.setHour19(value);
                break;
            }
            case "20": {
                stat.setHour20(value);
                break;
            }
            case "21": {
                stat.setHour21(value);
                break;
            }
            case "22": {
                stat.setHour22(value);
                break;
            }
            case "23": {
                stat.setHour23(value);
                break;
            }
        }
    }

    public User nextRobot() {
        if (CollUtil.isNotEmpty(robots)) {
            Integer uid = (Integer)RandomUtil.randomEle(robots);
            return this.getById(String.valueOf(uid));
        }
        return null;
    }
}

