/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.base;

import java.io.Serializable;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.UserThird;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;

public class UserThirdService {
    private static Logger log = LoggerFactory.getLogger(UserThirdService.class);
    public static final UserThirdService me = new UserThirdService();
    final UserThird nullUser = new UserThird();
    ICache openidCache = Caches.getCache(CacheConfig.OPENID_USERTHIRD);
    ICache uidCache = Caches.getCache(CacheConfig.UID_USERTHIRD);

    private UserThirdService() {
    }

    public boolean save(UserThird userThird) throws SQLException {
        boolean flag = userThird.save();
        UserThird.SubTable sub = userThird.getSubTable();
        if (sub != null) {
            sub.setUserThirdId(userThird.getId());
            sub.save();
        }
        return flag;
    }

    public UserThird getByOpenid(Integer type, String typeStr, String openid) {
        if (openid == null || typeStr == null || type == null) {
            return null;
        }
        String key = typeStr + "_" + openid;
        UserThird userThird = (UserThird)((Object)this.openidCache.get(key, UserThird.class));
        if (userThird == null) {
            userThird = (UserThird)UserThird.dao.findFirst("select * from user_third where type in (" + typeStr + ") and openid=?", new Object[]{openid});
            if (userThird != null) {
                this.openidCache.put(key, (Serializable)((Object)userThird));
            } else {
                this.openidCache.putTemporary(key, (Serializable)((Object)this.nullUser));
            }
        } else if (userThird.getId() == null) {
            return null;
        }
        return userThird;
    }

    public UserThird getByUnionid(Integer type, String typeStr, String unionid) {
        if (unionid == null || typeStr == null || type == null) {
            return null;
        }
        String key = typeStr + "_" + unionid;
        UserThird userThird = (UserThird)((Object)this.openidCache.get(key, UserThird.class));
        if (userThird == null) {
            userThird = (UserThird)UserThird.dao.findFirst("select * from user_third where type in (" + typeStr + ") and unionid=?", new Object[]{unionid});
            if (userThird != null) {
                this.openidCache.put(key, (Serializable)((Object)userThird));
            } else {
                this.openidCache.putTemporary(key, (Serializable)((Object)this.nullUser));
            }
        } else if (userThird.getId() == null) {
            return null;
        }
        return userThird;
    }

    public UserThird getByUid(final String uid) {
        if (uid == null) {
            return null;
        }
        String key = uid + "";
        boolean putTempToCacheIfNull = false;
        UserThird userThird = (UserThird)((Object)CacheUtils.get((ICache)this.uidCache, (String)key, (boolean)putTempToCacheIfNull, (FirsthandCreater)new FirsthandCreater<UserThird>(){

            public UserThird create() {
                UserThird userThird = (UserThird)UserThird.dao.findFirst("select * from user_third where uid=?", new Object[]{uid});
                return userThird;
            }
        }));
        return userThird;
    }
}

