/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.chat;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.WxChatGroupItem;
import org.tio.sitexxx.service.model.main.WxChatItems;
import org.tio.sitexxx.service.model.main.WxChatUserItem;
import org.tio.sitexxx.service.model.main.WxGroup;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.service.chat.ChatService;
import org.tio.sitexxx.service.service.chat.GroupService;
import org.tio.sitexxx.service.topic.Topics;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;
import org.tio.utils.lock.LockUtils;

public class ChatIndexService {
    private static Logger log = LoggerFactory.getLogger(ChatIndexService.class);
    public static final ChatIndexService me = new ChatIndexService();
    final WxChatUserItem userItemDao = (WxChatUserItem)new WxChatUserItem().dao();
    final WxChatGroupItem groupItemDao = (WxChatGroupItem)new WxChatGroupItem().dao();

    public List<WxChatGroupItem> getNoActGroupIndex(Long groupid) {
        return this.getLinkActGroupIndex(groupid, (byte)1, (byte)2, null);
    }

    public WxChatGroupItem getFristGroupUserIndex(Long groupid) {
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"linkflag", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.getFristGroupUser", (Map)params);
        return (WxChatGroupItem)WxChatGroupItem.dao.findFirst(sqlPara);
    }

    public List<WxChatGroupItem> getLinkActGroupIndex(Long groupid, Byte link, Byte act, Byte viewflag) {
        if (groupid == null) {
            return null;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid);
        if (link != null) {
            params.set((Object)"linkflag", (Object)link);
        }
        if (act != null) {
            params.set((Object)"actflag", (Object)act);
        }
        if (viewflag != null) {
            params.set((Object)"viewflag", (Object)viewflag);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.linkActGroupList", (Map)params);
        return WxChatGroupItem.dao.find(sqlPara);
    }

    public List<WxChatGroupItem> getNoStartMsgGroupIndex(Long groupid) {
        if (groupid == null) {
            return null;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"linkflag", (Object)1).set((Object)"actflag", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.noStartMsgList", (Map)params);
        return WxChatGroupItem.dao.find(sqlPara);
    }

    public List<WxChatGroupItem> getGroupLinkItems(Long groupid) {
        return this.getLinkActGroupIndex(groupid, (byte)1, null, null);
    }

    public List<WxChatGroupItem> getHideGroupItems(Long groupid) {
        return this.getLinkActGroupIndex(groupid, null, (byte)1, (byte)2);
    }

    public List<WxChatUserItem> getLinkActUserIndex(String uid, Byte chatmode, Byte link, Byte act) {
        if (uid == null) {
            return null;
        }
        Kv params = Kv.by((Object)"uid", (Object)uid);
        if (link != null) {
            params.set((Object)"linkflag", (Object)link);
        }
        if (act != null) {
            params.set((Object)"actflag", (Object)act);
        }
        if (chatmode != null) {
            params.set((Object)"chatmode", (Object)chatmode);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.linkActUserList", (Map)params);
        return WxChatUserItem.dao.find(sqlPara);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chatGroupIndexUpdate(Long groupid, String uid, Long chatlinkid) {
        if (groupid == null || uid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"uid", (Object)uid);
        if (chatlinkid != null) {
            params.set((Object)"chatlinkid", (Object)chatlinkid);
        } else {
            params.set((Object)"setnull", (Object)1).set((Object)"resetflag", (Object)1).set((Object)"actflag", (Object)2).set((Object)"viewflag", (Object)2);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.updateChatGroupIndex", (Map)params);
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..group." + groupid + "." + uid), WxChatGroupItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            int update = Db.use((String)"tio_site_main").update(sqlPara);
            if (update <= 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chatGroupIndexDelNoAct(Long groupid) {
        if (groupid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"actflag", (Object)2);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.delGroupNoAct", (Map)params);
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..group." + groupid), WxChatGroupItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            int update = Db.use((String)"tio_site_main").update(sqlPara);
            if (update <= 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chatGroupIndexUpdateAllLink(Long groupid) {
        if (groupid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"linkflag", (Object)2);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.updateGroupLink", (Map)params);
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..group." + groupid), WxChatGroupItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            int update = Db.use((String)"tio_site_main").update(sqlPara);
            if (update <= 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public WxChatGroupItem chatGroupIndexUpdate(Long groupid, String uid, Long chatlinkid, boolean isNew) {
        WxChatGroupItem item = ChatIndexService.chatGroupIndex(uid, groupid);
        this.chatGroupIndexUpdate(groupid, uid, chatlinkid);
        if (isNew) {
            return ChatIndexService.chatGroupIndex(uid, groupid);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chatGroupIndexUpdate(String uid, Long groupid, Byte viewFlag, Byte actflag, Byte linkflag, Byte role, Long gpulinkid, Byte resetflag, boolean removeStartMsg) {
        WxChatGroupItem update = new WxChatGroupItem();
        update.setUid(uid);
        update.setGroupid(groupid);
        if (viewFlag != null) {
            update.setViewflag(viewFlag);
        }
        if (actflag != null) {
            update.setActflag(actflag);
        }
        if (resetflag != null) {
            update.setResetflag(resetflag);
        }
        if (linkflag != null) {
            update.setLinkflag(linkflag);
        }
        if (gpulinkid != null) {
            update.setGpulinkid(gpulinkid);
        }
        if (removeStartMsg) {
            update.setStartmsgid(null);
        }
        if (role != null) {
            update.setGrouprole(role);
        }
        if (groupid == null) {
            return false;
        }
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..group." + groupid + "." + uid), WxChatGroupItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            boolean updateflag = update.update();
            if (!updateflag) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean actUserGroup(Long groupid, String uid, Long chatlinkid, Long startmsgid) {
        if (groupid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"actflag", (Object)1).set((Object)"chatlinkid", (Object)chatlinkid).set((Object)"uid", (Object)uid).set((Object)"viewflag", (Object)1);
        if (startmsgid != null) {
            params.set((Object)"startmsgid", (Object)startmsgid);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.actGroupIndex", (Map)params);
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..group." + groupid + "." + uid), WxChatGroupItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            int update = Db.use((String)"tio_site_main").update(sqlPara);
            if (update <= 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
        ChatIndexService.removeChatGroupCache(groupid, uid);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean actGroupToUserIndex(Long groupid, String uid, Long chatlinkid, Long startmsgid) {
        if (groupid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"actflag", (Object)1).set((Object)"viewflag", (Object)1).set((Object)"chatlinkid", (Object)chatlinkid).set((Object)"uid", (Object)uid).set((Object)"chatmode", (Object)2);
        if (startmsgid != null) {
            params.set((Object)"startmsgid", (Object)startmsgid);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.actGroupToUserIndex", (Map)params);
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..group." + groupid + "." + uid), WxChatGroupItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            int update = Db.use((String)"tio_site_main").update(sqlPara);
            if (update <= 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
        ChatIndexService.removeUserCache(uid, String.valueOf(groupid), (byte)2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chatGroupStartMsgUpdate(Long groupid, Long startmsgid) {
        if (groupid == null || startmsgid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"linkflag", (Object)1).set((Object)"actflag", (Object)1).set((Object)"startmsgid", (Object)startmsgid);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.chatGroupStartMsgUpdate", (Map)params);
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..group." + groupid), WxChatGroupItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            int update = Db.use((String)"tio_site_main").update(sqlPara);
            if (update <= 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chatUserIndexUpdate(String uid, String bizid, Byte mode, Long chatlinkid, Long tochatlinkid, Long startMsgId, Byte linkflag) {
        if (uid == null || bizid == null || mode == null) {
            return false;
        }
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"chatmode", (Object)mode).set((Object)"bizid", (Object)bizid);
        if (chatlinkid != null) {
            params.set((Object)"chatlinkid", (Object)chatlinkid).set((Object)"actflag", (Object)1).set((Object)"viewflag", (Object)1);
        } else {
            params.set((Object)"setnull", (Object)1).set((Object)"actflag", (Object)2).set((Object)"viewflag", (Object)2);
        }
        if (linkflag != null) {
            params.set((Object)"linkflag", (Object)1);
        }
        if (startMsgId != null) {
            params.set((Object)"startmsgid", (Object)startMsgId);
        }
        if (tochatlinkid != null) {
            params.set((Object)"tochatlinkid", (Object)tochatlinkid);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.actChatUserIndex", (Map)params);
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..user." + uid + ".bizid." + bizid + ".chatmode." + mode), WxChatUserItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            int update = Db.use((String)"tio_site_main").update(sqlPara);
            if (update <= 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chatuserUpdateToChatlink(String uid, String bizid, Byte mode, Long tochatlinkid, Long startMsgId) {
        if (uid == null || bizid == null || mode == null) {
            return false;
        }
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"chatmode", (Object)mode).set((Object)"bizid", (Object)bizid);
        if (startMsgId != null) {
            params.set((Object)"startmsgid", (Object)startMsgId);
        }
        if (tochatlinkid != null) {
            params.set((Object)"tochatlinkid", (Object)tochatlinkid);
        } else {
            params.set((Object)"setnull", (Object)1);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.updateToChatlinkId", (Map)params);
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..user." + uid + ".bizid." + bizid + ".chatmode." + mode), WxChatUserItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            int update = Db.use((String)"tio_site_main").update(sqlPara);
            if (update <= 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chatuserStartMsg(String uid, String bizid, Byte mode, Long startMsgId) {
        if (uid == null || bizid == null || mode == null) {
            return false;
        }
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"chatmode", (Object)mode).set((Object)"bizid", (Object)bizid);
        if (startMsgId != null) {
            params.set((Object)"startmsgid", (Object)startMsgId);
        } else {
            params.set((Object)"setnull", (Object)1);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.chatuserStartMsg", (Map)params);
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..user." + uid + ".bizid." + bizid + ".chatmode." + mode), WxChatUserItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            int update = Db.use((String)"tio_site_main").update(sqlPara);
            if (update <= 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chatGroupStartMsg(String uid, Long groupid, Long startMsgId) {
        if (uid == null || groupid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"groupid", (Object)groupid);
        if (startMsgId != null) {
            params.set((Object)"startmsgid", (Object)startMsgId);
        } else {
            params.set((Object)"setnull", (Object)1).set((Object)"resetflag", (Object)1);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.chatgroupStartMsg", (Map)params);
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..group." + groupid + ".uid." + uid), WxChatGroupItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            int update = Db.use((String)"tio_site_main").update(sqlPara);
            if (update <= 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chatUserIndexUpdate(String uid, String bizid, Byte mode, Byte oper) {
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"chatmode", (Object)mode).set((Object)"bizid", (Object)bizid);
        switch (oper) {
            case 4: {
                params.set((Object)"setfidnull", (Object)1).set((Object)"linkflag", (Object)2).set((Object)"actflag", (Object)2).set((Object)"viewflag", (Object)2);
                break;
            }
            case 5: {
                params.set((Object)"tofidnull", (Object)1).set((Object)"linkflag", (Object)2);
                break;
            }
            case 2: {
                params.set((Object)"setnull", (Object)1).set((Object)"actflag", (Object)2).set((Object)"viewflag", (Object)2);
                break;
            }
            case 3: {
                params.set((Object)"block", (Object)1).set((Object)"viewflag", (Object)2);
                break;
            }
            case 6: {
                params.set((Object)"block", (Object)1).set((Object)"viewflag", (Object)1);
                break;
            }
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.updateChatUserIndex", (Map)params);
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..user." + uid + ".bizid." + bizid + ".chatmode." + mode), WxChatUserItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            int update = Db.use((String)"tio_site_main").update(sqlPara);
            if (update <= 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chatGroupIndexDel(String uid, Long groupid) {
        WxChatGroupItem delItem = new WxChatGroupItem();
        delItem.setUid(uid);
        delItem.setGroupid(groupid);
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..group." + groupid + ".uid." + uid), WxChatGroupItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            boolean del = delItem.delete();
            if (del) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chatUserIndexDel(String uid, String bizid, Byte mode) {
        WxChatUserItem delItem = new WxChatUserItem();
        delItem.setUid(uid);
        delItem.setChatmode(mode);
        delItem.setBizid(bizid);
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..user." + uid + ".bizid." + bizid + ".chatmode." + mode), WxChatUserItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            boolean del = delItem.delete();
            if (del) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chatUserIndexUpdate(String uid, String bizid, Byte mode, Byte viewFlag, Byte actflag, Byte linkflag, Long linkid, Long chatlinkid, Long tochatlinkid) {
        WxChatUserItem update = new WxChatUserItem();
        update.setUid(uid);
        update.setChatmode(mode);
        update.setBizid(bizid);
        if (viewFlag != null) {
            update.setViewflag(viewFlag);
        }
        if (actflag != null) {
            update.setActflag(actflag);
        }
        if (tochatlinkid != null) {
            update.setTochatlinkid(tochatlinkid);
        }
        if (chatlinkid != null) {
            update.setChatlinkid(chatlinkid);
        }
        if (linkflag != null) {
            update.setLinkflag(linkflag);
        }
        if (linkid != null) {
            update.setLinkid(linkid);
        }
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..user." + uid + ".bizid." + bizid + ".chatmode." + mode), WxChatUserItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            boolean updateflag = update.update();
            if (!updateflag) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    public WxChatUserItem chatUserIndexUpdate(String uid, String bizid, Byte mode, Byte oper, boolean isNew) {
        WxChatUserItem item = ChatIndexService.chatUserIndex(uid, bizid, mode);
        this.chatUserIndexUpdate(uid, bizid, mode, oper);
        if (isNew) {
            return ChatIndexService.chatUserIndex(uid, bizid, mode);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int chatGroupInit(String uid, Long groupid, Long chatlinkid, Long gpulinkid, Byte view, Byte act, Byte link, Byte grouprole, Long startmsgid, Byte resetflag) {
        WxChatGroupItem item = new WxChatGroupItem();
        item.setUid(uid);
        item.setGroupid(groupid);
        item.setGpulinkid(gpulinkid);
        item.setChatlinkid(chatlinkid);
        item.setLinkflag(link);
        item.setActflag(act);
        item.setViewflag(view);
        item.setGrouprole(grouprole);
        if (startmsgid != null) {
            item.setStartmsgid(startmsgid);
        }
        if (resetflag != null) {
            item.setResetflag(resetflag);
        }
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..group." + groupid), WxChatGroupItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            int init = item.ignoreSave();
            if (init > 0) {
                ChatIndexService.setGroupIndexCache(groupid + "_" + uid, item);
            }
            int n = init;
            return n;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    public int chatGroupInit(String uid, Long groupid, Long chatlinkid, Long gpulinkid, Byte grouprole, Long startmsgid, Byte retsetFlag) {
        return this.chatGroupInit(uid, groupid, chatlinkid, gpulinkid, (byte)1, (byte)1, (byte)1, grouprole, startmsgid, retsetFlag);
    }

    public int chatGroupInit(String uid, Long groupid, Long chatlinkid, Long gpulinkid, Long startmsgid, Byte retsetFlag) {
        return this.chatGroupInit(uid, groupid, chatlinkid, gpulinkid, (byte)1, (byte)1, (byte)1, (byte)2, startmsgid, retsetFlag);
    }

    public int chatGroupInit(String uid, Long groupid, Long gpulinkid) {
        return this.chatGroupInit(uid, groupid, null, gpulinkid, (byte)2, (byte)2, (byte)1, (byte)2, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int chatUserInit(String uid, Byte chatmode, String bizid, Long chatlinkid, Long tochatlinkid, Long linkid, Byte viewFlag, Byte actfByte, Byte linkfByte, Long startmsgid) {
        WxChatUserItem item = new WxChatUserItem();
        item.setUid(uid);
        item.setChatmode(chatmode);
        item.setBizid(bizid);
        item.setLinkid(linkid);
        item.setChatlinkid(chatlinkid);
        item.setTochatlinkid(tochatlinkid);
        item.setLinkflag(linkfByte);
        item.setActflag(actfByte);
        item.setViewflag(viewFlag);
        if (Objects.equals(chatmode, (byte)1)) {
            item.setFidkey(UserService.twoUid(uid, String.valueOf(bizid)));
        }
        if (startmsgid != null) {
            item.setStartmsgid(startmsgid);
        }
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.index.lock..user." + uid + ".bizid." + bizid + ".chatmode." + chatmode), WxChatUserItem.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            int init = item.ignoreSave();
            if (init > 0) {
                ChatIndexService.setUserIndexCache(uid + "_" + chatmode + "_" + bizid, item);
            }
            int n = init;
            return n;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    public int chatUserInit(Long fid, String uid, Byte chatmode, String bizid, Long chatlinkid, Long tochatlinkid) {
        return this.chatUserInit(uid, chatmode, bizid, chatlinkid, tochatlinkid, fid, (byte)1, (byte)1, (byte)1, null);
    }

    public int chatUserInit(Long fid, String uid, Byte chatmode, String bizid) {
        return this.chatUserInit(uid, chatmode, bizid, null, null, fid, (byte)2, (byte)2, (byte)1, null);
    }

    public int chatUserInit(String uid, Byte chatmode, String bizid, Long chatlinkid, Long linkid, Long startmsgid) {
        return this.chatUserInit(uid, chatmode, bizid, chatlinkid, null, linkid, (byte)1, (byte)1, (byte)1, startmsgid);
    }

    public int chatUserInit(String uid, Byte chatmode, String bizid) {
        return this.chatUserInit(uid, chatmode, bizid, null, null, null, (byte)2, (byte)2, (byte)1, null);
    }

    public static WxChatUserItem chatUserIndex(final String uid, final String bizid, final Byte mode) {
        if (bizid == null || uid == null || mode == null) {
            return null;
        }
        ICache cache = Caches.getCache(CacheConfig.CHAT_USER_INDEX_1);
        String key = uid + "_" + mode + "_" + bizid;
        WxChatUserItem userIndex = (WxChatUserItem)((Object)CacheUtils.get((ICache)cache, (String)key, (boolean)false, (FirsthandCreater)new FirsthandCreater<WxChatUserItem>(){

            public WxChatUserItem create() {
                Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"chatmode", (Object)mode).set((Object)"bizid", (Object)bizid);
                SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.getuserindex", (Map)params);
                WxChatUserItem userItem = (WxChatUserItem)WxChatUserItem.dao.findFirst(sqlPara);
                return userItem;
            }
        }));
        return userIndex;
    }

    public static WxChatUserItem chatUserIndex(String uid, Number bizid, Byte mode) {
        return ChatIndexService.chatUserIndex(uid, String.valueOf(bizid), mode);
    }

    public static WxChatUserItem chatUserIndex(Long chatlinkid) {
        if (chatlinkid == null) {
            return null;
        }
        WxChatItems items = ChatService.me.getChatItems(chatlinkid);
        if (items == null) {
            return null;
        }
        return ChatIndexService.chatUserIndex(items.getUid(), items.getBizid(), items.getChatmode());
    }

    public static WxChatUserItem chatUserIndex(WxChatItems items) {
        if (items == null) {
            return null;
        }
        return ChatIndexService.chatUserIndex(items.getUid(), items.getBizid(), items.getChatmode());
    }

    public static WxChatGroupItem chatGroupIndex(Long chatlinkid) {
        if (chatlinkid == null) {
            return null;
        }
        WxChatItems items = ChatService.me.getChatItems(chatlinkid);
        if (items == null) {
            return null;
        }
        return ChatIndexService.chatGroupIndex(items.getUid(), Long.parseLong(items.getBizid()));
    }

    public static WxChatGroupItem chatGroupIndex(WxChatItems items) {
        if (items == null) {
            return null;
        }
        return ChatIndexService.chatGroupIndex(items.getUid(), Long.parseLong(items.getBizid()));
    }

    public static WxChatUserItem fdUserIndex(String uid, String touid) {
        return ChatIndexService.chatUserIndex(uid, touid, (Byte)1);
    }

    public static WxChatUserItem groupUserIndex(String uid, Long groupid) {
        return ChatIndexService.chatUserIndex(uid, groupid, (Byte)2);
    }

    public static WxChatGroupItem chatGroupIndex(final String uid, final Long groupid) {
        if (groupid == null || uid == null) {
            return null;
        }
        ICache cache = Caches.getCache(CacheConfig.CHAT_GROUP_INDEX_2);
        String key = groupid + "_" + uid;
        WxChatGroupItem groupindex = (WxChatGroupItem)((Object)CacheUtils.get((ICache)cache, (String)key, (boolean)false, (FirsthandCreater)new FirsthandCreater<WxChatGroupItem>(){

            public WxChatGroupItem create() {
                Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"uid", (Object)uid);
                SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.getgroupindex", (Map)params);
                WxChatGroupItem groupItem = (WxChatGroupItem)WxChatGroupItem.dao.findFirst(sqlPara);
                return groupItem;
            }
        }));
        return groupindex;
    }

    public static void removeBlockCache(String uid, String touid) {
        if (uid == null || touid == null) {
            return;
        }
        Caches.getCache(CacheConfig.CHAT_USER_BLOCK_1).remove(uid + "_" + touid);
    }

    public static void clearChatUserIndex(String uid, String bizid, Byte mode) {
        if (bizid == null || uid == null || mode == null) {
            return;
        }
        ChatIndexService.removeUserCache(uid, bizid, mode);
        if (Objects.equals(mode, (byte)2)) {
            ChatIndexService.removeChatGroupCache(Long.parseLong(bizid), uid);
        }
    }

    public static void clearMailListCache(String uid) {
        Caches.getCache(CacheConfig.WX_MAILLIST_2).remove(uid + "_99");
        Caches.getCache(CacheConfig.WX_MAILLIST_2).remove(uid + "_" + 1);
        Caches.getCache(CacheConfig.WX_MAILLIST_2).remove(uid + "_" + 2);
    }

    public static void clearFriendInfoCache(Long fid, String uid) {
        Caches.getCache(CacheConfig.WX_MY_FRIEND).remove(fid + "");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("uid", uid);
        String path = "/wx/friend/friendInfo";
        Topics.notifyRemoveHttpCache(path, uid, param, 2);
    }

    public static void clearChatP2pIndex(String uid, String toUid) {
        ChatIndexService.removeUserCache(uid, toUid, (byte)1);
    }

    public static void clearChatGroupIndex(Long groupid, String uid) {
        ChatIndexService.removeChatGroupCache(groupid, uid);
        ChatIndexService.removeUserCache(uid, String.valueOf(groupid), (byte)2);
    }

    public static void removeUserCache(String uid, String bizid, Byte mode) {
        String key = uid + "_" + mode + "_" + bizid;
        Caches.getCache(CacheConfig.CHAT_USER_INDEX_1).remove(key);
    }

    public static void removeGroupCache(Long groupid) {
        String key = groupid + "";
        Caches.getCache(CacheConfig.WX_GROUP_1).remove(key);
    }

    public static void clearGroupUserListCache(Long groupid) {
        WxGroup group = GroupService.me.getByGroupid(groupid);
        if (group == null) {
            return;
        }
        double loop = Math.ceil((double)group.getJoinnum().shortValue() / 100.0);
        for (int i = 0; (double)i < loop && i <= 3; ++i) {
            String key = groupid + "_" + (i + 1);
            Caches.getCache(CacheConfig.CHAT_GROUP_USER_LIST_2).remove(key);
        }
    }

    public static void clearGroupUserCache(Long linkid) {
        String key = linkid + "";
        Caches.getCache(CacheConfig.WX_GROUP_USER_2).remove(key);
    }

    public static void clearGroupMsgCache(Long groupid) {
        String key = groupid + "";
        Caches.getCache(CacheConfig.WX_GROUP_CHAT_4).remove(key);
    }

    public static void removeChatGroupCache(Long groupid, String uid) {
        String groupKey = groupid + "_" + uid;
        Caches.getCache(CacheConfig.CHAT_GROUP_INDEX_2).remove(groupKey);
    }

    public static void setUserIndexCache(String key, WxChatUserItem userItem) {
        Caches.getCache(CacheConfig.CHAT_USER_INDEX_1).put(key, (Serializable)((Object)userItem));
    }

    public static void setGroupIndexCache(String key, WxChatGroupItem groupItem) {
        Caches.getCache(CacheConfig.CHAT_GROUP_INDEX_2).put(key, (Serializable)((Object)groupItem));
    }

    public static void removeChatItemsCache(Long chatlinkid) {
        String key = chatlinkid + "";
        Caches.getCache(CacheConfig.CHAT_ITEMS_3).remove(key);
    }
}

